/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.netbeans.spi.mobility.cfgfactory.ProjectConfigurationFactory;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class UserConfigurationTemplatesProvider
implements ProjectConfigurationFactory,
ProjectConfigurationFactory.CategoryDescriptor {
    public static final String PRIVATE_PREFIX = "private.";
    public static final String CFG_TEMPLATE_SUFFIX = NbBundle.getMessage(UserConfigurationTemplatesProvider.class, (String)"LBL_Cfg_TemplateSuffix");
    public static final String CFG_EXT = "cfg";
    public static final String CFG_TEMPLATES_PATH = "Templates/J2MEProjectConfigurations";

    public ProjectConfigurationFactory.CategoryDescriptor getRootCategory() {
        return this;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UserConfigurationTemplatesProvider.class, (String)"UserConfigurationTemplatesProvider");
    }

    public List<ProjectConfigurationFactory.Descriptor> getChildren() {
        ArrayList<ProjectConfigurationFactory.Descriptor> a = new ArrayList<ProjectConfigurationFactory.Descriptor>();
        FileObject root = FileUtil.getConfigFile((String)CFG_TEMPLATES_PATH);
        if (root != null) {
            for (final FileObject fo : root.getChildren()) {
                if (!CFG_EXT.equals(fo.getExt())) continue;
                a.add((ProjectConfigurationFactory.Descriptor)new ProjectConfigurationFactory.ConfigurationTemplateDescriptor(){
                    Map<String, String> pcp;
                    Map<String, String> pgp;
                    Map<String, String> pp;
                    String name;
                    {
                        this.name = fo.getName();
                        if (this.name.toLowerCase().endsWith(CFG_TEMPLATE_SUFFIX.toLowerCase())) {
                            this.name = this.name.substring(0, this.name.length() - CFG_TEMPLATE_SUFFIX.length());
                        }
                    }

                    public String getCfgName() {
                        return this.name;
                    }

                    public String getDisplayName() {
                        return this.name;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Map<String, String> getProjectConfigurationProperties() {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            if (this.pcp == null) {
                                this.loadProperties();
                            }
                        }
                        return this.pcp;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Map<String, String> getProjectGlobalProperties() {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            if (this.pgp == null) {
                                this.loadProperties();
                            }
                        }
                        return this.pgp;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Map<String, String> getPrivateProperties() {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            if (this.pp == null) {
                                this.loadProperties();
                            }
                        }
                        return this.pp;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void loadProperties() {
                        Properties props = new Properties();
                        InputStream in = null;
                        this.pcp = new HashMap<String, String>();
                        this.pgp = new HashMap<String, String>();
                        this.pp = new HashMap<String, String>();
                        try {
                            in = fo.getInputStream();
                            props.load(in);
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().notify((Throwable)ioe);
                            return;
                        }
                        finally {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException ioe) {}
                            }
                        }
                        int privPrefixL = UserConfigurationTemplatesProvider.PRIVATE_PREFIX.length();
                        String tmpPrefix = "configs." + fo.getName() + '.';
                        int tmpPrefixL = tmpPrefix.length();
                        for (Map.Entry<Object, Object> en : props.entrySet()) {
                            String key = (String)en.getKey();
                            if (key.startsWith(UserConfigurationTemplatesProvider.PRIVATE_PREFIX)) {
                                key = key.substring(privPrefixL);
                                this.pp.put(key, (String)en.getValue());
                                continue;
                            }
                            if (key.startsWith(tmpPrefix)) {
                                key = key.substring(tmpPrefixL);
                                this.pcp.put(key, (String)en.getValue());
                                continue;
                            }
                            this.pgp.put(key, (String)en.getValue());
                        }
                    }
                });
            }
        }
        return a;
    }
}

