/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui;

import java.awt.EventQueue;
import java.io.CharConversionException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;

abstract class LazyInitFilterNode
extends FilterNode {
    public LazyInitFilterNode(Lookup lkp) {
        super((Node)new AbstractNode(FilterNode.Children.LEAF), FilterNode.Children.LEAF, lkp);
        this.reinit();
    }

    protected final void reinit() {
        this.setChildren((Children)this.createLazyChildren());
    }

    protected final FilterNode.Children createLazyChildren() {
        return new LazyChildren();
    }

    protected final boolean isLazyChildren() {
        return this.getChildren() instanceof LazyChildren;
    }

    public final void setName(String name) {
        if (name.equals(this.getName())) {
            this.fireDisplayNameChange(null, null);
        } else {
            super.setName(name);
        }
    }

    public final void setValue(String attributeName, Object value) {
        super.setValue(attributeName, value);
        if ("gray".equals(attributeName) || "bold".equals(attributeName) || "error".equals(attributeName)) {
            this.fireDisplayNameChange(null, null);
        }
    }

    public String getHtmlDisplayName() {
        String displayName = this.getDisplayName();
        try {
            displayName = XMLUtil.toElementContent((String)displayName);
        }
        catch (CharConversionException ex) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Boolean bold = Boolean.TRUE.equals(this.getValue("bold"));
        if (bold == Boolean.TRUE) {
            sb.append("<B>");
        }
        Boolean error = Boolean.TRUE.equals(this.getValue("error"));
        Boolean gray = Boolean.TRUE.equals(this.getValue("gray"));
        if (error == Boolean.TRUE) {
            sb.append("<font color=\"!nb.errorForeground\">");
        } else if (gray.booleanValue()) {
            sb.append("<font color=\"!controlShadow\">");
        }
        sb.append(displayName);
        return sb.toString();
    }

    protected abstract FilterNode.Children createRealChildren();

    private class LazyChildren
    extends FilterNode.Children
    implements Runnable {
        LazyChildren() {
            super((Node)new AbstractNode(FilterNode.Children.LEAF));
        }

        protected void addNotify() {
            super.addNotify();
            FilterNode.Children kids = LazyInitFilterNode.this.createRealChildren();
            if (kids == null) {
                EventQueue.invokeLater(this);
            } else {
                LazyInitFilterNode.this.setChildren((Children)kids);
            }
        }

        @Override
        public void run() {
            FilterNode.Children children = LazyInitFilterNode.this.createRealChildren();
            if (children == null) {
                EventQueue.invokeLater(this);
            } else {
                LazyInitFilterNode.this.setChildren((Children)LazyInitFilterNode.this.createRealChildren());
            }
        }
    }
}

