/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.ui.wizard.MIDPTargetChooserPanel;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MIDPTargetChooserPanelGUI
extends JPanel
implements ActionListener,
DocumentListener {
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    private static final ListCellRenderer CELL_RENDERER = new NodeCellRenderer();
    public static final String IS_MIDLET_TEMPLATE_ATTRIBUTE = "isMIDletTemplate";
    private Project project;
    protected AntProjectHelper helper;
    private String expectedExtension;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private boolean updateClassName = true;
    private boolean loadIcons = true;
    private Document packageComboBoxDocument = null;
    private boolean isMIDlet;
    public JComboBox cIcon;
    public JTextField fileTextField;
    public JLabel jLabel2;
    public JLabel jLabel4;
    public JLabel jLabel5;
    public JPanel jPanel1;
    public JPanel jPanel3;
    public JSeparator jSeparator1;
    public JLabel lClassName;
    public JLabel lIcon;
    public JLabel lName;
    public JLabel lNote;
    public JComboBox packageComboBox;
    public JTextField projectTextField;
    public JTextField tClassName;
    public JTextField tName;

    public MIDPTargetChooserPanelGUI() {
        this.initComponents();
        this.initAccessibility();
        this.lNote.setFont(this.lNote.getFont().deriveFont(2));
        Component packageEditor = this.packageComboBox.getEditor().getEditorComponent();
        if (packageEditor instanceof JTextField) {
            this.packageComboBoxDocument = ((JTextField)packageEditor).getDocument();
            this.packageComboBoxDocument.addDocumentListener(this);
        } else {
            this.packageComboBox.addActionListener(this);
        }
        this.packageComboBox.setRenderer(CELL_RENDERER);
        this.packageComboBox.addActionListener(this);
    }

    private void addThisListeners() {
        this.tClassName.getDocument().addDocumentListener(this);
    }

    private void removeThisListeners() {
        this.tClassName.getDocument().removeDocumentListener(this);
    }

    public void initValues(Project project, FileObject template, FileObject preselectedFolder) {
        String name;
        this.project = project;
        this.helper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
        Object obj = template.getAttribute(IS_MIDLET_TEMPLATE_ATTRIBUTE);
        this.isMIDlet = false;
        if (obj instanceof Boolean) {
            this.isMIDlet = (Boolean)obj;
        }
        this.projectTextField.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        SourceGroup preselectedGroup = this.getPreselectedGroup(groups, preselectedFolder);
        if (preselectedGroup != null) {
            ModelItem groupItem = new ModelItem(preselectedGroup);
            ModelItem[] nodes = groupItem.getChildren();
            this.packageComboBox.setModel(new DefaultComboBoxModel<ModelItem>(nodes));
            Object folderItem = this.getPreselectedPackage(groupItem, preselectedFolder);
            if (folderItem != null) {
                this.packageComboBox.setSelectedItem(folderItem);
            }
        } else {
            this.packageComboBox.setModel(new DefaultComboBoxModel());
        }
        String ext = template == null ? "" : template.getExt();
        this.expectedExtension = ext.length() == 0 ? "" : "." + ext;
        this.lName.setVisible(this.isMIDlet);
        this.tName.setVisible(this.isMIDlet);
        this.lIcon.setVisible(this.isMIDlet);
        this.cIcon.setVisible(this.isMIDlet);
        this.lNote.setVisible(this.isMIDlet);
        Mnemonics.setLocalizedText((JLabel)this.lClassName, (String)NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)(this.isMIDlet ? "LBL_File_MIDletClassName" : "LBL_File_MIDPClassName")));
        if (this.isMIDlet) {
            this.tName.getDocument().removeDocumentListener(this);
            this.tName.setText(template.getName());
            this.updateClassNameAndIcon();
            if (this.testIfFileNameExists(preselectedGroup) && this.updateClassName) {
                name = this.tName.getText();
                int i = 1;
                while (true) {
                    this.tName.setText(name + "_" + i);
                    this.updateClassNameAndIcon();
                    if (!this.testIfFileNameExists(preselectedGroup) || !this.updateClassName) break;
                    ++i;
                }
            }
            this.tName.getDocument().addDocumentListener(this);
        } else {
            this.tClassName.setText(template.getName());
            if (this.testIfFileNameExists(preselectedGroup)) {
                name = this.tClassName.getText();
                int i = 1;
                while (true) {
                    this.tClassName.setText(name + "_" + i);
                    if (!this.testIfFileNameExists(preselectedGroup)) break;
                    ++i;
                }
            }
            this.tClassName.getDocument().addDocumentListener(this);
        }
        this.updateText();
        if (this.loadIcons) {
            this.loadIcons = false;
            final DefaultComboBoxModel icons = new DefaultComboBoxModel();
            this.cIcon.setModel(icons);
            this.cIcon.setSelectedItem("");
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    ArrayList<FileObject> roots = new ArrayList<FileObject>();
                    roots.add(MIDPTargetChooserPanelGUI.this.helper.resolveFileObject(MIDPTargetChooserPanelGUI.this.helper.getStandardPropertyEvaluator().getProperty("src.dir")));
                    String libs = J2MEProjectUtils.evaluateProperty(MIDPTargetChooserPanelGUI.this.helper, "libs.classpath");
                    if (libs != null) {
                        String[] elements = PropertyUtils.tokenizePath((String)MIDPTargetChooserPanelGUI.this.helper.resolvePath(libs));
                        for (int i = 0; i < elements.length; ++i) {
                            try {
                                FileObject root = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(elements[i])));
                                if (root == null) continue;
                                roots.add(FileUtil.isArchiveFile((FileObject)root) ? FileUtil.getArchiveRoot((FileObject)root) : root);
                                continue;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                    for (FileObject root : roots) {
                        if (root == null) continue;
                        int rootLength = root.getPath().length();
                        Enumeration en = root.getChildren(true);
                        while (en.hasMoreElements()) {
                            String ext;
                            FileObject fo = (FileObject)en.nextElement();
                            if (!fo.isData() || !"png".equals(ext = fo.getExt().toLowerCase())) continue;
                            String name = fo.getPath().substring(rootLength);
                            if (!name.startsWith("/")) {
                                name = "/" + name;
                            }
                            if (icons.getIndexOf(name) >= 0) continue;
                            icons.addElement(name);
                        }
                    }
                }
            });
        }
    }

    private boolean testIfFileNameExists(SourceGroup preselectedGroup) {
        FileObject folder = null;
        if (preselectedGroup != null) {
            folder = preselectedGroup.getRootFolder();
        }
        if (folder == null) {
            return false;
        }
        String pkg = this.getPackageFileName();
        if (pkg != null && !"".equals(pkg) && (folder = folder.getFileObject(pkg)) == null) {
            return false;
        }
        return folder.getFileObject(this.tClassName.getText() + this.expectedExtension) != null;
    }

    public void updateClassNameAndIcon() {
        if (!this.isMIDlet) {
            return;
        }
        this.removeThisListeners();
        String name = this.tName.getText();
        StringBuffer sb = new StringBuffer();
        for (int a = 0; a < name.length(); ++a) {
            char c = name.charAt(a);
            if (!Character.isJavaIdentifierPart(c) || sb.length() <= 0 && !Character.isJavaIdentifierStart(c)) continue;
            sb.append(c);
        }
        name = sb.toString();
        if (this.updateClassName) {
            this.tClassName.setText(name);
        }
        this.addThisListeners();
    }

    public boolean isMIDletTemplate() {
        return this.isMIDlet;
    }

    public String getMIDletName() {
        return MIDPTargetChooserPanelGUI.normalizedString(this.tName.getText());
    }

    public String getClassName() {
        return MIDPTargetChooserPanelGUI.normalizedString(this.tClassName.getText());
    }

    public String getMIDletIcon() {
        return MIDPTargetChooserPanelGUI.normalizedString(this.cIcon.getEditor().getItem().toString());
    }

    public String getTargetName() {
        return MIDPTargetChooserPanelGUI.normalizedString(this.tClassName.getText());
    }

    public String getCreatedFile() {
        return this.fileTextField.getText();
    }

    private static String normalizedString(String text) {
        if (text == null) {
            return null;
        }
        if ((text = text.trim()).length() <= 0) {
            return null;
        }
        return text;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener lit : this.listeners) {
            lit.stateChanged(e);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.lName = new JLabel();
        this.tName = new JTextField();
        this.lClassName = new JLabel();
        this.tClassName = new JTextField();
        this.lIcon = new JLabel();
        this.cIcon = new JComboBox();
        this.jLabel5 = new JLabel();
        this.projectTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.packageComboBox = new JComboBox();
        this.jLabel4 = new JLabel();
        this.fileTextField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jPanel3 = new JPanel();
        this.lNote = new JLabel();
        this.setName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"TITLE_File"));
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.lName.setLabelFor(this.tName);
        Mnemonics.setLocalizedText((JLabel)this.lName, (String)NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"LBL_File_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 4);
        this.jPanel1.add((Component)this.lName, gridBagConstraints);
        this.lName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_MidletName"));
        this.lName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_MidletName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 4, 3, 4);
        this.jPanel1.add((Component)this.tName, gridBagConstraints);
        this.tName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_MidletName"));
        this.tName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_MidletName"));
        this.lClassName.setLabelFor(this.tClassName);
        Mnemonics.setLocalizedText((JLabel)this.lClassName, (String)NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"LBL_File_MIDletClassName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 4);
        this.jPanel1.add((Component)this.lClassName, gridBagConstraints);
        this.lClassName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_MidpClassName"));
        this.lClassName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_MidpClassName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 4, 3, 4);
        this.jPanel1.add((Component)this.tClassName, gridBagConstraints);
        this.tClassName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_MidpClassName"));
        this.tClassName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_MidpClassName"));
        this.lIcon.setLabelFor(this.cIcon);
        Mnemonics.setLocalizedText((JLabel)this.lIcon, (String)NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"LBL_File_Icon"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 4);
        this.jPanel1.add((Component)this.lIcon, gridBagConstraints);
        this.lIcon.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_MidletIcon"));
        this.lIcon.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_MidletIcon"));
        this.cIcon.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 4, 3, 4);
        this.jPanel1.add((Component)this.cIcon, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 24, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel5.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"LBL_File_Project"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel5.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_MidpTargetProject"));
        this.jLabel5.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_MidpTargetProject"));
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_MidpTargetProject"));
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_MidpTargetProject"));
        this.jLabel2.setLabelFor(this.packageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"LBL_File_Package"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_MidpTargetPackage"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_MidpTargetPackage"));
        this.packageComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.packageComboBox, gridBagConstraints);
        this.packageComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_MidpTargetPackage"));
        this.packageComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_MidpTargetPackage"));
        this.jLabel4.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"LBL_File_Created"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_CreatedFile"));
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_CreatedFile"));
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.fileTextField, gridBagConstraints);
        this.fileTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_CreatedFile"));
        this.fileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_CreatedFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel3, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lNote, (String)NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"LBL_MIDPTarget_Note"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.lNote, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_File"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_File"));
    }

    @Override
    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.packageComboBox == e.getSource()) {
            this.updateText();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (e.getDocument() == this.tName.getDocument()) {
            this.updateClassNameAndIcon();
            this.updateText();
            this.fireChange();
        } else if (e.getDocument() == this.tClassName.getDocument()) {
            this.updateText();
            this.fireChange();
            this.updateClassName = false;
        } else if (this.packageComboBoxDocument != null && e.getDocument() == this.packageComboBoxDocument) {
            this.updateText();
            this.fireChange();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    private SourceGroup getPreselectedGroup(SourceGroup[] groups, FileObject preselectedFolder) {
        if (preselectedFolder != null) {
            for (int i = 0; i < groups.length; ++i) {
                if (!groups[i].getRootFolder().equals(preselectedFolder) && !FileUtil.isParentOf((FileObject)groups[i].getRootFolder(), (FileObject)preselectedFolder)) continue;
                return groups[i];
            }
        }
        return groups.length >= 0 ? groups[0] : null;
    }

    private Object getPreselectedPackage(ModelItem groupItem, FileObject preselectedFolder) {
        if (preselectedFolder == null) {
            return null;
        }
        ModelItem[] ch = groupItem.getChildren();
        FileObject root = groupItem.group.getRootFolder();
        String relPath = FileUtil.getRelativePath((FileObject)root, (FileObject)preselectedFolder);
        relPath = relPath == null ? "" : relPath.replace('/', '.');
        for (int i = 0; i < ch.length; ++i) {
            if (!ch[i].toString().equals(relPath)) continue;
            return ch[i];
        }
        return relPath;
    }

    public FileObject getRootFolder() {
        return this.helper.resolveFileObject(this.helper.getStandardPropertyEvaluator().getProperty("src.dir"));
    }

    public File getFolder() {
        FileObject root = this.getRootFolder();
        File rootFile = FileUtil.toFile((FileObject)root);
        if (rootFile == null) {
            return null;
        }
        return new File(rootFile, this.getPackageFileName());
    }

    public String getPackageFileName() {
        String packageName = this.packageComboBox.getEditor().getItem().toString();
        if (ModelItem.DEFAULT_PACKAGE_DISPLAY_NAME.equals(packageName)) {
            packageName = "";
        }
        return packageName.replace('.', '/');
    }

    private void updateText() {
        File projdirFile = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        if (projdirFile != null) {
            String documentName = this.tClassName.getText().trim();
            if (documentName.length() == 0) {
                this.fileTextField.setText("");
            } else {
                File folder = this.getFolder();
                if (folder != null) {
                    File newFile = new File(folder, documentName + this.expectedExtension);
                    this.fileTextField.setText(newFile.getAbsolutePath());
                } else {
                    this.fileTextField.setText("");
                }
            }
        } else {
            this.fileTextField.setText("");
        }
    }

    private static class NodeCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public NodeCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof ModelItem) {
                ModelItem item = (ModelItem)value;
                this.setText(item.getDisplayName());
                this.setIcon(item.getIcon());
            } else {
                this.setText(value.toString());
                this.setIcon(null);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private static class ModelItem {
        public static final String DEFAULT_PACKAGE_DISPLAY_NAME = NbBundle.getMessage(MIDPTargetChooserPanel.class, (String)"LBL_MIDPTargetChooserPanelGUI_DefaultPackage");
        private final Icon icon;
        private Node node;
        protected SourceGroup group;
        private ModelItem[] children;

        public ModelItem(SourceGroup group) {
            this.group = group;
            this.icon = group.getIcon(false);
        }

        public ModelItem(Node node) {
            this.node = node;
            this.icon = new ImageIcon(node.getIcon(1));
        }

        public String getDisplayName() {
            if (this.group != null) {
                return this.group.getDisplayName();
            }
            String nodeName = this.node.getName();
            return nodeName.length() == 0 ? DEFAULT_PACKAGE_DISPLAY_NAME : nodeName;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String toString() {
            if (this.group != null) {
                return this.getDisplayName();
            }
            return this.node.getName();
        }

        public ModelItem[] getChildren() {
            if (this.group == null) {
                return null;
            }
            if (this.children == null) {
                Node n = PackageView.createPackageView((SourceGroup)this.group);
                if (n == null) {
                    return null;
                }
                Children ch = n.getChildren();
                if (ch == null) {
                    return null;
                }
                Node[] nodes = ch.getNodes(true);
                this.children = new ModelItem[nodes.length];
                for (int i = 0; i < nodes.length; ++i) {
                    this.children[i] = new ModelItem(nodes[i]);
                }
            }
            return this.children;
        }
    }
}

