/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard.i18n;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.project.ui.wizard.i18n.LocalizationSupportPanelGUI;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class LocalizationSupportPanel
implements WizardDescriptor.Panel,
ChangeListener {
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private LocalizationSupportPanelGUI gui;
    private TemplateWizard templateWizard = null;

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new LocalizationSupportPanelGUI();
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(LocalizationSupportPanel.class);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener lit : this.listeners) {
            lit.stateChanged(e);
        }
    }

    public void readSettings(Object settings) {
        this.templateWizard = (TemplateWizard)settings;
        if (this.getComponent() != null) {
            Project project = Templates.getProject((WizardDescriptor)this.templateWizard);
            FileObject preselectedTarget = Templates.getTargetFolder((WizardDescriptor)this.templateWizard);
            this.gui.initValues(project, Templates.getTemplate((WizardDescriptor)this.templateWizard), preselectedTarget);
        }
    }

    private static String getPackage(FileObject folder) {
        ClassPath cp = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
        if (cp != null) {
            return cp.getResourceName(folder, '.', false);
        }
        return "";
    }

    private static String getFullMessageResourceName(String messageFilename, String packageName) {
        StringBuffer fullResourceName = new StringBuffer("/");
        if (packageName != null && !packageName.equals("")) {
            fullResourceName.append(packageName.replace('.', '/'));
            fullResourceName.append('/');
        }
        fullResourceName.append(messageFilename);
        return fullResourceName.toString();
    }

    public void storeSettings(Object settings) {
        if (this.isValid()) {
            String packageFileName;
            FileObject rootFolder = this.gui.getRootFolder();
            FileObject folder = rootFolder.getFileObject(packageFileName = this.gui.getPackageFileName());
            if (folder == null) {
                try {
                    folder = FileUtil.createFolder((FileObject)rootFolder, (String)packageFileName);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                    return;
                }
            }
            Templates.setTargetFolder((WizardDescriptor)this.templateWizard, (FileObject)folder);
            Templates.setTargetName((WizardDescriptor)this.templateWizard, (String)this.gui.getTargetClassName());
            String messageResource = LocalizationSupportPanel.getFullMessageResourceName(this.gui.getTargetMessageFileNameExt(), LocalizationSupportPanel.getPackage(folder));
            ((WizardDescriptor)settings).putProperty("MESSAGE_BUNDLE_FILENAME", (Object)this.gui.getTargetMessageFileName());
            ((WizardDescriptor)settings).putProperty("__MESSAGE_BUNDLE_RESOURCE_NAME__", (Object)messageResource);
            ((WizardDescriptor)settings).putProperty("__DEFAULT_STRING__", (Object)this.gui.getTargetDefaultStringValue());
            ((WizardDescriptor)settings).putProperty("__DEFAULT_ERROR__", (Object)this.gui.getTargetDefaultErrorMessageValue());
        }
    }

    private void appendMessage(StringBuffer messageBuffer, String key) {
        String message = NbBundle.getMessage(this.getClass(), (String)key);
        if (message != null && message.length() > 0) {
            if (messageBuffer.length() > 0) {
                messageBuffer.append(' ');
            }
            messageBuffer.append(message);
        }
    }

    private static boolean isValidJavaFolderName(String packageFileName) {
        if (packageFileName == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(packageFileName, "/");
        while (st.hasMoreElements()) {
            String s = (String)st.nextElement();
            if (Utilities.isJavaIdentifier((String)s)) continue;
            return false;
        }
        return true;
    }

    public boolean isValid() {
        StringBuffer message = new StringBuffer();
        if (this.gui == null) {
            this.appendMessage(message, "ERR_File_NoGUI");
        } else {
            if (this.gui.getTargetClassName() == null || "".equals(this.gui.getTargetClassName())) {
                this.appendMessage(message, "ERR_File_NoTargetClassName");
            } else if (!LocalizationSupportPanel.isValidJavaFolderName(this.gui.getPackageFileName())) {
                this.appendMessage(message, "ERR_File_NoTargetFolder");
            } else if (this.gui.getCreatedClass() != null && new File(this.gui.getCreatedClass()).exists()) {
                this.appendMessage(message, "ERR_File_ClassAlreadyExists");
            } else if (!Utilities.isJavaIdentifier((String)this.gui.getTargetClassName())) {
                this.appendMessage(message, "ERR_File_InvalidClassName");
            }
            if (this.gui.getTargetMessageFileName() == null || "".equals(this.gui.getTargetMessageFileName())) {
                this.appendMessage(message, "ERR_File_NoTargetMessageFileName");
            } else if (this.gui.getCreatedMessageFile() != null && new File(this.gui.getCreatedMessageFile()).exists()) {
                this.appendMessage(message, "ERR_File_MessageResourceAlreadyExists");
            }
        }
        if (this.templateWizard != null) {
            this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)message.toString());
        }
        return message.length() == 0;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.templateWizard != null) {
            this.templateWizard.setValid(this.isValid());
        }
        this.fireChange();
    }

    public boolean isFinishPanel() {
        return true;
    }
}

