/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2;

import java.util.Collection;
import java.util.EnumSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerInfo;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.CndRemote;
import org.netbeans.modules.cnd.makeproject.api.BuildActionsProvider;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.openide.windows.IOSelect;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbgActionHandler
implements ProjectActionHandler {
    private Collection<ExecutionListener> listeners = new CopyOnWriteArrayList<ExecutionListener>();
    private ProjectActionEvent pae;
    private NativeDebuggerInfo ndi;

    public void init(ProjectActionEvent pae, ProjectActionEvent[] paes, Collection<BuildActionsProvider.OutputStreamHandler> outputHandlers) {
        this.pae = pae;
    }

    public void addExecutionListener(ExecutionListener l) {
        this.listeners.add(l);
    }

    public void removeExecutionListener(ExecutionListener l) {
        this.listeners.remove(l);
    }

    public boolean canCancel() {
        return true;
    }

    public void cancel() {
        for (NativeDebugger debugger : DebuggerManager.get().nativeDebuggers()) {
            if (this.ndi != debugger.getNDI()) continue;
            debugger.postKill();
            break;
        }
    }

    public void execute(final InputOutput io) {
        final String executable = this.pae.getExecutable();
        final DebuggerManager dm = DebuggerManager.get();
        dm.setIO(io);
        String hostName = CndRemote.userhostFromConfiguration((Configuration)this.pae.getConfiguration());
        CndRemote.validate(hostName, new Runnable(){

            public void run() {
                DbgActionHandler.this.doExecute(executable, dm, io);
            }
        });
    }

    private void doExecute(final String executable, final DebuggerManager dm, final InputOutput io) {
        MakeConfiguration configuration = this.pae.getConfiguration();
        int platform = configuration.getDevelopmentHost().getBuildPlatform();
        RunProfile profile = platform == 3 || platform == 4 ? this.pae.getProfile() : configuration.getProfile();
        this.executionStarted();
        Runnable loadProgram = new Runnable((Configuration)configuration, profile){
            final /* synthetic */ Configuration val$configuration;
            final /* synthetic */ RunProfile val$profile;
            {
                this.val$configuration = configuration;
                this.val$profile = runProfile;
            }

            public void run() {
                if (io != null) {
                    IOSelect.select((InputOutput)io, EnumSet.noneOf(IOSelect.AdditionalOperation.class));
                }
                if (DbgActionHandler.this.pae.getType() == ProjectActionEvent.PredefinedType.DEBUG || DbgActionHandler.this.pae.getType() == ProjectActionEvent.PredefinedType.DEBUG_TEST) {
                    dm.setAction(1);
                    dm.removeAction(2);
                    DbgActionHandler.this.ndi = DebuggerManager.get().debug(executable, this.val$configuration, CndRemote.userhostFromConfiguration(this.val$configuration), io, DbgActionHandler.this, this.val$profile);
                } else if (DbgActionHandler.this.pae.getType() == ProjectActionEvent.PredefinedType.DEBUG_STEPINTO || DbgActionHandler.this.pae.getType() == ProjectActionEvent.PredefinedType.DEBUG_STEPINTO_TEST) {
                    dm.setAction(2);
                    dm.removeAction(1);
                    DbgActionHandler.this.ndi = DebuggerManager.get().debug(executable, this.val$configuration, CndRemote.userhostFromConfiguration(this.val$configuration), io, DbgActionHandler.this, this.val$profile);
                } else assert (false);
            }
        };
        SwingUtilities.invokeLater(loadProgram);
    }

    private void executionStarted() {
        for (ExecutionListener listener : this.listeners) {
            listener.executionStarted(-1);
        }
    }

    public void executionFinished(int rc) {
        for (ExecutionListener listener : this.listeners) {
            listener.executionFinished(rc);
        }
    }
}

