/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.actions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ComboBoxEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerUpdateCache;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.DialogManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.ExecutableProjectPanel;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.ProjectSupport;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineDescriptor;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineType;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineTypeManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.debugtarget.DebugTarget;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.CndRemote;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.CustomizableHostList;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.HostListEditor;
import org.netbeans.modules.cnd.debugger.common2.utils.MRUComboBoxModel;
import org.netbeans.modules.cnd.debugger.common2.utils.PsProvider;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.RecordListEvent;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.RecordListListener;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.awt.StatusDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttachPanel
extends TopComponent {
    private JButton refreshButton;
    private static final Preferences prefs = NbPreferences.forModule(AttachPanel.class);
    private static final Preferences filterPrefs = prefs.node("attach_filters");
    private static Map<EngineType, AttachPanel> cacheInstance = new HashMap<EngineType, AttachPanel>();
    private MRUComboBoxModel filterModel;
    private DialogManager dialogManager = null;
    private JButton okButton;
    private ExecutableProjectPanel executableProjectPanel;
    private String lastExecPath = null;
    private EngineDescriptor engine;
    private boolean filterReady = false;
    private static final String REFRESH_ICON = "org/netbeans/modules/cnd/debugger/common2/icons/refresh.png";
    private static final String PREF_COUNT = "count";
    private static final String PREF_ITEM = "item_";
    private static final RequestProcessor getPcRP = new RequestProcessor("processes");
    private PsProvider.PsData psData = null;
    private final DefaultTableModel processModel = new AttachTableModel();
    private JTable procTable;
    private JPanel headingPanel;
    private JLabel pathLabel;
    private JComboBox pathComboBox;
    private JComboBox filterCombo;
    private JLabel filterLabel;
    private JLabel tableLabel;
    private JCheckBox allProcessesCheckBox;
    private JPanel buttonRowPanel;
    private static String lastHostChoice;
    private static String lastFilter;
    private JComboBox hostCombo;
    private JLabel hostLabel;
    private JButton hostsButton;
    private final AttachController controller = new AttachController();

    private AttachPanel(EngineType debuggerType) {
        this.engine = new EngineDescriptor(debuggerType);
        this.initComponents(this.engine);
        Catalog.setAccessibleDescription((Component)((Object)this), "ACSD_CTL_AttachToProcess");
    }

    public static synchronized AttachPanel getInstance(DialogManager dialogManager, JButton okButton, EngineType debuggerType) {
        AttachPanel panel = cacheInstance.get(debuggerType);
        if (panel == null) {
            panel = new AttachPanel(debuggerType);
            panel.initializeNew();
            cacheInstance.put(debuggerType, panel);
        } else {
            panel.initialize(dialogManager, okButton);
        }
        return panel;
    }

    private void initializeNew() {
        this.initRemoteHost();
        lastHostChoice = null;
        lastFilter = (String)this.filterCombo.getSelectedItem();
    }

    private void initialize(DialogManager dialogManager, JButton okButton) {
        this.dialogManager = dialogManager;
        this.okButton = okButton;
        lastHostChoice = null;
        this.hostCombo.setSelectedIndex(0);
        this.filterCombo.setSelectedItem(lastFilter);
        this.executableProjectPanel.initGui();
        if (!DebuggerManager.isStandalone()) {
            this.updateRemoteHostList();
        }
        this.refreshProcesses(null, true);
    }

    private void initRemoteHost() {
        CustomizableHostList hostlist;
        this.updateRemoteHostList();
        if (DebuggerManager.isStandalone() && (hostlist = DebuggerManager.get().getHostList()) != null) {
            hostlist.addRecordListListener(new RecordListListener(){

                public void contentsChanged(RecordListEvent e) {
                    AttachPanel.this.updateRemoteHostList();
                    String hostName = e.getHostName();
                    if (hostName != null) {
                        AttachPanel.this.hostCombo.setSelectedItem(hostName);
                        AttachPanel.setHostChoice(hostName, AttachPanel.this.hostCombo);
                    }
                }
            });
        }
    }

    private void updateRemoteHostList() {
        AttachPanel.fillHostsCombo(this.hostCombo);
        AttachPanel.setHostChoice(lastHostChoice, this.hostCombo);
    }

    private void initComponents(EngineDescriptor debuggerType) {
        this.headingPanel = new JPanel();
        this.refreshButton = new JButton();
        this.filterLabel = new JLabel();
        this.filterCombo = new JComboBox();
        this.hostLabel = new JLabel();
        this.hostCombo = new JComboBox();
        this.hostsButton = new JButton();
        this.tableLabel = new JLabel();
        this.allProcessesCheckBox = new JCheckBox(Catalog.get("All_Processes_Lab"));
        this.allProcessesCheckBox.setEnabled(true);
        this.allProcessesCheckBox.setSelected(false);
        this.allProcessesCheckBox.setFocusable(false);
        this.allProcessesCheckBox.setToolTipText(Catalog.get("All_Processes"));
        this.allProcessesCheckBox.setMnemonic(Catalog.getMnemonic("MNEM_All_Processes"));
        Catalog.setAccessibleDescription(this.allProcessesCheckBox, "ACSD_All_Processes");
        this.allProcessesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttachPanel.this.refreshProcesses(null, true);
            }
        });
        this.setLayout(new BorderLayout());
        this.refreshButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)REFRESH_ICON)));
        this.refreshButton.setText(Catalog.get("Refresh"));
        this.refreshButton.setToolTipText(Catalog.get("Refresh"));
        this.refreshButton.setMnemonic(Catalog.getMnemonic("MNEM_Refresh"));
        Catalog.setAccessibleDescription(this.refreshButton, "ACSD_Refresh");
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttachPanel.this.refreshProcesses(null, true);
            }
        });
        this.filterLabel.setText(Catalog.get("AttachProcDiag_FilterColon"));
        this.filterLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_AttachProcDiag_Filter"));
        this.filterLabel.setLabelFor(this.filterCombo);
        this.filterCombo.setToolTipText(Catalog.get("RegExp"));
        this.filterCombo.setEditable(true);
        this.filterCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String filter = (String)AttachPanel.this.filterCombo.getSelectedItem();
                if (filter != null && !filter.equals(lastFilter)) {
                    lastFilter = filter;
                    AttachPanel.this.refreshProcesses(null, false);
                }
            }
        });
        final JTextComponent cbEditor = (JTextComponent)this.filterCombo.getEditor().getEditorComponent();
        cbEditor.getDocument().addDocumentListener(new AnyChangeDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                lastFilter = cbEditor.getText();
                AttachPanel.this.refreshProcesses(null, false);
            }
        });
        this.hostLabel.setText(Catalog.get("AttachProcDiag_HostColon"));
        this.hostLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_Host"));
        this.hostLabel.setLabelFor(this.hostCombo);
        this.hostCombo.setToolTipText(Catalog.get("HostName"));
        this.hostCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String hostName;
                JComboBox cb;
                String ac = evt.getActionCommand();
                if (ac != null && ac.equals("comboBoxChanged") && (cb = (JComboBox)evt.getSource()) != null && cb.getItemCount() > 0 && (hostName = AttachPanel.this.getHostName()) != null && !hostName.equals(lastHostChoice)) {
                    AttachPanel.this.refreshProcesses(hostName, true);
                    lastHostChoice = hostName;
                }
            }
        });
        if (!DebuggerManager.isStandalone()) {
            this.hostsButton.setEnabled(false);
        }
        this.hostsButton.setText(Catalog.get("TITLE_Hosts"));
        this.hostsButton.setMnemonic(Catalog.getMnemonic("MNEM_Hosts"));
        Catalog.setAccessibleDescription(this.hostsButton, "ACSD_EditHosts");
        this.hostsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttachPanel.this.hostsButtonActionPerformed(evt);
            }
        });
        this.headingPanel.setLayout(new GridBagLayout());
        int gridy = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        this.headingPanel.add((Component)this.hostLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 4, 8, 0);
        gridBagConstraints.weightx = 1.0;
        this.headingPanel.add((Component)this.hostCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 4, 8, 0);
        this.headingPanel.add((Component)this.hostsButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        this.headingPanel.add((Component)this.filterLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 4, 8, 0);
        gridBagConstraints.weightx = 1.0;
        this.headingPanel.add((Component)this.filterCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = gridy++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 4, 8, 0);
        this.headingPanel.add((Component)this.refreshButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 4, 8, 0);
        gridBagConstraints.weightx = 1.0;
        JLabel fillLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 800);
        this.headingPanel.add((Component)fillLabel, gridBagConstraints);
        this.add(this.headingPanel, "North");
        this.executableProjectPanel = new ExecutableProjectPanel(this.okButton, debuggerType);
        this.add(this.executableProjectPanel, "South");
        this.filterReady = false;
        Vector<String> filters2 = this.restoreFilterPrefs();
        this.filterModel = new MRUComboBoxModel((Vector)filters2);
        this.filterCombo.setModel(this.filterModel);
        this.procTable = new JTable(this.processModel);
        this.procTable.setAutoResizeMode(3);
        this.procTable.setShowVerticalLines(false);
        this.procTable.setShowHorizontalLines(true);
        this.procTable.setSelectionMode(0);
        this.procTable.setIntercellSpacing(new Dimension(0, this.procTable.getRowMargin()));
        this.procTable.setGridColor((Color)UIManager.getDefaults().get("Label.background"));
        this.procTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (AttachPanel.this.procTable.isEnabled()) {
                    AttachPanel.this.procTableClicked(evt);
                }
            }
        });
        ListSelectionModel sm = this.procTable.getSelectionModel();
        sm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                AttachPanel.this.checkValid();
            }
        });
        JScrollPane jsp = new JScrollPane(this.procTable);
        jsp.setVerticalScrollBarPolicy(22);
        jsp.setBorder(new EmptyBorder(new Insets(6, 0, 12, 0)));
        this.tableLabel.setText(Catalog.get("AttachProcDiag_Table"));
        this.tableLabel.setLabelFor(this.procTable);
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        tablePanel.add((Component)this.tableLabel, "North");
        tablePanel.add((Component)jsp, "Center");
        Catalog.setAccessibleDescription(this.procTable, "ACSD_AttachProcDiag_Table");
        this.add(tablePanel, "Center");
        ComboBoxEditor editor = this.filterCombo.getEditor();
        editor.selectAll();
        this.filterReady = true;
    }

    private void procTableClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (this.dialogManager != null) {
                this.dialogManager.accept(true);
            } else {
                for (Object c = this; c != null; c = ((Component)c).getParent()) {
                    if (!(c instanceof JDialog)) continue;
                    JDialog d = (JDialog)c;
                    d.setVisible(false);
                    d.dispose();
                    break;
                }
                this.controller.ok();
            }
        } else if (evt.getClickCount() == 1) {
            this.chosenProcess();
        }
    }

    private void chosenProcess() {
        String cmdstring;
        int selectedRow = this.procTable.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        int cmdIndex = this.getPsData().commandColumnIdx();
        Object cmdobj = this.processModel.getValueAt(selectedRow, cmdIndex);
        if (cmdobj instanceof String && (cmdstring = (String)cmdobj) != null) {
            int i = cmdstring.indexOf(" ");
            if (i == -1) {
                i = cmdstring.length();
            }
            String executablePath = cmdstring.substring(0, i);
            this.executableProjectPanel.setExecutablePath(executablePath);
        }
    }

    private void doAttach(String loadedPID) {
        Object pidobj = loadedPID;
        if (pidobj == null) {
            int selectedRow = this.procTable.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            pidobj = this.processModel.getValueAt(selectedRow, this.getPsData().pidColumnIdx());
        }
        if (pidobj instanceof String) {
            String pidstring = pidobj;
            long pid = Long.parseLong(pidstring);
            assert (pid != 0L);
            String executable = null;
            String path = this.executableProjectPanel.getExecutablePath();
            Project project = this.executableProjectPanel.getSelectedProject();
            boolean noproject = this.executableProjectPanel.getNoProject();
            if (path != null) {
                executable = path.toString();
                this.executableProjectPanel.setExecutablePath(executable);
            }
            ProjectSupport.ProjectSeed seed = new ProjectSupport.ProjectSeed(project, this.engine.getType(), noproject, executable, ProjectSupport.Model.DONTCARE, null, pid, null, null, null, this.getHostName());
            ProjectSupport.getProject(seed);
            this.executableProjectPanel.setLastSelectedProject(seed.project());
            this.lastExecPath = seed.executable();
            DebugTarget dt = new DebugTarget(seed.conf());
            dt.setExecutable(seed.executableNoSentinel());
            dt.setPid(seed.pid());
            dt.setHostName(seed.getHostName());
            dt.setEngine(this.engine.getType());
            if (project == null) {
                if (noproject) {
                    dt.createProject(false);
                } else {
                    dt.setBuildFirst(false);
                    dt.createProject(true);
                }
            }
            DebuggerManager.get().attach(dt);
        }
    }

    private String getHostName() {
        return this.hostCombo.getSelectedItem().toString();
    }

    private void saveFilterPrefs() {
        try {
            filterPrefs.clear();
            filterPrefs.putInt(PREF_COUNT, this.filterCombo.getItemCount());
            for (int ix = 0; ix < this.filterCombo.getItemCount(); ++ix) {
                String item = (String)this.filterCombo.getItemAt(ix);
                filterPrefs.put(PREF_ITEM + ix, item);
            }
            prefs.flush();
        }
        catch (BackingStoreException x) {
            return;
        }
    }

    private Vector<String> restoreFilterPrefs() {
        Vector<String> items = new Vector<String>();
        int count = filterPrefs.getInt(PREF_COUNT, 0);
        if (count == 0) {
            items.add("");
            return items;
        }
        for (int ix = 0; ix < count; ++ix) {
            String item = filterPrefs.get(PREF_ITEM + ix, null);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    private void tableInfo(final String infoKey) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AttachPanel.this.procTable.setEnabled(false);
                AttachPanel.this.processModel.setDataVector(new Object[][]{{Catalog.get(infoKey)}}, new Object[]{" "});
            }
        });
    }

    private void refreshProcesses(String hostName, boolean request) {
        if (!this.filterReady) {
            return;
        }
        JTextComponent cbEditor = (JTextComponent)this.filterCombo.getEditor().getEditorComponent();
        Object selected = request ? this.filterCombo.getSelectedItem() : cbEditor.getText();
        String regexp = "";
        if (selected != null) {
            regexp = selected.toString();
        }
        Pattern re = null;
        try {
            String regexp2 = regexp;
            if (regexp.equals("")) {
                regexp2 = ".*";
            }
            re = Pattern.compile(regexp2);
        }
        catch (PatternSyntaxException e) {
            if (e.getLocalizedMessage() != null) {
                StatusDisplayer.getDefault().setStatusText(e.getLocalizedMessage());
            }
            return;
        }
        if (request) {
            this.filterModel.add(regexp);
            this.filterCombo.setSelectedItem(selected);
            this.saveFilterPrefs();
            if (hostName == null) {
                hostName = (String)this.hostCombo.getSelectedItem();
            }
            final Pattern fre = re;
            final String hostname = hostName;
            boolean getAllProcesses = false;
            this.tableInfo("MSG_Gathering_Data");
            CndRemote.validate(hostName, new Runnable(){

                public void run() {
                    AttachPanel.this.requestProcesses(fre, hostname, false);
                }
            });
        } else {
            this.filterProcesses(re);
        }
    }

    private void requestProcesses(final Pattern re, final String hostname, final boolean getAll) {
        Runnable asycData = new Runnable(){

            public void run() {
                Host selectedHost = Host.byName(hostname);
                PsProvider psProvider = PsProvider.getDefault(selectedHost);
                if (psProvider == null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            AttachPanel.this.processModel.setRowCount(0);
                        }
                    });
                    return;
                }
                PsProvider.PsData data = psProvider.getData(getAll);
                AttachPanel.this.setPsData(data);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            AttachPanel.this.filterProcesses(re);
                        }
                    });
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        };
        RequestProcessor.Task task = getPcRP.post(asycData);
    }

    private void setPsData(PsProvider.PsData data) {
        this.psData = data;
    }

    private PsProvider.PsData getPsData() {
        return this.psData;
    }

    private void filterProcesses(final Pattern re) {
        final PsProvider.PsData psData = this.getPsData();
        if (psData == null) {
            this.tableInfo("MSG_PS_Failed");
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AttachPanel.this.processModel.setDataVector(psData.processes(re), psData.header());
                AttachPanel.this.procTable.setEnabled(true);
                TableCellRenderer tcr = AttachPanel.this.procTable.getDefaultRenderer(Object.class);
                MyTableCellRenderer my_tcr = new MyTableCellRenderer(tcr);
                AttachPanel.this.procTable.setDefaultRenderer(Object.class, my_tcr);
                try {
                    TableColumn tbc = AttachPanel.this.procTable.getColumnModel().getColumn(psData.commandColumnIdx());
                    tbc.setPreferredWidth(300);
                    tbc.setMinWidth(75);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                AttachPanel.this.checkValid();
            }
        });
    }

    private boolean ckMatch() {
        EngineType override = EngineTypeManager.getOverrideEngineType();
        if (override == null) {
            return true;
        }
        return override.equals(this.engine.getType());
    }

    private void checkValid() {
        this.controller.validChanged();
        if (!this.ckMatch()) {
            this.executableProjectPanel.setEnabled(false);
            this.executableProjectPanel.setError("ERROR_DONTAPPLY", false);
            return;
        }
        if (this.procTable.getSelectedRow() == -1) {
            this.executableProjectPanel.setEnabled(false);
        } else {
            this.executableProjectPanel.setEnabled(true);
        }
    }

    public Controller getController() {
        return this.controller;
    }

    private void hostsButtonActionPerformed(ActionEvent evt) {
        if (DebuggerManager.isStandalone()) {
            HostListEditor editor = new HostListEditor();
            editor.showDialog((Component)((Object)this));
        } else {
            ServerUpdateCache suc = new ServerUpdateCache();
            suc.setHosts(ServerList.getRecords());
            suc.setDefaultRecord(ServerList.getDefaultRecord());
        }
    }

    public static void fillHostsCombo(JComboBox combo) {
        String[] hostChoices = null;
        if (DebuggerManager.isStandalone()) {
            CustomizableHostList hostlist = DebuggerManager.get().getHostList();
            if (hostlist != null) {
                hostChoices = hostlist.getRecordsDisplayName();
            }
        } else {
            hostChoices = CndRemote.getServerListIDs();
        }
        combo.removeAllItems();
        if (hostChoices != null) {
            for (String item : hostChoices) {
                combo.addItem(item);
            }
        }
    }

    public static void setHostChoice(String hostname, JComboBox combo) {
        if (hostname == null) {
            combo.setSelectedIndex(0);
            return;
        }
        for (int i = 0; i < combo.getModel().getSize(); ++i) {
            Object item = combo.getModel().getElementAt(i);
            if (!item.toString().startsWith(hostname)) continue;
            combo.setSelectedIndex(i);
            return;
        }
        combo.setSelectedIndex(0);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Attaching");
    }

    public class AttachController
    implements Controller {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private String loadedPID = null;
        private static final String COMMAND_PROP = "command";
        private static final String EXECUTABLE_PATH_PROP = "executable_path";
        private static final String SELECTED_PROJECT_PROP = "selected_project";
        private static final String ENGINE_PROP = "engine";
        private static final String HOST_NAME_PROP = "host_name";
        private static final String NO_EXISTING_PROCESS = "qwdq123svdfv";

        public final boolean isValid() {
            if (!AttachPanel.this.ckMatch()) {
                return false;
            }
            if (this.loadedPID == null) {
                int selectedRow = AttachPanel.this.procTable.getSelectedRow();
                if (selectedRow == -1) {
                    return false;
                }
                Object pidobj = AttachPanel.this.processModel.getValueAt(selectedRow, 1);
                if (!(pidobj instanceof String)) {
                    return false;
                }
            }
            return true;
        }

        public final boolean ok() {
            if (this.isValid()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AttachPanel.this.doAttach(AttachController.this.loadedPID);
                    }
                });
                return true;
            }
            return false;
        }

        public final boolean cancel() {
            return true;
        }

        public final void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public final void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }

        private void validChanged() {
            this.pcs.firePropertyChange("valid", null, null);
        }

        public boolean load(Properties props) {
            Vector<Vector<String>> processes = AttachPanel.this.psData.processes(Pattern.compile(props.getString(COMMAND_PROP, NO_EXISTING_PROCESS)));
            if (processes.isEmpty()) {
                return false;
            }
            EngineType et = EngineTypeManager.getEngineTypeByID(props.getString(ENGINE_PROP, ""));
            if (et == null) {
                return false;
            }
            String hostName = props.getString(HOST_NAME_PROP, "");
            AttachPanel.this.hostCombo.setSelectedItem(hostName);
            if (!AttachPanel.this.hostCombo.getSelectedItem().equals(hostName)) {
                return false;
            }
            String selectedProject = props.getString(SELECTED_PROJECT_PROP, "");
            if (!AttachPanel.this.executableProjectPanel.containsProjectWithPath(selectedProject)) {
                return false;
            }
            AttachPanel.this.executableProjectPanel.setSelectedProjectByPath(selectedProject);
            this.loadedPID = processes.get(0).get(AttachPanel.this.psData.pidColumnIdx());
            AttachPanel.this.executableProjectPanel.setExecutablePath(props.getString(EXECUTABLE_PATH_PROP, ""));
            AttachPanel.this.engine = new EngineDescriptor(et);
            return true;
        }

        public void save(Properties props) {
            String selectedCommand = this.getSelectedProcessCommand();
            if (selectedCommand != null) {
                props.setString(COMMAND_PROP, selectedCommand);
                props.setString(EXECUTABLE_PATH_PROP, AttachPanel.this.executableProjectPanel.getExecutablePath());
                props.setString(SELECTED_PROJECT_PROP, AttachPanel.this.executableProjectPanel.getSelectedProjectPath());
                props.setString(ENGINE_PROP, AttachPanel.this.engine.getType().getDebuggerID());
                props.setString(HOST_NAME_PROP, (String)AttachPanel.this.hostCombo.getSelectedItem());
            }
        }

        public String getDisplayName() {
            String selectedCommand = this.getSelectedProcessCommand();
            if (selectedCommand != null) {
                return this.getString("ATTACH_HISTORY_MESSAGE", new File(selectedCommand).getName(), (String)AttachPanel.this.hostCombo.getSelectedItem());
            }
            return "";
        }

        private String getSelectedProcessCommand() {
            int selectedRow = AttachPanel.this.procTable.getSelectedRow();
            if (selectedRow == -1) {
                return null;
            }
            return this.getProcessCommand(selectedRow);
        }

        private String getProcessCommand(int row) {
            Object commandobj = AttachPanel.this.processModel.getValueAt(row, AttachPanel.this.getPsData().commandColumnIdx());
            if (commandobj instanceof String) {
                return (String)commandobj;
            }
            return null;
        }

        private String getString(String key, String ... a1) {
            return NbBundle.getMessage(AttachController.class, (String)key, (Object[])a1);
        }
    }

    public static abstract class AnyChangeDocumentListener
    implements DocumentListener {
        protected abstract void documentChanged(DocumentEvent var1);

        public void changedUpdate(DocumentEvent e) {
            this.documentChanged(e);
        }

        public void insertUpdate(DocumentEvent e) {
            this.documentChanged(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.documentChanged(e);
        }
    }

    private static class AttachTableModel
    extends DefaultTableModel {
        private AttachTableModel() {
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    static class MyTableCellRenderer
    implements TableCellRenderer {
        TableCellRenderer original;

        MyTableCellRenderer(TableCellRenderer original) {
            this.original = original;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer = this.original.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JComponent c = (JComponent)renderer;
            Insets insets = new Insets(0, 5, 0, 0);
            EmptyBorder border = new EmptyBorder(insets);
            c.setBorder(border);
            return c;
        }
    }
}

