/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.EditWatchPanel;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.ControllerProvider;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Gen;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.values.AId;
import org.netbeans.modules.cnd.debugger.common2.values.Action;
import org.netbeans.modules.cnd.debugger.common2.values.CountLimit;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public abstract class BreakpointPanel
extends JPanel
implements DocumentListener,
ItemListener,
HelpCtx.Provider,
ControllerProvider {
    protected NativeBreakpoint breakpoint;
    protected final JPanel panel_settings;
    private final ActionsPanel panel_actions;
    protected boolean customizing = false;
    private final BptController controller = new BptController(this);
    private static boolean showingDetails = false;
    private JSeparator separator;
    private JLabel whileLabel;
    private JTextField whileField;
    private JLabel conditionLabel;
    private JTextComponent conditionPane;
    private JLabel lwpLabel;
    private JTextField lwpField;
    private JLabel threadLabel;
    private JTextField threadField;
    private JLabel countLimitLabel;
    private JComboBox countLimitCombo;
    private JLabel countLabel;
    private JTextField countField;
    private JCheckBox tempCheckBox;
    private JLabel javaLabel;
    private JComboBox javaCombo = null;
    private boolean checkPlanned = false;

    public String toString() {
        String className = this.getClass().getName();
        int dotx = className.lastIndexOf(46);
        if (dotx != -1) {
            className = className.substring(dotx);
        }
        return className + '@' + Integer.toHexString(this.hashCode());
    }

    private static Border makeBorder(String title) {
        Insets insets = new Insets(0, 8, 5, 7);
        return new CompoundBorder(new TitledBorder(new EtchedBorder(), title), new EmptyBorder(insets));
    }

    protected BreakpointPanel(NativeBreakpoint newBreakpoint, boolean customizing) {
        this.customizing = customizing;
        this.breakpoint = newBreakpoint;
        this.setLayout(new GridBagLayout());
        this.panel_settings = new JPanel();
        this.panel_settings.setBorder(BreakpointPanel.makeBorder(Catalog.get("BORDER_Settings")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        this.add((Component)this.panel_settings, gbc);
        CommonPanel panel_common = new CommonPanel();
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        this.add((Component)panel_common, gbc);
        this.panel_actions = new ActionsPanel();
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        this.add((Component)this.panel_actions, gbc);
    }

    private String trim(JTextComponent tf) {
        String s = tf.getText();
        if (s != null && s.trim().length() > 0) {
            return s.trim();
        }
        return null;
    }

    protected boolean badField(String tf, String err) {
        IllegalArgumentException ex = new IllegalArgumentException();
        String msg = NbBundle.getMessage(BreakpointPanel.class, (String)"ERR_invalid_field", (Object)err, (Object)tf);
        ErrorManager.getDefault().annotate((Throwable)ex, msg);
        ErrorManager.getDefault().notify(256, (Throwable)ex);
        return false;
    }

    public abstract void seed(NativeBreakpoint var1);

    public abstract void setDescriptionEnabled(boolean var1);

    protected abstract void assignProperties();

    protected abstract boolean propertiesAreValid();

    protected final void seedCommonComponents(NativeBreakpoint initialBpt) {
        assert (this.breakpoint == initialBpt);
        this.javaCombo.setSelectedItem(initialBpt.getJava());
        this.whileField.setText(initialBpt.getWhileIn());
        this.conditionPane.setText(initialBpt.getCondition());
        this.threadField.setText(initialBpt.getThread());
        this.lwpField.setText(initialBpt.getLwp());
        this.tempCheckBox.setSelected(initialBpt.getTemp());
        if (initialBpt.hasCountLimit()) {
            if (initialBpt.getCountLimit() == -1L) {
                this.countLimitCombo.getEditor().setItem(CountLimit.Keyword_INFINITY);
            } else {
                this.countLimitCombo.getEditor().setItem("" + initialBpt.getCountLimit());
            }
        } else {
            this.countLimitCombo.getEditor().setItem("");
        }
        if (this.customizing) {
            this.countField.setText("" + initialBpt.getCount());
        }
        this.panel_actions.seed(initialBpt);
    }

    private boolean validateFields() {
        String cf;
        String wf;
        String javaText;
        if (this.javaCombo != null && (javaText = (String)this.javaCombo.getSelectedItem()) != null) {
            if (javaText.equals(Catalog.get("Sessions_Table_ModeJava"))) {
                this.breakpoint.setJava(true);
            } else {
                this.breakpoint.setJava(false);
            }
        }
        if (!IpeUtils.sameString(wf = this.trim(this.whileField), this.breakpoint.getWhileIn())) {
            this.breakpoint.setWhileIn(wf);
            this.breakpoint.setQwhileIn(null);
        }
        if (!IpeUtils.sameString(cf = this.trim(this.conditionPane), this.breakpoint.getCondition())) {
            this.breakpoint.setCondition(cf);
            this.breakpoint.setQcondition(null);
        }
        AId tid = new AId(this.threadField.getText(), false, false);
        if (tid.errorMessage != null) {
            return this.badField(Catalog.get("PROP_thread"), tid.errorMessage);
        }
        this.breakpoint.setThread(tid.toString());
        AId lid = new AId(this.lwpField.getText(), true, false);
        if (lid.errorMessage != null) {
            return this.badField(Catalog.get("PROP_lwp"), lid.errorMessage);
        }
        this.breakpoint.setLwp(lid.toString());
        this.breakpoint.setTemp(this.tempCheckBox.isSelected());
        String countLimitText = (String)this.countLimitCombo.getEditor().getItem();
        CountLimit countLimit = new CountLimit(countLimitText);
        if (countLimit.errorMessage() != null) {
            return this.badField(Catalog.get("PROP_count_limit"), countLimit.errorMessage());
        }
        if (countLimit.isEnabled()) {
            this.breakpoint.setCountLimit(countLimit.count(), countLimit.isEnabled());
        } else {
            this.breakpoint.setCountLimit(1L, countLimit.isEnabled());
        }
        return true;
    }

    public Controller getController() {
        return this.controller;
    }

    private void post() {
        if (this.customizing) {
            this.breakpoint.original().postChange(this.breakpoint, Gen.primary(null));
        } else {
            this.breakpoint.postCreate();
        }
    }

    protected void addCommonComponents(int y) {
    }

    private void initA11y() {
        this.whileField.getAccessibleContext().setAccessibleDescription(Catalog.get("ACSD_WhileIn"));
        this.conditionPane.getAccessibleContext().setAccessibleDescription(Catalog.get("ACSD_Condition"));
        this.lwpField.getAccessibleContext().setAccessibleDescription(Catalog.get("ACSD_LWP"));
        this.threadField.getAccessibleContext().setAccessibleDescription(Catalog.get("ACSD_Thread"));
        this.countLimitCombo.getAccessibleContext().setAccessibleDescription(Catalog.get("ACSD_CountLimit"));
        this.countField.getAccessibleContext().setAccessibleDescription(Catalog.get("ACSD_CurrentCount"));
        this.tempCheckBox.getAccessibleContext().setAccessibleDescription(Catalog.get("ACSD_Temp"));
        this.javaCombo.getAccessibleContext().setAccessibleDescription(Catalog.get("ACSD_JavaBptMode"));
    }

    private void onLessMore() {
        showingDetails = !showingDetails;
        this.adjustModifiers();
    }

    private void adjustModifiers() {
        this.separator.setVisible(showingDetails);
        this.whileLabel.setVisible(showingDetails);
        this.whileField.setVisible(showingDetails);
        this.conditionLabel.setVisible(showingDetails);
        this.conditionPane.setVisible(showingDetails);
        this.lwpLabel.setVisible(showingDetails);
        this.lwpField.setVisible(showingDetails);
        this.threadLabel.setVisible(showingDetails);
        this.threadField.setVisible(showingDetails);
        this.countLimitLabel.setVisible(showingDetails);
        this.countLimitCombo.setVisible(showingDetails);
        this.countLabel.setVisible(showingDetails);
        this.countField.setVisible(showingDetails);
        this.tempCheckBox.setVisible(showingDetails);
        this.javaLabel.setVisible(showingDetails);
        this.javaCombo.setVisible(showingDetails);
        this.revalidate();
        Window w = SwingUtilities.windowForComponent(this);
        if (w == null) {
            return;
        }
        w.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkValidSoon() {
        BreakpointPanel breakpointPanel = this;
        synchronized (breakpointPanel) {
            if (this.checkPlanned) {
                return;
            }
            this.checkPlanned = true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BreakpointPanel breakpointPanel = BreakpointPanel.this;
                synchronized (breakpointPanel) {
                    BreakpointPanel.this.checkPlanned = false;
                }
                BreakpointPanel.this.controller.validChanged();
            }
        });
    }

    public void changedUpdate(DocumentEvent e) {
        this.checkValidSoon();
    }

    public void insertUpdate(DocumentEvent e) {
        this.checkValidSoon();
    }

    public void removeUpdate(DocumentEvent e) {
        this.checkValidSoon();
    }

    public void itemStateChanged(ItemEvent e) {
        this.checkValidSoon();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Breakpoints");
    }

    private class CommonPanel
    extends JPanel {
        protected CommonPanel() {
            this.setBorder(BreakpointPanel.makeBorder(Catalog.get("BORDER_Common")));
            this.setLayout(new GridBagLayout());
            int y = 0;
            BreakpointPanel.this.separator = new JSeparator();
            BreakpointPanel.this.whileLabel = new JLabel();
            BreakpointPanel.this.whileField = new JTextField();
            BreakpointPanel.this.conditionLabel = new JLabel();
            BreakpointPanel.this.lwpLabel = new JLabel();
            BreakpointPanel.this.lwpField = new JTextField();
            BreakpointPanel.this.threadLabel = new JLabel();
            BreakpointPanel.this.threadField = new JTextField();
            BreakpointPanel.this.countLimitLabel = new JLabel();
            BreakpointPanel.this.countLimitCombo = new JComboBox();
            BreakpointPanel.this.countLabel = new JLabel();
            BreakpointPanel.this.countField = new JTextField();
            BreakpointPanel.this.tempCheckBox = new JCheckBox(" ");
            BreakpointPanel.this.javaLabel = new JLabel();
            BreakpointPanel.this.javaCombo = new JComboBox();
            JComponent[] editorComponents = EditWatchPanel.createEditorComponent();
            BreakpointPanel.this.conditionPane = (JTextComponent)editorComponents[1];
            JScrollPane conditionSP = (JScrollPane)editorComponents[0];
            BreakpointPanel.this.javaLabel.setText(Catalog.get("JavaBptMode"));
            BreakpointPanel.this.javaLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_JavaBptMode"));
            BreakpointPanel.this.javaLabel.setLabelFor(BreakpointPanel.this.javaCombo);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = y;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = y;
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.anchor = 17;
            BreakpointPanel.this.conditionLabel.setText(Catalog.get("Condition"));
            BreakpointPanel.this.conditionLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_Condition"));
            BreakpointPanel.this.conditionLabel.setLabelFor(conditionSP);
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = y;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints2.anchor = 17;
            this.add((Component)BreakpointPanel.this.conditionLabel, gridBagConstraints2);
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = y++;
            gridBagConstraints2.gridwidth = 4;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
            this.add((Component)conditionSP, gridBagConstraints2);
            BreakpointPanel.this.countLimitLabel.setText(Catalog.get("CountLimit"));
            BreakpointPanel.this.countLimitLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_CountLimit"));
            BreakpointPanel.this.countLimitLabel.setLabelFor(BreakpointPanel.this.countLimitCombo);
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = y;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints2.anchor = 17;
            this.add((Component)BreakpointPanel.this.countLimitLabel, gridBagConstraints2);
            BreakpointPanel.this.countLimitCombo.setEditable(true);
            BreakpointPanel.this.countLimitCombo.addItem(CountLimit.Action_INFINITY);
            if (BreakpointPanel.this.customizing) {
                BreakpointPanel.this.countLimitCombo.addItem(CountLimit.Action_DISABLE);
                BreakpointPanel.this.countLimitCombo.addItem(CountLimit.Action_CURRENT);
            }
            BreakpointPanel.this.countLimitCombo.getEditor().setItem("");
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = y;
            gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints2.anchor = 17;
            this.add((Component)BreakpointPanel.this.countLimitCombo, gridBagConstraints2);
            Dimension ref_dim = BreakpointPanel.this.threadField.getPreferredSize();
            Dimension combo_dim = BreakpointPanel.this.countLimitCombo.getPreferredSize();
            combo_dim.height = ref_dim.height;
            BreakpointPanel.this.countLimitCombo.setPreferredSize(combo_dim);
            JPanel ccountPanel = new JPanel();
            ccountPanel.setLayout(new BorderLayout());
            ccountPanel.add((Component)BreakpointPanel.this.countLabel, "West");
            ccountPanel.add((Component)BreakpointPanel.this.countField, "Center");
            BreakpointPanel.this.countLabel.setText(Catalog.get("CurrentCount"));
            BreakpointPanel.this.countLabel.setLabelFor(BreakpointPanel.this.countField);
            BreakpointPanel.this.countLabel.setBorder(new EmptyBorder(new Insets(0, 0, 0, 10)));
            BreakpointPanel.this.countField.setEditable(false);
            BreakpointPanel.this.countLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_CurrentCount"));
            BreakpointPanel.this.countField.setColumns(5);
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.gridy = y++;
            gridBagConstraints2.insets = new Insets(0, 20, 0, 0);
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 0.1;
            this.add((Component)ccountPanel, gridBagConstraints2);
            BreakpointPanel.this.whileLabel.setText(Catalog.get("WhileIn"));
            BreakpointPanel.this.whileLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_WhileIn"));
            BreakpointPanel.this.whileLabel.setLabelFor(BreakpointPanel.this.whileField);
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = y;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints2.anchor = 17;
            this.add((Component)BreakpointPanel.this.whileLabel, gridBagConstraints2);
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = y++;
            gridBagConstraints2.gridwidth = 4;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints2.weightx = 1.0;
            this.add((Component)BreakpointPanel.this.whileField, gridBagConstraints2);
            BreakpointPanel.this.lwpLabel.setText(Catalog.get("LWP"));
            BreakpointPanel.this.lwpLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_LWP"));
            BreakpointPanel.this.lwpLabel.setLabelFor(BreakpointPanel.this.lwpField);
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = y;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints2.anchor = 17;
            BreakpointPanel.this.lwpField.setColumns(6);
            JPanel lwpPanel = new JPanel();
            lwpPanel.setLayout(new BorderLayout());
            lwpPanel.add((Component)BreakpointPanel.this.lwpField, "West");
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = y;
            gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.anchor = 17;
            BreakpointPanel.this.threadLabel.setText(Catalog.get("Thread"));
            BreakpointPanel.this.threadLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_Thread"));
            BreakpointPanel.this.threadLabel.setLabelFor(BreakpointPanel.this.threadField);
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = y;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints2.anchor = 17;
            this.add((Component)BreakpointPanel.this.threadLabel, gridBagConstraints2);
            BreakpointPanel.this.threadField.setColumns(6);
            JPanel threadPanel = new JPanel();
            threadPanel.setLayout(new BorderLayout());
            threadPanel.add((Component)BreakpointPanel.this.threadField, "West");
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = y++;
            gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.anchor = 17;
            this.add((Component)threadPanel, gridBagConstraints2);
            BreakpointPanel.this.tempCheckBox.setText(Catalog.get("Temp"));
            BreakpointPanel.this.tempCheckBox.setMnemonic(Catalog.getMnemonic("MNEM_Temp"));
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = y;
            gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints2.anchor = 17;
            if (BreakpointPanel.this.javaCombo != null) {
                String def = Catalog.get("Default");
                String nat = Catalog.get("Sessions_Table_ModeNative");
                String jv = Catalog.get("Sessions_Table_ModeJava");
                DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(new String[]{def, nat, jv});
                BreakpointPanel.this.javaCombo.setModel(model);
            }
            BreakpointPanel.this.whileField.getDocument().addDocumentListener(BreakpointPanel.this);
            BreakpointPanel.this.conditionPane.getDocument().addDocumentListener(BreakpointPanel.this);
            BreakpointPanel.this.lwpField.getDocument().addDocumentListener(BreakpointPanel.this);
            BreakpointPanel.this.threadField.getDocument().addDocumentListener(BreakpointPanel.this);
            BreakpointPanel.this.countLimitCombo.addItemListener(BreakpointPanel.this);
            BreakpointPanel.this.javaCombo.addItemListener(BreakpointPanel.this);
            BreakpointPanel.this.initA11y();
        }
    }

    protected class BptController
    implements Controller {
        private final BreakpointPanel owner;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        BptController(BreakpointPanel owner) {
            this.owner = owner;
        }

        public boolean ok() {
            if (!BreakpointPanel.this.validateFields()) {
                return false;
            }
            BreakpointPanel.this.breakpoint.setAction(BreakpointPanel.this.panel_actions.getAction());
            BreakpointPanel.this.breakpoint.setScript(ActionsPanel.getScript());
            if (!this.isValid()) {
                return false;
            }
            this.owner.assignProperties();
            BreakpointPanel.this.post();
            return true;
        }

        public final boolean cancel() {
            return true;
        }

        public final boolean isValid() {
            return this.owner.propertiesAreValid();
        }

        public final void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public final void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }

        protected void validChanged() {
            this.pcs.firePropertyChange("valid", null, null);
        }
    }

    private static class ActionsPanel
    extends JPanel {
        private DefaultComboBoxModel model;
        private static JTextArea scriptText = null;
        private JLabel scriptLabel = null;
        private JComboBox actionCombo;
        private JTextArea script;
        private static String lastActionScript = null;
        private Action actionType = Action.STOP;

        Action getAction() {
            return this.actionType;
        }

        static String getScript() {
            return ActionsPanel.rememberLastScript();
        }

        static String rememberLastScript() {
            String text = null;
            if (scriptText != null && (text = scriptText.getText()).trim().length() == 0) {
                text = null;
            }
            lastActionScript = text;
            return text;
        }

        ActionsPanel() {
            this.model = new DefaultComboBoxModel<String>(Action.getTags());
            this.setBorder(BreakpointPanel.makeBorder(Catalog.get("BORDER_Actions")));
            this.setLayout(new GridBagLayout());
            JLabel comboLabel = new JLabel(Catalog.get("LBL_ActionsCombo"));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(0, 0, 5, 10);
            gbc.anchor = 17;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            this.add((Component)comboLabel, gbc);
            this.actionCombo = new JComboBox(this.model);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.insets = new Insets(0, 0, 5, 0);
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.gridwidth = 0;
            this.add((Component)this.actionCombo, gbc);
            comboLabel.setLabelFor(this.actionCombo);
            this.scriptLabel = new JLabel(Catalog.get("LBL_ActionsScript"));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.insets = new Insets(0, 0, 5, 10);
            gbc.anchor = 18;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            this.add((Component)this.scriptLabel, gbc);
            this.script = scriptText = new JTextArea();
            JScrollPane scrollPane = new JScrollPane(this.script);
            this.script.setColumns(30);
            this.script.setEditable(false);
            this.script.setEnabled(false);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.gridwidth = 0;
            gbc.gridheight = 0;
            this.add((Component)scrollPane, gbc);
            this.scriptLabel.setLabelFor(this.script);
            this.actionCombo.setSelectedItem(this.actionType.toString());
            if (lastActionScript != null) {
                this.script.setText(lastActionScript);
            } else {
                this.script.setText(Catalog.get("StopExample"));
            }
            this.script.setCaretPosition(0);
            this.adjustScript();
            this.actionCombo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String value = ActionsPanel.this.actionCombo.getSelectedItem().toString();
                    if (value == null) {
                        return;
                    }
                    ActionsPanel.this.actionType = Action.byTag(value);
                    ActionsPanel.this.adjustScript();
                }
            });
            Catalog.setAccessibleDescription(this.actionCombo, "ACSD_ActionsCombo");
            comboLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_Actions"));
            Catalog.setAccessibleDescription(scriptText, "ACSD_ActionsScript");
            this.scriptLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_ActionsScript"));
        }

        private void adjustScript() {
            if (this.actionType == Action.WHEN || this.actionType == Action.WHENINSTR) {
                this.scriptLabel.setEnabled(true);
                scriptText.setEnabled(true);
                scriptText.setEditable(true);
            } else {
                this.scriptLabel.setEnabled(false);
                scriptText.setEnabled(false);
                scriptText.setEditable(false);
            }
        }

        void seed(NativeBreakpoint b) {
            this.actionType = b.getAction();
            this.actionCombo.setSelectedItem(this.actionType.toString());
            this.script.setText(b.getScript());
            this.script.setCaretPosition(0);
            this.adjustScript();
        }
    }
}

