/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.classpath.ClassPathProviderImpl;
import org.netbeans.modules.maven.cos.CopyResourcesOnSave;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.modules.maven.queries.MavenFileOwnerQueryImpl;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class ProjectOpenedHookImpl
extends ProjectOpenedHook {
    private static final String PROP_BINARIES_CHECKED = "binariesChecked";
    private static final String PROP_JAVADOC_CHECKED = "javadocChecked";
    private static final String PROP_SOURCE_CHECKED = "sourceChecked";
    private final NbMavenProjectImpl project;
    private List<URI> uriReferences = new ArrayList<URI>();
    static final String UI_LOGGER_NAME = "org.netbeans.ui.maven.project";
    static final Logger UI_LOGGER = Logger.getLogger("org.netbeans.ui.maven.project");
    static final String USG_LOGGER_NAME = "org.netbeans.ui.metrics.maven";
    static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.maven");
    private static final Logger LOGGER = Logger.getLogger(ProjectOpenedHookImpl.class.getName());
    private static final AtomicBoolean checkedIndices = new AtomicBoolean();

    ProjectOpenedHookImpl(NbMavenProjectImpl proj) {
        this.project = proj;
    }

    protected void projectOpened() {
        this.checkBinaryDownloads();
        this.checkSourceDownloads();
        this.checkJavadocDownloads();
        this.project.attachUpdater();
        MavenFileOwnerQueryImpl.getInstance().registerProject(this.project);
        HashSet<URI> uris = new HashSet<URI>();
        uris.addAll(Arrays.asList(this.project.getSourceRoots(false)));
        uris.addAll(Arrays.asList(this.project.getSourceRoots(true)));
        uris.addAll(Arrays.asList(this.project.getGeneratedSourceRoots()));
        URI rootUri = FileUtil.toFile((FileObject)this.project.getProjectDirectory()).toURI();
        File rootDir = new File(rootUri);
        for (URI uri : uris) {
            if (FileUtilities.getRelativePath(rootDir, new File(uri)) != null) continue;
            FileOwnerQuery.markExternalOwner((URI)uri, (Project)this.project, (int)0);
            this.uriReferences.add(uri);
        }
        ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)this.project.getLookup().lookup(ClassPathProviderImpl.class);
        GlobalPathRegistry.getDefault().register("classpath/boot", cpProvider.getProjectClassPaths("classpath/boot"));
        GlobalPathRegistry.getDefault().register("classpath/source", cpProvider.getProjectClassPaths("classpath/source"));
        GlobalPathRegistry.getDefault().register("classpath/compile", cpProvider.getProjectClassPaths("classpath/compile"));
        this.project.doBaseProblemChecks();
        LogRecord record = new LogRecord(Level.INFO, "UI_MAVEN_PROJECT_OPENED");
        record.setLoggerName(UI_LOGGER_NAME);
        record.setParameters(new Object[]{this.project.getProjectWatcher().getPackagingType()});
        record.setResourceBundle(NbBundle.getBundle(ProjectOpenedHookImpl.class));
        UI_LOGGER.log(record);
        record = new LogRecord(Level.INFO, "USG_PROJECT_OPEN_MAVEN");
        record.setLoggerName(USG_LOGGER_NAME);
        record.setParameters(new Object[]{this.project.getProjectWatcher().getPackagingType()});
        USG_LOGGER.log(record);
        for (ArtifactRepository rep : this.project.getOriginalMavenProject().getRemoteArtifactRepositories()) {
            RepositoryInfo ri;
            if (RepositoryPreferences.getInstance().getRepositoryInfoById(rep.getId()) != null) continue;
            try {
                ri = new RepositoryInfo(rep.getId(), "nexus", rep.getId(), null, rep.getUrl());
            }
            catch (URISyntaxException x) {
                LOGGER.log(Level.WARNING, "Ignoring repo with malformed URL: {0}", x.getMessage());
                continue;
            }
            RepositoryPreferences.getInstance().addOrModifyRepositoryInfo(ri);
        }
        CopyResourcesOnSave.opened();
        if (checkedIndices.compareAndSet(false, true) && this.existsDefaultIndexLocation()) {
            final int freq = RepositoryPreferences.getInstance().getIndexUpdateFrequency();
            new RequestProcessor("Maven Repo Index Transfer/Scan").post(new Runnable(){

                @Override
                public void run() {
                    List ris = RepositoryPreferences.getInstance().getRepositoryInfos();
                    for (RepositoryInfo ri : ris) {
                        if (!ri.isRemoteDownloadable() && !ri.isLocal() || freq == 3) continue;
                        boolean run = false;
                        if (freq == 2) {
                            LOGGER.log(Level.FINER, "Index At Startup :{0}", ri.getId());
                            run = true;
                        } else if (freq == 1 && ProjectOpenedHookImpl.this.checkDiff(ri.getId(), 86400000L)) {
                            LOGGER.log(Level.FINER, "Index Once a Day :{0}", ri.getId());
                            run = true;
                        } else if (freq == 0 && ProjectOpenedHookImpl.this.checkDiff(ri.getId(), 604800000L)) {
                            LOGGER.log(Level.FINER, "Index once a Week :{0}", ri.getId());
                            run = true;
                        }
                        if (!run || !ri.isRemoteDownloadable()) continue;
                        RepositoryIndexer.indexRepo((RepositoryInfo)ri);
                    }
                }
            }, 120000);
        }
    }

    private boolean existsDefaultIndexLocation() {
        String userdir = System.getProperty("netbeans.user");
        assert (userdir != null);
        File cacheDir = new File(new File(new File(userdir, "var"), "cache"), "mavenindex");
        return cacheDir.exists() && cacheDir.isDirectory();
    }

    private boolean checkDiff(String repoid, long amount) {
        Date date = RepositoryPreferences.getInstance().getLastIndexUpdate(repoid);
        Date now = new Date();
        LOGGER.log(Level.FINER, "Check Date Diff :{0}", repoid);
        LOGGER.log(Level.FINER, "Last Indexed Date :{0}", SimpleDateFormat.getInstance().format(date));
        LOGGER.log(Level.FINER, "Now :{0}", SimpleDateFormat.getInstance().format(now));
        long diff = now.getTime() - date.getTime();
        LOGGER.log(Level.FINER, "Diff :{0}", diff);
        return diff < 0L || diff > amount;
    }

    protected void projectClosed() {
        this.uriReferences.clear();
        this.project.detachUpdater();
        ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)this.project.getLookup().lookup(ClassPathProviderImpl.class);
        GlobalPathRegistry.getDefault().unregister("classpath/boot", cpProvider.getProjectClassPaths("classpath/boot"));
        GlobalPathRegistry.getDefault().unregister("classpath/source", cpProvider.getProjectClassPaths("classpath/source"));
        GlobalPathRegistry.getDefault().unregister("classpath/compile", cpProvider.getProjectClassPaths("classpath/compile"));
        CopyResourcesOnSave.closed();
    }

    private void checkBinaryDownloads() {
        boolean alreadyChecked;
        MavenSettings.DownloadStrategy ds = MavenSettings.getDefault().getBinaryDownloadStrategy();
        if (ds.equals((Object)MavenSettings.DownloadStrategy.NEVER)) {
            return;
        }
        NbMavenProject watcher = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        Preferences prefs = ProjectUtils.getPreferences((Project)this.project, NbMavenProject.class, (boolean)false);
        if (ds.equals((Object)MavenSettings.DownloadStrategy.EVERY_OPEN)) {
            watcher.synchronousDependencyDownload();
            prefs.putBoolean(PROP_BINARIES_CHECKED, true);
            try {
                prefs.sync();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else if (ds.equals((Object)MavenSettings.DownloadStrategy.FIRST_OPEN) && !(alreadyChecked = prefs.getBoolean(PROP_BINARIES_CHECKED, false))) {
            watcher.synchronousDependencyDownload();
            prefs.putBoolean(PROP_BINARIES_CHECKED, true);
            try {
                prefs.sync();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void checkJavadocDownloads() {
        boolean alreadyChecked;
        MavenSettings.DownloadStrategy ds = MavenSettings.getDefault().getJavadocDownloadStrategy();
        if (ds.equals((Object)MavenSettings.DownloadStrategy.NEVER)) {
            return;
        }
        NbMavenProject watcher = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        Preferences prefs = ProjectUtils.getPreferences((Project)this.project, NbMavenProject.class, (boolean)false);
        if (ds.equals((Object)MavenSettings.DownloadStrategy.EVERY_OPEN)) {
            watcher.triggerSourceJavadocDownload(true);
            prefs.putBoolean(PROP_JAVADOC_CHECKED, true);
            try {
                prefs.sync();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else if (ds.equals((Object)MavenSettings.DownloadStrategy.FIRST_OPEN) && !(alreadyChecked = prefs.getBoolean(PROP_JAVADOC_CHECKED, false))) {
            watcher.triggerSourceJavadocDownload(true);
            prefs.putBoolean(PROP_JAVADOC_CHECKED, true);
            try {
                prefs.sync();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void checkSourceDownloads() {
        boolean alreadyChecked;
        MavenSettings.DownloadStrategy ds = MavenSettings.getDefault().getSourceDownloadStrategy();
        if (ds.equals((Object)MavenSettings.DownloadStrategy.NEVER)) {
            return;
        }
        NbMavenProject watcher = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        Preferences prefs = ProjectUtils.getPreferences((Project)this.project, NbMavenProject.class, (boolean)false);
        if (ds.equals((Object)MavenSettings.DownloadStrategy.EVERY_OPEN)) {
            watcher.triggerSourceJavadocDownload(false);
            prefs.putBoolean(PROP_SOURCE_CHECKED, true);
            try {
                prefs.sync();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else if (ds.equals((Object)MavenSettings.DownloadStrategy.FIRST_OPEN) && !(alreadyChecked = prefs.getBoolean(PROP_SOURCE_CHECKED, false))) {
            watcher.triggerSourceJavadocDownload(false);
            prefs.putBoolean(PROP_SOURCE_CHECKED, true);
            try {
                prefs.sync();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

