/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.util.Properties;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.options.MavenSettings;

public class TestChecker
implements PrerequisitesChecker {
    public static final String PROP_SKIP_TEST = "skipTests";

    @Override
    public boolean checkRunConfig(RunConfig config) {
        String action = config.getActionName();
        if ("test".equals(action) || "test.single".equals(action) || "debug.test.single".equals(action) || "profile-tests".equals(action)) {
            if (!RunUtils.hasTestCompileOnSaveEnabled(config)) {
                Properties props = config.getProperties();
                String test = props.getProperty("test");
                String method = props.getProperty("nb.single.run.methodName");
                if (test != null && method != null) {
                    props.remove("nb.single.run.methodName");
                    props.setProperty("test", test + '#' + method);
                    config.setProperties(props);
                }
            }
        } else if (MavenSettings.getDefault().isSkipTests()) {
            Properties props;
            if (config.getPreExecution() != null) {
                this.checkRunConfig(config.getPreExecution());
            }
            if (!(props = config.getProperties()).containsKey(PROP_SKIP_TEST)) {
                props.setProperty(PROP_SKIP_TEST, "true");
                config.setProperties(props);
            }
        }
        return true;
    }
}

