/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.api;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.css.editor.model.CssRule;
import org.netbeans.modules.css.visual.api.CssRuleContext;
import org.netbeans.modules.css.visual.api.StyleBuilderPanel;
import org.netbeans.modules.css.visual.ui.StyleBuilderAction;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class StyleBuilderTopComponent
extends TopComponent {
    public static final int MODEL_UPDATING = 1;
    public static final int MODEL_OK = 2;
    public static final int MODEL_ERROR = 3;
    public static final int OUT_OF_RULE = 4;
    private static final String DEFAULT_TC_NAME = NbBundle.getMessage(StyleBuilderAction.class, (String)"CTL_CSSStyleBuilderTopComponent");
    private static StyleBuilderTopComponent instance;
    private static final String ICON_PATH = "org/netbeans/modules/css/resources/style_builder_view_toolbar.png";
    private static final String PREFERRED_ID = "StyleBuilderTC";
    private StyleBuilderPanel styleBuilderPanel = StyleBuilderPanel.createInstance();
    private JPanel BROKEN_MODEL_PANEL;
    private JPanel NO_RULE_SELECTED_PANEL;

    private StyleBuilderTopComponent() {
        this.initComponents();
        this.setToolTipText(NbBundle.getMessage(StyleBuilderAction.class, (String)"HINT_CSSStyleBuilderTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.NO_RULE_SELECTED_PANEL = this.makeMsgPanel(NbBundle.getMessage(StyleBuilderAction.class, (String)"Out_Of_Rule"));
        this.BROKEN_MODEL_PANEL = this.makeMsgPanel(NbBundle.getMessage(StyleBuilderAction.class, (String)"Broken_Model"));
        this.setPanelMode(4);
    }

    public void setContent(CssRuleContext content) {
        CssRule rule = content.selectedRuleContent().rule();
        this.setName((rule != null ? rule.name() + " - " : "") + DEFAULT_TC_NAME);
        this.styleBuilderPanel.setContent(content);
    }

    public void setPanelMode(int mode) {
        switch (mode) {
            case 2: {
                this.styleBuilderPanel.setCursor(null);
                this.removeAll();
                this.add(this.styleBuilderPanel, "Center");
                break;
            }
            case 3: {
                this.removeAll();
                this.setName(DEFAULT_TC_NAME);
                this.add(this.BROKEN_MODEL_PANEL, "Center");
                break;
            }
            case 1: {
                this.styleBuilderPanel.setCursor(Cursor.getPredefinedCursor(3));
                break;
            }
            case 4: {
                this.setName(DEFAULT_TC_NAME);
                this.removeAll();
                this.add(this.NO_RULE_SELECTED_PANEL, "Center");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid StyleBuilder mode = " + mode);
            }
        }
        this.validate();
        this.repaint();
    }

    private JPanel makeMsgPanel(String message) {
        JPanel p = new JPanel();
        p.setBackground(Color.WHITE);
        p.setLayout(new BorderLayout());
        JLabel msgLabel = new JLabel(message);
        p.add((Component)msgLabel, "Center");
        msgLabel.setHorizontalAlignment(0);
        return p;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized StyleBuilderTopComponent getDefault() {
        if (instance == null) {
            instance = new StyleBuilderTopComponent();
        }
        return instance;
    }

    public static synchronized StyleBuilderTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(StyleBuilderTopComponent.class.getName()).warning("Cannot find StyleBuilderTC component. It will not be located properly in the window system.");
            return StyleBuilderTopComponent.getDefault();
        }
        if (win instanceof StyleBuilderTopComponent) {
            return (StyleBuilderTopComponent)win;
        }
        Logger.getLogger(StyleBuilderTopComponent.class.getName()).warning("There seem to be multiple components with the 'StyleBuilderTC' ID. That is a potential source of errors and unexpected behavior.");
        return StyleBuilderTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentActivated() {
        super.componentActivated();
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return StyleBuilderTopComponent.getDefault();
        }
    }
}

