/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.css.editor.CssEditorSupport;
import org.netbeans.modules.css.editor.model.CssRuleContent;
import org.netbeans.modules.css.visual.api.CssRuleContext;
import org.openide.util.Exceptions;

public abstract class StyleEditor
extends JPanel {
    private PropertyChangeSupport cssPropertyChangeSupport;
    CssPropertyChangeListener cssPropertyChangeListener = new CssPropertyChangeListener();
    boolean listenerAdded = false;
    private CssRuleContext content;
    private final Object LOCK = new Object();
    private Executor EXECUTOR = Executors.newSingleThreadExecutor();
    private final AtomicBoolean IN_PROPERTY_VALUES_INITIALIZATION = new AtomicBoolean(false);
    private String displayName;
    private Icon icon;

    protected StyleEditor(String name, String dispName) {
        this.setName(name);
        this.setDisplayName(dispName);
        this.armPanel();
    }

    public synchronized void setContent(final CssRuleContext content) {
        this.content = content;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StyleEditor.this.IN_PROPERTY_VALUES_INITIALIZATION.set(true);
                        StyleEditor.this.setCssPropertyValues(content.selectedRuleContent());
                        StyleEditor.this.IN_PROPERTY_VALUES_INITIALIZATION.set(false);
                        StyleEditor.this.EXECUTOR = null;
                    }
                });
            }
        };
        if (this.EXECUTOR != null) {
            this.EXECUTOR.execute(task);
        } else {
            task.run();
        }
    }

    protected void startAggregatedEventsSession() {
        if (!this.IN_PROPERTY_VALUES_INITIALIZATION.get()) {
            CssEditorSupport.getDefault().firstAggregatedEventWillFire();
        }
    }

    protected void closeAggregatedEventsSession() {
        if (!this.IN_PROPERTY_VALUES_INITIALIZATION.get()) {
            CssEditorSupport.getDefault().lastAggregatedEventFired();
        }
    }

    protected CssRuleContext content() {
        return this.content;
    }

    protected abstract void lazyInitializePanel();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializePanel() {
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.notifyAll();
        }
    }

    private StyleEditor armPanel() {
        this.EXECUTOR.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = StyleEditor.this.LOCK;
                synchronized (object) {
                    try {
                        StyleEditor.this.LOCK.wait();
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            StyleEditor.this.lazyInitializePanel();
                            StyleEditor.this.revalidate();
                            StyleEditor.this.repaint();
                        }
                    });
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        return this;
    }

    protected abstract void setCssPropertyValues(CssRuleContent var1);

    PropertyChangeSupport cssPropertyChangeSupport() {
        if (this.cssPropertyChangeSupport == null) {
            this.cssPropertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.cssPropertyChangeSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCssPropertyChangeListener(CssRuleContent styleData) {
        Class<StyleEditor> clazz = StyleEditor.class;
        synchronized (StyleEditor.class) {
            if (!this.listenerAdded) {
                this.listenerAdded = true;
                this.cssPropertyChangeListener.setCssStyleData(styleData);
                this.cssPropertyChangeSupport().addPropertyChangeListener(this.cssPropertyChangeListener);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCssPropertyChangeListener() {
        Class<StyleEditor> clazz = StyleEditor.class;
        synchronized (StyleEditor.class) {
            if (this.listenerAdded) {
                this.listenerAdded = false;
                this.cssPropertyChangeSupport().removePropertyChangeListener(this.cssPropertyChangeListener);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    static class CssPropertyChangeListener
    implements PropertyChangeListener {
        CssRuleContent cssStyleData;

        public CssPropertyChangeListener() {
        }

        public CssPropertyChangeListener(CssRuleContent styleData) {
            this.cssStyleData = styleData;
        }

        public void setCssStyleData(CssRuleContent styleData) {
            this.cssStyleData = styleData;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                this.cssStyleData.modifyProperty(evt.getPropertyName(), (String)evt.getNewValue());
            }
            catch (BadLocationException ex) {
                Logger.getLogger("global").log(Level.WARNING, "CssModel inconsistency!", ex);
            }
        }
    }
}

