/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.ext;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmConstructor;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;

public abstract class CsmCompletion {
    public static final int PUBLIC_LEVEL = 3;
    public static final int PROTECTED_LEVEL = 2;
    public static final int PACKAGE_LEVEL = 1;
    public static final int PRIVATE_LEVEL = 0;
    public static final SimpleClass BOOLEAN_CLASS;
    public static final SimpleClass BYTE_CLASS;
    public static final SimpleClass CHAR_CLASS;
    public static final SimpleClass DOUBLE_CLASS;
    public static final SimpleClass FLOAT_CLASS;
    public static final SimpleClass INT_CLASS;
    public static final SimpleClass LONG_CLASS;
    public static final SimpleClass SHORT_CLASS;
    public static final SimpleClass VOID_CLASS;
    public static final SimpleClass UNSIGNED_CHAR_CLASS;
    public static final SimpleClass UNSIGNED_INT_CLASS;
    public static final SimpleClass UNSIGNED_LONG_CLASS;
    public static final SimpleClass UNSIGNED_SHORT_CLASS;
    public static final BaseType BOOLEAN_TYPE;
    public static final BaseType BYTE_TYPE;
    public static final BaseType CHAR_TYPE;
    public static final BaseType DOUBLE_TYPE;
    public static final BaseType FLOAT_TYPE;
    public static final BaseType INT_TYPE;
    public static final BaseType LONG_TYPE;
    public static final BaseType SHORT_TYPE;
    public static final BaseType UNSIGNED_CHAR_TYPE;
    public static final BaseType UNSIGNED_INT_TYPE;
    public static final BaseType UNSIGNED_LONG_TYPE;
    public static final BaseType UNSIGNED_SHORT_TYPE;
    public static final BaseType VOID_TYPE;
    public static final SimpleClass INVALID_CLASS;
    public static final BaseType INVALID_TYPE;
    public static final SimpleClass NULL_CLASS;
    public static final BaseType NULL_TYPE;
    public static final SimpleClass OBJECT_CLASS_ARRAY;
    public static final BaseType OBJECT_TYPE_ARRAY;
    public static final SimpleClass OBJECT_CLASS;
    public static final BaseType OBJECT_TYPE;
    public static final SimpleClass CLASS_CLASS;
    public static final BaseType CLASS_TYPE;
    public static final SimpleClass STRING_CLASS;
    public static final BaseType STRING_TYPE;
    public static final SimpleClass CONST_STRING_CLASS;
    public static final BaseType CONST_STRING_TYPE;
    public static final BaseType CONST_BOOLEAN_TYPE;
    public static final BaseType CONST_BYTE_TYPE;
    public static final BaseType CONST_CHAR_TYPE;
    public static final BaseType CONST_DOUBLE_TYPE;
    public static final BaseType CONST_FLOAT_TYPE;
    public static final BaseType CONST_INT_TYPE;
    public static final BaseType CONST_LONG_TYPE;
    public static final BaseType CONST_SHORT_TYPE;
    public static final BaseType CONST_VOID_TYPE;
    public static final int LOCAL_MEMBER_BIT = 0x20000000;
    public static final int DEPRECATED_BIT = 0x100000;
    private static final Map<CharSequence, CsmClassifier> str2PrimitiveClass;
    private static final Map<CharSequence, BaseType> str2PrimitiveType;
    private static final Map<CharSequence, BaseType> str2PredefinedType;
    public static final CsmParameter[] EMPTY_PARAMETERS;
    public static final CsmClassifier[] EMPTY_CLASSES;
    public static final CsmNamespace[] EMPTY_NAMESPACES;
    public static final CsmField[] EMPTY_FIELDS;
    public static final CsmConstructor[] EMPTY_CONSTRUCTORS;
    public static final CsmMethod[] EMPTY_METHODS;
    public static final String SCOPE = "::";
    private static int debugMode;
    public static final int DEBUG_EXP = 1;
    public static final int DEBUG_FIND = 2;

    private CsmCompletion() {
    }

    public static int getLevel(int modifiers) {
        if ((modifiers & 1) != 0) {
            return 3;
        }
        if ((modifiers & 4) != 0) {
            return 2;
        }
        if ((modifiers & 2) == 0) {
            return 1;
        }
        return 0;
    }

    public static boolean isPrimitiveClassName(String s) {
        return CndLexerUtilities.isType((String)s);
    }

    public static boolean isPrimitiveClass(CsmClassifier c) {
        return CsmCompletion.isPrimitiveClassName(((Object)c.getName()).toString());
    }

    private static BaseType getPrimitiveType(String s) {
        return str2PrimitiveType.get(s);
    }

    public static CsmType getPredefinedType(CsmFile containingFile, int start, int end, String s) {
        BaseType baseType = CsmCompletion.getPrimitiveType(s);
        if (baseType == null) {
            baseType = str2PredefinedType.get(s);
        }
        if (baseType != null) {
            return new OffsetableType(baseType, containingFile, start, end);
        }
        return null;
    }

    public static Iterator getPrimitiveClassIterator() {
        return str2PrimitiveClass.values().iterator();
    }

    public static CsmClassifier getSimpleClass(CsmClassifier clazz) {
        SimpleClass cls = null;
        if (clazz != null) {
            cls = new SimpleClass(clazz);
        }
        return cls;
    }

    public static CsmClassifier createSimpleClass(String fullClassName) {
        int nameInd = fullClassName.lastIndexOf(SCOPE) + 1;
        return CsmCompletion.createSimpleClass(fullClassName.substring(nameInd), nameInd > 0 ? fullClassName.substring(0, nameInd - 1) : "");
    }

    public static CsmClassifier createSimpleClass(String name, String packageName) {
        return new SimpleClass(name, packageName, CsmDeclaration.Kind.CLASS);
    }

    public static CsmType createType(CsmClassifier cls, int ptrDepth, int arrayDepth, boolean _const) {
        return new BaseType(cls, ptrDepth, false, arrayDepth, _const);
    }

    public static CsmType getObjectType(CsmObject obj, boolean _constIfClassifier) {
        Object type = null;
        if (CsmKindUtilities.isTypedef((CsmObject)obj)) {
            type = ((CsmTypedef)obj).getType();
        } else if (CsmKindUtilities.isClassifier((CsmObject)obj)) {
            type = CsmCompletion.getType((CsmClassifier)obj, 0, false, 0, _constIfClassifier);
        } else if (CsmKindUtilities.isFunction((CsmObject)obj)) {
            CsmFunction fun = (CsmFunction)obj;
            if (CsmKindUtilities.isConstructor((CsmObject)fun)) {
                CsmClass cls = ((CsmConstructor)obj).getContainingClass();
                type = CsmCompletion.getType((CsmClassifier)cls, 0, false, 0, false);
            } else {
                type = fun.getReturnType();
            }
        } else {
            type = CsmKindUtilities.isVariable((CsmObject)obj) ? ((CsmVariable)obj).getType() : (CsmKindUtilities.isEnumerator((Object)obj) ? INT_TYPE : null);
        }
        return type;
    }

    public static CsmType getType(CsmClassifier cls, int pointerDepth, boolean reference, int arrayDepth, boolean _const) {
        if (cls == null) {
            return null;
        }
        return new BaseType(cls, pointerDepth, reference, arrayDepth, _const);
    }

    public static int getDebugMode() {
        return debugMode;
    }

    public static void setDebugMode(int newDebugMode) {
        debugMode = newDebugMode;
    }

    static {
        String typeName;
        int i;
        BOOLEAN_CLASS = new SimpleClass("boolean", "");
        BYTE_CLASS = new SimpleClass("byte", "");
        CHAR_CLASS = new SimpleClass("char", "");
        DOUBLE_CLASS = new SimpleClass("double", "");
        FLOAT_CLASS = new SimpleClass("float", "");
        INT_CLASS = new SimpleClass("int", "");
        LONG_CLASS = new SimpleClass("long", "");
        SHORT_CLASS = new SimpleClass("short", "");
        VOID_CLASS = new SimpleClass("void", "");
        UNSIGNED_CHAR_CLASS = new SimpleClass("unsigned char", "");
        UNSIGNED_INT_CLASS = new SimpleClass("unsigned int", "");
        UNSIGNED_LONG_CLASS = new SimpleClass("unsigned long", "");
        UNSIGNED_SHORT_CLASS = new SimpleClass("unsigned short", "");
        BOOLEAN_TYPE = new BaseType(BOOLEAN_CLASS, 0, false, 0, false);
        BYTE_TYPE = new BaseType(BYTE_CLASS, 0, false, 0, false);
        CHAR_TYPE = new BaseType(CHAR_CLASS, 0, false, 0, false);
        DOUBLE_TYPE = new BaseType(DOUBLE_CLASS, 0, false, 0, false);
        FLOAT_TYPE = new BaseType(FLOAT_CLASS, 0, false, 0, false);
        INT_TYPE = new BaseType(INT_CLASS, 0, false, 0, false);
        LONG_TYPE = new BaseType(LONG_CLASS, 0, false, 0, false);
        SHORT_TYPE = new BaseType(SHORT_CLASS, 0, false, 0, false);
        UNSIGNED_CHAR_TYPE = new BaseType(UNSIGNED_CHAR_CLASS, 0, false, 0, false);
        UNSIGNED_INT_TYPE = new BaseType(UNSIGNED_INT_CLASS, 0, false, 0, false);
        UNSIGNED_LONG_TYPE = new BaseType(UNSIGNED_LONG_CLASS, 0, false, 0, false);
        UNSIGNED_SHORT_TYPE = new BaseType(UNSIGNED_SHORT_CLASS, 0, false, 0, false);
        VOID_TYPE = new BaseType(VOID_CLASS, 0, false, 0, false);
        INVALID_CLASS = new SimpleClass("", "");
        INVALID_TYPE = new BaseType(INVALID_CLASS, 0, false, 0, false);
        NULL_CLASS = new SimpleClass("null", "");
        NULL_TYPE = new BaseType(NULL_CLASS, 0, false, 0, false);
        OBJECT_CLASS_ARRAY = new SimpleClass("java.lang.Object[]", "java.lang".length(), true);
        OBJECT_TYPE_ARRAY = new BaseType(OBJECT_CLASS_ARRAY, 0, false, 0, false);
        OBJECT_CLASS = new SimpleClass("java.lang.Object", "java.lang".length(), true);
        OBJECT_TYPE = new BaseType(OBJECT_CLASS, 0, false, 0, false);
        CLASS_CLASS = new SimpleClass("java.lang.Class", "java.lang".length(), true);
        CLASS_TYPE = new BaseType(CLASS_CLASS, 0, false, 0, false);
        STRING_CLASS = new SimpleClass("char", 0, true);
        STRING_TYPE = new BaseType(STRING_CLASS, 1, false, 0, false);
        CONST_STRING_CLASS = new SimpleClass("const char", 0, true);
        CONST_STRING_TYPE = new BaseType(CONST_STRING_CLASS, 1, false, 0, true);
        CONST_BOOLEAN_TYPE = new BaseType(BOOLEAN_CLASS, 0, false, 0, true);
        CONST_BYTE_TYPE = new BaseType(BYTE_CLASS, 0, false, 0, true);
        CONST_CHAR_TYPE = new BaseType(CHAR_CLASS, 0, false, 0, true);
        CONST_DOUBLE_TYPE = new BaseType(DOUBLE_CLASS, 0, false, 0, true);
        CONST_FLOAT_TYPE = new BaseType(FLOAT_CLASS, 0, false, 0, true);
        CONST_INT_TYPE = new BaseType(INT_CLASS, 0, false, 0, true);
        CONST_LONG_TYPE = new BaseType(LONG_CLASS, 0, false, 0, true);
        CONST_SHORT_TYPE = new BaseType(SHORT_CLASS, 0, false, 0, true);
        CONST_VOID_TYPE = new BaseType(VOID_CLASS, 0, false, 0, true);
        str2PrimitiveClass = new HashMap<CharSequence, CsmClassifier>();
        str2PrimitiveType = new HashMap<CharSequence, BaseType>();
        str2PredefinedType = new HashMap<CharSequence, BaseType>();
        BaseType[] types = new BaseType[]{BOOLEAN_TYPE, BYTE_TYPE, CHAR_TYPE, DOUBLE_TYPE, FLOAT_TYPE, INT_TYPE, LONG_TYPE, SHORT_TYPE, VOID_TYPE, UNSIGNED_CHAR_TYPE, UNSIGNED_INT_TYPE, UNSIGNED_LONG_TYPE, UNSIGNED_SHORT_TYPE};
        for (i = types.length - 1; i >= 0; --i) {
            typeName = ((Object)types[i].getClassifier().getName()).toString();
            str2PrimitiveClass.put(typeName, types[i].getClassifier());
            str2PrimitiveType.put(typeName, types[i]);
        }
        types = new BaseType[]{NULL_TYPE, OBJECT_TYPE_ARRAY, OBJECT_TYPE, CLASS_TYPE, STRING_TYPE, CONST_STRING_TYPE, CONST_BOOLEAN_TYPE, CONST_BYTE_TYPE, CONST_CHAR_TYPE, CONST_DOUBLE_TYPE, CONST_FLOAT_TYPE, CONST_INT_TYPE, CONST_LONG_TYPE, CONST_SHORT_TYPE, CONST_VOID_TYPE};
        for (i = types.length - 1; i >= 0; --i) {
            typeName = ((Object)types[i].getClassifier().getName()).toString();
            str2PredefinedType.put(typeName, types[i]);
            str2PredefinedType.put(types[i].getClassifier().getQualifiedName(), types[i]);
            str2PredefinedType.put(types[i].format(true), types[i]);
        }
        EMPTY_PARAMETERS = new CsmParameter[0];
        EMPTY_CLASSES = new CsmClassifier[0];
        EMPTY_NAMESPACES = new CsmNamespace[0];
        EMPTY_FIELDS = new CsmField[0];
        EMPTY_CONSTRUCTORS = new CsmConstructor[0];
        EMPTY_METHODS = new CsmMethod[0];
    }

    public static class OffsetableType
    implements CsmType {
        private final CsmType delegate;
        private final CsmFile container;
        private final int start;
        private final int end;

        public OffsetableType(BaseType delegate, CsmFile container, int start, int end) {
            assert (delegate != null);
            assert (container != null);
            this.delegate = delegate;
            this.container = container;
            this.start = start;
            this.end = end;
        }

        public int getArrayDepth() {
            return this.delegate.getArrayDepth();
        }

        public int hashCode() {
            return this.delegate.hashCode() + this.container.hashCode() + this.start + this.end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof CsmType) {
                CsmType t = (CsmType)o;
                return this.delegate.equals(t) && this.container.equals(t.getContainingFile()) && this.start == t.getStartOffset() && this.end == t.getEndOffset();
            }
            return false;
        }

        public String toString() {
            return this.delegate.toString();
        }

        public CsmClassifier getClassifier() {
            return this.delegate.getClassifier();
        }

        public List<CsmSpecializationParameter> getInstantiationParams() {
            return this.delegate.getInstantiationParams();
        }

        public boolean isInstantiation() {
            return this.delegate.isInstantiation();
        }

        public boolean isTemplateBased() {
            return this.delegate.isTemplateBased();
        }

        public CharSequence getClassifierText() {
            return this.delegate.getClassifierText();
        }

        public boolean isPointer() {
            return this.delegate.isPointer();
        }

        public int getPointerDepth() {
            return this.delegate.getPointerDepth();
        }

        public boolean isReference() {
            return this.delegate.isReference();
        }

        public boolean isConst() {
            return this.delegate.isConst();
        }

        public CharSequence getText() {
            return this.delegate.getText();
        }

        public CharSequence getCanonicalText() {
            return this.delegate.getCanonicalText();
        }

        public CsmFile getContainingFile() {
            return this.container;
        }

        public int getStartOffset() {
            return this.start;
        }

        public int getEndOffset() {
            return this.end;
        }

        public CsmOffsetable.Position getStartPosition() {
            return null;
        }

        public CsmOffsetable.Position getEndPosition() {
            return null;
        }

        public boolean isBuiltInBased(boolean resolveTypeChain) {
            return this.delegate.isBuiltInBased(resolveTypeChain);
        }
    }

    public static class BaseType
    implements CsmType {
        protected CsmClassifier clazz;
        protected int arrayDepth;
        protected int pointerDepth;
        protected boolean reference;
        protected boolean _const;

        public BaseType(CsmClassifier clazz, int pointerDepth, boolean reference, int arrayDepth, boolean _const) {
            this.clazz = clazz;
            this.arrayDepth = arrayDepth;
            this.pointerDepth = pointerDepth;
            this.reference = reference;
            this._const = _const;
            if (arrayDepth < 0) {
                throw new IllegalArgumentException("Array depth " + arrayDepth + " < 0.");
            }
        }

        BaseType() {
        }

        public int getArrayDepth() {
            return this.arrayDepth;
        }

        public String format(boolean useFullName) {
            StringBuilder sb = new StringBuilder();
            if (this._const) {
                sb.append("const ");
            }
            CsmClassifier classifier = this.getClassifier();
            sb.append(classifier.getQualifiedName());
            for (int pd = this.pointerDepth; pd > 0; --pd) {
                sb.append("*");
            }
            for (int ad = this.arrayDepth; ad > 0; --ad) {
                sb.append("[]");
            }
            return sb.toString();
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            CsmType t = (CsmType)o;
            int order = ((Object)this.clazz.getQualifiedName()).toString().compareTo(((Object)t.getClassifier().getQualifiedName()).toString());
            if (order == 0) {
                order = this.arrayDepth - t.getArrayDepth();
            }
            return order;
        }

        public int hashCode() {
            return this.clazz.hashCode() + this.arrayDepth;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof CsmType) {
                CsmType t = (CsmType)o;
                return this.clazz.equals(t.getClassifier()) && this.arrayDepth == t.getArrayDepth() && this.pointerDepth == t.getPointerDepth() && this._const == t.isConst();
            }
            return false;
        }

        public String toString() {
            return this.format(true);
        }

        public CsmClassifier getClassifier() {
            if (this.clazz instanceof SimpleClass) {
                return ((SimpleClass)this.clazz).clazz == null ? this.clazz : ((SimpleClass)this.clazz).clazz;
            }
            return this.clazz;
        }

        public List<CsmSpecializationParameter> getInstantiationParams() {
            return Collections.emptyList();
        }

        public boolean isInstantiation() {
            return false;
        }

        public boolean isTemplateBased() {
            return CsmKindUtilities.isTemplateParameter((CsmObject)this.clazz);
        }

        public CharSequence getClassifierText() {
            return this.clazz.getName();
        }

        public boolean isPointer() {
            return this.pointerDepth > 0;
        }

        public int getPointerDepth() {
            return this.pointerDepth;
        }

        public boolean isReference() {
            return this.reference;
        }

        public boolean isConst() {
            return this._const;
        }

        public CharSequence getText() {
            return this.format(true);
        }

        public CharSequence getCanonicalText() {
            return this.getText();
        }

        public CsmFile getContainingFile() {
            if (CsmKindUtilities.isOffsetable((Object)this.clazz)) {
                return ((CsmOffsetable)this.clazz).getContainingFile();
            }
            return null;
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return 0;
        }

        public CsmOffsetable.Position getStartPosition() {
            return null;
        }

        public CsmOffsetable.Position getEndPosition() {
            return null;
        }

        public boolean isBuiltInBased(boolean resolveTypeChain) {
            return CsmKindUtilities.isBuiltIn((CsmObject)this.clazz);
        }
    }

    public static class SimpleClass
    implements CsmClassifier {
        protected CharSequence name;
        protected String packageName = "";
        protected CharSequence fullName;
        protected CsmDeclaration.Kind kind;
        private String stringValue;
        private CsmClassifier clazz;

        public SimpleClass(CsmClassifier clazz) {
            this.clazz = clazz;
            this.name = clazz.getName();
            this.fullName = clazz.getQualifiedName();
        }

        public SimpleClass(String name, String packageName, CsmDeclaration.Kind kind) {
            this.name = name;
            this.packageName = packageName != null ? packageName : "";
            this.kind = kind;
            if (name == null || kind == null) {
                throw new NullPointerException("className=" + name + ", kind=" + kind);
            }
        }

        public SimpleClass(String name, String packageName) {
            this(name, packageName, CsmDeclaration.Kind.BUILT_IN);
        }

        public SimpleClass(String fullName, int packageNameLen, boolean intern) {
            this.fullName = fullName;
            if (packageNameLen <= 0 || packageNameLen >= fullName.length()) {
                this.name = fullName;
                this.packageName = "";
            } else {
                this.name = fullName.substring(packageNameLen + 1);
                this.packageName = fullName.substring(0, packageNameLen);
                if (intern) {
                    this.name = ((String)this.name).intern();
                    this.packageName = this.packageName.intern();
                }
            }
        }

        SimpleClass() {
        }

        public final CharSequence getName() {
            if (this.clazz != null) {
                return this.clazz.getName();
            }
            return this.name;
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public CharSequence getQualifiedName() {
            if (this.clazz != null) {
                return this.clazz.getQualifiedName();
            }
            if (this.fullName == null) {
                this.fullName = this.packageName.length() > 0 ? this.packageName + "." + this.name : this.name;
            }
            return this.fullName;
        }

        public CharSequence getUniqueName() {
            return this.getQualifiedName();
        }

        public int getTagOffset() {
            return -1;
        }

        public boolean isInterface() {
            return false;
        }

        public int getModifiers() {
            return 0;
        }

        public CsmClassifier getSuperclass() {
            return null;
        }

        public CsmClassifier[] getInterfaces() {
            return EMPTY_CLASSES;
        }

        public CsmField[] getFields() {
            return EMPTY_FIELDS;
        }

        public CsmConstructor[] getConstructors() {
            return EMPTY_CONSTRUCTORS;
        }

        public CsmMethod[] getMethods() {
            return EMPTY_METHODS;
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            CsmClassifier c = (CsmClassifier)o;
            int order = 0;
            if (order == 0) {
                order = ((Object)this.name).toString().compareTo(((Object)c.getName()).toString());
            }
            return order;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.packageName.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof CsmClassifier) {
                CsmClassifier c = (CsmClassifier)o;
                String className = c.getName() == null ? null : ((Object)c.getName()).toString().replace('.', '$');
                String thisName = ((Object)this.name).toString().replace('.', '$');
                return thisName.equals(className);
            }
            return false;
        }

        public String toString() {
            if (this.stringValue == null) {
                this.stringValue = this.getPackageName().length() > 0 ? this.getPackageName() + '.' + ((Object)this.getName()).toString().replace('.', '$') : ((Object)this.getName()).toString().replace('.', '$');
            }
            return this.stringValue;
        }

        public CsmDeclaration.Kind getKind() {
            if (this.clazz != null) {
                return this.clazz.getKind();
            }
            return this.kind;
        }

        public CsmScope getScope() {
            if (this.clazz != null) {
                return this.clazz.getScope();
            }
            return null;
        }

        public boolean isValid() {
            return CsmBaseUtilities.isValid((CsmObject)this.clazz);
        }
    }
}

