/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.partitioning;

import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.descriptors.partitioning.UnionPartitioningPolicy;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.ReplicationPartitioningMetadata;

public class UnionPartitioningMetadata
extends ReplicationPartitioningMetadata {
    protected Boolean replicateWrites;

    public UnionPartitioningMetadata() {
        super("<union-partitioning>");
    }

    public UnionPartitioningMetadata(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject) {
        super(annotation, accessibleObject);
        this.replicateWrites = (Boolean)annotation.getAttribute("replicateWrites");
    }

    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof UnionPartitioningMetadata) {
            UnionPartitioningMetadata policy = (UnionPartitioningMetadata)objectToCompare;
            return this.valuesMatch(this.replicateWrites, policy.getReplicateWrites());
        }
        return false;
    }

    public PartitioningPolicy buildPolicy() {
        UnionPartitioningPolicy policy = new UnionPartitioningPolicy();
        super.buildPolicy(policy);
        if (this.replicateWrites != null) {
            policy.setReplicateWrites(this.replicateWrites);
        }
        return policy;
    }

    public Boolean getReplicateWrites() {
        return this.replicateWrites;
    }

    public void setReplicateWrites(Boolean replicateWrites) {
        this.replicateWrites = replicateWrites;
    }
}

