/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.dtrace.collector.support;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.acl.NotOwnerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.execution.AttachableTarget;
import org.netbeans.modules.dlight.api.execution.DLightDeploymentService;
import org.netbeans.modules.dlight.api.execution.DLightDeploymentTarget;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.storage.StackDataStorage;
import org.netbeans.modules.dlight.dtrace.collector.DTDCConfiguration;
import org.netbeans.modules.dlight.dtrace.collector.DTraceOutputParser;
import org.netbeans.modules.dlight.dtrace.collector.impl.DTDCConfigurationAccessor;
import org.netbeans.modules.dlight.dtrace.collector.support.DataAndStacksParser;
import org.netbeans.modules.dlight.dtrace.collector.support.DataOnlyParser;
import org.netbeans.modules.dlight.dtrace.collector.support.DefaultOutputProcessor;
import org.netbeans.modules.dlight.dtrace.collector.support.DemultiplexingOutputProcessor;
import org.netbeans.modules.dlight.dtrace.collector.support.OutputProcessor;
import org.netbeans.modules.dlight.extras.api.support.CollectorRunner;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.collector.DataCollectorListener;
import org.netbeans.modules.dlight.spi.collector.DataCollectorListenersSupport;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.spi.indicator.IndicatorNotificationsListener;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.Util;
import org.netbeans.modules.dlight.util.usagetracking.SunStudioUserCounter;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.SolarisPrivilegesSupport;
import org.netbeans.modules.nativeexecution.api.util.SolarisPrivilegesSupportProvider;
import org.openide.util.NbBundle;

public final class DtraceDataCollector
extends IndicatorDataProvider<DTDCConfiguration>
implements DataCollector<DTDCConfiguration> {
    private static final List<String> ultimateDTracePrivilegesList = Arrays.asList("dtrace_kernel", "dtrace_proc", "dtrace_user");
    private static final String command = "/usr/sbin/dtrace";
    private static final Logger log = DLightLogger.getLogger(DtraceDataCollector.class);
    private final Set<String> requiredPrivilegesSet = new HashSet<String>();
    private DataTableMetadata tableMetaData = null;
    private URL localScriptUrl;
    private String extraArgs;
    private String scriptPath;
    private CollectorRunner dtraceRunner = null;
    private DTDCConfiguration configuration;
    private DataStorage storage;
    private StackDataStorage stackStorage;
    private List<DataTableMetadata> dataTablesMetadata;
    private DTraceOutputParser parser;
    private final List<DataRow> indicatorDataBuffer = new ArrayList<DataRow>();
    private int indicatorFiringFactor;
    private OutputProcessor outputProcessor;
    private boolean isSlave;
    private final boolean multiScriptMode;
    private DtraceDataCollector parentCollector;
    private final Map<String, DtraceDataCollector> slaveCollectors;
    private volatile boolean terminated = false;
    private boolean isDeploymentTarget = false;
    private final DataCollectorListenersSupport dclsupport = new DataCollectorListenersSupport((DataCollector)this);
    private static final String bootstrapScript = "/org/netbeans/modules/dlight/dtrace/resources/bootstrap.d";
    private static final String eofMarker = "__EOF_MARKER__";

    DtraceDataCollector(boolean multiScriptMode, DTDCConfiguration configuration) {
        super("DTrace");
        this.multiScriptMode = multiScriptMode;
        DTDCConfigurationAccessor cfgInfo = DTDCConfigurationAccessor.getDefault();
        if (multiScriptMode) {
            this.dataTablesMetadata = new ArrayList<DataTableMetadata>();
            this.tableMetaData = null;
            this.slaveCollectors = new HashMap<String, DtraceDataCollector>();
            this.outputProcessor = new DemultiplexingOutputProcessor(Collections.unmodifiableMap(this.slaveCollectors));
            this.addSlaveConfiguration(configuration);
        } else {
            assert (cfgInfo.getScriptUrl(configuration) != null);
            this.dataTablesMetadata = cfgInfo.getDatatableMetadata(configuration);
            this.slaveCollectors = Collections.emptyMap();
            this.tableMetaData = this.dataTablesMetadata != null && this.dataTablesMetadata.size() > 0 ? this.dataTablesMetadata.get(0) : null;
            this.outputProcessor = new DefaultOutputProcessor(this.tableMetaData);
            this.parser = cfgInfo.isStackSupportEnabled(configuration) ? new DataAndStacksParser(this.tableMetaData) : (cfgInfo.getParser(configuration) == null ? (this.tableMetaData != null ? new DataOnlyParser(this.tableMetaData) : (DataOnlyParser)null) : cfgInfo.getParser(configuration));
            this.localScriptUrl = cfgInfo.getScriptUrl(configuration);
            this.extraArgs = cfgInfo.getArgs(configuration);
            List<String> requiredPrivileges = cfgInfo.getRequiredPrivileges(configuration);
            if (requiredPrivileges != null) {
                this.requiredPrivilegesSet.addAll(requiredPrivileges);
            } else {
                this.requiredPrivilegesSet.addAll(ultimateDTracePrivilegesList);
            }
            this.configuration = configuration;
            this.indicatorFiringFactor = cfgInfo.getIndicatorFiringFactor(configuration);
        }
        this.terminated = false;
    }

    public final void addDataCollectorListener(DataCollectorListener listener) {
        this.dclsupport.addListener(listener);
    }

    public final void removeDataCollectorListener(DataCollectorListener listener) {
        this.dclsupport.removeListener(listener);
    }

    protected final void notifyListeners(DataCollector.CollectorState state) {
        this.dclsupport.notifyListeners(state);
    }

    void addSlaveConfiguration(DTDCConfiguration configuration) {
        if (!this.multiScriptMode) {
            throw new IllegalStateException("addSlaveConfiguration called in single-script mode");
        }
        for (DtraceDataCollector dc : this.slaveCollectors.values()) {
            if (dc.configuration != configuration) continue;
            return;
        }
        DTDCConfigurationAccessor accessor = DTDCConfigurationAccessor.getDefault();
        List<String> requiredPrivileges = accessor.getRequiredPrivileges(configuration);
        this.requiredPrivilegesSet.addAll(requiredPrivileges == null ? ultimateDTracePrivilegesList : requiredPrivileges);
        if (accessor.getScriptUrl(configuration) == null) {
            return;
        }
        DtraceDataCollector slaveCollector = new DtraceDataCollector(false, configuration);
        slaveCollector.setSlave(true);
        slaveCollector.setParentCollector(this);
        this.slaveCollectors.put(accessor.getOutputPrefix(configuration), slaveCollector);
    }

    void setParentCollector(DtraceDataCollector parentCollector) {
        this.parentCollector = parentCollector;
    }

    void setSlave(boolean isSlave) {
        this.isSlave = isSlave;
    }

    URL getLocalScriptUrl() {
        return this.localScriptUrl;
    }

    void setLocalScriptUrl(URL path) {
        this.localScriptUrl = path;
    }

    OutputProcessor getOutputProcessor() {
        return this.outputProcessor;
    }

    protected DataStorage getStorage() {
        return this.storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDataRow(DataRow dataRow) {
        if (dataRow == null || this.isDeploymentTarget && this.terminated) {
            return;
        }
        if (this.storage != null && this.tableMetaData != null) {
            this.storage.addData(this.tableMetaData.getName(), Arrays.asList(dataRow));
        }
        List<DataRow> list = this.indicatorDataBuffer;
        synchronized (list) {
            this.indicatorDataBuffer.add(dataRow);
            if (this.indicatorDataBuffer.size() >= this.indicatorFiringFactor) {
                if (this.isSlave) {
                    if (this.parentCollector != null) {
                        this.parentCollector.notifyIndicators(this.indicatorDataBuffer);
                    }
                } else {
                    this.notifyIndicators(this.indicatorDataBuffer);
                }
                this.indicatorDataBuffer.clear();
            }
        }
    }

    public Collection<DataStorageType> getRequiredDataStorageTypes() {
        DataStorageTypeFactory dstf = DataStorageTypeFactory.getInstance();
        DataStorageType sqlStorageType = dstf.getDataStorageType("db:sql");
        DataStorageType stackStorageType = dstf.getDataStorageType("stack");
        return Arrays.asList(sqlStorageType, stackStorageType);
    }

    public boolean isAttachable() {
        return true;
    }

    public void init(Map<DataStorageType, DataStorage> storages, DLightTarget target) {
        if (this.multiScriptMode) {
            for (DtraceDataCollector ddc : this.slaveCollectors.values()) {
                ddc.init(storages, target);
            }
        }
        DataStorageTypeFactory dstf = DataStorageTypeFactory.getInstance();
        this.storage = storages.get(dstf.getDataStorageType("db:sql"));
        this.stackStorage = (StackDataStorage)storages.get(dstf.getDataStorageType("stack"));
        this.outputProcessor.init(this, this.stackStorage);
        if (this.isSlave) {
            return;
        }
        ExecutionEnvironment trgExecEnv = target.getExecEnv();
        try {
            this.scriptPath = this.mergeAndUploadScripts(trgExecEnv);
        }
        catch (IOException ex) {
            DLightLogger.getLogger(DtraceDataCollector.class).log(Level.SEVERE, null, ex);
        }
        catch (ConnectionManager.CancellationException ex) {
            DLightLogger.getLogger(DtraceDataCollector.class).log(Level.SEVERE, null, ex);
        }
    }

    public String getCmd() {
        return command;
    }

    public String[] getArgs() {
        return null;
    }

    public List<DataTableMetadata> getDataTablesMetadata() {
        ArrayList<DataTableMetadata> ret = new ArrayList<DataTableMetadata>();
        ret.addAll(this.dataTablesMetadata);
        for (DtraceDataCollector ddc : this.slaveCollectors.values()) {
            ret.addAll(ddc.getDataTablesMetadata());
        }
        return ret;
    }

    protected String getCollectorTaskExtraParams() {
        return this.extraArgs;
    }

    void packageVisibleSuggestIndicatorsRepaint() {
        super.suggestIndicatorsRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void targetFinished(DLightTarget target) {
        if (!this.isSlave && this.dtraceRunner != null) {
            log.log(Level.FINE, "Stopping DtraceDataCollector: {0}", this.dtraceRunner.toString());
            this.dtraceRunner.shutdown(this.terminated);
        }
        if (this.isDeploymentTarget && this.terminated) {
            return;
        }
        List<DataRow> list = this.indicatorDataBuffer;
        synchronized (list) {
            if (!this.indicatorDataBuffer.isEmpty()) {
                if (this.isSlave) {
                    if (this.parentCollector != null) {
                        this.parentCollector.notifyIndicators(this.indicatorDataBuffer);
                    }
                } else {
                    this.notifyIndicators(this.indicatorDataBuffer);
                }
                this.indicatorDataBuffer.clear();
            }
        }
    }

    private static String loc(String key, String ... param) {
        return NbBundle.getMessage(DtraceDataCollector.class, (String)key, (Object[])param);
    }

    protected ValidationStatus doValidation(DLightTarget target) {
        DLightLogger.assertNonUiThread();
        ExecutionEnvironment execEnv = target.getExecEnv();
        ConnectionManager mgr = ConnectionManager.getInstance();
        boolean isConnected = mgr.isConnectedTo(execEnv);
        if (!isConnected) {
            Runnable doOnConnect = new Runnable(){

                @Override
                public void run() {
                    DLightManager.getDefault().revalidateSessions();
                }
            };
            AsynchronousAction connectAction = mgr.getConnectToAction(execEnv, doOnConnect);
            return ValidationStatus.unknownStatus((String)DtraceDataCollector.loc("ValidationStatus.HostNotConnected", new String[0]), (AsynchronousAction)connectAction);
        }
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv);
            if (hostInfo == null || hostInfo.getOSFamily() != HostInfo.OSFamily.SUNOS) {
                return ValidationStatus.invalidStatus((String)NbBundle.getMessage(DtraceDataCollector.class, (String)"DtraceDataCollector.DtraceIsSupportedOnSunOSOnly"));
            }
            if (!HostInfoUtils.fileExists((ExecutionEnvironment)execEnv, (String)command)) {
                return ValidationStatus.invalidStatus((String)DtraceDataCollector.loc("ValidationStatus.CommandNotFound", command));
            }
        }
        catch (Exception ex) {
            return ValidationStatus.invalidStatus((String)DtraceDataCollector.loc("ValidationStatus.ErrorWhileValidation", ex.getMessage()));
        }
        ProcessUtils.ExitStatus zonenameResult = ProcessUtils.execute((ExecutionEnvironment)execEnv, (String)"/sbin/zonename", (String[])new String[0]);
        if (!zonenameResult.isOK() || !"global".equals(zonenameResult.output)) {
            return ValidationStatus.invalidStatus((String)DtraceDataCollector.loc("ValidationStatus.NotGlobalZone", command));
        }
        SolarisPrivilegesSupport sps = SolarisPrivilegesSupportProvider.getSupportFor((ExecutionEnvironment)execEnv);
        if (sps == null) {
            return ValidationStatus.invalidStatus((String)NbBundle.getMessage(DtraceDataCollector.class, (String)"DtraceDataCollector.NoPrivSupport", (Object)execEnv.toString()));
        }
        boolean status = sps.hasPrivileges(this.requiredPrivilegesSet);
        if (!status) {
            try {
                sps.requestPrivileges(this.requiredPrivilegesSet, false);
                status = true;
            }
            catch (InterruptedException ex) {
            }
            catch (ConnectionManager.CancellationException ex) {
            }
            catch (NotOwnerException ex) {
                // empty catch block
            }
        }
        if (!status) {
            Runnable onPrivilegesGranted = new Runnable(){

                @Override
                public void run() {
                    DLightManager.getDefault().revalidateSessions();
                }
            };
            AsynchronousAction requestPrivilegesAction = sps.getRequestPrivilegesAction(this.requiredPrivilegesSet, onPrivilegesGranted);
            return ValidationStatus.unknownStatus((String)DtraceDataCollector.loc("DTraceDataCollector_Status_NotEnoughPrivileges", new String[0]), (AsynchronousAction)requestPrivilegesAction);
        }
        SunStudioUserCounter.countDLight((ExecutionEnvironment)target.getExecEnv());
        return ValidationStatus.validStatus();
    }

    protected void targetStarted(DLightTarget target) {
        if (this.isSlave || this.scriptPath == null) {
            return;
        }
        String taskCommand = this.scriptPath;
        if (target instanceof AttachableTarget) {
            AttachableTarget at = (AttachableTarget)target;
            taskCommand = taskCommand + " " + Integer.toString(at.getPID());
        }
        String extraParams = this.getCollectorTaskExtraParams();
        this.isDeploymentTarget = target instanceof DLightDeploymentTarget;
        if (extraParams != null && target instanceof DLightDeploymentTarget) {
            DLightDeploymentTarget deploymentTarget = (DLightDeploymentTarget)target;
            Collection services = deploymentTarget.getDeploymentServices();
            for (DLightDeploymentService s : services) {
                String paramToReplace = "@" + s.getName();
                if (!extraParams.contains(paramToReplace)) continue;
                int pid = deploymentTarget.getPid(s);
                if (pid < 0) {
                    return;
                }
                extraParams = extraParams.replaceAll("@" + s.getName(), "" + pid);
            }
        }
        if (extraParams != null) {
            taskCommand = taskCommand + " " + extraParams;
        }
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)target.getExecEnv());
        npb.setCommandLine(taskCommand);
        this.dtraceRunner = new CollectorRunner((IndicatorNotificationsListener)new FakeIndicatorNotificationListener(), npb, (LineProcessor)this.outputProcessor, eofMarker, "DTrace");
        log.log(Level.FINE, "DtraceDataCollector ({0}) for {1} STARTED", new Object[]{this.dtraceRunner.toString(), taskCommand});
    }

    public void targetStateChanged(DLightTargetChangeEvent event) {
        switch (event.state) {
            case RUNNING: {
                this.targetStarted(event.target);
                break;
            }
            case FAILED: {
                this.targetFinished(event.target);
                break;
            }
            case TERMINATED: {
                this.terminated = true;
                this.targetFinished(event.target);
                break;
            }
            case DONE: {
                this.targetFinished(event.target);
                break;
            }
            case STOPPED: {
                this.targetFinished(event.target);
                return;
            }
        }
        for (DtraceDataCollector ddc : this.slaveCollectors.values()) {
            ddc.targetStateChanged(event);
        }
    }

    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String mergeAndUploadScripts(ExecutionEnvironment trgEnv) throws IOException, ConnectionManager.CancellationException {
        String finalPath;
        boolean followForks;
        HashMap<String, URL> scriptsMap = new HashMap<String, URL>();
        if (this.multiScriptMode) {
            for (Map.Entry<String, DtraceDataCollector> entry : this.slaveCollectors.entrySet()) {
                scriptsMap.put(entry.getKey(), entry.getValue().getLocalScriptUrl());
            }
        } else {
            scriptsMap.put("", this.localScriptUrl);
        }
        ServiceInfoDataStorage info = this.getServiceInfoDataStorage();
        assert (info != null);
        String mode = info.getValue("DTraceMode");
        String pattern = info.getValue("DTraceTracingPattern");
        boolean bl = followForks = mode != null && mode.equalsIgnoreCase("tracing");
        String forkFollowCondition = followForks ? (pattern != null && !pattern.trim().isEmpty() ? "strstr(execname, \"".concat(pattern).concat("\") != NULL/") : "1") : "0";
        File localTmpFile = File.createTempFile("dlight", ".d", HostInfoUtils.getHostInfo((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal()).getTempDirFile());
        if (trgEnv.isLocal()) {
            finalPath = localTmpFile.getAbsolutePath();
            localTmpFile.deleteOnExit();
        } else {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)trgEnv);
            finalPath = hostInfo.getTempDir() + "/r" + localTmpFile.getName();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(localTmpFile));
        try {
            String line;
            InputStream is = DtraceDataCollector.class.getResourceAsStream(bootstrapScript);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            try {
                while ((line = reader.readLine()) != null) {
                    line = line.replaceAll("__FORK_FOLLOW_CONDITION__", forkFollowCondition);
                    line = line.replaceAll("__DLIGHT_DSCRIPT__", finalPath);
                    line = line.replaceAll(eofMarker, eofMarker);
                    writer.write(line);
                    writer.write(10);
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            for (Map.Entry entry : scriptsMap.entrySet()) {
                String prefix = (String)entry.getKey();
                URL url = (URL)entry.getValue();
                try {
                    reader = new BufferedReader(new InputStreamReader(url.openStream()));
                    String replacement = "$1" + prefix;
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith("#!") || line.startsWith("#define ts()")) continue;
                        line = line.replaceAll("(print[af]\\(\")", replacement);
                        writer.write(line);
                        writer.write(10);
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        if (trgEnv.isLocal()) {
            Util.setExecutionPermissions(Arrays.asList(finalPath));
        } else {
            try {
                if (!((CommonTasksSupport.UploadStatus)CommonTasksSupport.uploadFile((File)localTmpFile, (ExecutionEnvironment)trgEnv, (String)finalPath, (int)511).get()).isOK()) {
                    throw new IOException("Failed to upload dtrace script");
                }
            }
            catch (InterruptedException ex) {
                throw new IOException("Failed to upload dtrace script", ex);
            }
            catch (ExecutionException ex) {
                throw new IOException("Failed to upload dtrace script", ex);
            }
            localTmpFile.delete();
        }
        return finalPath;
    }

    DTraceOutputParser getParser() {
        return this.parser;
    }

    private class FakeIndicatorNotificationListener
    implements IndicatorNotificationsListener {
        private FakeIndicatorNotificationListener() {
        }

        public void reset() {
            DtraceDataCollector.this.resetIndicators();
        }

        public void suggestRepaint() {
            if (DtraceDataCollector.this.isDeploymentTarget && DtraceDataCollector.this.terminated) {
                return;
            }
            DtraceDataCollector.this.suggestIndicatorsRepaint();
        }

        public void updated(List<DataRow> data) {
            if (DtraceDataCollector.this.isDeploymentTarget && DtraceDataCollector.this.terminated) {
                return;
            }
            DtraceDataCollector.this.notifyIndicators(data);
        }
    }
}

