/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.server;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.server.RemoteServerSetup;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.spi.remote.setup.HostSetupProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.PasswordManager;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RemoteServerRecord
implements ServerRecord {
    public static final String PROP_STATE_CHANGED = "stateChanged";
    private final ExecutionEnvironment executionEnvironment;
    private final boolean editable;
    private boolean deleted;
    private State state;
    private final Object stateLock;
    private String reason;
    private String problems;
    private String displayName;
    private RemoteSyncFactory syncFactory;
    private boolean x11forwarding;
    HostInfo.OSFamily cachedOsFamily = null;
    HostInfo.CpuFamily cachedCpuFamily = null;
    String cachedOsVersion = null;
    private static final char SERVER_RECORD_SEPARATOR = '|';
    private static final String SERVER_LIST_SEPARATOR = ",";

    @SuppressWarnings(value={"Dm"})
    RemoteServerRecord(ExecutionEnvironment env, String displayName, RemoteSyncFactory syncFactory, boolean connect) {
        CndUtils.assertTrue((env != null ? 1 : 0) != 0);
        CndUtils.assertTrue((syncFactory != null ? 1 : 0) != 0);
        this.executionEnvironment = env;
        this.syncFactory = syncFactory;
        this.stateLock = new String("RemoteServerRecord state lock for " + this.toString());
        this.reason = null;
        this.deleted = false;
        this.displayName = this.escape(displayName);
        if (env.isLocal()) {
            this.editable = false;
            this.state = State.ONLINE;
        } else {
            this.editable = true;
            this.state = connect ? State.UNINITIALIZED : State.OFFLINE;
        }
        this.x11forwarding = Boolean.getBoolean("cnd.remote.X11");
        this.checkHostInfo();
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public String toString() {
        return this.executionEnvironment.toString();
    }

    public synchronized void validate(boolean force) {
        if (this.isOnline()) {
            return;
        }
        RemoteUtil.LOGGER.log(Level.FINE, "RSR.validate2: Validating {0}", this.toString());
        if (force) {
            ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RemoteServerRecord.class, (String)"PBAR_ConnectingTo", (Object)this.getDisplayName()));
            ph.start();
            this.init(null);
            ph.finish();
        }
        String msg = this.isOnline() ? NbBundle.getMessage(RemoteServerRecord.class, (String)"Validation_OK", (Object)this.getDisplayName()) : NbBundle.getMessage(RemoteServerRecord.class, (String)"Validation_ERR", (Object)this.getDisplayName(), (Object)this.getStateAsText(), (Object)this.getReason());
        StatusDisplayer.getDefault().setStatusText(msg);
    }

    public void checkSetupAfterConnection(Runnable task) {
        if (!this.isOnline()) {
            this.resetOfflineState();
            this.init(null);
            if (this.isOnline()) {
                task.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init(PropertyChangeSupport pcs) {
        assert (!SwingUtilities.isEventDispatchThread()) : "RemoteServer initialization must be done out of EDT";
        try {
            ConnectionManager.getInstance().connectTo(this.executionEnvironment);
        }
        catch (IOException ex) {
            RemoteUtil.LOGGER.log(Level.INFO, "Error connecting to " + this.executionEnvironment, ex);
            this.state = State.OFFLINE;
            this.reason = ex.getMessage();
            return;
        }
        catch (ConnectionManager.CancellationException ex) {
            this.state = State.CANCELLED;
            return;
        }
        State ostate = this.state;
        this.state = State.INITIALIZING;
        RemoteServerSetup rss = new RemoteServerSetup(this.getExecutionEnvironment());
        if (!Boolean.getBoolean("cnd.remote.skip.setup") && rss.needsSetupOrUpdate()) {
            rss.setup();
        }
        boolean initPathMap = false;
        Object object = this.stateLock;
        synchronized (object) {
            if (rss.isCancelled()) {
                this.state = State.CANCELLED;
            } else if (rss.isFailed()) {
                this.state = State.OFFLINE;
                this.reason = rss.getReason();
            } else {
                initPathMap = true;
                this.state = State.ONLINE;
                if (rss.hasProblems()) {
                    this.problems = rss.getReason();
                }
            }
        }
        if (initPathMap) {
            RemotePathMap.getPathMap(this.getExecutionEnvironment()).init();
        }
        if (pcs != null) {
            pcs.firePropertyChange(PROP_STATE_CHANGED, (Object)ostate, (Object)this.state);
        }
    }

    public String getProblems() {
        return this.problems;
    }

    public boolean hasProblems() {
        return this.problems != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetOfflineState() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != State.INITIALIZING && this.state != State.ONLINE) {
                this.state = State.UNINITIALIZED;
                return true;
            }
        }
        return false;
    }

    public String getStateAsText() {
        return NbBundle.getMessage(RemoteServerRecord.class, (String)this.state.toString());
    }

    public boolean isOnline() {
        if (this.state == State.ONLINE && !ConnectionManager.getInstance().isConnectedTo(this.executionEnvironment)) {
            this.state = State.OFFLINE;
        }
        return this.state == State.ONLINE;
    }

    public boolean isOffline() {
        if (this.state == State.ONLINE && !ConnectionManager.getInstance().isConnectedTo(this.executionEnvironment)) {
            this.state = State.OFFLINE;
        }
        return this.state == State.OFFLINE;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isRemote() {
        return this.executionEnvironment.isRemote();
    }

    public String getDisplayName() {
        return this.displayName != null && this.displayName.length() > 0 ? this.displayName : this.executionEnvironment.getDisplayName();
    }

    String getRawDisplayName() {
        return this.displayName;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteServerRecord other = (RemoteServerRecord)obj;
        return this.executionEnvironment == other.executionEnvironment || this.executionEnvironment != null && this.executionEnvironment.equals(other.executionEnvironment);
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.executionEnvironment != null ? this.executionEnvironment.hashCode() : 0);
        return hash;
    }

    public String getServerDisplayName() {
        if (this.displayName == null || this.displayName.length() == 0) {
            if (this.executionEnvironment.isLocal()) {
                return "localhost";
            }
            return this.executionEnvironment.getHost();
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = this.escape(displayName);
    }

    private String escape(String text) {
        if (text != null) {
            text = text.replace('|', '_');
            text = text.replace(',', '_');
        }
        return text;
    }

    public String getServerName() {
        return this.executionEnvironment.getHost();
    }

    public String getUserName() {
        return this.executionEnvironment.getUser();
    }

    public boolean isRememberPassword() {
        return PasswordManager.getInstance().isRememberPassword(this.executionEnvironment);
    }

    public void setRememberPassword(boolean rememberPassword) {
        PasswordManager.getInstance().setRememberPassword(this.executionEnvironment, rememberPassword);
    }

    public String getReason() {
        return this.reason == null ? "" : this.reason;
    }

    public RemoteSyncFactory getSyncFactory() {
        return this.syncFactory;
    }

    public void setSyncFactory(RemoteSyncFactory factory) {
        this.syncFactory = factory;
    }

    void setState(State state) {
        this.state = state;
    }

    public boolean isSetUp() {
        Collection providers = Lookup.getDefault().lookupAll(HostSetupProvider.class);
        for (HostSetupProvider provider : providers) {
            if (!provider.canCheckSetup(this.executionEnvironment)) continue;
            return provider.isSetUp(this.executionEnvironment);
        }
        return true;
    }

    public boolean setUp() {
        Collection providers = Lookup.getDefault().lookupAll(HostSetupProvider.class);
        for (HostSetupProvider provider : providers) {
            if (!provider.canCheckSetup(this.executionEnvironment)) continue;
            return provider.setUp(this.executionEnvironment);
        }
        return true;
    }

    public boolean getX11Forwarding() {
        return this.x11forwarding;
    }

    public void setX11Forwarding(boolean x11forwarding) {
        this.x11forwarding = x11forwarding;
    }

    static List<RemoteServerRecord> fromString(String slist) {
        ArrayList<RemoteServerRecord> result = new ArrayList<RemoteServerRecord>();
        for (String serverString : slist.split(SERVER_LIST_SEPARATOR)) {
            String syncId;
            if (serverString.trim().isEmpty()) continue;
            String displayName = null;
            RemoteSyncFactory syncFactory = RemoteSyncFactory.getDefault();
            String[] arr = serverString.split("\\|");
            CndUtils.assertTrue((arr.length > 0 ? 1 : 0) != 0);
            String hostKey = arr[0];
            if (arr.length > 1) {
                displayName = arr[1];
            }
            ExecutionEnvironment env = ExecutionEnvironmentFactory.fromUniqueID((String)hostKey);
            if (arr.length > 2 && (syncFactory = RemoteSyncFactory.fromID((String)(syncId = arr[2]))) == null) {
                syncFactory = RemoteSyncFactory.getDefault();
                RemoteUtil.LOGGER.log(Level.WARNING, "Unsupported synchronization mode \"{0}\" for {1}. Switching to default one.", new Object[]{syncId, env.toString()});
            }
            if (!env.isRemote()) continue;
            RemoteServerRecord record = new RemoteServerRecord(env, displayName, syncFactory, false);
            record.setState(State.OFFLINE);
            result.add(record);
            if (arr.length > 3) {
                record.setX11Forwarding(Boolean.parseBoolean(arr[3]));
            }
            if (arr.length > 4 && arr[4].length() > 0) {
                try {
                    record.cachedOsFamily = HostInfo.OSFamily.valueOf((String)arr[4]);
                }
                catch (IllegalArgumentException ex) {
                    RemoteUtil.LOGGER.log(Level.WARNING, "Error restoring OS family", ex);
                }
            }
            if (arr.length > 5 && arr[5].length() > 0) {
                try {
                    record.cachedCpuFamily = HostInfo.CpuFamily.valueOf((String)arr[5]);
                }
                catch (IllegalArgumentException ex) {
                    RemoteUtil.LOGGER.log(Level.WARNING, "Error restoring CPU family", ex);
                }
            }
            if (arr.length <= 6 || arr[5].length() <= 0) continue;
            record.cachedOsVersion = arr[6];
        }
        return result;
    }

    static String toString(List<RemoteServerRecord> records) {
        StringBuilder result = new StringBuilder();
        for (RemoteServerRecord record : records) {
            if (result.length() > 0) {
                result.append(SERVER_LIST_SEPARATOR);
            }
            String displayName = record.getRawDisplayName();
            String hostKey = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)record.getExecutionEnvironment());
            HostInfo.CpuFamily cpuFamily = record.getCpuFamily();
            HostInfo.OSFamily osFamily = record.getOsFamily();
            String osVersion = record.getOsVersion();
            String preferencesKey = hostKey + '|' + (displayName == null ? "" : displayName) + '|' + record.getSyncFactory().getID() + '|' + record.getX11Forwarding() + '|' + (osFamily == null ? "" : osFamily.name()) + '|' + (cpuFamily == null ? "" : cpuFamily.name()) + '|' + (osVersion == null ? "" : osVersion);
            result.append(preferencesKey);
        }
        return result.toString();
    }

    public String getOsVersion() {
        return this.cachedOsVersion;
    }

    public HostInfo.CpuFamily getCpuFamily() {
        return this.cachedCpuFamily;
    }

    public HostInfo.OSFamily getOsFamily() {
        return this.cachedOsFamily;
    }

    final void checkHostInfo() {
        block5: {
            if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)this.executionEnvironment)) {
                try {
                    HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.executionEnvironment);
                    HostInfo.OSFamily osFamily = hostInfo.getOSFamily();
                    HostInfo.CpuFamily cpuFamily = hostInfo.getCpuFamily();
                    String osVersion = hostInfo.getOS().getVersion();
                    if (osFamily.equals((Object)this.cachedOsFamily) && cpuFamily.equals((Object)this.cachedCpuFamily) && osVersion.equals(this.cachedOsVersion)) break block5;
                    this.cachedOsFamily = osFamily;
                    this.cachedCpuFamily = cpuFamily;
                    this.cachedOsVersion = osVersion;
                    if (!this.executionEnvironment.isRemote() || this.syncFactory.isApplicable(this.executionEnvironment)) break block5;
                    for (RemoteSyncFactory newFactory : RemoteSyncFactory.getFactories()) {
                        if (!newFactory.isApplicable(this.executionEnvironment)) continue;
                        RemoteUtil.LOGGER.log(Level.WARNING, "Inapplicable factory for {0} : {1}; changing to {2}", new Object[]{this.executionEnvironment.getDisplayName(), this.syncFactory.getDisplayName(), newFactory.getDisplayName()});
                        this.syncFactory = newFactory;
                        break;
                    }
                }
                catch (IOException ex) {
                }
                catch (ConnectionManager.CancellationException cancellationException) {
                    // empty catch block
                }
            }
        }
    }

    public static enum State {
        UNINITIALIZED,
        INITIALIZING,
        ONLINE,
        OFFLINE,
        CANCELLED;

    }
}

