/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.util;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.Utils;

public class Context
implements Serializable {
    public static final Context Empty = new Context(Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET);
    private static final long serialVersionUID = 1L;
    private final Set filteredFiles;
    private final Set rootFiles;
    private final Set exclusions;

    public Context(Set filteredFiles, Set rootFiles, Set exclusions) {
        this.filteredFiles = filteredFiles;
        this.rootFiles = rootFiles;
        this.exclusions = exclusions;
        while (this.normalize()) {
        }
    }

    private boolean normalize() {
        for (File root : this.rootFiles) {
            Iterator j = this.exclusions.iterator();
            while (j.hasNext()) {
                File exclusion = (File)j.next();
                if (!Utils.isAncestorOrEqual((File)exclusion, (File)root)) continue;
                j.remove();
                this.exclusionRemoved(exclusion, root);
                return true;
            }
        }
        this.removeDuplicates(this.rootFiles);
        this.removeDuplicates(this.exclusions);
        return false;
    }

    private void removeDuplicates(Set files) {
        ArrayList<File> newFiles = new ArrayList<File>();
        block0: for (File file : files) {
            Iterator j = newFiles.iterator();
            while (j.hasNext()) {
                File includedFile = (File)j.next();
                if (Utils.isAncestorOrEqual((File)includedFile, (File)file) && (file.isFile() || !VersioningSupport.isFlat((File)includedFile))) continue block0;
                if (!Utils.isAncestorOrEqual((File)file, (File)includedFile) || !includedFile.isFile() && VersioningSupport.isFlat((File)file)) continue;
                j.remove();
            }
            newFiles.add(file);
        }
        files.clear();
        files.addAll(newFiles);
    }

    private void exclusionRemoved(File exclusion, File root) {
        File[] exclusionChildren = exclusion.listFiles();
        if (exclusionChildren == null) {
            return;
        }
        for (int i = 0; i < exclusionChildren.length; ++i) {
            File child = exclusionChildren[i];
            if (Utils.isAncestorOrEqual((File)root, (File)child)) continue;
            this.exclusions.add(child);
        }
    }

    public Set<File> getExclusions() {
        return this.exclusions;
    }

    public File[] getFiles() {
        return this.filteredFiles.toArray(new File[this.filteredFiles.size()]);
    }

    public File[] getRootFiles() {
        return this.rootFiles.toArray(new File[this.rootFiles.size()]);
    }

    public boolean contains(File file) {
        block0: for (File root : this.rootFiles) {
            if (!Utils.isAncestorOrEqual((File)root, (File)file)) continue;
            for (File excluded : this.exclusions) {
                if (!Utils.isAncestorOrEqual((File)excluded, (File)file)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    public Context union(Context ctx) {
        HashSet newfilteredFiles = new HashSet(this.filteredFiles);
        HashSet newrootFiles = new HashSet(this.rootFiles);
        HashSet newexclusions = new HashSet(this.exclusions);
        newfilteredFiles.addAll(ctx.filteredFiles);
        newrootFiles.addAll(ctx.rootFiles);
        newexclusions.addAll(ctx.exclusions);
        Context nc = new Context(newfilteredFiles, newrootFiles, newexclusions);
        return nc;
    }
}

