/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.execution;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.openide.util.NbBundle;

public final class ValidationStatus {
    private static final ValidationStatus validStatus = new ValidationStatus(true, true, NbBundle.getMessage(ValidationStatus.class, (String)"ValidationStatus.Valid"), null);
    private static final ValidationStatus initialStatus = new ValidationStatus(false, false, NbBundle.getMessage(ValidationStatus.class, (String)"ValidationStatus.Initial"), null);
    private final boolean isDefined;
    private final boolean isValid;
    private final String reason;
    private final Collection<AsynchronousAction> requiredActions = new ArrayList<AsynchronousAction>();

    private ValidationStatus(boolean isDefined, boolean isValid, String reason, Collection<AsynchronousAction> requiredActions) {
        this.isValid = isValid;
        this.isDefined = isDefined;
        String string = this.reason = reason == null ? "" : reason;
        if (requiredActions != null) {
            this.requiredActions.addAll(requiredActions);
        }
    }

    public static ValidationStatus unknownStatus(String reason, AsynchronousAction requiredAction) {
        if (requiredAction == null) {
            throw new NullPointerException("requiredAction cannot be NULL");
        }
        ArrayList<AsynchronousAction> actions = new ArrayList<AsynchronousAction>();
        actions.add(requiredAction);
        return new ValidationStatus(false, false, reason, actions);
    }

    public static ValidationStatus invalidStatus(String reason) {
        return new ValidationStatus(true, false, reason, null);
    }

    public static ValidationStatus validStatus() {
        return validStatus;
    }

    public static ValidationStatus initialStatus() {
        return initialStatus;
    }

    public String getReason() {
        return this.reason;
    }

    public ValidationStatus merge(ValidationStatus status) {
        if (this.isInvalid()) {
            return this;
        }
        if (status.isInvalid()) {
            return status;
        }
        if (this.isValid() && status.isValid()) {
            return this;
        }
        if (this.isValid()) {
            return status == initialStatus ? this : status;
        }
        if (status.isValid()) {
            return this == initialStatus ? status : this;
        }
        ArrayList<AsynchronousAction> mergedActions = new ArrayList<AsynchronousAction>();
        mergedActions.addAll(this.requiredActions);
        mergedActions.addAll(status.requiredActions);
        String mergedReason = null;
        mergedReason = this == initialStatus ? status.reason : (status == initialStatus ? this.reason : this.reason + "; " + status.reason);
        ValidationStatus result = new ValidationStatus(false, false, mergedReason, mergedActions);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ValidationStatus)) {
            return false;
        }
        ValidationStatus st = (ValidationStatus)obj;
        if (!st.reason.equals(this.reason)) {
            return false;
        }
        if (st.isDefined != this.isDefined) {
            return false;
        }
        return !this.isDefined || st.isValid == this.isValid;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.isDefined ? 1 : 0);
        hash = 97 * hash + (this.isValid ? 1 : 0);
        hash = 97 * hash + (this.reason != null ? this.reason.hashCode() : 0);
        return hash;
    }

    public String toString() {
        if (!this.isDefined) {
            return "UNKNOWN: " + this.reason;
        }
        if (this.isValid) {
            return "OK";
        }
        return "INVALID: " + this.reason;
    }

    public Collection<AsynchronousAction> getRequiredActions() {
        return this.requiredActions;
    }

    public boolean isValid() {
        return this.isDefined && this.isValid;
    }

    public boolean isInvalid() {
        return this.isDefined && !this.isValid;
    }

    public boolean isKnown() {
        return this.isDefined;
    }
}

