/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.spi.indicator;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.spi.indicator.TickerListener;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;

final class IndicatorTickerService {
    private static final IndicatorTickerService instance = new IndicatorTickerService();
    private static final Logger log = DLightLogger.getLogger(IndicatorTickerService.class);
    private final List<TickerListener> listeners = new ArrayList<TickerListener>();
    private DLightExecutorService.DLightScheduledTask tickerTask;
    private final Lock lock = new Lock();

    private IndicatorTickerService() {
    }

    static IndicatorTickerService getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void subsribe(TickerListener l) {
        Lock lock = this.lock;
        synchronized (lock) {
            this.listeners.add(l);
            if (this.tickerTask == null) {
                this.tickerTask = DLightExecutorService.scheduleAtFixedRate((Runnable)new Notifier(), (long)1L, (TimeUnit)TimeUnit.SECONDS, (String)"IndicatorTickerService");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsubscribe(TickerListener l) {
        Lock lock = this.lock;
        synchronized (lock) {
            this.listeners.remove(l);
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }

    private class Notifier
    implements Runnable {
        private Notifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Lock lock = IndicatorTickerService.this.lock;
            synchronized (lock) {
                for (TickerListener l : IndicatorTickerService.this.listeners) {
                    try {
                        l.tick();
                    }
                    catch (Throwable th) {
                        if (!log.isLoggable(Level.WARNING)) continue;
                        log.log(Level.WARNING, "Exception while indicator " + l + " notification:", th);
                    }
                }
                if (IndicatorTickerService.this.listeners.isEmpty() && IndicatorTickerService.this.tickerTask != null) {
                    IndicatorTickerService.this.tickerTask.cancel(1L);
                    IndicatorTickerService.this.tickerTask = null;
                }
            }
        }
    }
}

