/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.folding;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTWalker;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageFilter;
import org.netbeans.modules.cnd.editor.parser.CppFoldRecord;
import org.netbeans.modules.cnd.folding.APTFoldingCommentFilter;
import org.netbeans.modules.cnd.folding.APTFoldingUtils;

class APTFoldingWalker
extends APTWalker {
    private static final int IFDEF_FOLD = 5;
    private static final int INCLUDES_FOLD = 4;
    private APTFoldingCommentFilter filter = null;
    private List<CppFoldRecord> includeFolds = new ArrayList<CppFoldRecord>();
    private List<CppFoldRecord> ifdefFolds = new ArrayList<CppFoldRecord>();
    private Stack<APT> ppStartDirectives = new Stack();
    private APT firstInclude = null;
    private APT lastInclude = null;

    public APTFoldingWalker(APTFile apt) {
        super(apt, null);
    }

    public TokenStream getFilteredTokenStream(APTLanguageFilter lang) {
        return lang.getFilteredStream(this.getTokenStream());
    }

    public TokenStream getTokenStream() {
        this.filter = new APTFoldingCommentFilter(super.getTokenStream());
        return this.filter;
    }

    public List<CppFoldRecord> getFolders() {
        List<CppFoldRecord> filterFolds = this.filter.getFolders();
        ArrayList<CppFoldRecord> out = new ArrayList<CppFoldRecord>(filterFolds.size() + this.includeFolds.size() + this.ifdefFolds.size());
        out.addAll(filterFolds);
        out.addAll(this.includeFolds);
        out.addAll(this.ifdefFolds);
        return out;
    }

    protected void onInclude(APT apt) {
        this.include(apt);
    }

    protected void onIncludeNext(APT apt) {
        this.include(apt);
    }

    protected boolean onIf(APT apt) {
        return this.onStartPreprocNode(apt);
    }

    protected boolean onIfdef(APT apt) {
        return this.onStartPreprocNode(apt);
    }

    protected boolean onIfndef(APT apt) {
        return this.onStartPreprocNode(apt);
    }

    protected void onDefine(APT apt) {
        this.onOtherPreprocNode(apt);
    }

    protected void onUndef(APT apt) {
        this.onOtherPreprocNode(apt);
    }

    protected boolean onElif(APT apt, boolean wasInPrevBranch) {
        this.onOtherPreprocNode(apt);
        return true;
    }

    protected boolean onElse(APT apt, boolean wasInPrevBranch) {
        this.onOtherPreprocNode(apt);
        return true;
    }

    protected void onEndif(APT apt, boolean wasInBranch) {
        this.createEndifFold(apt);
    }

    protected void onErrorNode(APT apt) {
        this.onOtherPreprocNode(apt);
    }

    protected void onPragmaNode(APT apt) {
        this.onOtherPreprocNode(apt);
    }

    protected void onOtherNode(APT apt) {
        this.onOtherPreprocNode(apt);
    }

    protected void onStreamNode(APT apt) {
        this.addIncludesIfNeeded();
    }

    protected void onEOF() {
        this.addIncludesIfNeeded();
    }

    private boolean onStartPreprocNode(APT apt) {
        this.filter.onPreprocNode(apt);
        this.addIncludesIfNeeded();
        this.ppStartDirectives.push(apt);
        return true;
    }

    private void createEndifFold(APT end) {
        this.filter.onPreprocNode(end);
        this.addIncludesIfNeeded();
        if (!this.ppStartDirectives.empty()) {
            APT start = this.ppStartDirectives.pop();
            int startFold = start.getEndOffset();
            int endFold = end.getEndOffset();
            if (APTFoldingUtils.isStandalone()) {
                this.ifdefFolds.add(new CppFoldRecord(5, start.getToken().getLine(), startFold, end.getToken().getEndLine(), endFold));
            } else {
                this.ifdefFolds.add(new CppFoldRecord(5, startFold, endFold));
            }
        }
    }

    private void include(APT apt) {
        this.filter.onPreprocNode(apt);
        if (this.firstInclude == null) {
            this.firstInclude = apt;
        }
        this.lastInclude = apt;
    }

    private void addIncludesIfNeeded() {
        if (this.lastInclude != this.firstInclude) {
            int end;
            assert (this.lastInclude != null);
            assert (this.firstInclude != null);
            int start = this.firstInclude.getToken().getEndOffset();
            if (start < (end = this.lastInclude.getEndOffset())) {
                if (APTFoldingUtils.isStandalone()) {
                    this.includeFolds.add(new CppFoldRecord(4, this.firstInclude.getToken().getLine(), start, this.lastInclude.getToken().getEndLine(), end));
                } else {
                    this.includeFolds.add(new CppFoldRecord(4, start, end));
                }
            }
        }
        this.lastInclude = null;
        this.firstInclude = null;
    }

    private void onOtherPreprocNode(APT apt) {
        this.filter.onPreprocNode(apt);
        this.addIncludesIfNeeded();
    }

    protected boolean stopOnErrorDirective() {
        return false;
    }
}

