/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.phone.deploy;

import com.nokia.phone.deploy.CONA;
import com.nokia.phone.deploy.Deployer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DeployerMain {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("usage: DeployerMain <jad file> <jar file> [list of device names to deploy to]");
        } else {
            List<String> allConnectedTerminals;
            if (!CONA.getInstance().isOSSupportsDeployment()) {
                System.err.println("Deployment aborted, only supported on Windows operating system");
                System.exit(0);
            }
            if (!CONA.getInstance().isConnAPIDllFound()) {
                System.err.println("Deployment aborted, ConnAPI.dll not found.");
                System.exit(0);
            }
            if (!CONA.getInstance().isConnJNIDllFound()) {
                System.err.println("Deployment aborted, ConnJNI.dll not found.");
                System.exit(0);
            }
            String jad = args[0];
            String jar = args[1];
            File jadFile = new File(jad);
            File jarFile = new File(jar);
            ArrayList<String> selectedTerminals = null;
            if (args.length > 2) {
                String[] deviceNamesList = args[2].split("\n");
                selectedTerminals = new ArrayList<String>();
                for (int i = 0; i < deviceNamesList.length; ++i) {
                    String deviceName = deviceNamesList[i].trim();
                    if (deviceName.equals("")) continue;
                    selectedTerminals.add(deviceName);
                }
            }
            Deployer deployer = new Deployer();
            deployer.openConnectionLayer();
            if (!deployer.isConnected()) {
                System.err.println("Deployment aborted, connection failed.");
                System.exit(0);
            }
            if ((allConnectedTerminals = deployer.getTerminals()).size() == 0) {
                System.err.println("Deployment aborted, no devices found.");
                deployer.closeConnectionLayer();
                System.exit(0);
            }
            List<Object> notOkTerminals = new ArrayList();
            if (selectedTerminals != null) {
                for (String string : selectedTerminals) {
                    if (!allConnectedTerminals.contains(string)) {
                        System.err.println("Could not deploy. Selected terminal: " + string + " is not currently connected.");
                        notOkTerminals.add(string);
                        continue;
                    }
                    System.out.println("Deploying to: '" + string + "' using " + deployer.getConnectionType(string));
                    try {
                        boolean success = deployer.deploy(new File(jad), new File(jar), string);
                        if (success) {
                            System.out.println("Deployment succeeded!");
                            continue;
                        }
                        notOkTerminals.add(string);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        notOkTerminals.add(string);
                    }
                    catch (UnsatisfiedLinkError e) {
                        e.printStackTrace();
                        notOkTerminals.add(string);
                    }
                }
                selectedTerminals.removeAll(notOkTerminals);
            } else {
                System.out.println("Deploying to all connected terminals.");
                notOkTerminals = deployer.deployToAllTerminals(jadFile, jarFile);
            }
            for (String string : notOkTerminals) {
                System.err.println("Could not deploy to terminal: " + string);
            }
            System.out.println("Deployment done, closing connection layer");
            deployer.closeConnectionLayer();
        }
    }
}

