/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.io.javame;

import java.io.IOException;
import java.util.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.mobility.editor.pub.J2MEDataObject;
import org.netbeans.modules.vmd.api.io.providers.DataObjectInterface;
import org.netbeans.modules.vmd.api.io.providers.DocumentSerializer;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.io.javame.MEDesignDataLoader;
import org.netbeans.modules.vmd.io.javame.MEDesignEditorSupport;
import org.netbeans.modules.vmd.io.javame.MEDesignNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.UserQuestionException;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public final class MEDesignDataObject
extends J2MEDataObject
implements DataObjectInterface,
FileChangeListener {
    private MEDesignEditorSupport editorSupport;
    private AtomicBoolean dirty = new AtomicBoolean(false);

    public MEDesignDataObject(FileObject javaFile, FileObject designFile, MultiFileLoader loader) throws DataObjectExistsException {
        super(javaFile, loader);
        ((MEDesignDataLoader)loader).createSecondaryEntry((MultiDataObject)this, designFile);
        this.editorSupport = new MEDesignEditorSupport(this);
        CookieSet cookies = this.getCookieSet();
        cookies.add((Node.Cookie)this.editorSupport);
        designFile.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this), (Object)designFile));
    }

    public Node createNodeDelegate() {
        return new MEDesignNode(this);
    }

    public FileObject getDesignFile() {
        return FileUtil.findBrother((FileObject)this.getPrimaryFile(), (String)"vmd");
    }

    public void discardAllEditorSupportEdits() {
        this.editorSupport.discardAllEdits();
    }

    public void notifyEditorSupportModified() {
        this.editorSupport.notifyModified();
    }

    public void setMVTC(TopComponent multiViewTopComponent) {
        this.editorSupport.setMVTC(multiViewTopComponent);
    }

    public StyledDocument getEditorDocument() {
        try {
            StyledDocument styledDocument = null;
            try {
                styledDocument = this.editorSupport.openDocument();
            }
            catch (UserQuestionException uqe) {
                uqe.confirmed();
                styledDocument = this.editorSupport.openDocument();
            }
            return styledDocument;
        }
        catch (IOException e) {
            throw Debug.error((Object[])new Object[]{e});
        }
    }

    public MEDesignEditorSupport getEditorSupport() {
        return this.editorSupport;
    }

    protected synchronized J2MEDataObject.J2MEEditorSupport createJavaEditorSupport() {
        return this.editorSupport;
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
        if (!fe.firedFrom(this.editorSupport.getAtomicSaveAction())) {
            this.reloadDesign();
        }
    }

    public void fileDeleted(FileEvent fe) {
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.getEditorSupport().updateDisplayName();
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    private void reloadDesign() {
        if (this.dirty.compareAndSet(true, true)) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MEDesignDataObject.this.dirty.set(false);
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(MEDesignDataObject.class, (String)"MSG_ConfirmReload", (Object)MEDesignDataObject.this.getDesignFile().getPath()), 0, 3);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) != NotifyDescriptor.YES_OPTION) {
                    return;
                }
                DocumentSerializer documentSerializer = IOSupport.getDocumentSerializer((DataObject)MEDesignDataObject.this);
                if (documentSerializer.isLoadingOrLoaded()) {
                    documentSerializer.restartLoadingDocument();
                }
            }
        });
    }
}

