/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.util.Collections;
import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.ext.html.parser.api.AstNode;
import org.netbeans.modules.html.editor.api.Utils;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.BracesMatcherFactory;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.openide.util.Exceptions;

public class HtmlBracesMatching
implements BracesMatcher,
BracesMatcherFactory {
    private MatcherContext context;
    private static final String BLOCK_COMMENT_START = "<!--";
    private static final String BLOCK_COMMENT_END = "-->";
    static boolean testMode = false;

    public HtmlBracesMatching() {
        this(null);
    }

    private HtmlBracesMatching(MatcherContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws InterruptedException, BadLocationException {
        int searchOffset = this.context.getSearchOffset();
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            if (!testMode && MatcherContext.isTaskCanceled()) {
                int[] nArray = null;
                return nArray;
            }
            TokenSequence<HTMLTokenId> ts = Utils.getJoinedHtmlSequence(this.context.getDocument(), searchOffset);
            TokenHierarchy th = TokenHierarchy.get((Document)this.context.getDocument());
            if (ts.language() == HTMLTokenId.language()) {
                block11: while (searchOffset != this.context.getLimitOffset()) {
                    int diff = ts.move(searchOffset);
                    searchOffset += this.context.isSearchingBackward() ? -1 : 1;
                    if (diff == 0 && this.context.isSearchingBackward() ? !ts.movePrevious() : !ts.moveNext()) continue;
                    Token t = ts.token();
                    int toffs = ts.offset();
                    if (this.tokenInTag(t)) {
                        do {
                            Token t2 = ts.token();
                            int t2offs = ts.offset();
                            if (!this.tokenInTag(t2)) {
                                int[] nArray = null;
                                return nArray;
                            }
                            if (t2.id() != HTMLTokenId.TAG_OPEN_SYMBOL) continue;
                            int tagNameEnd = -1;
                            while (ts.moveNext()) {
                                Token t3 = ts.token();
                                int t3offs = ts.offset();
                                if (!this.tokenInTag(t3) || t3.id() == HTMLTokenId.TAG_OPEN_SYMBOL) {
                                    int[] nArray = null;
                                    return nArray;
                                }
                                if (t3.id() == HTMLTokenId.TAG_CLOSE_SYMBOL) {
                                    if ("/>".equals(((Object)t3.text()).toString())) {
                                        int[] nArray = null;
                                        return nArray;
                                    }
                                    int from = t2offs;
                                    int to = t3offs + t3.length();
                                    if (tagNameEnd != -1) {
                                        int[] nArray = new int[]{from, to, from, tagNameEnd, to - 1, to};
                                        return nArray;
                                    }
                                    int[] nArray = new int[]{from, to};
                                    return nArray;
                                }
                                if (t3.id() != HTMLTokenId.TAG_OPEN && t3.id() != HTMLTokenId.TAG_CLOSE) continue;
                                tagNameEnd = t3offs + t3.length();
                            }
                            continue block11;
                        } while (ts.movePrevious());
                        continue;
                    }
                    if (t.id() != HTMLTokenId.BLOCK_COMMENT) continue;
                    String tokenImage = ((Object)t.text()).toString();
                    if (tokenImage.startsWith(BLOCK_COMMENT_START) && this.context.getSearchOffset() < toffs + BLOCK_COMMENT_START.length()) {
                        int[] nArray = new int[]{toffs, toffs + BLOCK_COMMENT_START.length()};
                        return nArray;
                    }
                    if (!tokenImage.endsWith(BLOCK_COMMENT_END) || this.context.getSearchOffset() < toffs + tokenImage.length() - BLOCK_COMMENT_END.length()) continue;
                    int[] nArray = new int[]{toffs + t.length() - BLOCK_COMMENT_END.length(), toffs + t.length()};
                    return nArray;
                }
            }
            int[] nArray = null;
            return nArray;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    private boolean tokenInTag(Token t) {
        return t.id() == HTMLTokenId.TAG_CLOSE_SYMBOL || t.id() == HTMLTokenId.TAG_OPEN_SYMBOL || t.id() == HTMLTokenId.TAG_OPEN || t.id() == HTMLTokenId.TAG_CLOSE || t.id() == HTMLTokenId.WS || t.id() == HTMLTokenId.ARGUMENT || t.id() == HTMLTokenId.VALUE || t.id() == HTMLTokenId.VALUE_CSS || t.id() == HTMLTokenId.VALUE_JAVASCRIPT || t.id() == HTMLTokenId.OPERATOR || t.id() == HTMLTokenId.EOL;
    }

    public int[] findMatches() throws InterruptedException, BadLocationException {
        if (!testMode && MatcherContext.isTaskCanceled()) {
            return null;
        }
        final int searchOffset = this.context.getSearchOffset();
        final Source source = Source.create((Document)this.context.getDocument());
        if (source == null) {
            return null;
        }
        final int[][] ret = new int[1][];
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    if (!testMode && MatcherContext.isTaskCanceled()) {
                        return;
                    }
                    if (!source.getMimeType().equals("text/html")) {
                        resultIterator = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/html");
                    }
                    if (resultIterator == null) {
                        ret[0] = new int[]{searchOffset, searchOffset};
                        return;
                    }
                    HtmlParserResult result = (HtmlParserResult)resultIterator.getParserResult();
                    if (result == null) {
                        return;
                    }
                    for (int searchOffsetLocal = searchOffset; searchOffsetLocal != HtmlBracesMatching.this.context.getLimitOffset(); searchOffsetLocal += HtmlBracesMatching.this.context.isSearchingBackward() ? -1 : 1) {
                        int searched = result.getSnapshot().getEmbeddedOffset(searchOffsetLocal);
                        AstNode origin = result.findLeafTag(searched, !HtmlBracesMatching.this.context.isSearchingBackward(), true);
                        if (origin == null) continue;
                        if (origin.type() == AstNode.NodeType.OPEN_TAG || origin.type() == AstNode.NodeType.ENDTAG) {
                            if (origin == null) {
                                ret[0] = null;
                                continue;
                            }
                            AstNode match = origin.getMatchingTag();
                            if (match == null) {
                                if (origin.needsToHaveMatchingTag()) {
                                    ret[0] = null;
                                    continue;
                                }
                                ret[0] = new int[]{searchOffsetLocal, searchOffsetLocal};
                                continue;
                            }
                            if (match.type() == AstNode.NodeType.OPEN_TAG) {
                                int f1 = match.startOffset();
                                int t1 = f1 + match.name().length() + 1;
                                int f2 = match.endOffset() - 1;
                                int t2 = match.endOffset();
                                ret[0] = HtmlBracesMatching.this.translate(new int[]{f1, t1, f2, t2}, (Parser.Result)result);
                                continue;
                            }
                            ret[0] = HtmlBracesMatching.this.translate(new int[]{match.startOffset(), match.endOffset()}, (Parser.Result)result);
                            continue;
                        }
                        if (origin.type() != AstNode.NodeType.COMMENT) continue;
                        if (searched >= origin.startOffset() && searched <= origin.startOffset() + HtmlBracesMatching.BLOCK_COMMENT_START.length()) {
                            ret[0] = HtmlBracesMatching.this.translate(new int[]{origin.endOffset() - HtmlBracesMatching.BLOCK_COMMENT_END.length(), origin.endOffset()}, (Parser.Result)result);
                            continue;
                        }
                        if (searched < origin.endOffset() - HtmlBracesMatching.BLOCK_COMMENT_END.length() || searched > origin.endOffset()) continue;
                        ret[0] = HtmlBracesMatching.this.translate(new int[]{origin.startOffset(), origin.startOffset() + HtmlBracesMatching.BLOCK_COMMENT_START.length()}, (Parser.Result)result);
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return ret[0];
    }

    private int[] translate(int[] match, Parser.Result source) {
        int[] translation = new int[match.length];
        for (int i = 0; i < match.length; ++i) {
            translation[i] = source.getSnapshot().getOriginalOffset(match[i]);
        }
        return translation;
    }

    public BracesMatcher createMatcher(final MatcherContext context) {
        final HtmlBracesMatching[] ret = new HtmlBracesMatching[]{null};
        context.getDocument().render(new Runnable(){

            @Override
            public void run() {
                TokenHierarchy hierarchy = TokenHierarchy.get((Document)context.getDocument());
                if (hierarchy.tokenSequence().language() == HTMLTokenId.language()) {
                    ret[0] = new HtmlBracesMatching(context);
                    return;
                }
                List ets = hierarchy.embeddedTokenSequences(context.getSearchOffset(), context.isSearchingBackward());
                for (TokenSequence ts : ets) {
                    Language language = ts.language();
                    if (language != HTMLTokenId.language()) continue;
                    ret[0] = new HtmlBracesMatching(context);
                    return;
                }
            }
        });
        return ret[0];
    }
}

