/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.HarnessVersion;
import org.netbeans.modules.apisupport.project.universe.JavadocRootsProvider;
import org.netbeans.modules.apisupport.project.universe.JavadocRootsSupport;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.SourceRootsProvider;
import org.netbeans.modules.apisupport.project.universe.SourceRootsSupport;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;

public final class NbPlatform
implements SourceRootsProvider,
JavadocRootsProvider {
    private static final String PLATFORM_PREFIX = "nbplatform.";
    private static final String PLATFORM_DEST_DIR_SUFFIX = ".netbeans.dest.dir";
    private static final String PLATFORM_LABEL_SUFFIX = ".label";
    public static final String PLATFORM_SOURCES_SUFFIX = ".sources";
    public static final String PLATFORM_JAVADOC_SUFFIX = ".javadoc";
    private static final String PLATFORM_HARNESS_DIR_SUFFIX = ".harness.dir";
    public static final String PLATFORM_ID_DEFAULT = "default";
    private static final Logger LOG = Logger.getLogger(NbPlatform.class.getName());
    private static volatile Set<NbPlatform> platforms;
    private final PropertyChangeSupport pcs;
    private final SourceRootsSupport srs;
    private final JavadocRootsSupport jrs;
    private static volatile boolean inited;
    private static final Object lock;
    private final String id;
    private String label;
    private File nbdestdir;
    private File harness;
    private HarnessVersion harnessVersion;
    private URL[] defaultSourceRoots;

    private static Map<String, String> initBuildProperties() {
        if (inited) {
            return null;
        }
        final File install = NbPlatform.defaultPlatformLocation();
        if (install == null) {
            inited = true;
            return null;
        }
        return (Map)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Map<String, String>>(){

            private EditableProperties loadWithProcessing() {
                EditableProperties p = PropertyUtils.getGlobalProperties();
                String installS = install.getAbsolutePath();
                p.setProperty("nbplatform.default.netbeans.dest.dir", installS);
                if (!p.containsKey((Object)"nbplatform.default.harness.dir")) {
                    p.setProperty("nbplatform.default.harness.dir", "${nbplatform.default.netbeans.dest.dir}/harness");
                }
                return p;
            }

            public Map<String, String> run() {
                ProjectManager.mutex().postWriteRequest(new Runnable(){

                    @Override
                    public void run() {
                        if (inited) {
                            return;
                        }
                        try {
                            PropertyUtils.putGlobalProperties((EditableProperties)this.loadWithProcessing());
                        }
                        catch (IOException e) {
                            LOG.log(Level.INFO, null, e);
                        }
                        inited = true;
                    }
                });
                return PropertyUtils.sequentialPropertyEvaluator(null, (PropertyProvider[])new PropertyProvider[]{PropertyUtils.fixedPropertyProvider((Map)this.loadWithProcessing())}).getProperties();
            }
        });
    }

    public static void reset() {
        platforms = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<NbPlatform> getPlatforms() {
        Set<NbPlatform> plafs;
        Set<NbPlatform> set = plafs = NbPlatform.getPlatformsInternal();
        synchronized (set) {
            return new HashSet<NbPlatform>(plafs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<NbPlatform> getPlatformsOrNot() {
        Set<NbPlatform> plafs;
        Set<NbPlatform> set = lock;
        synchronized (set) {
            plafs = platforms;
        }
        if (plafs != null) {
            set = plafs;
            synchronized (set) {
                return new HashSet<NbPlatform>(plafs);
            }
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<NbPlatform> getPlatformsInternal() {
        Map p = null;
        if (platforms == null && (p = NbPlatform.initBuildProperties()) == null) {
            p = PropertyUtils.sequentialPropertyEvaluator(null, (PropertyProvider[])new PropertyProvider[]{PropertyUtils.globalPropertyProvider()}).getProperties();
        }
        Object object = lock;
        synchronized (object) {
            if (platforms == null) {
                File loc;
                platforms = Collections.synchronizedSet(new HashSet());
                if (p == null) {
                    p = Collections.emptyMap();
                }
                boolean foundDefault = false;
                for (Map.Entry entry : p.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!key.startsWith(PLATFORM_PREFIX) || !key.endsWith(PLATFORM_DEST_DIR_SUFFIX)) continue;
                    String id = key.substring(PLATFORM_PREFIX.length(), key.length() - PLATFORM_DEST_DIR_SUFFIX.length());
                    String label = (String)p.get(PLATFORM_PREFIX + id + PLATFORM_LABEL_SUFFIX);
                    String destdir = (String)entry.getValue();
                    String harnessdir = (String)p.get(PLATFORM_PREFIX + id + PLATFORM_HARNESS_DIR_SUFFIX);
                    String sources = (String)p.get(PLATFORM_PREFIX + id + PLATFORM_SOURCES_SUFFIX);
                    String javadoc = (String)p.get(PLATFORM_PREFIX + id + PLATFORM_JAVADOC_SUFFIX);
                    File destdirF = FileUtil.normalizeFile((File)new File(destdir));
                    File harness = harnessdir != null ? FileUtil.normalizeFile((File)new File(harnessdir)) : NbPlatform.findHarness(destdirF);
                    platforms.add(new NbPlatform(id, label, destdirF, harness, Util.findURLs(sources), Util.findURLs(javadoc)));
                    foundDefault |= id.equals(PLATFORM_ID_DEFAULT);
                }
                if (!foundDefault && (loc = NbPlatform.defaultPlatformLocation()) != null) {
                    platforms.add(new NbPlatform(PLATFORM_ID_DEFAULT, null, loc, NbPlatform.findHarness(loc), new URL[0], new URL[0]));
                }
                LOG.log(Level.FINE, "NbPlatform initial list: {0}", platforms);
            }
        }
        return platforms;
    }

    @CheckForNull
    public static NbPlatform getDefaultPlatform() {
        return NbPlatform.getPlatformByID(PLATFORM_ID_DEFAULT);
    }

    public static File defaultPlatformLocation() {
        File bootJar = InstalledFileLocator.getDefault().locate("core/core.jar", "org.netbeans.core.startup", false);
        if (bootJar == null) {
            LOG.warning("no core/core.jar");
            return null;
        }
        File platformCluster = bootJar.getParentFile().getParentFile();
        if (!platformCluster.getName().startsWith("platform")) {
            LOG.log(Level.WARNING, "{0} found in unexpected cluster", bootJar);
            return null;
        }
        File harnessJar = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-apisupport-harness.jar", "org.netbeans.modules.apisupport.harness", false);
        if (harnessJar == null) {
            LOG.warning("Cannot resolve default platform. Probably either \"org.netbeans.modules.apisupport.harness\" module is missing or is corrupted.");
            return null;
        }
        if (!harnessJar.getParentFile().getParentFile().getName().startsWith("harness")) {
            LOG.log(Level.WARNING, "{0} found in unexpected cluster", harnessJar);
            return null;
        }
        File loc = harnessJar.getParentFile().getParentFile().getParentFile();
        try {
            String netbeansHomeS = System.getProperty("netbeans.home");
            if (netbeansHomeS != null) {
                File netbeansHome = new File(netbeansHomeS);
                if (!platformCluster.getCanonicalFile().equals(netbeansHome.getCanonicalFile())) {
                    LOG.log(Level.WARNING, "{0} does not match {1}", new Object[]{platformCluster, netbeansHome});
                    return null;
                }
            }
            if (!loc.getCanonicalFile().equals(platformCluster.getParentFile().getCanonicalFile())) {
                LOG.log(Level.WARNING, "core.jar & harness.jar locations do not match: {0} vs. {1}", new Object[]{bootJar, harnessJar});
                return null;
            }
        }
        catch (IOException x) {
            LOG.log(Level.INFO, null, x);
        }
        return FileUtil.normalizeFile((File)loc);
    }

    @CheckForNull
    public static NbPlatform getPlatformByID(String id) {
        for (NbPlatform p : NbPlatform.getPlatformsInternal()) {
            if (!p.getID().equals(id)) continue;
            return p;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NbPlatform getPlatformByDestDir(File destDir) {
        File superparent;
        File parent;
        Set<NbPlatform> plafs;
        Set<NbPlatform> set = plafs = NbPlatform.getPlatformsInternal();
        synchronized (set) {
            for (NbPlatform p : plafs) {
                if (!p.getDestDir().equals(destDir)) continue;
                return p;
            }
        }
        URL[] sources = new URL[]{};
        if (destDir.getName().equals("netbeans") && (parent = destDir.getParentFile()) != null && parent.getName().equals("nbbuild") && (superparent = parent.getParentFile()) != null && ModuleList.isNetBeansOrg(superparent)) {
            sources = new URL[]{FileUtil.urlForArchiveOrDir((File)superparent)};
        }
        return new NbPlatform(null, null, destDir, NbPlatform.findHarness(destDir), sources, new URL[0]);
    }

    private static File findHarness(File destDir) {
        File[] kids = destDir.listFiles();
        if (kids != null) {
            for (int i = 0; i < kids.length; ++i) {
                if (!NbPlatform.isHarness(kids[i])) continue;
                return kids[i];
            }
        }
        return new File(destDir, "harness");
    }

    public static boolean isHarness(File dir) {
        return new File(dir, "modules" + File.separatorChar + "org-netbeans-modules-apisupport-harness.jar").isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contains(File destDir) {
        Set<NbPlatform> plafs;
        boolean contains = false;
        Set<NbPlatform> set = plafs = NbPlatform.getPlatformsInternal();
        synchronized (set) {
            for (NbPlatform p : plafs) {
                if (!p.getDestDir().equals(destDir)) continue;
                contains = true;
                break;
            }
        }
        return contains;
    }

    public static NbPlatform addPlatform(String id, File destdir, String label) throws IOException {
        return NbPlatform.addPlatform(id, destdir, NbPlatform.findHarness(destdir), label);
    }

    public static NbPlatform addPlatform(final String id, final File destdir, final File harness, final String label) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    if (NbPlatform.getPlatformByID(id) != null) {
                        throw new IOException("ID " + id + " already taken");
                    }
                    EditableProperties props = PropertyUtils.getGlobalProperties();
                    String plafDestDir = NbPlatform.PLATFORM_PREFIX + id + NbPlatform.PLATFORM_DEST_DIR_SUFFIX;
                    props.setProperty(plafDestDir, destdir.getAbsolutePath());
                    if (!destdir.isDirectory()) {
                        throw new FileNotFoundException(destdir.getAbsolutePath());
                    }
                    NbPlatform.storeHarnessLocation(id, destdir, harness, props);
                    props.setProperty(NbPlatform.PLATFORM_PREFIX + id + NbPlatform.PLATFORM_LABEL_SUFFIX, label);
                    PropertyUtils.putGlobalProperties((EditableProperties)props);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
        NbPlatform plaf = new NbPlatform(id, label, FileUtil.normalizeFile((File)destdir), harness, Util.findURLs(null), Util.findURLs(null));
        NbPlatform.getPlatformsInternal().add(plaf);
        LOG.log(Level.FINE, "NbPlatform added: {0}", plaf);
        return plaf;
    }

    private static void storeHarnessLocation(String id, File destdir, File harness, EditableProperties props) {
        String harnessDirKey = PLATFORM_PREFIX + id + PLATFORM_HARNESS_DIR_SUFFIX;
        if (harness.equals(NbPlatform.findHarness(destdir))) {
            String plafDestDir = PLATFORM_PREFIX + id + PLATFORM_DEST_DIR_SUFFIX;
            props.setProperty(harnessDirKey, "${" + plafDestDir + "}/" + harness.getName());
        } else if (NbPlatform.getDefaultPlatform() != null && harness.equals(NbPlatform.getDefaultPlatform().getHarnessLocation())) {
            props.setProperty(harnessDirKey, "${nbplatform.default.harness.dir}");
        } else {
            props.setProperty(harnessDirKey, harness.getAbsolutePath());
        }
    }

    public static void removePlatform(final NbPlatform plaf) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    EditableProperties props = PropertyUtils.getGlobalProperties();
                    props.remove((Object)(NbPlatform.PLATFORM_PREFIX + plaf.getID() + NbPlatform.PLATFORM_DEST_DIR_SUFFIX));
                    props.remove((Object)(NbPlatform.PLATFORM_PREFIX + plaf.getID() + NbPlatform.PLATFORM_HARNESS_DIR_SUFFIX));
                    props.remove((Object)(NbPlatform.PLATFORM_PREFIX + plaf.getID() + NbPlatform.PLATFORM_LABEL_SUFFIX));
                    props.remove((Object)(NbPlatform.PLATFORM_PREFIX + plaf.getID() + NbPlatform.PLATFORM_SOURCES_SUFFIX));
                    props.remove((Object)(NbPlatform.PLATFORM_PREFIX + plaf.getID() + NbPlatform.PLATFORM_JAVADOC_SUFFIX));
                    PropertyUtils.putGlobalProperties((EditableProperties)props);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
        NbPlatform.getPlatformsInternal().remove(plaf);
        ModuleList.refresh();
        LOG.log(Level.FINE, "NbPlatform removed: {0}", plaf);
    }

    private NbPlatform(String id, String label, File nbdestdir, File harness, URL[] sources, URL[] javadoc) {
        this.id = id;
        this.label = label;
        this.nbdestdir = nbdestdir;
        this.harness = harness;
        this.pcs = new PropertyChangeSupport(this);
        this.srs = new SourceRootsSupport(sources, this);
        this.srs.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NbPlatform.this.pcs.firePropertyChange(evt);
            }
        });
        this.jrs = new JavadocRootsSupport(javadoc, this);
        this.jrs.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NbPlatform.this.pcs.firePropertyChange(evt);
            }
        });
    }

    public String getID() {
        return this.id;
    }

    public boolean isDefault() {
        return PLATFORM_ID_DEFAULT.equals(this.id);
    }

    public String getLabel() {
        if (this.label == null) {
            try {
                this.label = this.isValid() ? NbPlatform.computeDisplayName(this.nbdestdir) : NbBundle.getMessage(NbPlatform.class, (String)"MSG_InvalidPlatform", (Object)this.getDestDir().getAbsolutePath());
            }
            catch (IOException e) {
                Logger.getLogger(NbPlatform.class.getName()).log(Level.FINE, "could not get label for " + this.nbdestdir, e);
                this.label = this.nbdestdir.getAbsolutePath();
            }
        }
        if (this.isDefault()) {
            return NbBundle.getMessage(NbPlatform.class, (String)"LBL_default_platform", (Object)this.label);
        }
        return this.label;
    }

    public File getDestDir() {
        return this.nbdestdir;
    }

    public void setDestDir(File destdir) {
        this.nbdestdir = destdir;
    }

    @Override
    public URL[] getDefaultJavadocRoots() {
        block5: {
            Matcher m;
            String spec;
            File apidocsZip;
            if (this.isDefault() && (apidocsZip = InstalledFileLocator.getDefault().locate("docs/NetBeansAPIs.zip", "org.netbeans.modules.apisupport.apidocs", true)) != null) {
                return new URL[]{FileUtil.urlForArchiveOrDir((File)apidocsZip)};
            }
            ModuleEntry platform = this.getModule("org.netbeans.modules.core.kit");
            if (platform != null && (spec = platform.getSpecificationVersion()) != null && (m = Pattern.compile("(\\d+[.]\\d+)([.]\\d+)*").matcher(spec)).matches()) {
                String trunkSpec = m.group(1);
                try {
                    String loc = NbBundle.getBundle(NbPlatform.class).getString("NbPlatform.web.javadoc." + trunkSpec);
                    return new URL[]{new URL(loc)};
                }
                catch (MissingResourceException x) {
                }
                catch (MalformedURLException x) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError((Object)x);
                }
            }
        }
        return null;
    }

    @Override
    public void addJavadocRoot(URL root) throws IOException {
        this.jrs.addJavadocRoot(root);
    }

    @Override
    public URL[] getJavadocRoots() {
        return this.jrs.getJavadocRoots();
    }

    @Override
    public void moveJavadocRootDown(int indexToDown) throws IOException {
        this.jrs.moveJavadocRootDown(indexToDown);
    }

    @Override
    public void moveJavadocRootUp(int indexToUp) throws IOException {
        this.jrs.moveJavadocRootUp(indexToUp);
    }

    @Override
    public void removeJavadocRoots(URL[] urlsToRemove) throws IOException {
        this.jrs.removeJavadocRoots(urlsToRemove);
    }

    @Override
    public void setJavadocRoots(URL[] roots) throws IOException {
        this.putGlobalProperty(PLATFORM_PREFIX + this.getID() + PLATFORM_JAVADOC_SUFFIX, Util.urlsToAntPath(roots));
        this.jrs.setJavadocRoots(roots);
    }

    @Override
    public URL[] getDefaultSourceRoots() {
        block5: {
            if (!this.isDefault()) {
                return null;
            }
            if (this.defaultSourceRoots != null) {
                return this.defaultSourceRoots;
            }
            this.defaultSourceRoots = new URL[0];
            File loc = this.getDestDir();
            if (loc.getName().equals("netbeans") && loc.getParentFile().getName().equals("nbbuild")) {
                try {
                    this.defaultSourceRoots = new URL[]{loc.getParentFile().getParentFile().toURI().toURL()};
                }
                catch (MalformedURLException e) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError((Object)e);
                }
            }
        }
        return this.defaultSourceRoots;
    }

    @Override
    public URL[] getSourceRoots() {
        return this.srs.getSourceRoots();
    }

    @Override
    public void addSourceRoot(URL root) throws IOException {
        this.srs.addSourceRoot(root);
    }

    @Override
    public void removeSourceRoots(URL[] urlsToRemove) throws IOException {
        this.srs.removeSourceRoots(urlsToRemove);
    }

    @Override
    public void moveSourceRootUp(int indexToUp) throws IOException {
        this.srs.moveSourceRootUp(indexToUp);
    }

    @Override
    public void moveSourceRootDown(int indexToDown) throws IOException {
        this.srs.moveSourceRootDown(indexToDown);
    }

    @Override
    public void setSourceRoots(URL[] roots) throws IOException {
        this.putGlobalProperty(PLATFORM_PREFIX + this.getID() + PLATFORM_SOURCES_SUFFIX, Util.urlsToAntPath(roots));
        this.srs.setSourceRoots(roots);
    }

    public boolean isValid() {
        return NbPlatform.isPlatformDirectory(this.getDestDir());
    }

    private void putGlobalProperty(final String key, final String value) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    EditableProperties props = PropertyUtils.getGlobalProperties();
                    if ("".equals(value)) {
                        props.remove((Object)key);
                    } else {
                        props.setProperty(key, value);
                    }
                    PropertyUtils.putGlobalProperties((EditableProperties)props);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    @Override
    public File getSourceLocationOfModule(File jar) {
        return this.srs.getSourceLocationOfModule(jar);
    }

    public ModuleEntry[] getSortedModules() {
        TreeSet<ModuleEntry> set = new TreeSet<ModuleEntry>(this.getModules());
        ModuleEntry[] entries = new ModuleEntry[set.size()];
        set.toArray(entries);
        return entries;
    }

    public Set<ModuleEntry> getModules() {
        if (this.nbdestdir.isDirectory()) {
            try {
                return ModuleList.findOrCreateModuleListFromBinaries(this.nbdestdir).getAllEntries();
            }
            catch (IOException x) {
                LOG.log(Level.INFO, null, x);
            }
        } else {
            LOG.log(Level.WARNING, "Platform directory {0} does not exist", this.nbdestdir);
        }
        return Collections.emptySet();
    }

    @CheckForNull
    public ModuleEntry getModule(String cnb) {
        if (this.nbdestdir.isDirectory()) {
            try {
                return ModuleList.findOrCreateModuleListFromBinaries(this.nbdestdir).getEntry(cnb);
            }
            catch (IOException x) {
                LOG.log(Level.INFO, null, x);
            }
        } else {
            LOG.log(Level.WARNING, "Platform directory {0} does not exist", this.nbdestdir);
        }
        return null;
    }

    private static File findCoreJar(File destdir) {
        File[] subdirs = destdir.listFiles();
        if (subdirs != null) {
            for (int i = 0; i < subdirs.length; ++i) {
                File coreJar;
                if (!subdirs[i].isDirectory() || !subdirs[i].getName().startsWith("platform") || !(coreJar = new File(subdirs[i], "core" + File.separatorChar + "core.jar")).isFile()) continue;
                return coreJar;
            }
        }
        return null;
    }

    public static boolean isPlatformDirectory(File destdir) {
        return NbPlatform.findCoreJar(destdir) != null;
    }

    public static boolean isSupportedPlatform(File destdir) {
        boolean valid = false;
        File coreJar = NbPlatform.findCoreJar(destdir);
        if (coreJar != null) {
            String platformDir = coreJar.getParentFile().getParentFile().getName();
            assert (platformDir.startsWith("platform"));
            String version = platformDir.substring("platform".length());
            valid = version.isEmpty() || Integer.parseInt(version) >= 6;
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String computeDisplayName(File destdir) throws IOException {
        String implVers;
        String currVer;
        File coreJar = NbPlatform.findCoreJar(destdir);
        if (coreJar == null) {
            throw new IllegalArgumentException(destdir.getAbsolutePath());
        }
        JarFile jf = new JarFile(coreJar);
        try {
            currVer = NbPlatform.findCurrVer(jf, "");
            if (currVer == null) {
                throw new IOException(coreJar.getAbsolutePath());
            }
            implVers = jf.getManifest().getMainAttributes().getValue("OpenIDE-Module-Build-Version");
            if (implVers == null) {
                implVers = jf.getManifest().getMainAttributes().getValue("OpenIDE-Module-Implementation-Version");
            }
            if (implVers == null) {
                throw new IOException(coreJar.getAbsolutePath());
            }
        }
        finally {
            jf.close();
        }
        File[] clusters = destdir.listFiles();
        if (clusters != null) {
            block6: for (int i = 0; i < clusters.length; ++i) {
                String[] kids;
                File coreLocaleDir = new File(clusters[i], "core" + File.separatorChar + "locale");
                if (!coreLocaleDir.isDirectory() || (kids = coreLocaleDir.list()) == null) continue;
                for (int j = 0; j < kids.length; ++j) {
                    String infix;
                    int uscore;
                    String name = kids[j];
                    String prefix = "core";
                    String suffix = ".jar";
                    if (!name.startsWith(prefix) || !name.endsWith(suffix) || (uscore = (infix = name.substring(prefix.length(), name.length() - suffix.length())).lastIndexOf(95)) == -1) continue;
                    String lastPiece = infix.substring(uscore + 1);
                    if (Arrays.asList(Locale.getISOCountries()).contains(lastPiece) || !lastPiece.equals("nb") && Arrays.asList(Locale.getISOLanguages()).contains(lastPiece)) continue;
                    jf = new JarFile(new File(coreLocaleDir, name));
                    try {
                        String brandedCurrVer = NbPlatform.findCurrVer(jf, infix);
                        if (brandedCurrVer == null) continue;
                        currVer = brandedCurrVer;
                        break block6;
                    }
                    finally {
                        jf.close();
                    }
                }
            }
        }
        return MessageFormat.format(currVer, implVers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String findCurrVer(JarFile jar, String infix) throws IOException {
        ZipEntry bundle = jar.getEntry("org/netbeans/core/startup/Bundle" + infix + ".properties");
        if (bundle == null) {
            bundle = jar.getEntry("org/netbeans/core/Bundle" + infix + ".properties");
        }
        if (bundle == null) {
            return null;
        }
        Properties props = new Properties();
        InputStream is = jar.getInputStream(bundle);
        try {
            props.load(is);
        }
        finally {
            is.close();
        }
        return props.getProperty("currentVersion");
    }

    public static boolean isLabelValid(String supposedLabel) {
        if (supposedLabel == null) {
            return false;
        }
        for (NbPlatform p : NbPlatform.getPlatforms()) {
            String label = p.getLabel();
            if (!supposedLabel.equals(label)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "NbPlatform[" + this.getID() + ":" + this.getDestDir() + ";sources=" + Arrays.asList(this.getSourceRoots()) + ";javadoc=" + Arrays.asList(this.getJavadocRoots()) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HarnessVersion getHarnessVersion() {
        if (this.harnessVersion != null) {
            return this.harnessVersion;
        }
        if (!this.isValid()) {
            this.harnessVersion = HarnessVersion.UNKNOWN;
            return this.harnessVersion;
        }
        File harnessJar = new File(this.harness, "modules" + File.separatorChar + "org-netbeans-modules-apisupport-harness.jar");
        if (harnessJar.isFile()) {
            try {
                JarFile jf = new JarFile(harnessJar);
                try {
                    String spec = jf.getManifest().getMainAttributes().getValue("OpenIDE-Module-Specification-Version");
                    if (spec != null) {
                        SpecificationVersion v = new SpecificationVersion(spec);
                        HarnessVersion harnessVersion = this.harnessVersion = HarnessVersion.forHarnessModuleVersion(v);
                        return harnessVersion;
                    }
                }
                finally {
                    jf.close();
                }
            }
            catch (IOException e) {
                LOG.log(Level.INFO, null, e);
            }
            catch (NumberFormatException e) {
                LOG.log(Level.INFO, null, e);
            }
        }
        this.harnessVersion = HarnessVersion.UNKNOWN;
        return this.harnessVersion;
    }

    public File getHarnessLocation() {
        return this.harness;
    }

    public File getBundledHarnessLocation() {
        return NbPlatform.findHarness(this.nbdestdir);
    }

    public void setHarnessLocation(final File harness) throws IOException {
        if (harness.equals(this.harness)) {
            return;
        }
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    EditableProperties props = PropertyUtils.getGlobalProperties();
                    NbPlatform.storeHarnessLocation(NbPlatform.this.id, NbPlatform.this.nbdestdir, harness, props);
                    PropertyUtils.putGlobalProperties((EditableProperties)props);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
        this.harness = harness;
        this.harnessVersion = null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    static {
        lock = new Object();
    }
}

