/*
 * Decompiled with CFR 0.152.
 */
package persistence.antlr;

import java.io.IOException;
import java.io.PrintWriter;
import persistence.antlr.ActionElement;
import persistence.antlr.ActionTransInfo;
import persistence.antlr.AlternativeBlock;
import persistence.antlr.BlockEndElement;
import persistence.antlr.CharFormatter;
import persistence.antlr.CharLiteralElement;
import persistence.antlr.CharRangeElement;
import persistence.antlr.DefineGrammarSymbols;
import persistence.antlr.Grammar;
import persistence.antlr.GrammarAtom;
import persistence.antlr.GrammarSymbol;
import persistence.antlr.LLkGrammarAnalyzer;
import persistence.antlr.LexerGrammar;
import persistence.antlr.Lookahead;
import persistence.antlr.OneOrMoreBlock;
import persistence.antlr.ParserGrammar;
import persistence.antlr.RuleBlock;
import persistence.antlr.RuleRefElement;
import persistence.antlr.RuleSymbol;
import persistence.antlr.StringLiteralElement;
import persistence.antlr.StringLiteralSymbol;
import persistence.antlr.Token;
import persistence.antlr.TokenManager;
import persistence.antlr.TokenRangeElement;
import persistence.antlr.TokenRefElement;
import persistence.antlr.TokenSymbol;
import persistence.antlr.Tool;
import persistence.antlr.TreeElement;
import persistence.antlr.TreeWalkerGrammar;
import persistence.antlr.WildcardElement;
import persistence.antlr.ZeroOrMoreBlock;
import persistence.antlr.collections.impl.BitSet;
import persistence.antlr.collections.impl.Vector;

public abstract class CodeGenerator {
    protected Tool antlrTool;
    protected int tabs = 0;
    protected transient PrintWriter currentOutput;
    protected Grammar grammar = null;
    protected Vector bitsetsUsed;
    protected DefineGrammarSymbols behavior;
    protected LLkGrammarAnalyzer analyzer;
    protected CharFormatter charFormatter;
    protected boolean DEBUG_CODE_GENERATOR = false;
    protected static final int DEFAULT_MAKE_SWITCH_THRESHOLD = 2;
    protected static final int DEFAULT_BITSET_TEST_THRESHOLD = 4;
    protected static final int BITSET_OPTIMIZE_INIT_THRESHOLD = 8;
    protected int makeSwitchThreshold = 2;
    protected int bitsetTestThreshold = 4;
    private static boolean OLD_ACTION_TRANSLATOR = true;
    public static String TokenTypesFileSuffix = "TokenTypes";
    public static String TokenTypesFileExt = ".txt";

    protected void _print(String s) {
        if (s != null) {
            this.currentOutput.print(s);
        }
    }

    protected void _printAction(String s) {
        int end;
        int start;
        if (s == null) {
            return;
        }
        for (start = 0; start < s.length() && Character.isSpaceChar(s.charAt(start)); ++start) {
        }
        for (end = s.length() - 1; end > start && Character.isSpaceChar(s.charAt(end)); --end) {
        }
        char c = '\u0000';
        int i = start;
        while (i <= end) {
            c = s.charAt(i);
            ++i;
            boolean newline = false;
            switch (c) {
                case '\n': {
                    newline = true;
                    break;
                }
                case '\r': {
                    if (i <= end && s.charAt(i) == '\n') {
                        ++i;
                    }
                    newline = true;
                    break;
                }
                default: {
                    this.currentOutput.print(c);
                }
            }
            if (!newline) continue;
            this.currentOutput.println();
            this.printTabs();
            while (i <= end && Character.isSpaceChar(s.charAt(i))) {
                ++i;
            }
            newline = false;
        }
        this.currentOutput.println();
    }

    protected void _println(String s) {
        if (s != null) {
            this.currentOutput.println(s);
        }
    }

    public static boolean elementsAreRange(int[] elems) {
        if (elems.length == 0) {
            return false;
        }
        int begin = elems[0];
        int end = elems[elems.length - 1];
        if (elems.length <= 2) {
            return false;
        }
        if (end - begin + 1 > elems.length) {
            return false;
        }
        int v = begin + 1;
        for (int i = 1; i < elems.length - 1; ++i) {
            if (v != elems[i]) {
                return false;
            }
            ++v;
        }
        return true;
    }

    protected String extractIdOfAction(Token t) {
        return this.extractIdOfAction(t.getText(), t.getLine(), t.getColumn());
    }

    protected String extractIdOfAction(String s, int line, int column) {
        s = this.removeAssignmentFromDeclaration(s);
        for (int i = s.length() - 2; i >= 0; --i) {
            if (Character.isLetterOrDigit(s.charAt(i)) || s.charAt(i) == '_') continue;
            return s.substring(i + 1);
        }
        this.antlrTool.warning("Ill-formed action", this.grammar.getFilename(), line, column);
        return "";
    }

    protected String extractTypeOfAction(Token t) {
        return this.extractTypeOfAction(t.getText(), t.getLine(), t.getColumn());
    }

    protected String extractTypeOfAction(String s, int line, int column) {
        s = this.removeAssignmentFromDeclaration(s);
        for (int i = s.length() - 2; i >= 0; --i) {
            if (Character.isLetterOrDigit(s.charAt(i)) || s.charAt(i) == '_') continue;
            return s.substring(0, i + 1);
        }
        this.antlrTool.warning("Ill-formed action", this.grammar.getFilename(), line, column);
        return "";
    }

    public abstract void gen();

    public abstract void gen(ActionElement var1);

    public abstract void gen(AlternativeBlock var1);

    public abstract void gen(BlockEndElement var1);

    public abstract void gen(CharLiteralElement var1);

    public abstract void gen(CharRangeElement var1);

    public abstract void gen(LexerGrammar var1) throws IOException;

    public abstract void gen(OneOrMoreBlock var1);

    public abstract void gen(ParserGrammar var1) throws IOException;

    public abstract void gen(RuleRefElement var1);

    public abstract void gen(StringLiteralElement var1);

    public abstract void gen(TokenRangeElement var1);

    public abstract void gen(TokenRefElement var1);

    public abstract void gen(TreeElement var1);

    public abstract void gen(TreeWalkerGrammar var1) throws IOException;

    public abstract void gen(WildcardElement var1);

    public abstract void gen(ZeroOrMoreBlock var1);

    protected void genTokenInterchange(TokenManager tm) throws IOException {
        String fName = tm.getName() + TokenTypesFileSuffix + TokenTypesFileExt;
        this.currentOutput = this.antlrTool.openOutputFile(fName);
        this.println("// $ANTLR " + Tool.version + ": " + this.antlrTool.fileMinusPath(this.antlrTool.grammarFile) + " -> " + fName + "$");
        this.tabs = 0;
        this.println(tm.getName() + "    // output token vocab name");
        Vector v = tm.getVocabulary();
        for (int i = 4; i < v.size(); ++i) {
            String s = (String)v.elementAt(i);
            if (this.DEBUG_CODE_GENERATOR) {
                System.out.println("gen persistence file entry for: " + s);
            }
            if (s == null || s.startsWith("<")) continue;
            if (s.startsWith("\"")) {
                StringLiteralSymbol sl = (StringLiteralSymbol)tm.getTokenSymbol(s);
                if (sl != null && sl.label != null) {
                    this.print(sl.label + "=");
                }
                this.println(s + "=" + i);
                continue;
            }
            this.print(s);
            TokenSymbol ts = tm.getTokenSymbol(s);
            if (ts == null) {
                this.antlrTool.warning("undefined token symbol: " + s);
            } else if (ts.getParaphrase() != null) {
                this.print("(" + ts.getParaphrase() + ")");
            }
            this.println("=" + i);
        }
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public String processStringForASTConstructor(String str) {
        return str;
    }

    public abstract String getASTCreateString(Vector var1);

    public abstract String getASTCreateString(GrammarAtom var1, String var2);

    protected String getBitsetName(int index) {
        return "_tokenSet_" + index;
    }

    public static String encodeLexerRuleName(String id) {
        return "m" + id;
    }

    public static String decodeLexerRuleName(String id) {
        if (id == null) {
            return null;
        }
        return id.substring(1, id.length());
    }

    public abstract String mapTreeId(String var1, ActionTransInfo var2);

    protected int markBitsetForGen(BitSet p) {
        for (int i = 0; i < this.bitsetsUsed.size(); ++i) {
            BitSet set = (BitSet)this.bitsetsUsed.elementAt(i);
            if (!p.equals(set)) continue;
            return i;
        }
        this.bitsetsUsed.appendElement(p.clone());
        return this.bitsetsUsed.size() - 1;
    }

    protected void print(String s) {
        if (s != null) {
            this.printTabs();
            this.currentOutput.print(s);
        }
    }

    protected void printAction(String s) {
        if (s != null) {
            this.printTabs();
            this._printAction(s);
        }
    }

    protected void println(String s) {
        if (s != null) {
            this.printTabs();
            this.currentOutput.println(s);
        }
    }

    protected void printTabs() {
        for (int i = 1; i <= this.tabs; ++i) {
            this.currentOutput.print("\t");
        }
    }

    protected abstract String processActionForSpecialSymbols(String var1, int var2, RuleBlock var3, ActionTransInfo var4);

    public String getFOLLOWBitSet(String ruleName, int k) {
        GrammarSymbol rs = this.grammar.getSymbol(ruleName);
        if (!(rs instanceof RuleSymbol)) {
            return null;
        }
        RuleBlock blk = ((RuleSymbol)rs).getBlock();
        Lookahead follow = this.grammar.theLLkAnalyzer.FOLLOW(k, blk.endNode);
        String followSetName = this.getBitsetName(this.markBitsetForGen(follow.fset));
        return followSetName;
    }

    public String getFIRSTBitSet(String ruleName, int k) {
        GrammarSymbol rs = this.grammar.getSymbol(ruleName);
        if (!(rs instanceof RuleSymbol)) {
            return null;
        }
        RuleBlock blk = ((RuleSymbol)rs).getBlock();
        Lookahead first = this.grammar.theLLkAnalyzer.look(k, blk);
        String firstSetName = this.getBitsetName(this.markBitsetForGen(first.fset));
        return firstSetName;
    }

    protected String removeAssignmentFromDeclaration(String d) {
        if (d.indexOf(61) >= 0) {
            d = d.substring(0, d.indexOf(61)).trim();
        }
        return d;
    }

    private void reset() {
        this.tabs = 0;
        this.bitsetsUsed = new Vector();
        this.currentOutput = null;
        this.grammar = null;
        this.DEBUG_CODE_GENERATOR = false;
        this.makeSwitchThreshold = 2;
        this.bitsetTestThreshold = 4;
    }

    public static String reverseLexerRuleName(String id) {
        return id.substring(1, id.length());
    }

    public void setAnalyzer(LLkGrammarAnalyzer analyzer_) {
        this.analyzer = analyzer_;
    }

    public void setBehavior(DefineGrammarSymbols behavior_) {
        this.behavior = behavior_;
    }

    protected void setGrammar(Grammar g) {
        Token tok;
        this.reset();
        this.grammar = g;
        if (this.grammar.hasOption("codeGenMakeSwitchThreshold")) {
            try {
                this.makeSwitchThreshold = this.grammar.getIntegerOption("codeGenMakeSwitchThreshold");
            }
            catch (NumberFormatException e) {
                tok = this.grammar.getOption("codeGenMakeSwitchThreshold");
                this.antlrTool.error("option 'codeGenMakeSwitchThreshold' must be an integer", this.grammar.getClassName(), tok.getLine(), tok.getColumn());
            }
        }
        if (this.grammar.hasOption("codeGenBitsetTestThreshold")) {
            try {
                this.bitsetTestThreshold = this.grammar.getIntegerOption("codeGenBitsetTestThreshold");
            }
            catch (NumberFormatException e) {
                tok = this.grammar.getOption("codeGenBitsetTestThreshold");
                this.antlrTool.error("option 'codeGenBitsetTestThreshold' must be an integer", this.grammar.getClassName(), tok.getLine(), tok.getColumn());
            }
        }
        if (this.grammar.hasOption("codeGenDebug")) {
            Token t = this.grammar.getOption("codeGenDebug");
            if (t.getText().equals("true")) {
                this.DEBUG_CODE_GENERATOR = true;
            } else if (t.getText().equals("false")) {
                this.DEBUG_CODE_GENERATOR = false;
            } else {
                this.antlrTool.error("option 'codeGenDebug' must be true or false", this.grammar.getClassName(), t.getLine(), t.getColumn());
            }
        }
    }

    public void setTool(Tool tool) {
        this.antlrTool = tool;
    }
}

