/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.mercurial;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ini4j.Ini;
import org.ini4j.InvalidFileFormatException;
import org.ini4j.Profile;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.mercurial.MercurialHyperlink;
import org.netbeans.modules.hudson.spi.HudsonJobChangeItem;
import org.netbeans.modules.hudson.spi.HudsonSCM;
import org.netbeans.modules.hudson.spi.ProjectHudsonJobCreatorFactory;
import org.openide.util.NbBundle;
import org.openide.windows.OutputListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HudsonMercurialSCM
implements HudsonSCM {
    static final Logger LOG = Logger.getLogger(HudsonMercurialSCM.class.getName());

    public HudsonSCM.Configuration forFolder(File folder) {
        final URI source = HudsonMercurialSCM.getDefaultPull(folder.toURI());
        if (source == null) {
            return null;
        }
        final String repo = "file".equals(source.getScheme()) ? new File(source).getAbsolutePath() : source.toString();
        return new HudsonSCM.Configuration(){

            public void configure(Document doc) {
                Element root = doc.getDocumentElement();
                Element configXmlSCM = (Element)root.appendChild(doc.createElement("scm"));
                configXmlSCM.setAttribute("class", "hudson.plugins.mercurial.MercurialSCM");
                configXmlSCM.appendChild(doc.createElement("source")).appendChild(doc.createTextNode(repo));
                configXmlSCM.appendChild(doc.createElement("modules")).appendChild(doc.createTextNode(""));
                configXmlSCM.appendChild(doc.createElement("clean")).appendChild(doc.createTextNode("true"));
                HudsonSCM.Helper.addTrigger((Document)doc);
            }

            public ProjectHudsonJobCreatorFactory.ConfigurationStatus problems() {
                if (!source.isAbsolute() || "file".equals(source.getScheme())) {
                    return ProjectHudsonJobCreatorFactory.ConfigurationStatus.withWarning((String)NbBundle.getMessage(HudsonMercurialSCM.class, (String)"warning.local_repo", (Object)repo));
                }
                return null;
            }
        };
    }

    public String translateWorkspacePath(HudsonJob job, String workspacePath, File localRoot) {
        return null;
    }

    public List<? extends HudsonJobChangeItem> parseChangeSet(HudsonJob job, Element changeSet) {
        if (!"hg".equals(HudsonSCM.Helper.xpath((String)"kind", (Element)changeSet))) {
            return null;
        }
        URI repo = HudsonMercurialSCM.getDefaultPull(URI.create(job.getUrl() + "ws/"), job);
        if (repo == null) {
            LOG.log(Level.FINE, "No known repo location for {0}", job);
        }
        if (repo != null && !"http".equals(repo.getScheme()) && !"https".equals(repo.getScheme())) {
            LOG.log(Level.FINE, "Need hgweb to show changes from {0}", repo);
            repo = null;
        }
        final URI _repo = repo;
        class HgItem
        implements HudsonJobChangeItem {
            final Element itemXML;

            HgItem(Element xml) {
                this.itemXML = xml;
            }

            public String getUser() {
                return HudsonSCM.Helper.xpath((String)"author/fullName", (Element)this.itemXML);
            }

            public String getMessage() {
                return HudsonSCM.Helper.xpath((String)"msg", (Element)this.itemXML);
            }

            public Collection<? extends HudsonJobChangeItem.HudsonJobChangeFile> getFiles() {
                int i;
                if ("true".equals(HudsonSCM.Helper.xpath((String)"merge", (Element)this.itemXML))) {
                    return Collections.emptySet();
                }
                final String node = HudsonSCM.Helper.xpath((String)"node", (Element)this.itemXML);
                class HgFile
                implements HudsonJobChangeItem.HudsonJobChangeFile {
                    final String path;
                    final HudsonJobChangeItem.HudsonJobChangeFile.EditType editType;

                    HgFile(String path, HudsonJobChangeItem.HudsonJobChangeFile.EditType editType) {
                        this.path = path;
                        this.editType = editType;
                    }

                    public String getName() {
                        return this.path;
                    }

                    public HudsonJobChangeItem.HudsonJobChangeFile.EditType getEditType() {
                        return this.editType;
                    }

                    public OutputListener hyperlink() {
                        return _repo != null ? new MercurialHyperlink(_repo, node, this) : null;
                    }
                }
                ArrayList<HgFile> files = new ArrayList<HgFile>();
                NodeList nl = this.itemXML.getElementsByTagName("addedPath");
                for (i = 0; i < nl.getLength(); ++i) {
                    files.add(new HgFile(HudsonSCM.Helper.xpath((String)"text()", (Element)((Element)nl.item(i))), HudsonJobChangeItem.HudsonJobChangeFile.EditType.add));
                }
                nl = this.itemXML.getElementsByTagName("modifiedPath");
                for (i = 0; i < nl.getLength(); ++i) {
                    files.add(new HgFile(HudsonSCM.Helper.xpath((String)"text()", (Element)((Element)nl.item(i))), HudsonJobChangeItem.HudsonJobChangeFile.EditType.edit));
                }
                nl = this.itemXML.getElementsByTagName("deletedPath");
                for (i = 0; i < nl.getLength(); ++i) {
                    files.add(new HgFile(HudsonSCM.Helper.xpath((String)"text()", (Element)((Element)nl.item(i))), HudsonJobChangeItem.HudsonJobChangeFile.EditType.delete));
                }
                return files;
            }
        }
        ArrayList<HgItem> items = new ArrayList<HgItem>();
        NodeList nl = changeSet.getElementsByTagName("item");
        for (int i = 0; i < nl.getLength(); ++i) {
            items.add(new HgItem((Element)nl.item(i)));
        }
        return items;
    }

    static URI getDefaultPull(URI repository) {
        return HudsonMercurialSCM.getDefaultPull(repository, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URI getDefaultPull(URI repository, HudsonJob job) {
        assert (repository.toString().endsWith("/"));
        URI hgrc = repository.resolve(".hg/hgrc");
        String defaultPull = null;
        ClassLoader l = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(HudsonMercurialSCM.class.getClassLoader());
        try {
            ConnectionBuilder cb = new ConnectionBuilder();
            if (job != null) {
                cb = cb.job(job);
            }
            InputStream is = cb.url(hgrc.toURL()).connection().getInputStream();
            try {
                Ini ini = new Ini(is);
                Profile.Section section = (Profile.Section)ini.get((Object)"paths");
                if (section != null && (defaultPull = (String)section.get((Object)"default-pull")) == null) {
                    defaultPull = (String)section.get((Object)"default");
                }
            }
            finally {
                is.close();
            }
        }
        catch (InvalidFileFormatException x) {
            LOG.log(Level.FINE, "{0} was malformed, perhaps no workspace: {1}", new Object[]{hgrc, x});
            URI is = null;
            return is;
        }
        catch (FileNotFoundException x) {
            try {
                ConnectionBuilder cb = new ConnectionBuilder();
                if (job != null) {
                    cb = cb.job(job);
                }
                cb.url(repository.resolve(".hg/requires").toURL()).connection();
            }
            catch (IOException x2) {
                LOG.log(Level.FINE, "{0} is not an Hg repo", repository);
                URI uRI = null;
                return uRI;
            }
            LOG.log(Level.FINE, "{0} not found", hgrc);
            URI x2 = repository;
            return x2;
        }
        catch (Exception x) {
            LOG.log(Level.WARNING, "Could not parse " + hgrc, x);
            URI x2 = null;
            return x2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(l);
        }
        if (defaultPull == null) {
            LOG.log(Level.FINE, "{0} does not specify paths.default or default-pull", hgrc);
            return repository;
        }
        if (!defaultPull.endsWith("/")) {
            defaultPull = defaultPull + "/";
        }
        if (defaultPull.startsWith("/") || defaultPull.startsWith("\\")) {
            LOG.log(Level.FINE, "{0} looks like a local file location", defaultPull);
            return new File(defaultPull).toURI();
        }
        String defaultPullNoPassword = defaultPull.replaceFirst("//[^/]+(:[^/]+)?@", "//");
        try {
            return repository.resolve(new URI(defaultPullNoPassword));
        }
        catch (URISyntaxException x) {
            LOG.log(Level.FINE, "{0} is not a valid URI", defaultPullNoPassword);
            return null;
        }
    }
}

