/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.FolderImpl;
import org.netbeans.modules.cnd.discovery.api.FolderProperties;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.discovery.wizard.api.support.ProjectBridge;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.Utilities;

public final class ProjectImpl
implements ProjectProperties {
    private static boolean gatherFolders = true;
    private ItemProperties.LanguageKind language;
    private Set<String> userIncludes = new LinkedHashSet<String>();
    private Set<String> systemIncludes = new LinkedHashSet<String>();
    private Map<String, String> userMacros = new HashMap<String, String>();
    private Map<String, FolderProperties> folders = new HashMap<String, FolderProperties>();

    public ProjectImpl(ItemProperties.LanguageKind language) {
        this.language = language;
    }

    public void update(SourceFileProperties source) {
        this.userIncludes.addAll(source.getUserInludePaths());
        for (String path : source.getUserInludePaths()) {
            this.userIncludes.add(DiscoveryUtils.convertRelativePathToAbsolute(source, path));
        }
        this.userMacros.putAll(source.getUserMacros());
        if (gatherFolders) {
            this.updateFolder(source);
        }
    }

    public static List<ProjectProperties> divideByLanguage(List<SourceFileProperties> sources, ProjectProxy project) {
        ProjectImpl cProp = null;
        ProjectImpl cppProp = null;
        if (sources.size() > 0 && project != null && project.mergeProjectProperties()) {
            sources = ProjectImpl.mergeLists(sources, project);
        }
        for (SourceFileProperties source : sources) {
            ItemProperties.LanguageKind lang = source.getLanguageKind();
            ProjectImpl current = null;
            if (lang == ItemProperties.LanguageKind.C) {
                if (cProp == null) {
                    cProp = new ProjectImpl(lang);
                }
                current = cProp;
            } else {
                if (cppProp == null) {
                    cppProp = new ProjectImpl(lang);
                }
                current = cppProp;
            }
            current.update(source);
        }
        ArrayList<ProjectProperties> languages = new ArrayList<ProjectProperties>();
        if (cProp != null) {
            languages.add(cProp);
        }
        if (cppProp != null) {
            languages.add(cppProp);
        }
        return languages;
    }

    private static List<SourceFileProperties> mergeLists(List<SourceFileProperties> discovered, ProjectProxy project) {
        ProjectBridge bridge = new ProjectBridge(project.getProject());
        HashMap<String, SourceFileProperties> map = new HashMap<String, SourceFileProperties>();
        ArrayList<SourceFileProperties> res = new ArrayList<SourceFileProperties>(discovered);
        for (SourceFileProperties source : discovered) {
            map.put(source.getItemPath(), source);
        }
        int equalsSources = 0;
        for (SourceFileProperties source : ProjectImpl.getExistingProjectItems(project)) {
            if (!map.containsKey(source.getItemPath())) {
                res.add(source);
                continue;
            }
            if (!ProjectImpl.isSourcesEquals((SourceFileProperties)map.get(source.getItemPath()), source, bridge)) continue;
            ++equalsSources;
        }
        if (equalsSources == discovered.size()) {
            return Collections.emptyList();
        }
        return res;
    }

    private static boolean isSourcesEquals(SourceFileProperties newSource, SourceFileProperties oldSource, ProjectBridge bridge) {
        List<String> l1 = newSource.getUserInludePaths();
        List<String> l2 = oldSource.getUserInludePaths();
        HashSet<String> set1 = new HashSet<String>();
        bridge.convertIncludePaths(set1, l1, newSource.getCompilePath(), newSource.getItemPath());
        HashSet<String> set2 = new HashSet<String>();
        for (String s : l2) {
            set2.add(bridge.getRelativepath(s));
        }
        if (!set1.equals(set2)) {
            return false;
        }
        Map<String, String> m1 = newSource.getUserMacros();
        Map<String, String> m2 = oldSource.getUserMacros();
        if (m1.size() != m2.size()) {
            return false;
        }
        return new HashMap<String, String>(m1).equals(m2);
    }

    private static List<SourceFileProperties> getExistingProjectItems(ProjectProxy project) {
        Item item;
        int i;
        ArrayList<SourceFileProperties> res = new ArrayList<SourceFileProperties>();
        Project makeProject = project.getProject();
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor makeConfigurationDescriptor = pdp.getConfigurationDescriptor();
        Item[] items = makeConfigurationDescriptor.getProjectItems();
        HashMap<String, Item> projectSearchBase = new HashMap<String, Item>();
        for (i = 0; i < items.length; ++i) {
            item = items[i];
            String path = item.getNormalizedPath();
            projectSearchBase.put(path, item);
        }
        for (i = 0; i < items.length; ++i) {
            NativeFileItem.Language lang;
            item = items[i];
            if (ProjectImpl.isExcluded(item) || (lang = item.getLanguage()) != NativeFileItem.Language.C && lang != NativeFileItem.Language.CPP) continue;
            res.add(new ItemWrapper(item));
        }
        return res;
    }

    private static boolean isExcluded(Item item) {
        MakeConfiguration makeConfiguration = item.getFolder().getConfigurationDescriptor().getActiveConfiguration();
        ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
        if (itemConfiguration == null) {
            return true;
        }
        BooleanConfiguration excl = itemConfiguration.getExcluded();
        return excl.getValue();
    }

    private void updateFolder(SourceFileProperties source) {
        FolderProperties folder;
        File file = new File(source.getItemPath());
        String path = CndFileUtils.normalizeFile((File)file.getParentFile()).getAbsolutePath();
        if (Utilities.isWindows()) {
            path = path.replace('\\', '/');
        }
        if ((folder = this.folders.get(path)) == null) {
            this.folders.put(path, new FolderImpl(path, source));
        } else {
            ((FolderImpl)folder).update(source);
        }
    }

    @Override
    public List<FolderProperties> getConfiguredFolders() {
        return new ArrayList<FolderProperties>(this.folders.values());
    }

    @Override
    public String getMakePath() {
        return null;
    }

    @Override
    public String getBinaryPath() {
        return null;
    }

    @Override
    public ProjectProperties.BinaryKind getBinaryKind() {
        return null;
    }

    @Override
    public List<String> getUserInludePaths() {
        return new ArrayList<String>(this.userIncludes);
    }

    @Override
    public List<String> getSystemInludePaths() {
        return new ArrayList<String>(this.systemIncludes);
    }

    @Override
    public Map<String, String> getUserMacros() {
        return this.userMacros;
    }

    @Override
    public Map<String, String> getSystemMacros() {
        return null;
    }

    @Override
    public ItemProperties.LanguageKind getLanguageKind() {
        return this.language;
    }

    @Override
    public String getCompilerName() {
        return "";
    }

    @Override
    public ItemProperties.LanguageStandard getLanguageStandard() {
        return ItemProperties.LanguageStandard.Unknown;
    }

    private static final class ItemWrapper
    implements SourceFileProperties {
        private final Item item;
        private final List<String> userIncludePaths;
        private final Map<String, String> userMacroDefinitions;

        private ItemWrapper(Item item) {
            this.item = item;
            this.userIncludePaths = this.convertFSPaths(item.getUserIncludePaths());
            this.userMacroDefinitions = this.convertToMap(item.getUserMacroDefinitions());
        }

        private List<String> convertFSPaths(List<FSPath> list) {
            ArrayList<String> res = new ArrayList<String>(list.size());
            for (FSPath p : list) {
                res.add(p.getPath());
            }
            return res;
        }

        private Map<String, String> convertToMap(List<String> list) {
            HashMap<String, String> res = new HashMap<String, String>();
            for (String macro : list) {
                int i = macro.indexOf(61);
                if (i > 0) {
                    res.put(macro.substring(0, i).trim(), macro.substring(i + 1).trim());
                    continue;
                }
                res.put(macro, null);
            }
            return res;
        }

        @Override
        public String getCompilePath() {
            return this.item.getFileObject().getParent().getPath();
        }

        @Override
        public String getItemPath() {
            return this.item.getFileObject().getPath();
        }

        @Override
        public String getItemName() {
            return this.item.getFileObject().getNameExt();
        }

        @Override
        public List<String> getUserInludePaths() {
            return this.userIncludePaths;
        }

        @Override
        public List<String> getSystemInludePaths() {
            return this.convertFSPaths(this.item.getSystemIncludePaths());
        }

        @Override
        public Map<String, String> getUserMacros() {
            return this.userMacroDefinitions;
        }

        @Override
        public Map<String, String> getSystemMacros() {
            return this.convertToMap(this.item.getSystemMacroDefinitions());
        }

        @Override
        public ItemProperties.LanguageKind getLanguageKind() {
            switch (this.item.getLanguage()) {
                case C: {
                    return ItemProperties.LanguageKind.C;
                }
                case CPP: {
                    return ItemProperties.LanguageKind.CPP;
                }
                case FORTRAN: {
                    return ItemProperties.LanguageKind.Fortran;
                }
            }
            return ItemProperties.LanguageKind.Unknown;
        }

        @Override
        public ItemProperties.LanguageStandard getLanguageStandard() {
            switch (this.item.getLanguageFlavor()) {
                case C: {
                    return ItemProperties.LanguageStandard.C;
                }
                case C89: {
                    return ItemProperties.LanguageStandard.C89;
                }
                case C99: {
                    return ItemProperties.LanguageStandard.C99;
                }
                case CPP: {
                    return ItemProperties.LanguageStandard.CPP;
                }
                case F77: {
                    return ItemProperties.LanguageStandard.F77;
                }
                case F90: {
                    return ItemProperties.LanguageStandard.F90;
                }
                case F95: {
                    return ItemProperties.LanguageStandard.F95;
                }
            }
            return ItemProperties.LanguageStandard.Unknown;
        }

        @Override
        public String getCompilerName() {
            switch (this.item.getLanguage()) {
                case C: {
                    return "cc";
                }
                case CPP: {
                    return "CC";
                }
                case FORTRAN: {
                    return "f95";
                }
            }
            return "";
        }
    }
}

