/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.projectimport;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.projectimport.ImportExecutable;
import org.netbeans.modules.cnd.discovery.projectimport.ImportProject;
import org.netbeans.modules.cnd.discovery.services.DiscoveryManagerImpl;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryExtension;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.Env;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.makeproject.api.wizards.CommonUtilities;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CreateDependencies
implements PropertyChangeListener {
    private static final boolean TRACE = true;
    private static final RequestProcessor RP = new RequestProcessor(ImportExecutable.class.getName(), 1);
    private final Project mainProject;
    private final List<String> dependencies;
    private List<String> paths;
    private final List<String> searchPaths;
    private final String binary;
    private final Map<Project, String> createdProjects = new HashMap<Project, String>();
    private MakeConfigurationDescriptor mainConfigurationDescriptor;
    private static final List<CsmProgressListener> listeners = new ArrayList<CsmProgressListener>(1);

    public CreateDependencies(Project mainProject, List<String> dependencies, List<String> paths, List<String> searchPaths, String binary) {
        this.mainProject = mainProject;
        this.dependencies = dependencies;
        this.paths = paths;
        this.searchPaths = searchPaths;
        this.binary = binary;
    }

    public void create() {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.mainProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (!pdp.gotDescriptor()) {
            return;
        }
        this.mainConfigurationDescriptor = pdp.getConfigurationDescriptor();
        if (this.paths == null) {
            if (this.dependencies == null || this.dependencies.isEmpty()) {
                return;
            }
            HashMap<String, String> dllPaths = new HashMap<String, String>();
            String root = ImportExecutable.findFolderPath(this.mainConfigurationDescriptor, ImportExecutable.getRoot(this.mainConfigurationDescriptor));
            if (root != null) {
                MakeConfiguration activeConfiguration = this.mainConfigurationDescriptor.getActiveConfiguration();
                String string2 = CommonUtilities.getLdLibraryPath((MakeConfiguration)activeConfiguration);
                string2 = CommonUtilities.addSearchPaths((String)string2, this.searchPaths, (String)this.binary);
                boolean search = false;
                for (String dll : this.dependencies) {
                    String p = ImportExecutable.findLocation(dll, string2);
                    if (p != null) {
                        dllPaths.put(dll, p);
                        continue;
                    }
                    search = true;
                    dllPaths.put(dll, null);
                }
                if (search && root.length() > 1) {
                    ImportExecutable.gatherSubFolders(new File(root), new HashSet<String>(), dllPaths);
                }
            }
            this.paths = new ArrayList<String>();
            for (Map.Entry entry : dllPaths.entrySet()) {
                if (entry.getValue() == null || !ImportExecutable.isMyDll((String)entry.getValue(), root)) continue;
                this.paths.add((String)entry.getValue());
            }
        }
        for (String entry : this.paths) {
            try {
                Project createProject = CreateDependencies.createProject(entry, "", "", "");
                this.createdProjects.put(createProject, entry);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (!this.createdProjects.isEmpty()) {
            OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
            Project[] toOpen = new Project[this.createdProjects.size()];
            int i = 0;
            Iterator<Object> i$ = this.createdProjects.keySet().iterator();
            while (i$.hasNext()) {
                Project project;
                toOpen[i] = project = (Project)i$.next();
                ++i;
            }
            OpenProjects.getDefault().open(toOpen, false);
        }
    }

    private static void updateRunProfile(String baseDir, RunProfile runProfile, String arguments, String dir, String envText) {
        runProfile.setArgs(arguments);
        String wd = dir;
        wd = CndPathUtilitities.toRelativePath((String)baseDir, (String)wd);
        wd = CndPathUtilitities.normalizeSlashes((String)wd);
        runProfile.setRunDirectory(wd);
        Env env = runProfile.getEnvironment();
        env.removeAll();
        env.decode(envText);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("openProjects") && evt.getNewValue() instanceof Project[]) {
            Project[] projects = (Project[])evt.getNewValue();
            if (projects.length == 0) {
                return;
            }
            for (Project aProject : projects) {
                if (!this.createdProjects.containsKey(aProject)) continue;
                this.addReqProject(aProject);
            }
            DiscoveryManagerImpl.saveMakeConfigurationDescriptor(this.mainProject);
            for (Project aProject : projects) {
                String executable = null;
                if (!this.createdProjects.containsKey(aProject)) continue;
                executable = this.createdProjects.get(aProject);
                this.createdProjects.remove(aProject);
                IteratorExtension extension = (IteratorExtension)Lookup.getDefault().lookup(IteratorExtension.class);
                if (extension == null) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("DW:buildResult", executable);
                map.put("DW:consolidationLevel", "file");
                map.put("DW:rootFolder", aProject.getProjectDirectory().getPath());
                this.process((DiscoveryExtension)extension, aProject, map);
            }
            if (this.createdProjects.isEmpty()) {
                OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }

    private void addReqProject(Project lastSelectedProject) {
        ConfigurationDescriptorProvider provider = (ConfigurationDescriptorProvider)lastSelectedProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor configurationDescriptor = provider.getConfigurationDescriptor(true);
        this.mainConfigurationDescriptor.getActiveConfiguration().getRequiredProjectsConfiguration().add((Object)new LibraryItem.ProjectItem(new MakeArtifact(configurationDescriptor, configurationDescriptor.getActiveConfiguration())));
    }

    public void process(final DiscoveryExtension extension, final Project lastSelectedProject, final Map<String, Object> map) {
        ImportExecutable.switchModel(false, lastSelectedProject);
        RequestProcessor.Task post = RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle progress = ProgressHandleFactory.createHandle((String)NbBundle.getBundle(ImportExecutable.class).getString("ImportExecutable.Progress"));
                progress.start();
                try {
                    ConfigurationDescriptorProvider provider = (ConfigurationDescriptorProvider)lastSelectedProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
                    MakeConfigurationDescriptor configurationDescriptor = provider.getConfigurationDescriptor(true);
                    DiscoveryExtensionInterface.Applicable applicable = extension.isApplicable(map, lastSelectedProject);
                    if (applicable.isApplicable()) {
                        ImportExecutable.resetCompilerSet(configurationDescriptor.getActiveConfiguration(), applicable);
                        if (extension.canApply(map, lastSelectedProject)) {
                            try {
                                extension.apply(map, lastSelectedProject);
                                DiscoveryManagerImpl.saveMakeConfigurationDescriptor(lastSelectedProject);
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    ImportExecutable.switchModel(true, lastSelectedProject);
                    CreateDependencies.this.onProjectParsingFinished(lastSelectedProject);
                }
                catch (Throwable ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    progress.finish();
                }
            }
        });
    }

    private void onProjectParsingFinished(final Project makeProject) {
        if (makeProject != null) {
            final NativeProject np = (NativeProject)makeProject.getLookup().lookup(NativeProject.class);
            CsmProgressAdapter listener = new CsmProgressAdapter(){

                public void projectParsingFinished(CsmProject project) {
                    if (project.getPlatformProject().equals(np)) {
                        CsmListeners.getDefault().removeProgressListener((CsmProgressListener)this);
                        listeners.remove((Object)this);
                        DiscoveryManagerImpl.fixExcludedHeaderFiles(makeProject, ImportProject.logger);
                    }
                }
            };
            listeners.add((CsmProgressListener)listener);
            CsmListeners.getDefault().addProgressListener((CsmProgressListener)listener);
        }
    }

    private static Project createProject(String executablePath, String arguments, String dir, String envText) throws IOException {
        String projectParentFolder = ProjectGenerator.getDefaultProjectFolder();
        String projectName = ProjectGenerator.getValidProjectName((String)projectParentFolder, (String)new File(executablePath).getName());
        String baseDir = projectParentFolder + File.separator + projectName;
        MakeConfiguration conf = new MakeConfiguration(baseDir, "Default", 0);
        String wd = new File(executablePath).getParentFile().getPath();
        wd = CndPathUtilitities.toRelativePath((String)baseDir, (String)wd);
        wd = CndPathUtilitities.normalizeSlashes((String)wd);
        conf.getMakefileConfiguration().getBuildCommandWorkingDir().setValue(wd);
        String exe = executablePath;
        exe = CndPathUtilitities.toRelativePath((String)baseDir, (String)exe);
        exe = CndPathUtilitities.normalizeSlashes((String)exe);
        conf.getMakefileConfiguration().getOutput().setValue(exe);
        CreateDependencies.updateRunProfile(baseDir, conf.getProfile(), arguments, dir, envText);
        ProjectGenerator.ProjectParameters prjParams = new ProjectGenerator.ProjectParameters(projectName, CndFileUtils.createLocalFile((String)projectParentFolder, (String)projectName));
        prjParams.setOpenFlag(false).setConfiguration(conf).setImportantFiles(Collections.singletonList(exe).iterator());
        Project project = ProjectGenerator.createBlankProject((ProjectGenerator.ProjectParameters)prjParams);
        return project;
    }
}

