/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.projectimport;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.BrokenIncludes;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.discovery.projectimport.ImportProject;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class FollowUp
extends JPanel {
    private static final RequestProcessor RP = new RequestProcessor(FollowUp.class.getName(), 2);
    private CsmProject csmProject;
    private JLabel codeAssistance;
    private JLabel configureDone;
    private JLabel details;
    private JScrollPane detailsPane;
    private JTextPane detailsTextPane;
    private JLabel make;
    private JLabel makeClean;
    private JLabel projectCreated;

    private FollowUp(ImportProject importer, NativeProject project) {
        this.initComponents();
        this.details.setVisible(false);
        this.detailsPane.setVisible(false);
        Map<ImportProject.Step, ImportProject.State> map = importer.getImportResult();
        this.showState(ImportProject.Step.Project, map.get((Object)ImportProject.Step.Project), this.projectCreated);
        this.showState(ImportProject.Step.Configure, map.get((Object)ImportProject.Step.Configure), this.configureDone);
        this.showState(ImportProject.Step.MakeClean, map.get((Object)ImportProject.Step.MakeClean), this.makeClean);
        this.showState(ImportProject.Step.Make, map.get((Object)ImportProject.Step.Make), this.make);
        this.showCodeAssistanceState(map, project);
        CsmModel model = CsmModelAccessor.getModel();
        if (model != null && project != null) {
            this.csmProject = model.getProject((Object)project);
            this.initDetails();
        }
    }

    private void showState(ImportProject.Step step, ImportProject.State state, JLabel label) {
        if (state == null) {
            label.setVisible(false);
            return;
        }
        switch (state) {
            case Successful: {
                break;
            }
            case Fail: {
                switch (step) {
                    case Project: {
                        label.setText(FollowUp.getString("ProjectCreatedFailedText", new String[0]));
                        break;
                    }
                    case Configure: {
                        label.setText(FollowUp.getString("ConfigureFailedText", new String[0]));
                        break;
                    }
                    case MakeClean: {
                        label.setText(FollowUp.getString("MakeCleanFailedText", new String[0]));
                        break;
                    }
                    case Make: {
                        label.setText(FollowUp.getString("MakeFailedText", new String[0]));
                    }
                }
                label.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/discovery/wizard/resources/error.png")));
                break;
            }
            case Skiped: {
                label.setVisible(false);
            }
        }
    }

    private void showCodeAssistanceState(Map<ImportProject.Step, ImportProject.State> map, NativeProject project) {
        if (FollowUp.hasBrokenIncludes(project)) {
            this.codeAssistance.setText(FollowUp.getString("CodeAssistanceFailedText", new String[0]));
            this.codeAssistance.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/discovery/wizard/resources/error.png")));
        } else {
            ImportProject.State stateMake = map.get((Object)ImportProject.Step.Make);
            if (stateMake == ImportProject.State.Fail) {
                this.codeAssistance.setText(FollowUp.getString("CodeAssistanceInfoText", new String[0]));
                this.codeAssistance.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/discovery/wizard/resources/info.png")));
            }
        }
    }

    private static boolean hasBrokenIncludes(NativeProject project) {
        BrokenIncludes provider = (BrokenIncludes)Lookup.getDefault().lookup(BrokenIncludes.class);
        if (provider != null) {
            return provider.isBroken(project);
        }
        return false;
    }

    private void initDetails() {
        Object o = this.csmProject.getPlatformProject();
        if (o instanceof NativeProject) {
            NativeProject nativeProject = (NativeProject)o;
            int sourceFiles = 0;
            int sourceFilesExcluded = 0;
            int headerFiles = 0;
            int headerFilesExcluded = 0;
            for (NativeFileItem item : nativeProject.getAllFiles()) {
                switch (item.getLanguage()) {
                    case C: 
                    case CPP: {
                        ++sourceFiles;
                        if (!item.isExcluded()) break;
                        ++sourceFilesExcluded;
                        break;
                    }
                    case C_HEADER: {
                        ++headerFiles;
                        if (!item.isExcluded()) break;
                        ++headerFilesExcluded;
                    }
                }
            }
            String text = MessageFormat.format(FollowUp.getString("Details.String", new String[0]), sourceFilesExcluded, sourceFiles, headerFilesExcluded, headerFiles);
            this.detailsTextPane.setContentType("text/html");
            this.detailsTextPane.setText(text);
            this.details.setVisible(true);
            this.detailsPane.setVisible(true);
        }
    }

    public static void showFollowUp(final ImportProject importer, final NativeProject project) {
        ImageIcon icon;
        String title;
        ActionListener onClickAction = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (importer.isProjectOpened()) {
                    FollowUp panel = new FollowUp(importer, project);
                    DialogDescriptor descriptor = new DialogDescriptor((Object)panel, FollowUp.getString("Dialog_Title", new String[0]), true, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, null, null);
                    Dialog dlg = DialogDisplayer.getDefault().createDialog(descriptor);
                    try {
                        dlg.setVisible(true);
                    }
                    catch (Throwable th) {
                        if (!(th.getCause() instanceof InterruptedException)) {
                            throw new RuntimeException(th);
                        }
                        descriptor.setValue(DialogDescriptor.CANCEL_OPTION);
                    }
                    finally {
                        dlg.dispose();
                    }
                }
            }
        };
        if (FollowUp.hasBrokenIncludes(project)) {
            title = FollowUp.getString("Configure_Fail", new String[0]);
            icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/discovery/wizard/resources/info.png", (boolean)false);
        } else {
            ImportProject.State stateMake = importer.getImportResult().get((Object)ImportProject.Step.Make);
            if (stateMake == ImportProject.State.Fail) {
                title = FollowUp.getString("Configure_Info", new String[0]);
                icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/discovery/wizard/resources/info.png", (boolean)false);
            } else {
                title = FollowUp.getString("Configure_Success", new String[0]);
                icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/discovery/wizard/resources/check.png", (boolean)false);
            }
        }
        final Notification notification = NotificationDisplayer.getDefault().notify(title, (Icon)icon, FollowUp.getString("Dialog_Action", new String[0]), onClickAction, NotificationDisplayer.Priority.HIGH);
        RP.post(new Runnable(){

            @Override
            public void run() {
                notification.clear();
            }
        }, 15000);
    }

    private void initComponents() {
        this.projectCreated = new JLabel();
        this.configureDone = new JLabel();
        this.makeClean = new JLabel();
        this.make = new JLabel();
        this.codeAssistance = new JLabel();
        this.detailsPane = new JScrollPane();
        this.detailsTextPane = new JTextPane();
        this.details = new JLabel();
        this.setEnabled(false);
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(320, 280));
        this.setLayout(new GridBagLayout());
        this.projectCreated.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/discovery/wizard/resources/check.png")));
        this.projectCreated.setText(NbBundle.getMessage(FollowUp.class, (String)"ProjectCreatedText"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.projectCreated, gridBagConstraints);
        this.configureDone.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/discovery/wizard/resources/check.png")));
        this.configureDone.setText(NbBundle.getMessage(FollowUp.class, (String)"ConfigureDoneText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 10);
        this.add((Component)this.configureDone, gridBagConstraints);
        this.makeClean.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/discovery/wizard/resources/check.png")));
        this.makeClean.setText(NbBundle.getMessage(FollowUp.class, (String)"MakeCleanText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 10);
        this.add((Component)this.makeClean, gridBagConstraints);
        this.make.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/discovery/wizard/resources/check.png")));
        this.make.setText(NbBundle.getMessage(FollowUp.class, (String)"MakeText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 10);
        this.add((Component)this.make, gridBagConstraints);
        this.codeAssistance.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/discovery/wizard/resources/check.png")));
        this.codeAssistance.setText(NbBundle.getMessage(FollowUp.class, (String)"CodeAssistanceText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 10, 10);
        this.add((Component)this.codeAssistance, gridBagConstraints);
        this.detailsPane.setBorder(null);
        this.detailsPane.setOpaque(false);
        this.detailsPane.setPreferredSize(new Dimension(100, 100));
        this.detailsTextPane.setEditable(false);
        this.detailsTextPane.setOpaque(false);
        this.detailsPane.setViewportView(this.detailsTextPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.detailsPane, gridBagConstraints);
        this.details.setLabelFor(this.detailsTextPane);
        this.details.setText(NbBundle.getMessage(FollowUp.class, (String)"FollowUp.details.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.details, gridBagConstraints);
    }

    private static String getString(String key, String ... params) {
        return NbBundle.getMessage(FollowUp.class, (String)key, (Object[])params);
    }
}

