/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.util.List;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.api.ProjectConfiguration;
import org.openide.WizardDescriptor;
import org.openide.util.Utilities;

public class DiscoveryWizardDescriptor
extends WizardDescriptor
implements DiscoveryDescriptor {
    public static final String PROJECT = "DW:project";
    public static final String PROVIDER = "DW:provider";
    public static final String ROOT_FOLDER = "DW:rootFolder";
    public static final String BUILD_RESULT = "DW:buildResult";
    public static final String LOG_FILE = "DW:logFile";
    public static final String EXEC_LOG_FILE = "DW:execLogFile";
    public static final String ADDITIONAL_LIBRARIES = "DW:libraries";
    public static final String CONSOLIDATION_STRATEGY = "DW:consolidationLevel";
    public static final String CONFIGURATIONS = "DW:configurations";
    public static final String INCLUDED = "DW:included";
    public static final String INVOKE_PROVIDER = "DW:invokeProvider";
    public static final String COMPILER_NAME = "DW:compiler";
    public static final String DEPENDENCIES = "DW:dependencies";
    public static final String SEARCH_PATHS = "DW:searchPaths";
    public static final String ERRORS = "DW:errors";
    public static final String INCREMENTAL = "DW:incremental";
    private boolean stateChanged = true;
    private boolean simple = true;
    private boolean cutResult = false;

    public DiscoveryWizardDescriptor(WizardDescriptor.Iterator panels) {
        super(panels);
    }

    public static DiscoveryDescriptor adaptee(Object wizard) {
        if (wizard instanceof DiscoveryDescriptor) {
            return (DiscoveryDescriptor)wizard;
        }
        if (wizard instanceof WizardDescriptor) {
            return new DiscoveryWizardDescriptorAdapter((WizardDescriptor)wizard);
        }
        if (wizard instanceof Map) {
            return new DiscoveryWizardClone((Map)wizard);
        }
        return null;
    }

    @Override
    public Project getProject() {
        return (Project)this.getProperty(PROJECT);
    }

    @Override
    public void setProject(Project project) {
        this.putProperty(PROJECT, project);
    }

    @Override
    public String getRootFolder() {
        return (String)this.getProperty(ROOT_FOLDER);
    }

    @Override
    public void setRootFolder(String root) {
        this.stateChanged = true;
        if (root != null && Utilities.isWindows()) {
            root = root.replace('\\', '/');
        }
        this.putProperty(ROOT_FOLDER, root);
    }

    @Override
    public List<String> getErrors() {
        return (List)this.getProperty(ERRORS);
    }

    @Override
    public void setErrors(List<String> errors) {
        this.stateChanged = true;
        this.putProperty(ERRORS, errors);
    }

    @Override
    public String getBuildResult() {
        return (String)this.getProperty(BUILD_RESULT);
    }

    @Override
    public void setBuildResult(String binaryPath) {
        this.putProperty(BUILD_RESULT, binaryPath);
    }

    @Override
    public String getAditionalLibraries() {
        return (String)this.getProperty(ADDITIONAL_LIBRARIES);
    }

    @Override
    public void setAditionalLibraries(String binaryPath) {
        this.putProperty(ADDITIONAL_LIBRARIES, binaryPath);
    }

    @Override
    public String getBuildLog() {
        return (String)this.getProperty(LOG_FILE);
    }

    @Override
    public void setBuildLog(String logFile) {
        this.putProperty(LOG_FILE, logFile);
    }

    @Override
    public String getExecLog() {
        return (String)this.getProperty(EXEC_LOG_FILE);
    }

    @Override
    public void setExecLog(String logFile) {
        this.putProperty(EXEC_LOG_FILE, logFile);
    }

    @Override
    public DiscoveryProvider getProvider() {
        return (DiscoveryProvider)this.getProperty(PROVIDER);
    }

    @Override
    public String getProviderID() {
        DiscoveryProvider provider = (DiscoveryProvider)this.getProperty(PROVIDER);
        if (provider != null) {
            return provider.getID();
        }
        return null;
    }

    @Override
    public void setProvider(DiscoveryProvider provider) {
        this.stateChanged = true;
        this.putProperty(PROVIDER, provider);
    }

    @Override
    public String getLevel() {
        return (String)this.getProperty(CONSOLIDATION_STRATEGY);
    }

    @Override
    public void setLevel(String level) {
        this.putProperty(CONSOLIDATION_STRATEGY, level);
    }

    @Override
    public List<ProjectConfiguration> getConfigurations() {
        return (List)this.getProperty(CONFIGURATIONS);
    }

    @Override
    public void setConfigurations(List<ProjectConfiguration> configuration) {
        this.putProperty(CONFIGURATIONS, configuration);
    }

    @Override
    public List<String> getIncludedFiles() {
        return (List)this.getProperty(INCLUDED);
    }

    @Override
    public void setIncludedFiles(List<String> includedFiles) {
        this.putProperty(INCLUDED, includedFiles);
    }

    @Override
    public boolean isInvokeProvider() {
        return this.stateChanged;
    }

    @Override
    public void setInvokeProvider(boolean invoke) {
        this.stateChanged = invoke;
    }

    @Override
    public void setMessage(String message) {
        this.putProperty("WizardPanel_errorMessage", message);
    }

    @Override
    public void clean() {
        this.setProject(null);
        this.setProvider(null);
        this.setRootFolder(null);
        this.setBuildResult(null);
        this.setAditionalLibraries(null);
        this.setLevel(null);
        this.setConfigurations(null);
        this.setIncludedFiles(null);
    }

    @Override
    public boolean isSimpleMode() {
        return this.simple;
    }

    @Override
    public void setSimpleMode(boolean simple) {
        this.simple = simple;
    }

    public boolean isCutResult() {
        return this.cutResult;
    }

    public void setCutResult(boolean cutResult) {
        this.cutResult = cutResult;
    }

    @Override
    public String getCompilerName() {
        return (String)this.getProperty(COMPILER_NAME);
    }

    @Override
    public void setCompilerName(String compiler) {
        this.putProperty(COMPILER_NAME, compiler);
    }

    @Override
    public List<String> getDependencies() {
        return (List)this.getProperty(DEPENDENCIES);
    }

    @Override
    public void setDependencies(List<String> dependencies) {
        this.putProperty(DEPENDENCIES, dependencies);
    }

    @Override
    public List<String> getSearchPaths() {
        return (List)this.getProperty(SEARCH_PATHS);
    }

    @Override
    public void setSearchPaths(List<String> searchPaths) {
        this.putProperty(SEARCH_PATHS, searchPaths);
    }

    @Override
    public boolean isIncrementalMode() {
        return Boolean.TRUE.equals(this.getProperty(INCREMENTAL));
    }

    @Override
    public void setIncrementalMode(boolean incremental) {
        this.putProperty(INCREMENTAL, incremental);
    }

    private static class DiscoveryWizardClone
    implements DiscoveryDescriptor {
        private Map<String, Object> map;

        public DiscoveryWizardClone(Map<String, Object> map) {
            this.map = map;
        }

        @Override
        public Project getProject() {
            return (Project)this.map.get(DiscoveryWizardDescriptor.PROJECT);
        }

        @Override
        public void setProject(Project project) {
            this.map.put(DiscoveryWizardDescriptor.PROJECT, project);
        }

        @Override
        public String getRootFolder() {
            String root = (String)this.map.get(DiscoveryWizardDescriptor.ROOT_FOLDER);
            if (root == null && (root = (String)this.map.get("buildCommandWorkingDirTextField")) != null && Utilities.isWindows()) {
                root = root.replace('\\', '/');
            }
            return root;
        }

        @Override
        public void setRootFolder(String root) {
            this.map.put(DiscoveryWizardDescriptor.INVOKE_PROVIDER, Boolean.TRUE);
            if (root != null && Utilities.isWindows()) {
                root = root.replace('\\', '/');
            }
            this.map.put(DiscoveryWizardDescriptor.ROOT_FOLDER, root);
        }

        @Override
        public List<String> getErrors() {
            return (List)this.map.get(DiscoveryWizardDescriptor.ERRORS);
        }

        @Override
        public void setErrors(List<String> errors) {
            this.map.put(DiscoveryWizardDescriptor.ERRORS, errors);
        }

        @Override
        public String getBuildResult() {
            return (String)this.map.get(DiscoveryWizardDescriptor.BUILD_RESULT);
        }

        @Override
        public void setBuildResult(String binaryPath) {
            this.map.put(DiscoveryWizardDescriptor.BUILD_RESULT, binaryPath);
        }

        @Override
        public String getAditionalLibraries() {
            return (String)this.map.get(DiscoveryWizardDescriptor.ADDITIONAL_LIBRARIES);
        }

        @Override
        public void setAditionalLibraries(String binaryPath) {
            this.map.put(DiscoveryWizardDescriptor.ADDITIONAL_LIBRARIES, binaryPath);
        }

        @Override
        public String getBuildLog() {
            return (String)this.map.get(DiscoveryWizardDescriptor.LOG_FILE);
        }

        @Override
        public void setBuildLog(String logFile) {
            this.map.put(DiscoveryWizardDescriptor.LOG_FILE, logFile);
        }

        @Override
        public String getExecLog() {
            return (String)this.map.get(DiscoveryWizardDescriptor.EXEC_LOG_FILE);
        }

        @Override
        public void setExecLog(String logFile) {
            this.map.put(DiscoveryWizardDescriptor.EXEC_LOG_FILE, logFile);
        }

        @Override
        public DiscoveryProvider getProvider() {
            return (DiscoveryProvider)this.map.get(DiscoveryWizardDescriptor.PROVIDER);
        }

        @Override
        public String getProviderID() {
            DiscoveryProvider provider = (DiscoveryProvider)this.map.get(DiscoveryWizardDescriptor.PROVIDER);
            if (provider != null) {
                return provider.getID();
            }
            return null;
        }

        @Override
        public void setProvider(DiscoveryProvider provider) {
            this.map.put(DiscoveryWizardDescriptor.INVOKE_PROVIDER, Boolean.TRUE);
            this.map.put(DiscoveryWizardDescriptor.PROVIDER, provider);
        }

        @Override
        public String getLevel() {
            return (String)this.map.get(DiscoveryWizardDescriptor.CONSOLIDATION_STRATEGY);
        }

        @Override
        public void setLevel(String level) {
            this.map.put(DiscoveryWizardDescriptor.CONSOLIDATION_STRATEGY, level);
        }

        @Override
        public List<ProjectConfiguration> getConfigurations() {
            return (List)this.map.get(DiscoveryWizardDescriptor.CONFIGURATIONS);
        }

        @Override
        public void setConfigurations(List<ProjectConfiguration> configuration) {
            this.map.put(DiscoveryWizardDescriptor.CONFIGURATIONS, configuration);
        }

        @Override
        public List<String> getIncludedFiles() {
            return (List)this.map.get(DiscoveryWizardDescriptor.INCLUDED);
        }

        @Override
        public void setIncludedFiles(List<String> includedFiles) {
            this.map.put(DiscoveryWizardDescriptor.INCLUDED, includedFiles);
        }

        @Override
        public boolean isInvokeProvider() {
            Boolean res = (Boolean)this.map.get(DiscoveryWizardDescriptor.INVOKE_PROVIDER);
            if (res == null) {
                return true;
            }
            return res;
        }

        @Override
        public void setInvokeProvider(boolean invoke) {
            if (invoke) {
                this.map.put(DiscoveryWizardDescriptor.INVOKE_PROVIDER, Boolean.TRUE);
            } else {
                this.map.put(DiscoveryWizardDescriptor.INVOKE_PROVIDER, Boolean.FALSE);
            }
        }

        @Override
        public boolean isSimpleMode() {
            return true;
        }

        @Override
        public void setSimpleMode(boolean simple) {
        }

        public boolean isCutResult() {
            return false;
        }

        public void setCutResult(boolean cutResult) {
        }

        @Override
        public void setMessage(String message) {
            this.map.put("WizardPanel_errorMessage", message);
        }

        @Override
        public void clean() {
            this.setProject(null);
            this.setProvider(null);
            this.setRootFolder(null);
            this.setBuildResult(null);
            this.setAditionalLibraries(null);
            this.setBuildLog(null);
            this.setLevel(null);
            this.setConfigurations(null);
            this.setIncludedFiles(null);
        }

        @Override
        public String getCompilerName() {
            return (String)this.map.get(DiscoveryWizardDescriptor.COMPILER_NAME);
        }

        @Override
        public void setCompilerName(String compiler) {
            this.map.put(DiscoveryWizardDescriptor.COMPILER_NAME, compiler);
        }

        @Override
        public List<String> getDependencies() {
            return (List)this.map.get(DiscoveryWizardDescriptor.DEPENDENCIES);
        }

        @Override
        public void setDependencies(List<String> dependencies) {
            this.map.put(DiscoveryWizardDescriptor.DEPENDENCIES, dependencies);
        }

        @Override
        public List<String> getSearchPaths() {
            return (List)this.map.get(DiscoveryWizardDescriptor.SEARCH_PATHS);
        }

        @Override
        public void setSearchPaths(List<String> searchPaths) {
            this.map.put(DiscoveryWizardDescriptor.SEARCH_PATHS, searchPaths);
        }

        @Override
        public boolean isIncrementalMode() {
            return Boolean.TRUE.equals(this.map.get(DiscoveryWizardDescriptor.INCREMENTAL));
        }

        @Override
        public void setIncrementalMode(boolean incremental) {
            this.map.put(DiscoveryWizardDescriptor.INCREMENTAL, incremental);
        }
    }

    private static class DiscoveryWizardDescriptorAdapter
    implements DiscoveryDescriptor {
        private WizardDescriptor wizard;

        public DiscoveryWizardDescriptorAdapter(WizardDescriptor wizard) {
            this.wizard = wizard;
        }

        @Override
        public Project getProject() {
            return (Project)this.wizard.getProperty(DiscoveryWizardDescriptor.PROJECT);
        }

        @Override
        public void setProject(Project project) {
            this.wizard.putProperty(DiscoveryWizardDescriptor.PROJECT, (Object)project);
        }

        @Override
        public String getRootFolder() {
            String root = (String)this.wizard.getProperty(DiscoveryWizardDescriptor.ROOT_FOLDER);
            if (root == null && (root = (String)this.wizard.getProperty("buildCommandWorkingDirTextField")) != null && Utilities.isWindows()) {
                root = root.replace('\\', '/');
            }
            return root;
        }

        @Override
        public void setRootFolder(String root) {
            this.wizard.putProperty(DiscoveryWizardDescriptor.INVOKE_PROVIDER, (Object)Boolean.TRUE);
            if (root != null && Utilities.isWindows()) {
                root = root.replace('\\', '/');
            }
            this.wizard.putProperty(DiscoveryWizardDescriptor.ROOT_FOLDER, (Object)root);
        }

        @Override
        public List<String> getErrors() {
            return (List)this.wizard.getProperty(DiscoveryWizardDescriptor.ERRORS);
        }

        @Override
        public void setErrors(List<String> errors) {
            this.wizard.putProperty(DiscoveryWizardDescriptor.ERRORS, errors);
        }

        @Override
        public String getBuildResult() {
            return (String)this.wizard.getProperty(DiscoveryWizardDescriptor.BUILD_RESULT);
        }

        @Override
        public void setBuildResult(String binaryPath) {
            this.wizard.putProperty(DiscoveryWizardDescriptor.BUILD_RESULT, (Object)binaryPath);
        }

        @Override
        public String getAditionalLibraries() {
            return (String)this.wizard.getProperty(DiscoveryWizardDescriptor.ADDITIONAL_LIBRARIES);
        }

        @Override
        public void setAditionalLibraries(String binaryPath) {
            this.wizard.putProperty(DiscoveryWizardDescriptor.ADDITIONAL_LIBRARIES, (Object)binaryPath);
        }

        @Override
        public String getBuildLog() {
            return (String)this.wizard.getProperty(DiscoveryWizardDescriptor.LOG_FILE);
        }

        @Override
        public void setBuildLog(String logFile) {
            this.wizard.putProperty(DiscoveryWizardDescriptor.LOG_FILE, (Object)logFile);
        }

        @Override
        public String getExecLog() {
            return (String)this.wizard.getProperty(DiscoveryWizardDescriptor.EXEC_LOG_FILE);
        }

        @Override
        public void setExecLog(String logFile) {
            this.wizard.putProperty(DiscoveryWizardDescriptor.EXEC_LOG_FILE, (Object)logFile);
        }

        @Override
        public DiscoveryProvider getProvider() {
            return (DiscoveryProvider)this.wizard.getProperty(DiscoveryWizardDescriptor.PROVIDER);
        }

        @Override
        public String getProviderID() {
            DiscoveryProvider provider = (DiscoveryProvider)this.wizard.getProperty(DiscoveryWizardDescriptor.PROVIDER);
            if (provider != null) {
                return provider.getID();
            }
            return null;
        }

        @Override
        public void setProvider(DiscoveryProvider provider) {
            this.wizard.putProperty(DiscoveryWizardDescriptor.INVOKE_PROVIDER, (Object)Boolean.TRUE);
            this.wizard.putProperty(DiscoveryWizardDescriptor.PROVIDER, (Object)provider);
        }

        @Override
        public String getLevel() {
            return (String)this.wizard.getProperty(DiscoveryWizardDescriptor.CONSOLIDATION_STRATEGY);
        }

        @Override
        public void setLevel(String level) {
            this.wizard.putProperty(DiscoveryWizardDescriptor.CONSOLIDATION_STRATEGY, (Object)level);
        }

        @Override
        public List<ProjectConfiguration> getConfigurations() {
            return (List)this.wizard.getProperty(DiscoveryWizardDescriptor.CONFIGURATIONS);
        }

        @Override
        public void setConfigurations(List<ProjectConfiguration> configuration) {
            this.wizard.putProperty(DiscoveryWizardDescriptor.CONFIGURATIONS, configuration);
        }

        @Override
        public List<String> getIncludedFiles() {
            return (List)this.wizard.getProperty(DiscoveryWizardDescriptor.INCLUDED);
        }

        @Override
        public void setIncludedFiles(List<String> includedFiles) {
            this.wizard.putProperty(DiscoveryWizardDescriptor.INCLUDED, includedFiles);
        }

        @Override
        public boolean isInvokeProvider() {
            Boolean res = (Boolean)this.wizard.getProperty(DiscoveryWizardDescriptor.INVOKE_PROVIDER);
            if (res == null) {
                return true;
            }
            return res;
        }

        @Override
        public void setInvokeProvider(boolean invoke) {
            if (invoke) {
                this.wizard.putProperty(DiscoveryWizardDescriptor.INVOKE_PROVIDER, (Object)Boolean.TRUE);
            } else {
                this.wizard.putProperty(DiscoveryWizardDescriptor.INVOKE_PROVIDER, (Object)Boolean.FALSE);
            }
        }

        @Override
        public boolean isSimpleMode() {
            return true;
        }

        @Override
        public void setSimpleMode(boolean simple) {
        }

        public boolean isCutResult() {
            return false;
        }

        public void setCutResult(boolean cutResult) {
        }

        @Override
        public void setMessage(String message) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)message);
        }

        @Override
        public void clean() {
            this.setProject(null);
            this.setProvider(null);
            this.setRootFolder(null);
            this.setBuildResult(null);
            this.setAditionalLibraries(null);
            this.setBuildLog(null);
            this.setLevel(null);
            this.setConfigurations(null);
            this.setIncludedFiles(null);
        }

        @Override
        public String getCompilerName() {
            return (String)this.wizard.getProperty(DiscoveryWizardDescriptor.COMPILER_NAME);
        }

        @Override
        public void setCompilerName(String compiler) {
            this.wizard.putProperty(DiscoveryWizardDescriptor.COMPILER_NAME, (Object)compiler);
        }

        @Override
        public List<String> getDependencies() {
            return (List)this.wizard.getProperty(DiscoveryWizardDescriptor.DEPENDENCIES);
        }

        @Override
        public void setDependencies(List<String> dependencies) {
            this.wizard.putProperty(DiscoveryWizardDescriptor.DEPENDENCIES, dependencies);
        }

        @Override
        public List<String> getSearchPaths() {
            return (List)this.wizard.getProperty(DiscoveryWizardDescriptor.SEARCH_PATHS);
        }

        @Override
        public void setSearchPaths(List<String> searchPaths) {
            this.wizard.putProperty(DiscoveryWizardDescriptor.SEARCH_PATHS, searchPaths);
        }

        @Override
        public boolean isIncrementalMode() {
            return Boolean.TRUE.equals(this.wizard.getProperty(DiscoveryWizardDescriptor.INCREMENTAL));
        }

        @Override
        public void setIncrementalMode(boolean incremental) {
            this.wizard.putProperty(DiscoveryWizardDescriptor.INCREMENTAL, (Object)incremental);
        }
    }
}

