/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import java.util.concurrent.Future;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.SftpSupport;
import org.openide.util.Exceptions;

public class FileInfoProvider {
    private static final short ACCESS_MASK = 511;
    private static final short USR_R = 256;
    private static final short USR_W = 128;
    private static final short USR_X = 64;
    private static final short GRP_R = 32;
    private static final short GRP_W = 16;
    private static final short GRP_X = 8;
    private static final short ALL_R = 4;
    private static final short ALL_W = 2;
    private static final short ALL_X = 1;

    public static Future<StatInfo> stat(ExecutionEnvironment env, String absPath) {
        return SftpSupport.getInstance(env).stat(absPath, new PrintWriter(System.err));
    }

    public static Future<StatInfo> stat(ExecutionEnvironment env, String absPath, Writer error) {
        return SftpSupport.getInstance(env).stat(absPath, error);
    }

    public static Future<StatInfo[]> ls(ExecutionEnvironment env, String absPath) {
        return FileInfoProvider.ls(env, absPath, new PrintWriter(System.err));
    }

    public static Future<StatInfo[]> ls(ExecutionEnvironment env, String absPath, Writer error) {
        return SftpSupport.getInstance(env).ls(absPath, error);
    }

    private static short stringToAcces(String accessString) {
        if (accessString.length() < 9) {
            throw new IllegalArgumentException("wrong access string: " + accessString);
        }
        short result = 0;
        result = (short)(result | (accessString.charAt(0) == 'r' ? 256 : 0));
        result = (short)(result | (accessString.charAt(1) == 'w' ? 128 : 0));
        result = (short)(result | (accessString.charAt(2) == 'x' ? 64 : 0));
        result = (short)(result | (accessString.charAt(3) == 'r' ? 32 : 0));
        result = (short)(result | (accessString.charAt(4) == 'w' ? 16 : 0));
        result = (short)(result | (accessString.charAt(5) == 'x' ? 8 : 0));
        result = (short)(result | (accessString.charAt(6) == 'r' ? 4 : 0));
        result = (short)(result | (accessString.charAt(7) == 'w' ? 2 : 0));
        result = (short)(result | (accessString.charAt(8) == 'x' ? 1 : 0));
        return result;
    }

    private static String accessToString(int access) {
        char[] accessChars = new char[]{(access & 0x100) == 0 ? (char)'-' : 'r', (access & 0x80) == 0 ? (char)'-' : 'w', (access & 0x40) == 0 ? (char)'-' : 'x', (access & 0x20) == 0 ? (char)'-' : 'r', (access & 0x10) == 0 ? (char)'-' : 'w', (access & 8) == 0 ? (char)'-' : 'x', (access & 4) == 0 ? (char)'-' : 'r', (access & 2) == 0 ? (char)'-' : 'w', (access & 1) == 0 ? (char)'-' : 'x'};
        return new String(accessChars);
    }

    private static String escape(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            text = text.replace(" ", "\\ ");
            return text;
        }
    }

    private static String unescape(String text) {
        try {
            return URLDecoder.decode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            text = text.replace("\\ ", " ");
            return text;
        }
    }

    public static final class StatInfo {
        private final String name;
        private final boolean directory;
        private final boolean link;
        private final int gid;
        private final int uid;
        private final long size;
        private final String linkTarget;
        private final int access;
        private final Date lastModified;

        StatInfo(String name, int uid, int gid, long size, boolean directory, boolean link, String linkTarget, int access, Date lastModified) {
            this.name = name;
            this.gid = gid;
            this.uid = uid;
            this.size = size;
            this.access = access & 0x1FF;
            this.directory = directory;
            this.link = link;
            this.linkTarget = linkTarget;
            this.lastModified = lastModified;
        }

        public int getAccess() {
            return this.access;
        }

        public String getAccessAsString() {
            return FileInfoProvider.accessToString(this.access);
        }

        public long getSize() {
            return this.size;
        }

        public int getGropupId() {
            return this.gid;
        }

        public Date getLastModified() {
            return this.lastModified;
        }

        public String getLinkTarget() {
            return this.linkTarget;
        }

        public String getName() {
            return this.name;
        }

        public int getUserId() {
            return this.uid;
        }

        public boolean isDirectory() {
            return this.directory;
        }

        public boolean isLink() {
            return this.link;
        }

        public String toExternalForm() {
            StringBuilder sb = new StringBuilder();
            sb.append(FileInfoProvider.escape(this.name)).append(' ');
            sb.append(FileInfoProvider.accessToString(this.access)).append(' ');
            sb.append(this.directory).append(' ');
            sb.append(this.link).append(' ');
            sb.append(this.gid).append(' ');
            sb.append(this.uid).append(' ');
            sb.append(this.lastModified.getTime()).append(' ');
            sb.append(this.size).append(' ');
            if (this.linkTarget != null) {
                sb.append(FileInfoProvider.escape(this.linkTarget)).append(' ');
            }
            return sb.toString();
        }

        public static StatInfo fromExternalForm(String externalForm) {
            String[] parts = externalForm.split(" +");
            String name = FileInfoProvider.unescape(parts[0]);
            short acc = FileInfoProvider.stringToAcces(parts[1]);
            boolean dir = Boolean.parseBoolean(parts[2]);
            boolean link = Boolean.parseBoolean(parts[3]);
            int gid = Integer.parseInt(parts[4]);
            int uid = Integer.parseInt(parts[5]);
            long time = Long.parseLong(parts[6]);
            long size = Long.parseLong(parts[7]);
            String linkTarget = parts.length < 9 ? null : FileInfoProvider.unescape(parts[8]);
            return new StatInfo(name, uid, gid, size, dir, link, linkTarget, acc, new Date(time));
        }

        private boolean can(ExecutionEnvironment env, short all_mask, short grp_mask, short usr_mask) {
            if (HostInfoUtils.isHostInfoAvailable(env)) {
                try {
                    HostInfo hostInfo = HostInfoUtils.getHostInfo(env);
                    if (this.uid == hostInfo.getUserId()) {
                        return (this.access & usr_mask) > 0;
                    }
                    boolean isGroupClass = false;
                    for (int currGid : hostInfo.getAllGroupIDs()) {
                        if (this.gid != currGid) continue;
                        isGroupClass = true;
                        break;
                    }
                    if (isGroupClass) {
                        return (this.access & grp_mask) > 0;
                    }
                    return (this.access & all_mask) > 0;
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ConnectionManager.CancellationException ex) {
                    // empty catch block
                }
            }
            return false;
        }

        public boolean canRead(ExecutionEnvironment env) {
            return this.can(env, (short)4, (short)32, (short)256);
        }

        public boolean canWrite(ExecutionEnvironment env) {
            return this.can(env, (short)2, (short)16, (short)128);
        }

        public boolean canExecute(ExecutionEnvironment env) {
            return this.can(env, (short)1, (short)8, (short)64);
        }

        public String toString() {
            return this.name + ' ' + this.uid + ' ' + this.gid + ' ' + FileInfoProvider.accessToString(this.access) + ' ' + this.directory + ' ' + this.lastModified + ' ' + (this.link ? " -> " + this.linkTarget : "");
        }
    }
}

