/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class PasswordManager {
    private static final boolean keepPasswordsInMemory;
    private static final String KEY_PREFIX = "remote.user.info.password.";
    private static final String STORE_PREFIX = "remote.user.info.store.";
    private final Map<String, String> cache = Collections.synchronizedMap(new HashMap());
    private boolean keyringIsActivated = false;
    private static PasswordManager instance;

    private PasswordManager() {
    }

    public static PasswordManager getInstance() {
        return instance;
    }

    public char[] getPassword(ExecutionEnvironment execEnv) {
        String cachedPassword;
        String key = ExecutionEnvironmentFactory.toUniqueID(execEnv);
        if (keepPasswordsInMemory && (cachedPassword = this.cache.get(key)) != null) {
            Logger.getInstance().log(Level.FINEST, "PasswordManager.get({0}) found password in memory", execEnv);
            return cachedPassword.toCharArray();
        }
        boolean stored = NbPreferences.forModule(PasswordManager.class).getBoolean(STORE_PREFIX + key, false);
        if (stored) {
            this.keyringIsActivated = true;
            char[] keyringPassword = Keyring.read((String)(KEY_PREFIX + key));
            if (keepPasswordsInMemory && keyringPassword != null) {
                this.cache.put(key, String.valueOf(keyringPassword));
            }
            Logger.getInstance().log(Level.FINEST, "PasswordManager.get({0}) found password in keyring", execEnv);
            return keyringPassword;
        }
        Logger.getInstance().log(Level.FINEST, "PasswordManager.get({0}) failed to find password", execEnv);
        return null;
    }

    public void storePassword(ExecutionEnvironment execEnv, char[] password, boolean rememberPassword) {
        this.setRememberPassword(execEnv, rememberPassword);
        this.put(execEnv, password);
    }

    private void put(ExecutionEnvironment execEnv, char[] password) {
        boolean store;
        String key = ExecutionEnvironmentFactory.toUniqueID(execEnv);
        if (keepPasswordsInMemory) {
            if (password != null) {
                this.cache.put(key, String.valueOf(password));
                Logger.getInstance().log(Level.FINEST, "PasswordManager.put({0}, non-null) stored password in memory", execEnv);
            } else {
                Logger.getInstance().log(Level.FINEST, "PasswordManager.put({0}, null) cleared password from memory", execEnv);
                this.cache.put(key, null);
            }
        }
        if (store = NbPreferences.forModule(PasswordManager.class).getBoolean(STORE_PREFIX + key, false)) {
            this.keyringIsActivated = true;
            Keyring.save((String)(KEY_PREFIX + key), (char[])password, (String)NbBundle.getMessage(PasswordManager.class, (String)"PasswordManagerPasswordFor", (Object)execEnv.getDisplayName()));
            Logger.getInstance().log(Level.FINEST, "PasswordManager.put({0}, non-null) stored password in keyring", execEnv);
        }
    }

    void onExplicitDisconnect(ExecutionEnvironment execEnv) {
        String key = ExecutionEnvironmentFactory.toUniqueID(execEnv);
        this.cache.remove(key);
    }

    public void clearPassword(ExecutionEnvironment execEnv) {
        String key = ExecutionEnvironmentFactory.toUniqueID(execEnv);
        if (keepPasswordsInMemory) {
            this.cache.remove(key);
        }
        NbPreferences.forModule(PasswordManager.class).remove(STORE_PREFIX + key);
        if (this.keyringIsActivated) {
            Keyring.delete((String)(KEY_PREFIX + key));
        }
        Logger.getInstance().log(Level.FINEST, "PasswordManager.clearPassword({0})", execEnv);
    }

    public void forceClearPassword(ExecutionEnvironment execEnv) {
        String key = ExecutionEnvironmentFactory.toUniqueID(execEnv);
        if (keepPasswordsInMemory) {
            this.cache.remove(key);
        }
        NbPreferences.forModule(PasswordManager.class).remove(STORE_PREFIX + key);
        Keyring.delete((String)(KEY_PREFIX + key));
        Logger.getInstance().log(Level.FINEST, "PasswordManager.forceClearPassword({0})", execEnv);
    }

    public void setServerList(List<ExecutionEnvironment> envs) {
        HashSet<String> keys = new HashSet<String>();
        for (ExecutionEnvironment env : envs) {
            String key = ExecutionEnvironmentFactory.toUniqueID(env);
            keys.add(KEY_PREFIX + key);
            keys.add(STORE_PREFIX + key);
        }
        try {
            String[] allKeys;
            for (String aKey : allKeys = NbPreferences.forModule(PasswordManager.class).keys()) {
                if (keys.contains(aKey) || !aKey.startsWith(STORE_PREFIX)) continue;
                if (this.keyringIsActivated) {
                    Keyring.delete((String)(KEY_PREFIX + aKey.substring(STORE_PREFIX.length())));
                }
                if (!keepPasswordsInMemory) continue;
                this.cache.remove(aKey.substring(STORE_PREFIX.length()));
            }
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (Throwable ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public boolean isRememberPassword(ExecutionEnvironment execEnv) {
        String key = ExecutionEnvironmentFactory.toUniqueID(execEnv);
        boolean stored = NbPreferences.forModule(PasswordManager.class).getBoolean(STORE_PREFIX + key, false);
        return stored;
    }

    public void setRememberPassword(ExecutionEnvironment execEnv, boolean rememberPassword) {
        String key = ExecutionEnvironmentFactory.toUniqueID(execEnv);
        if (!rememberPassword && this.keyringIsActivated) {
            Keyring.delete((String)(KEY_PREFIX + key));
        }
        NbPreferences.forModule(PasswordManager.class).putBoolean(STORE_PREFIX + key, rememberPassword);
    }

    static {
        instance = new PasswordManager();
        keepPasswordsInMemory = !Boolean.getBoolean("remote.user.password.do_not_keep_in_memory");
    }
}

