/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibrary;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibraryDependency;
import org.netbeans.modules.j2ee.deployment.plugins.spi.ServerLibraryFactory;
import org.netbeans.modules.j2ee.deployment.plugins.spi.ServerLibraryImplementation;
import org.netbeans.modules.j2ee.deployment.plugins.spi.ServerLibraryManager;
import org.netbeans.modules.j2ee.weblogic9.ProgressObjectSupport;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.config.WLDatasourceManager;
import org.netbeans.modules.j2ee.weblogic9.config.WLServerLibrarySupport;
import org.netbeans.modules.j2ee.weblogic9.deploy.CommandBasedDeployer;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.openide.util.NbBundle;

public class WLServerLibraryManager
implements ServerLibraryManager {
    private static final Logger LOGGER = Logger.getLogger(WLServerLibraryManager.class.getName());
    private static final String DWP_JSF_SPEC_TITLE = "JavaServer Faces";
    private static final Version DWP_JSF_SPEC_VERSION = Version.fromJsr277OrDottedNotationWithFallback((String)"2.0");
    private final WLDeploymentManager manager;
    private final WLServerLibrarySupport support;

    public WLServerLibraryManager(WLDeploymentManager manager) {
        this.manager = manager;
        String domainDir = manager.getInstanceProperties().getProperty("domainRoot");
        assert (domainDir != null);
        String serverDir = manager.getInstanceProperties().getProperty("serverRoot");
        assert (serverDir != null);
        this.support = new WLServerLibrarySupport(new File(serverDir), new File(domainDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployLibraries(Set<ServerLibraryDependency> libraries) throws ConfigurationException {
        Set<ServerLibraryDependency> notHandled = this.filterDeployed(libraries);
        HashSet<File> toDeploy = new HashSet<File>();
        Map<ServerLibrary, File> deployable = this.support.getDeployableFiles();
        Iterator<ServerLibraryDependency> it = notHandled.iterator();
        block3: while (it.hasNext()) {
            ServerLibraryDependency range = it.next();
            for (Map.Entry<ServerLibrary, File> entry : deployable.entrySet()) {
                if (!range.versionMatches(entry.getKey())) continue;
                it.remove();
                toDeploy.add(entry.getValue());
                continue block3;
            }
        }
        if (!notHandled.isEmpty()) {
            throw new ConfigurationException(NbBundle.getMessage(WLServerLibraryManager.class, (String)"MSG_DidNotFindServerLibraries"));
        }
        try {
            this.deployFiles(toDeploy);
        }
        finally {
            WLPluginProperties.getDomainConfigFileObject(this.manager).refresh();
        }
    }

    public Set<ServerLibrary> getDeployableLibraries() {
        if (this.manager.isWebProfile()) {
            Map<ServerLibrary, File> deployable = this.support.getDeployableFiles();
            Iterator<Map.Entry<ServerLibrary, File>> it = deployable.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ServerLibrary, File> entry = it.next();
                ServerLibrary lib = entry.getKey();
                if (!DWP_JSF_SPEC_TITLE.equals(lib.getSpecificationTitle()) || !DWP_JSF_SPEC_VERSION.equals((Object)lib.getSpecificationVersion()) || entry.getValue().length() >= 10240L) continue;
                it.remove();
                break;
            }
            return deployable.keySet();
        }
        return this.support.getDeployableFiles().keySet();
    }

    public Set<ServerLibrary> getDeployedLibraries() {
        HashSet<ServerLibrary> result = new HashSet<ServerLibrary>();
        for (WLServerLibrarySupport.WLServerLibrary lib : this.support.getDeployedLibraries()) {
            result.add(ServerLibraryFactory.createServerLibrary((ServerLibraryImplementation)lib));
        }
        return result;
    }

    public Set<ServerLibraryDependency> getDeployableDependencies(Set<ServerLibraryDependency> libraries) {
        Set<ServerLibraryDependency> notHandled = this.filterDeployed(libraries);
        HashSet<ServerLibraryDependency> result = new HashSet<ServerLibraryDependency>();
        Map<ServerLibrary, File> deployable = this.support.getDeployableFiles();
        block0: for (ServerLibraryDependency range : notHandled) {
            for (Map.Entry<ServerLibrary, File> entry : deployable.entrySet()) {
                if (!range.versionMatches(entry.getKey())) continue;
                result.add(range);
                continue block0;
            }
        }
        return result;
    }

    public Set<ServerLibraryDependency> getMissingDependencies(Set<ServerLibraryDependency> libraries) {
        Set<ServerLibraryDependency> notHandled = this.filterDeployed(libraries);
        Map<ServerLibrary, File> deployable = this.support.getDeployableFiles();
        Iterator<ServerLibraryDependency> it = notHandled.iterator();
        block0: while (it.hasNext()) {
            ServerLibraryDependency range = it.next();
            for (Map.Entry<ServerLibrary, File> entry : deployable.entrySet()) {
                if (!range.versionMatches(entry.getKey())) continue;
                it.remove();
                continue block0;
            }
        }
        return notHandled;
    }

    private void deployFiles(Set<File> libraries) throws ConfigurationException {
        CommandBasedDeployer deployer = new CommandBasedDeployer(this.manager);
        ProgressObject po = deployer.deployLibraries(libraries);
        ProgressObjectSupport.waitFor(po);
        if (po.getDeploymentStatus().isFailed()) {
            String msg = NbBundle.getMessage(WLDatasourceManager.class, (String)"MSG_FailedToDeployLibrary");
            throw new ConfigurationException(msg);
        }
    }

    private Set<ServerLibraryDependency> filterDeployed(Set<ServerLibraryDependency> libraries) {
        HashSet<ServerLibraryDependency> notHandled = new HashSet<ServerLibraryDependency>(libraries);
        Set<ServerLibrary> deployed = this.getDeployedLibraries();
        block0: for (ServerLibraryDependency range : libraries) {
            for (ServerLibrary lib : deployed) {
                if (!range.versionMatches(lib)) continue;
                notHandled.remove(range);
                continue block0;
            }
        }
        return notHandled;
    }
}

