/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.dd.model;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibraryDependency;
import org.netbeans.modules.j2ee.weblogic9.dd.model.BaseDescriptorModel;
import org.netbeans.modules.j2ee.weblogic9.dd.model.JspDescriptorType;
import org.netbeans.modules.j2ee.weblogic9.dd.model.LibraryRefType;
import org.netbeans.modules.j2ee.weblogic9.dd.model.ResourceDescriptionType;
import org.netbeans.modules.j2ee.weblogic9.dd.model.WeblogicWebApp;
import org.netbeans.modules.j2ee.weblogic9.dd.web1031.FastSwapType;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.NullEntityResolver;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public final class WebApplicationModel
extends BaseDescriptorModel {
    private final WeblogicWebApp bean;

    private WebApplicationModel(WeblogicWebApp bean) {
        super(bean);
        this.bean = bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebApplicationModel forFile(File file) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        try {
            WebApplicationModel webApplicationModel = WebApplicationModel.forInputStream(is);
            return webApplicationModel;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public static WebApplicationModel forInputStream(InputStream is) throws IOException {
        Document doc;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((EntityResolver)NullEntityResolver.newInstance());
            doc = builder.parse(is);
        }
        catch (SAXException ex) {
            throw new RuntimeException(NbBundle.getMessage(WebApplicationModel.class, (String)"MSG_CantCreateXMLDOMDocument"), ex);
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(NbBundle.getMessage(WebApplicationModel.class, (String)"MSG_CantCreateXMLDOMDocument"), ex);
        }
        String ns = doc.getDocumentElement().getNamespaceURI();
        if ("http://xmlns.oracle.com/weblogic/weblogic-web-app".equals(ns)) {
            return new WebApplicationModel(org.netbeans.modules.j2ee.weblogic9.dd.web1031.WeblogicWebApp.createGraph(doc));
        }
        if ("http://www.bea.com/ns/weblogic/weblogic-web-app".equals(ns)) {
            return new WebApplicationModel(org.netbeans.modules.j2ee.weblogic9.dd.web1030.WeblogicWebApp.createGraph(doc));
        }
        return new WebApplicationModel(org.netbeans.modules.j2ee.weblogic9.dd.web90.WeblogicWebApp.createGraph(doc));
    }

    public static WebApplicationModel generate(@NullAllowed Version serverVersion) {
        if (serverVersion != null) {
            if (serverVersion.isAboveOrEqual(VERSION_10_3_1)) {
                return WebApplicationModel.generate1031();
            }
            if (serverVersion.isAboveOrEqual(VERSION_10_3_0)) {
                return WebApplicationModel.generate1030();
            }
        }
        return WebApplicationModel.generate90();
    }

    private static WebApplicationModel generate90() {
        org.netbeans.modules.j2ee.weblogic9.dd.web90.WeblogicWebApp webLogicWebApp = new org.netbeans.modules.j2ee.weblogic9.dd.web90.WeblogicWebApp();
        webLogicWebApp.createAttribute("xmlns:j2ee", "xmlns:j2ee", 513, null, null);
        webLogicWebApp.setAttributeValue("xmlns:j2ee", "http://java.sun.com/xml/ns/j2ee");
        webLogicWebApp.setAttributeValue("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        webLogicWebApp.setAttributeValue("xsi:schemaLocation", "http://www.bea.com/ns/weblogic/90 http://www.bea.com/ns/weblogic/90/weblogic-web-app.xsd");
        return new WebApplicationModel(webLogicWebApp);
    }

    private static WebApplicationModel generate1030() {
        org.netbeans.modules.j2ee.weblogic9.dd.web1030.WeblogicWebApp webLogicWebApp = new org.netbeans.modules.j2ee.weblogic9.dd.web1030.WeblogicWebApp();
        webLogicWebApp.setAttributeValue("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        webLogicWebApp.setAttributeValue("xsi:schemaLocation", "http://www.bea.com/ns/weblogic/weblogic-web-app http://www.bea.com/ns/weblogic/weblogic-web-app/1.0/weblogic-web-app.xsd");
        return new WebApplicationModel(webLogicWebApp);
    }

    private static WebApplicationModel generate1031() {
        org.netbeans.modules.j2ee.weblogic9.dd.web1031.WeblogicWebApp webLogicWebApp = new org.netbeans.modules.j2ee.weblogic9.dd.web1031.WeblogicWebApp();
        webLogicWebApp.setAttributeValue("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        webLogicWebApp.setAttributeValue("xsi:schemaLocation", "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd http://xmlns.oracle.com/weblogic/weblogic-web-app http://xmlns.oracle.com/weblogic/weblogic-web-app/1.0/weblogic-web-app.xsd");
        return new WebApplicationModel(webLogicWebApp);
    }

    @CheckForNull
    public String getContextRoot() {
        String[] roots = this.bean.getContextRoot();
        if (roots == null || roots.length < 1) {
            return null;
        }
        return roots[0];
    }

    public void setContextRoot(String root) {
        this.bean.setContextRoot(new String[]{root});
    }

    public void setReference(String referenceName, String jndiName) {
        for (ResourceDescriptionType type : this.bean.getResourceDescription()) {
            String refName = type.getResRefName();
            if (!referenceName.equals(refName)) continue;
            type.setJndiName(jndiName);
            return;
        }
        BaseBean type = null;
        type = this.bean instanceof org.netbeans.modules.j2ee.weblogic9.dd.web1031.WeblogicWebApp ? new org.netbeans.modules.j2ee.weblogic9.dd.web1031.ResourceDescriptionType() : (this.bean instanceof org.netbeans.modules.j2ee.weblogic9.dd.web1030.WeblogicWebApp ? new org.netbeans.modules.j2ee.weblogic9.dd.web1030.ResourceDescriptionType() : new org.netbeans.modules.j2ee.weblogic9.dd.web90.ResourceDescriptionType());
        type.setResRefName(referenceName);
        type.setJndiName(jndiName);
        this.bean.addResourceDescription((ResourceDescriptionType)type);
    }

    public String getReferenceJndiName(String referenceName) {
        for (ResourceDescriptionType type : this.bean.getResourceDescription()) {
            String refName = type.getResRefName();
            if (!referenceName.equals(refName)) continue;
            return type.getJndiName();
        }
        return null;
    }

    public Set<ServerLibraryDependency> getLibraries() {
        HashSet<ServerLibraryDependency> ranges = new HashSet<ServerLibraryDependency>();
        for (LibraryRefType libRef : this.bean.getLibraryRef()) {
            ranges.add(this.getLibrary(libRef));
        }
        return ranges;
    }

    public void addLibrary(ServerLibraryDependency library) {
        LibraryRefType[] current;
        for (LibraryRefType libRef : current = this.bean.getLibraryRef()) {
            ServerLibraryDependency lib = this.getLibrary(libRef);
            if (!library.equals((Object)lib)) continue;
            return;
        }
        BaseBean[] libRef = null;
        if (this.bean instanceof org.netbeans.modules.j2ee.weblogic9.dd.web1031.WeblogicWebApp) {
            libRef = new org.netbeans.modules.j2ee.weblogic9.dd.web1031.LibraryRefType[current.length + 1];
            libRef[0] = new org.netbeans.modules.j2ee.weblogic9.dd.web1031.LibraryRefType();
        } else if (this.bean instanceof org.netbeans.modules.j2ee.weblogic9.dd.web1030.WeblogicWebApp) {
            libRef = new org.netbeans.modules.j2ee.weblogic9.dd.web1030.LibraryRefType[current.length + 1];
            libRef[0] = new org.netbeans.modules.j2ee.weblogic9.dd.web1030.LibraryRefType();
        } else {
            libRef = new org.netbeans.modules.j2ee.weblogic9.dd.web90.LibraryRefType[current.length + 1];
            libRef[0] = new org.netbeans.modules.j2ee.weblogic9.dd.web90.LibraryRefType();
        }
        BaseBean single = libRef[0];
        single.setLibraryName(library.getName());
        if (library.isExactMatch()) {
            single.setExactMatch(library.isExactMatch());
        }
        if (library.getSpecificationVersion() != null) {
            single.setSpecificationVersion(library.getSpecificationVersion().toString());
        }
        if (library.getImplementationVersion() != null) {
            single.setImplementationVersion(library.getImplementationVersion().toString());
        }
        System.arraycopy(current, 0, libRef, 1, current.length);
        this.bean.setLibraryRef((LibraryRefType[])libRef);
    }

    public void setKeepJspGenerated(boolean keep) {
        JspDescriptorType[] desc;
        for (JspDescriptorType type : desc = this.getJspDescriptor()) {
            type.setKeepgenerated(keep);
        }
        this.bean.setJspDescriptor(desc);
    }

    public void setDebug(boolean debug) {
        JspDescriptorType[] desc;
        for (JspDescriptorType type : desc = this.getJspDescriptor()) {
            type.setDebug(debug);
        }
        this.bean.setJspDescriptor(desc);
    }

    public void setFastSwap(boolean fast) {
        if (this.bean instanceof org.netbeans.modules.j2ee.weblogic9.dd.web1031.WeblogicWebApp) {
            FastSwapType fastSwap = new FastSwapType();
            fastSwap.setEnabled(fast);
            ((org.netbeans.modules.j2ee.weblogic9.dd.web1031.WeblogicWebApp)this.bean).setFastSwap(fastSwap);
        }
    }

    private JspDescriptorType[] getJspDescriptor() {
        JspDescriptorType[] jspDescriptor = this.bean.getJspDescriptor();
        if (jspDescriptor != null && jspDescriptor.length > 0) {
            return jspDescriptor;
        }
        jspDescriptor = this.bean instanceof org.netbeans.modules.j2ee.weblogic9.dd.web1031.WeblogicWebApp ? new org.netbeans.modules.j2ee.weblogic9.dd.web1031.JspDescriptorType[]{new org.netbeans.modules.j2ee.weblogic9.dd.web1031.JspDescriptorType()} : (this.bean instanceof org.netbeans.modules.j2ee.weblogic9.dd.web1030.WeblogicWebApp ? new org.netbeans.modules.j2ee.weblogic9.dd.web1030.JspDescriptorType[]{new org.netbeans.modules.j2ee.weblogic9.dd.web1030.JspDescriptorType()} : new org.netbeans.modules.j2ee.weblogic9.dd.web90.JspDescriptorType[]{new org.netbeans.modules.j2ee.weblogic9.dd.web90.JspDescriptorType()});
        return jspDescriptor;
    }

    private ServerLibraryDependency getLibrary(LibraryRefType libRef) {
        Version impl;
        String name = libRef.getLibraryName();
        String specVersionString = libRef.getSpecificationVersion();
        String implVersionString = libRef.getImplementationVersion();
        boolean exactMatch = libRef.isExactMatch();
        Version spec = specVersionString == null ? null : Version.fromJsr277NotationWithFallback((String)specVersionString);
        Version version = impl = implVersionString == null ? null : Version.fromJsr277NotationWithFallback((String)implVersionString);
        if (exactMatch) {
            return ServerLibraryDependency.exactVersion((String)name, (Version)spec, (Version)impl);
        }
        return ServerLibraryDependency.minimalVersion((String)name, (Version)spec, (Version)impl);
    }
}

