/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.deploy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.netbeans.modules.j2ee.weblogic9.WLConnectionSupport;
import org.netbeans.modules.j2ee.weblogic9.deploy.AbstractDeployer;
import org.netbeans.modules.j2ee.weblogic9.deploy.CommandBasedDeployer;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentStatus;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLProgressObject;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLTargetModuleID;
import org.openide.util.NbBundle;

public final class WebProfileDeployer
extends AbstractDeployer {
    private static final Logger LOGGER = Logger.getLogger(WebProfileDeployer.class.getName());

    public WebProfileDeployer(WLDeploymentManager deploymentManager) {
        super(deploymentManager);
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleID) {
        final HashMap<String, TargetModuleID> toRedeploy = new HashMap<String, TargetModuleID>();
        for (TargetModuleID moduleId : targetModuleID) {
            toRedeploy.put(moduleId.getModuleID(), moduleId);
        }
        final WLProgressObject progress = new WLProgressObject(targetModuleID);
        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeployment_Started")));
        DEPLOYMENT_RP.submit(new Runnable(){

            @Override
            public void run() {
                WLConnectionSupport support = new WLConnectionSupport(WebProfileDeployer.this.getDeploymentManager());
                try {
                    support.executeAction(new WLConnectionSupport.JMXAction<Void>(){

                        @Override
                        public Void call(MBeanServerConnection connection) throws Exception {
                            Set<ObjectName> mgr = connection.queryNames(new ObjectName("com.bea:Name=DeploymentManager,Type=DeploymentManager,*"), null);
                            Iterator<ObjectName> mgrIt = mgr.iterator();
                            if (!mgrIt.hasNext()) {
                                return null;
                            }
                            ObjectName jmxManager = mgrIt.next();
                            ObjectName[] appDeploymentRuntimes = (ObjectName[])connection.getAttribute(jmxManager, "AppDeploymentRuntimes");
                            if (appDeploymentRuntimes != null) {
                                boolean failed = false;
                                for (ObjectName app : appDeploymentRuntimes) {
                                    String name = (String)connection.getAttribute(app, "Name");
                                    TargetModuleID module = (TargetModuleID)toRedeploy.remove(name);
                                    if (module == null) continue;
                                    progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeploying", (Object)name)));
                                    ObjectName progressMBean = (ObjectName)connection.invoke(app, "redeploy", null, null);
                                    try {
                                        if (WebProfileDeployer.waitForCompletion(connection, progressMBean)) continue;
                                        failed = true;
                                        progress.fireProgressEvent(module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeployment_Failed", (Object)WebProfileDeployer.getLastMessage(connection, progressMBean))));
                                    }
                                    catch (InterruptedException ex) {
                                        failed = true;
                                        progress.fireProgressEvent(module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeployment_Failed_Interrupted")));
                                        WebProfileDeployer.cancel(connection, progressMBean);
                                        Thread.currentThread().interrupt();
                                    }
                                    catch (TimeoutException ex) {
                                        failed = true;
                                        progress.fireProgressEvent(module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeployment_Failed_Timeout")));
                                        WebProfileDeployer.cancel(connection, progressMBean);
                                    }
                                    catch (MBeanException ex) {
                                        failed = true;
                                        progress.fireProgressEvent(module, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeployment_Failed_With_Message", (Object)ex.getLocalizedMessage())));
                                        WebProfileDeployer.cancel(connection, progressMBean);
                                    }
                                    break;
                                }
                                if (!failed) {
                                    if (toRedeploy.isEmpty()) {
                                        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.COMPLETED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeployment_Completed")));
                                    } else {
                                        progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeployment_Failed_Modules")));
                                    }
                                }
                            }
                            return null;
                        }

                        @Override
                        public String getPath() {
                            return null;
                        }
                    });
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    progress.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(CommandBasedDeployer.class, (String)"MSG_Redeployment_Failed", (Object)ex.getLocalizedMessage())));
                }
            }
        });
        return progress;
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targets) {
        Set<TargetModuleID> result = this.getAvailableModules(targets, moduleType).keySet();
        return result.toArray(new TargetModuleID[result.size()]);
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targets) {
        return this.getFilteredModules(moduleType, targets, "STATE_ACTIVE", false);
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targets) {
        return this.getFilteredModules(moduleType, targets, "STATE_ACTIVE", true);
    }

    private TargetModuleID[] getFilteredModules(ModuleType moduleType, Target[] targets, String filter, boolean inverted) {
        ArrayList<TargetModuleID> result = new ArrayList<TargetModuleID>();
        for (Map.Entry<TargetModuleID, String> entry : this.getAvailableModules(targets, moduleType).entrySet()) {
            if (inverted) {
                if (filter.equals(entry.getValue())) continue;
                result.add(entry.getKey());
                continue;
            }
            if (!filter.equals(entry.getValue())) continue;
            result.add(entry.getKey());
        }
        return result.toArray(new TargetModuleID[result.size()]);
    }

    private Map<TargetModuleID, String> getAvailableModules(final Target[] targets, ModuleType moduleType) {
        if (!ModuleType.WAR.equals(moduleType)) {
            return Collections.emptyMap();
        }
        WLConnectionSupport support = new WLConnectionSupport(this.getDeploymentManager());
        try {
            Map<TargetModuleID, String> result = support.executeAction(new WLConnectionSupport.JMXAction<Map<TargetModuleID, String>>(){

                @Override
                public Map<TargetModuleID, String> call(MBeanServerConnection connection) throws Exception {
                    Set<ObjectName> mgr = connection.queryNames(new ObjectName("com.bea:Name=DeploymentManager,Type=DeploymentManager,*"), null);
                    Iterator<ObjectName> mgrIt = mgr.iterator();
                    if (!mgrIt.hasNext()) {
                        return Collections.emptyMap();
                    }
                    HashMap<TargetModuleID, String> result = new HashMap<TargetModuleID, String>();
                    ObjectName jmxManager = mgrIt.next();
                    ObjectName[] appDeploymentRuntimes = (ObjectName[])connection.getAttribute(jmxManager, "AppDeploymentRuntimes");
                    if (appDeploymentRuntimes != null) {
                        for (ObjectName app : appDeploymentRuntimes) {
                            String name = (String)connection.getAttribute(app, "Name");
                            for (Target target : targets) {
                                String state = (String)connection.invoke(app, "getState", new Object[]{target.getName()}, new String[]{"java.lang.String"});
                                WLTargetModuleID module = new WLTargetModuleID(target, name);
                                ObjectName appRuntime = new ObjectName("com.bea:ServerRuntime=" + target.getName() + ",Name=" + name + ",Type=ApplicationRuntime");
                                ObjectName[] componentRuntimes = (ObjectName[])connection.getAttribute(appRuntime, "ComponentRuntimes");
                                boolean isApp = false;
                                for (ObjectName n : componentRuntimes) {
                                    String type = (String)connection.getAttribute(n, "Type");
                                    if (!"WebAppComponentRuntime".equals(type)) continue;
                                    isApp = true;
                                    String root = (String)connection.getAttribute(n, "ContextRoot");
                                    if (root == null) continue;
                                    module.setContextURL("http://" + WebProfileDeployer.this.getDeploymentManager().getHost() + ":" + WebProfileDeployer.this.getDeploymentManager().getPort() + root);
                                    break;
                                }
                                if (!isApp) continue;
                                result.put(module, state);
                            }
                        }
                    }
                    return result;
                }

                @Override
                public String getPath() {
                    return null;
                }
            });
            return result;
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, null, ex);
            return Collections.emptyMap();
        }
    }

    private static boolean waitForCompletion(MBeanServerConnection connection, ObjectName progressMBean) throws TimeoutException, InterruptedException, MBeanException {
        String state = null;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 300000L) {
            try {
                state = (String)connection.getAttribute(progressMBean, "State");
                if ("STATE_COMPLETED".equals(state)) {
                    return true;
                }
                if ("STATE_FAILED".equals(state)) {
                    return false;
                }
                Thread.sleep(100L);
            }
            catch (AttributeNotFoundException ex) {
                throw new MBeanException(ex);
            }
            catch (InstanceNotFoundException ex) {
                throw new MBeanException(ex);
            }
            catch (ReflectionException ex) {
                throw new MBeanException(ex);
            }
            catch (IOException ex) {
                throw new MBeanException(ex);
            }
        }
        throw new TimeoutException();
    }

    private static String getLastMessage(MBeanServerConnection connection, ObjectName progressMBean) {
        try {
            String[] messages = (String[])connection.getAttribute(progressMBean, "Messages");
            if (messages.length > 0) {
                return messages[messages.length];
            }
        }
        catch (MBeanException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (AttributeNotFoundException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (InstanceNotFoundException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (ReflectionException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        return "";
    }

    private static void cancel(MBeanServerConnection connection, ObjectName progressMBean) {
        try {
            connection.invoke(progressMBean, "cancel", null, null);
        }
        catch (InstanceNotFoundException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (MBeanException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (ReflectionException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
    }
}

