/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.nodes;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.j2ee.weblogic9.WLConnectionSupport;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.JdbcChildrenFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WebProfileJdbRetriever
implements JdbcChildrenFactory.Retriever {
    private static final Logger LOGGER = Logger.getLogger(WebProfileJdbRetriever.class.getName());
    private static final Integer JDBC = 4;
    private final AtomicReference<List<JdbcChildrenFactory.JDBCDataBean>> data = new AtomicReference();
    private final Lookup lookup;
    private boolean isRetrieveStarted;

    public WebProfileJdbRetriever(Lookup lookup) {
        this.lookup = lookup;
    }

    @Override
    public void clean() {
        this.data.set(null);
    }

    @Override
    public List<JdbcChildrenFactory.JDBCDataBean> get() {
        return this.data.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retrieve() {
        WebProfileJdbRetriever webProfileJdbRetriever = this;
        synchronized (webProfileJdbRetriever) {
            if (this.isRetrieveStarted) {
                return;
            }
            this.isRetrieveStarted = true;
        }
        this.data.set(null);
        WLDeploymentManager manager = (WLDeploymentManager)this.lookup.lookup(WLDeploymentManager.class);
        WLConnectionSupport support = new WLConnectionSupport(manager);
        List<Object> list = Collections.emptyList();
        try {
            list = support.executeAction(new WLConnectionSupport.JMXAction<List<JdbcChildrenFactory.JDBCDataBean>>(){

                @Override
                public List<JdbcChildrenFactory.JDBCDataBean> call(MBeanServerConnection con) throws Exception {
                    LinkedList<JdbcChildrenFactory.JDBCDataBean> list = new LinkedList<JdbcChildrenFactory.JDBCDataBean>();
                    Set<ObjectName> servers = con.queryNames(new ObjectName("com.bea:Name=*,Type=ServerRuntime"), null);
                    HashSet<String> adminNames = new HashSet<String>();
                    for (ObjectName adminServer : servers) {
                        adminNames.add(con.getAttribute(adminServer, "Name").toString());
                    }
                    Set<ObjectName> domain = con.queryNames(new ObjectName("com.bea:Name=*,Type=Domain"), null);
                    if (domain.isEmpty()) {
                        return Collections.emptyList();
                    }
                    ObjectName config = domain.iterator().next();
                    this.findSystemJdbc(con, list, adminNames, config);
                    this.findDeployedJdbc(con, list, adminNames, config);
                    return list;
                }

                @Override
                public String getPath() {
                    return "";
                }

                private void findDeployedJdbc(MBeanServerConnection con, List<JdbcChildrenFactory.JDBCDataBean> list, Set<String> adminNames, ObjectName config) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException, MalformedObjectNameException {
                    ObjectName[] applications;
                    for (ObjectName application : applications = (ObjectName[])con.getAttribute(config, "Applications")) {
                        Integer type = (Integer)con.getAttribute(application, "InternalType");
                        if (!JDBC.equals(type)) continue;
                        String path = (String)con.getAttribute(application, "FullPath");
                        String name = (String)con.getAttribute(application, "Name");
                        if (path == null) continue;
                        WebProfileJdbRetriever.this.loadDeployedDataSource(path, list, name);
                    }
                }

                private void findSystemJdbc(MBeanServerConnection con, List<JdbcChildrenFactory.JDBCDataBean> list, Set<String> adminNames, ObjectName objectName) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
                }
            });
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, null, e);
        }
        finally {
            this.data.compareAndSet(null, list);
            WebProfileJdbRetriever webProfileJdbRetriever2 = this;
            synchronized (webProfileJdbRetriever2) {
                this.isRetrieveStarted = false;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForCompletion() {
        WebProfileJdbRetriever webProfileJdbRetriever = this;
        synchronized (webProfileJdbRetriever) {
            while (this.isRetrieveStarted) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.FINE, null, e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private void loadDeployedDataSource(String path, List<JdbcChildrenFactory.JDBCDataBean> list, String deplName) {
        try {
            if (!path.endsWith(".xml")) {
                return;
            }
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            JdbcConfigHandler handler = new JdbcConfigHandler();
            FileObject jdbcConfig = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(path)));
            parser.parse((InputStream)new BufferedInputStream(jdbcConfig.getInputStream()), (DefaultHandler)handler);
            List<String> jndiNames = handler.getJndiNames();
            list.add(new JdbcChildrenFactory.JDBCDataBean(handler.getName(), jndiNames.toArray(new String[jndiNames.size()]), deplName));
        }
        catch (ParserConfigurationException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        catch (SAXException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, null, e);
        }
    }

    private static class JdbcConfigHandler
    extends DefaultHandler {
        private static final String DATA_SOURCE_PARAMS = "jdbc-data-source-params";
        private final List<String> jndiNames = new LinkedList<String>();
        private String content;
        private String name;
        private boolean dataSourceParamsStarted;

        private JdbcConfigHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.content = null;
            if (DATA_SOURCE_PARAMS.equals(this.getUnprefixedName(qName))) {
                this.dataSourceParamsStarted = true;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.name == null && "name".equals(this.getUnprefixedName(qName))) {
                this.name = this.content;
            } else if (DATA_SOURCE_PARAMS.equals(this.getUnprefixedName(qName))) {
                this.dataSourceParamsStarted = false;
            } else if (this.dataSourceParamsStarted && "jndi-name".equals(this.getUnprefixedName(qName))) {
                this.jndiNames.add(this.content);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.content = new String(ch, start, length);
        }

        String getName() {
            return this.name;
        }

        List<String> getJndiNames() {
            return this.jndiNames;
        }

        private String getUnprefixedName(String name) {
            if (name.contains(":")) {
                return name.substring(name.indexOf(":") + 1);
            }
            return name;
        }
    }
}

