/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.nodes;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.netbeans.modules.j2ee.weblogic9.WLConnectionSupport;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.ResourceNode;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions.RefreshModulesCookie;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class WebProfileLibrariesChildrenFactory
extends ChildFactory<ResourceNode>
implements RefreshModulesCookie {
    private static final Logger LOGGER = Logger.getLogger(WebProfileLibrariesChildrenFactory.class.getName());
    private final Lookup lookup;

    WebProfileLibrariesChildrenFactory(Lookup lookup) {
        this.lookup = lookup;
    }

    @Override
    public void refresh() {
        this.refresh(false);
    }

    protected boolean createKeys(List<ResourceNode> nodes) {
        WLDeploymentManager manager = (WLDeploymentManager)this.lookup.lookup(WLDeploymentManager.class);
        WLConnectionSupport support = new WLConnectionSupport(manager);
        try {
            Set<String> libraries = support.executeAction(new WLConnectionSupport.JMXAction<Set<String>>(){

                @Override
                public Set<String> call(MBeanServerConnection connection) throws Exception {
                    HashSet<String> result = new HashSet<String>();
                    Set<ObjectName> mgr = connection.queryNames(new ObjectName("com.bea:Name=DeploymentManager,Type=DeploymentManager,*"), null);
                    Iterator<ObjectName> mgrIt = mgr.iterator();
                    if (!mgrIt.hasNext()) {
                        return Collections.emptySet();
                    }
                    ObjectName jmxManager = mgrIt.next();
                    ObjectName[] libDeploymentRuntimes = (ObjectName[])connection.getAttribute(jmxManager, "LibDeploymentRuntimes");
                    if (libDeploymentRuntimes != null) {
                        for (ObjectName lib : libDeploymentRuntimes) {
                            result.add((String)connection.getAttribute(lib, "Name"));
                        }
                    }
                    return result;
                }

                @Override
                public String getPath() {
                    return "";
                }
            });
            for (String name : libraries) {
                nodes.add(new ResourceNode(Children.LEAF, ResourceNode.ResourceNodeType.LIBRARY, name, (String)null));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, null, e);
        }
        return true;
    }

    protected Node createNodeForKey(ResourceNode key) {
        return key;
    }
}

