/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.ui.wizard.ServerLocationPanel;
import org.netbeans.modules.j2ee.weblogic9.ui.wizard.ServerPropertiesPanel;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class WLInstantiatingIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final String PROP_DISPLAY_NAME = "ServInstWizard_displayName";
    public static final String DEFAULT_DEBUGGER_PORT = "8787";
    public static final String DEFAULT_MAC_MEM_OPTS = "-Xmx1024m -XX:PermSize=256m";
    public static final String DEFAULT_DWP_MEM_OPTS = "-Xmx512m -XX:PermSize=128m";
    private WizardDescriptor wizardDescriptor;
    private String serverRoot;
    private String domainRoot;
    private String username;
    private String password;
    private String url;
    private String domainName;
    private String port;
    private String host;
    private Version serverVersion;
    private String[] steps = new String[]{NbBundle.getMessage(ServerPropertiesPanel.class, (String)"SERVER_LOCATION_STEP"), NbBundle.getMessage(ServerPropertiesPanel.class, (String)"SERVER_PROPERTIES_STEP")};
    private WizardDescriptor.Panel[] panels;
    private ServerLocationPanel serverLocationPanel;
    private ServerPropertiesPanel serverPropertiesPanel;
    private int index = 0;
    private Vector listeners = new Vector();

    public void uninitialize(WizardDescriptor wizardDescriptor) {
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
        for (int i = 0; i < this.getPanels().length; ++i) {
            Component c = this.panels[i].getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", this.steps);
        }
    }

    public String name() {
        return "";
    }

    public Set instantiate() throws IOException {
        HashSet<InstanceProperties> result = new HashSet<InstanceProperties>();
        String displayName = (String)this.wizardDescriptor.getProperty(PROP_DISPLAY_NAME);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("serverRoot", this.serverRoot);
        props.put("domainRoot", this.domainRoot);
        props.put("debuggerPort", DEFAULT_DEBUGGER_PORT);
        props.put("domainName", this.domainName);
        props.put("port", this.port);
        props.put("host", this.host);
        props.put("remote", Boolean.FALSE.toString());
        boolean isWebProfile = WLPluginProperties.isWebProfile(new File(this.serverRoot));
        if (Utilities.isMac() && !isWebProfile) {
            props.put("mem_opts", DEFAULT_MAC_MEM_OPTS);
        } else if ((Utilities.isUnix() || Utilities.isMac()) && isWebProfile) {
            props.put("mem_opts", DEFAULT_DWP_MEM_OPTS);
        }
        InstanceProperties ip = InstanceProperties.createInstanceProperties((String)this.url, (String)this.username, (String)this.password, (String)displayName, props);
        result.add(ip);
        return result;
    }

    static String decorateMessage(String message) {
        return message == null ? null : "<html>" + message.replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</html>";
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setDomainName(String name) {
        this.domainName = name;
    }

    public void setServerRoot(String serverRoot) {
        this.serverRoot = serverRoot;
        this.serverPropertiesPanel.getVisual().updateInstancesList();
        this.serverPropertiesPanel.getVisual().updateJpa2Button();
    }

    public String getServerRoot() {
        return this.serverRoot;
    }

    public String getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainRoot(String domainRoot) {
        this.domainRoot = domainRoot;
    }

    public String getDomainRoot() {
        return this.domainRoot;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Version getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(Version serverVersion) {
        this.serverVersion = serverVersion;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public WizardDescriptor.Panel current() {
        this.getPanels();
        return this.panels[this.index];
    }

    protected final WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = this.createPanels();
        }
        return this.panels;
    }

    protected WizardDescriptor.Panel[] createPanels() {
        this.serverLocationPanel = new ServerLocationPanel(this);
        this.serverPropertiesPanel = new ServerPropertiesPanel(this);
        return new WizardDescriptor.Panel[]{this.serverLocationPanel, this.serverPropertiesPanel};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener listener) {
        if (this.listeners != null) {
            Vector vector = this.listeners;
            synchronized (vector) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener listener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent(ChangeEvent event) {
        Vector targetListeners;
        Vector vector = this.listeners;
        synchronized (vector) {
            targetListeners = (Vector)this.listeners.clone();
        }
        for (int i = 0; i < targetListeners.size(); ++i) {
            ChangeListener listener = (ChangeListener)targetListeners.elementAt(i);
            listener.stateChanged(event);
        }
    }

    private class IteratorListener
    implements ChangeListener {
        private IteratorListener() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            WLInstantiatingIterator.this.fireChangeEvent(event);
        }
    }
}

