/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.modules.tasklist.impl.TaskComparator;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.modules.tasklist.trampoline.TaskGroup;
import org.netbeans.modules.tasklist.ui.Settings;
import org.netbeans.modules.tasklist.ui.TaskListModel;
import org.netbeans.spi.tasklist.Task;

class FoldingTaskListModel
extends TaskListModel {
    private final LinkedList<FoldingGroup> groups = new LinkedList();
    private HashMap<String, FoldingGroup> groupMap = new HashMap(10);

    public FoldingTaskListModel(TaskList taskList) {
        super(taskList);
        this.sortTaskList();
        this.tasksAdded(taskList.getTasks());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        if (null == this.list) {
            return 0;
        }
        int count = 0;
        LinkedList<FoldingGroup> linkedList = this.groups;
        synchronized (linkedList) {
            for (FoldingGroup g : this.groups) {
                count += g.getRowCount();
            }
        }
        return count;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (0 == column) {
            return FoldingGroup.class;
        }
        return super.getColumnClass(column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Task getTaskAtRow(int row) {
        if (this.isGroupRow(row)) {
            return null;
        }
        int groupRow = 0;
        LinkedList<FoldingGroup> linkedList = this.groups;
        synchronized (linkedList) {
            for (FoldingGroup g : this.groups) {
                if (row < groupRow + g.getRowCount()) {
                    return g.getTaskAt(row - groupRow - 1);
                }
                groupRow += g.getRowCount();
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int row, int col) {
        FoldingGroup group = this.getGroupAtRow(row);
        if (null != group) {
            switch (col) {
                case 0: {
                    return group;
                }
            }
            return null;
        }
        return super.getValueAt(row, col);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FoldingGroup getGroupAtRow(int row) {
        int groupRow = 0;
        LinkedList<FoldingGroup> linkedList = this.groups;
        synchronized (linkedList) {
            for (FoldingGroup g : this.groups) {
                if (g.isEmpty()) continue;
                if (row == groupRow) {
                    return g;
                }
                groupRow += g.getRowCount();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<FoldingGroup, List<Task>> divideByGroup(List<? extends Task> tasks) {
        HashMap<FoldingGroup, List<Task>> grouppedTasksMap = new HashMap<FoldingGroup, List<Task>>(this.groupMap.size());
        for (Task task : tasks) {
            LinkedList<Task> tasksInGroup;
            TaskGroup tg = Accessor.getGroup(task);
            FoldingGroup group = this.groupMap.get(tg.getName());
            if (null == group) {
                LinkedList<FoldingGroup> linkedList = this.groups;
                synchronized (linkedList) {
                    group = new FoldingGroup(tg);
                    this.groupMap.put(tg.getName(), group);
                    this.groups.add(group);
                    Collections.sort(this.groups);
                }
            }
            if (null == (tasksInGroup = (LinkedList<Task>)grouppedTasksMap.get(group))) {
                tasksInGroup = new LinkedList<Task>();
                grouppedTasksMap.put(group, tasksInGroup);
            }
            tasksInGroup.add(task);
        }
        return grouppedTasksMap;
    }

    @Override
    public void tasksAdded(List<? extends Task> tasks) {
        if (tasks.isEmpty()) {
            return;
        }
        Map<FoldingGroup, List<Task>> grouppedTasksMap = this.divideByGroup(tasks);
        for (FoldingGroup fg : grouppedTasksMap.keySet()) {
            List<Task> tasksInGroup = grouppedTasksMap.get(fg);
            fg.add(tasksInGroup);
        }
    }

    @Override
    public void tasksRemoved(List<? extends Task> tasks) {
        if (tasks.isEmpty()) {
            return;
        }
        Map<FoldingGroup, List<Task>> grouppedTasksMap = this.divideByGroup(tasks);
        for (FoldingGroup fg : grouppedTasksMap.keySet()) {
            List<Task> tasksInGroup = grouppedTasksMap.get(fg);
            fg.remove(tasksInGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleared() {
        LinkedList<FoldingGroup> linkedList = this.groups;
        synchronized (linkedList) {
            for (FoldingGroup fg : this.groups) {
                fg.clear();
            }
        }
    }

    public boolean isGroupRow(int row) {
        return null != this.getGroupAtRow(row);
    }

    public void toggleGroupExpanded(int row) {
        FoldingGroup fg = this.getGroupAtRow(row);
        if (null != fg) {
            fg.toggleExpanded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFoldingGroupStartingRow(FoldingGroup fg) {
        if (fg.isEmpty()) {
            return -1;
        }
        int startingRow = 0;
        LinkedList<FoldingGroup> linkedList = this.groups;
        synchronized (linkedList) {
            int groupIndex = this.groups.indexOf(fg);
            for (int i = 0; i < groupIndex; ++i) {
                startingRow += this.groups.get(i).getRowCount();
            }
        }
        return startingRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sortTaskList() {
        Comparator<Task> comparator = null;
        switch (this.sortingCol) {
            case 1: {
                comparator = TaskComparator.getDescriptionComparator(this.ascending);
                break;
            }
            case 3: {
                comparator = TaskComparator.getLocationComparator(this.ascending);
                break;
            }
            case 2: {
                comparator = TaskComparator.getFileComparator(this.ascending);
                break;
            }
            default: {
                comparator = TaskComparator.getDefault();
            }
        }
        if (null != this.groups) {
            LinkedList<FoldingGroup> linkedList = this.groups;
            synchronized (linkedList) {
                for (FoldingGroup fg : this.groups) {
                    fg.setComparator(comparator);
                }
            }
            Settings.getDefault().setSortingColumn(this.sortingCol);
            Settings.getDefault().setAscendingSort(this.ascending);
        }
        this.fireTableDataChanged();
    }

    class FoldingGroup
    implements Comparable<FoldingGroup> {
        private TaskGroup tg;
        private final Object TASK_LOCK = new Object();
        private TreeSet<Task> sortedTasks = new TreeSet<Task>(this.getComparator());
        private ArrayList<Task> tasksList;
        private boolean isExpanded;
        private Comparator<Task> comparator;

        public FoldingGroup(TaskGroup tg) {
            this.tg = tg;
            this.isExpanded = Settings.getDefault().isGroupExpanded(tg.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(List<Task> newTasks) {
            boolean wasEmpty = this.isEmpty();
            Object object = this.TASK_LOCK;
            synchronized (object) {
                this.sortedTasks.addAll(newTasks);
                this.tasksList = null;
            }
            int startingRow = FoldingTaskListModel.this.getFoldingGroupStartingRow(this);
            if (wasEmpty) {
                FoldingTaskListModel.this.fireTableRowsInserted(startingRow, startingRow + this.getRowCount());
            } else {
                if (this.isExpanded) {
                    int firstRow = Integer.MAX_VALUE;
                    int lastRow = Integer.MIN_VALUE;
                    for (Task t : newTasks) {
                        int index = this.getTasksList().indexOf(t);
                        if (index < firstRow) {
                            firstRow = index;
                        }
                        if (index <= lastRow) continue;
                        lastRow = index;
                    }
                    FoldingTaskListModel.this.fireTableRowsInserted(firstRow + startingRow + 1, lastRow + startingRow + 1);
                }
                FoldingTaskListModel.this.fireTableCellUpdated(startingRow, 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(List<Task> removedTasks) {
            int firstRow = Integer.MAX_VALUE;
            int lastRow = Integer.MIN_VALUE;
            int rowCount = this.getRowCount();
            if (this.isExpanded) {
                for (Task t : removedTasks) {
                    int index = this.getTasksList().indexOf(t);
                    if (index < firstRow) {
                        firstRow = index;
                    }
                    if (index <= lastRow) continue;
                    lastRow = index;
                }
            }
            Object i$ = this.TASK_LOCK;
            synchronized (i$) {
                this.sortedTasks.removeAll(removedTasks);
                this.tasksList = null;
            }
            int startingRow = FoldingTaskListModel.this.getFoldingGroupStartingRow(this);
            if (this.isEmpty()) {
                FoldingTaskListModel.this.fireTableRowsDeleted(startingRow, startingRow + rowCount);
            } else {
                if (this.isExpanded) {
                    FoldingTaskListModel.this.fireTableRowsDeleted(firstRow + startingRow + 1, lastRow + startingRow + 1);
                }
                FoldingTaskListModel.this.fireTableCellUpdated(startingRow, 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            if (this.isEmpty()) {
                return;
            }
            final int rowCount = this.getRowCount();
            final int startingRow = FoldingTaskListModel.this.getFoldingGroupStartingRow(this);
            Object object = this.TASK_LOCK;
            synchronized (object) {
                this.sortedTasks.clear();
                this.tasksList = null;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FoldingTaskListModel.this.fireTableRowsDeleted(startingRow, startingRow + rowCount);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.TASK_LOCK;
            synchronized (object) {
                return this.sortedTasks.isEmpty();
            }
        }

        public void setExpanded(boolean expand) {
            if (this.isExpanded == expand) {
                return;
            }
            this.toggleExpanded();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void toggleExpanded() {
            this.isExpanded = !this.isExpanded;
            Settings.getDefault().setGroupExpanded(this.tg.getName(), this.isExpanded);
            int firstRow = 0;
            LinkedList linkedList = FoldingTaskListModel.this.groups;
            synchronized (linkedList) {
                int groupIndex = FoldingTaskListModel.this.groups.indexOf(this);
                for (int i = 0; i < groupIndex; ++i) {
                    firstRow += ((FoldingGroup)FoldingTaskListModel.this.groups.get(i)).getRowCount();
                }
            }
            int lastRow = firstRow + this.getTaskCount();
            ++firstRow;
            if (this.isExpanded) {
                FoldingTaskListModel.this.fireTableRowsInserted(firstRow, lastRow);
            } else {
                FoldingTaskListModel.this.fireTableRowsDeleted(firstRow, lastRow);
            }
            FoldingTaskListModel.this.fireTableCellUpdated(firstRow - 1, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            Object object = this.TASK_LOCK;
            synchronized (object) {
                return this.isEmpty() ? 0 : (this.isExpanded ? 1 + this.sortedTasks.size() : 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getTaskCount() {
            Object object = this.TASK_LOCK;
            synchronized (object) {
                return this.sortedTasks.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Task getTaskAt(int index) {
            Object object = this.TASK_LOCK;
            synchronized (object) {
                return this.getTasksList().get(index);
            }
        }

        @Override
        public int compareTo(FoldingGroup other) {
            List groupList = TaskGroup.getGroups();
            int myIndex = groupList.indexOf(this.tg);
            int otherIndex = groupList.indexOf(other.tg);
            return myIndex - otherIndex;
        }

        public boolean isExpanded() {
            return this.isExpanded;
        }

        public TaskGroup getGroup() {
            return this.tg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Task> getTasksList() {
            Object object = this.TASK_LOCK;
            synchronized (object) {
                if (this.tasksList == null) {
                    this.tasksList = new ArrayList<Task>(this.sortedTasks);
                }
                return this.tasksList;
            }
        }

        private Comparator<Task> getComparator() {
            if (null == this.comparator) {
                this.comparator = TaskComparator.getDefault();
            }
            return this.comparator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setComparator(Comparator<Task> newComparator) {
            if (((Object)this.getComparator()).equals(newComparator)) {
                return;
            }
            this.comparator = newComparator;
            Object object = this.TASK_LOCK;
            synchronized (object) {
                if (!this.sortedTasks.isEmpty()) {
                    TreeSet<Task> s = this.sortedTasks;
                    this.sortedTasks = new TreeSet<Task>(this.comparator);
                    this.tasksList = null;
                    if (this.isExpanded()) {
                        int firstRow = 0;
                        LinkedList linkedList = FoldingTaskListModel.this.groups;
                        synchronized (linkedList) {
                            int groupIndex = FoldingTaskListModel.this.groups.indexOf(this);
                            for (int i = 0; i < groupIndex; ++i) {
                                firstRow += ((FoldingGroup)FoldingTaskListModel.this.groups.get(i)).getRowCount();
                            }
                        }
                        int lastRow = firstRow + this.getTaskCount();
                        FoldingTaskListModel.this.fireTableRowsUpdated(++firstRow, lastRow);
                    }
                }
            }
        }
    }
}

