/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.search.QuickSearchComboBar;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.netbeans.modules.versioning.util.VerticallyNonResizingPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class HookPanel
extends VerticallyNonResizingPanel
implements ItemListener,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.vcshooks.HookPanel");
    private QuickSearchComboBar qs;
    private Repository selectedRepository;
    private FieldValues fieldValues = null;
    private ButtonGroup buttonGroup1;
    final LinkButton changeFormatButton = new LinkButton();
    final JRadioButton commitRadioButton = new JRadioButton();
    private JLabel issueLabel;
    private JPanel issuePanel;
    private JButton jButton2;
    private JLabel jLabel2;
    final JCheckBox linkCheckBox = new JCheckBox();
    final JRadioButton pushRadioButton = new JRadioButton();
    final JComboBox repositoryComboBox = new JComboBox();
    private JLabel repositoryLabel;
    final JCheckBox resolveCheckBox = new JCheckBox();

    public HookPanel(boolean link, boolean resolve, boolean commit) {
        this.initComponents();
        this.fieldValues = new FieldValues();
        this.qs = new QuickSearchComboBar((JPanel)((Object)this));
        this.issuePanel.add((Component)this.qs, "North");
        this.issueLabel.setLabelFor(this.qs.getIssueComponent());
        this.linkCheckBox.setSelected(link);
        this.resolveCheckBox.setSelected(resolve);
        this.commitRadioButton.setSelected(commit);
        this.pushRadioButton.setSelected(!commit);
        this.enableFields();
        this.repositoryComboBox.addItemListener(this);
    }

    Issue getIssue() {
        return this.qs.getIssue();
    }

    public Repository getSelectedRepository() {
        return this.selectedRepository;
    }

    void enableFields() {
        boolean enableFields;
        boolean repoSelected = this.isRepositorySelected();
        boolean bl = enableFields = repoSelected && this.getIssue() != null;
        if (!enableFields && !this.fieldValues.stored) {
            this.fieldValues.store();
        } else if (enableFields) {
            this.fieldValues.restore();
        }
        this.linkCheckBox.setEnabled(enableFields);
        this.resolveCheckBox.setEnabled(enableFields);
        this.pushRadioButton.setEnabled(enableFields);
        this.commitRadioButton.setEnabled(enableFields);
        this.changeFormatButton.setEnabled(enableFields);
        this.issueLabel.setEnabled(repoSelected);
        this.qs.enableFields(repoSelected);
    }

    private boolean isRepositorySelected() {
        Object selectedItem = this.repositoryComboBox.getSelectedItem();
        return selectedItem instanceof Repository;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.issuePanel = new JPanel();
        this.repositoryLabel = new JLabel();
        this.jButton2 = this.createDoubleWidthButton();
        this.issueLabel = new JLabel();
        this.jLabel2 = new JLabel();
        this.setFocusable(false);
        this.issuePanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.resolveCheckBox, (String)NbBundle.getMessage(HookPanel.class, (String)"HookPanel.resolveCheckBox.text"));
        this.resolveCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HookPanel.this.resolveCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.linkCheckBox, (String)NbBundle.getMessage(HookPanel.class, (String)"HookPanel.linkCheckBox.text"));
        this.linkCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HookPanel.this.linkCheckBoxActionPerformed(evt);
            }
        });
        this.repositoryLabel.setLabelFor(this.repositoryComboBox);
        Mnemonics.setLocalizedText((JLabel)this.repositoryLabel, (String)NbBundle.getMessage(HookPanel.class, (String)"HookPanel.repositoryLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(HookPanel.class, (String)"HookPanel.jButton2.text"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HookPanel.this.jButton2ActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.issueLabel, (String)NbBundle.getMessage(HookPanel.class, (String)"HookPanel.issueLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.changeFormatButton, (String)NbBundle.getMessage(HookPanel.class, (String)"HookPanel.changeFormatButton.text"));
        this.changeFormatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HookPanel.this.changeFormatButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.commitRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.commitRadioButton, (String)NbBundle.getMessage(HookPanel.class, (String)"HookPanel.commitRadioButton.text"));
        this.buttonGroup1.add(this.pushRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.pushRadioButton, (String)NbBundle.getMessage(HookPanel.class, (String)"HookPanel.pushRadioButton.text"));
        this.jLabel2.setForeground(UIManager.getDefaults().getColor("Button.disabledText"));
        this.jLabel2.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(HookPanel.class, (String)"HookPanel.jLabel2.text"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.repositoryLabel).add((Component)this.issueLabel)).add(11, 11, 11).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.resolveCheckBox).add((Component)this.linkCheckBox)).addPreferredGap(0).add((Component)this.changeFormatButton, -2, -1, -2).add(65, 65, 65).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.commitRadioButton).add((Component)this.pushRadioButton))).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jLabel2, -1, 463, Short.MAX_VALUE).add((Component)this.issuePanel, -1, 463, Short.MAX_VALUE).add(1, (Component)this.repositoryComboBox, 0, 463, Short.MAX_VALUE)).addPreferredGap(1).add((Component)this.jButton2))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.repositoryLabel).add((Component)this.jButton2).add((Component)this.repositoryComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.issuePanel, -1, 16, Short.MAX_VALUE).add((Component)this.issueLabel, -1, -1, Short.MAX_VALUE)).add(9, 9, 9).add((Component)this.jLabel2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.resolveCheckBox).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.linkCheckBox).add((Component)this.changeFormatButton, -2, -1, -2))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.commitRadioButton).addPreferredGap(0).add((Component)this.pushRadioButton))).addContainerGap()));
        this.resolveCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HookPanel.class, (String)"HookPanel.resolveCheckBox.AccessibleContext.accessibleDescription"));
        this.linkCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HookPanel.class, (String)"HookPanel.addRevisionCheckBox.AccessibleContext.accessibleDescription"));
        this.repositoryComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HookPanel.class, (String)"HookPanel.repositoryComboBox.AccessibleContext.accessibleDescription"));
        this.jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HookPanel.class, (String)"HookPanel.jButton2.AccessibleContext.accessibleDescription"));
        this.changeFormatButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HookPanel.class, (String)"HookPanel.changeRevisionFormatButton.AccessibleContext.accessibleDescription"));
        this.commitRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HookPanel.class, (String)"HookPanel.commitRadioButton.AccessibleContext.accessibleDescription"));
        this.pushRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HookPanel.class, (String)"HookPanel.pushRadioButton.AccessibleContext.accessibleDescription"));
    }

    private JButton createDoubleWidthButton() {
        class DoubleWidthButton
        extends JButton {
            DoubleWidthButton() {
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension defPrefSize = super.getPreferredSize();
                return new Dimension((int)(1.8f * (float)defPrefSize.width), defPrefSize.height);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        }
        return new DoubleWidthButton();
    }

    private void linkCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        Repository repo = BugtrackingUtil.createRepository();
        if (repo == null) {
            return;
        }
        this.repositoryComboBox.addItem(repo);
        this.repositoryComboBox.setSelectedItem(repo);
    }

    private void resolveCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void changeFormatButtonActionPerformed(ActionEvent evt) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "itemStateChanged() - selected item: {0}", e.getItem());
        }
        this.enableFields();
        if (e.getStateChange() == 1) {
            Repository repo;
            Object item = e.getItem();
            this.selectedRepository = repo = item instanceof Repository ? (Repository)item : null;
            if (repo != null) {
                this.qs.setRepository(repo);
            }
        }
    }

    public void addNotify() {
        this.qs.addPropertyChangeListener((PropertyChangeListener)this);
        super.addNotify();
    }

    public void removeNotify() {
        this.qs.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("QuickSearchComboBar.issue.changed")) {
            this.enableFields();
        }
    }

    private class FieldValues {
        private boolean addLinkInfo = false;
        private boolean resolve = false;
        private boolean commit = false;
        private boolean stored = false;

        private FieldValues() {
        }

        void store() {
            this.addLinkInfo = HookPanel.this.linkCheckBox.isSelected();
            this.resolve = HookPanel.this.resolveCheckBox.isSelected();
            this.commit = HookPanel.this.commitRadioButton.isSelected();
            HookPanel.this.linkCheckBox.setSelected(false);
            HookPanel.this.resolveCheckBox.setSelected(false);
            HookPanel.this.commitRadioButton.setSelected(false);
            this.stored = true;
        }

        void restore() {
            HookPanel.this.linkCheckBox.setSelected(this.addLinkInfo);
            HookPanel.this.resolveCheckBox.setSelected(this.resolve);
            HookPanel.this.commitRadioButton.setSelected(this.commit);
            this.stored = false;
        }
    }
}

