/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ftp;

import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.ftp.FtpConnectionProvider;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;

public final class FtpConfiguration
extends RemoteConfiguration {
    private static final String PATH_SEPARATOR = "/";
    private final String host;
    private final int port;
    private final String userName;
    private final String password;
    private final boolean anonymousLogin;
    private final String initialDirectory;
    private final int timeout;
    private final boolean passiveMode;
    private final boolean ignoreDisconnectErrors;

    public FtpConfiguration(ConfigManager.Configuration cfg) {
        super(cfg);
        this.host = cfg.getValue("host");
        this.port = Integer.parseInt(cfg.getValue("port"));
        this.userName = cfg.getValue("user");
        this.password = this.readPassword(cfg, "password");
        this.anonymousLogin = Boolean.valueOf(cfg.getValue("anonymousLogin"));
        this.initialDirectory = cfg.getValue("initialDirectory");
        this.timeout = Integer.parseInt(cfg.getValue("timeout"));
        this.passiveMode = Boolean.valueOf(cfg.getValue("passiveMode"));
        this.ignoreDisconnectErrors = Boolean.valueOf(cfg.getValue("ignoreDisconnectErrors"));
    }

    public boolean isAnonymousLogin() {
        return this.anonymousLogin;
    }

    public String getHost() {
        return this.host;
    }

    @Override
    public String getInitialDirectory() {
        return this.initialDirectory;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isPassiveMode() {
        return this.passiveMode;
    }

    public boolean getIgnoreDisconnectErrors() {
        return this.ignoreDisconnectErrors;
    }

    public String getUserName() {
        if (this.anonymousLogin) {
            return "anonymous";
        }
        return this.userName;
    }

    public String getPassword() {
        if (this.anonymousLogin) {
            return "nobody@nowhere.net";
        }
        return this.password != null ? this.password : "";
    }

    @Override
    public String getUrl(String directory) {
        assert (directory != null);
        String path = this.initialDirectory;
        if (directory.trim().length() > 0) {
            path = path + directory;
        }
        return "ftp://" + this.host + path.replaceAll("/{2,}", PATH_SEPARATOR);
    }

    @Override
    public boolean saveProperty(String key, String value) {
        if ("password".equals(key)) {
            this.savePassword(this.password, FtpConnectionProvider.get().getDisplayName());
            return true;
        }
        return false;
    }

    @Override
    public void notifyDeleted() {
        this.deletePassword();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        FtpConfiguration other = (FtpConfiguration)obj;
        if (!(this.host == other.host || this.host != null && this.host.equals(other.host))) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (!(this.userName == other.userName || this.userName != null && this.userName.equals(other.userName))) {
            return false;
        }
        return this.password == other.password || this.password != null && this.password.equals(other.password);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 97 * hash + (this.host != null ? this.host.hashCode() : 0);
        hash = 97 * hash + this.port;
        hash = 97 * hash + (this.userName != null ? this.userName.hashCode() : 0);
        hash = 97 * hash + (this.password != null ? this.password.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getClass().getName());
        sb.append(" [displayName: ");
        sb.append(this.getDisplayName());
        sb.append(", name: ");
        sb.append(this.getName());
        sb.append(", host: ");
        sb.append(this.host);
        sb.append(", port: ");
        sb.append(this.port);
        sb.append(", userName: ");
        sb.append(this.getUserName());
        sb.append(", password: *****");
        sb.append(", anonymousLogin: ");
        sb.append(this.anonymousLogin);
        sb.append(", initialDirectory: ");
        sb.append(this.initialDirectory);
        sb.append(", timeout: ");
        sb.append(this.timeout);
        sb.append(", passiveMode: ");
        sb.append(this.passiveMode);
        sb.append(", ignoreDisconnectErrors: ");
        sb.append(this.ignoreDisconnectErrors);
        sb.append("]");
        return sb.toString();
    }
}

