/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.phpunit;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.project.phpunit.PhpUnit;
import org.netbeans.modules.php.project.phpunit.PhpUnitOptionsPanel;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class PhpUnitOptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private PhpUnitOptionsPanel phpUnitOptionsPanel = null;
    private volatile boolean changed = false;

    public void update() {
        this.phpUnitOptionsPanel.setPhpUnit(this.getPhpOptions().getPhpUnit());
        this.changed = false;
    }

    public void applyChanges() {
        this.getPhpOptions().setPhpUnit(this.phpUnitOptionsPanel.getPhpUnit());
        this.changed = false;
    }

    public void cancel() {
    }

    public boolean isValid() {
        PhpUnit.resetVersion();
        PhpUnit phpUnit = null;
        try {
            phpUnit = PhpUnit.getCustom(this.phpUnitOptionsPanel.getPhpUnit());
        }
        catch (PhpProgram.InvalidPhpProgramException ex) {
            this.phpUnitOptionsPanel.setWarning(ex.getLocalizedMessage());
            return true;
        }
        assert (phpUnit != null);
        String warning = PhpUnit.validateVersion(phpUnit);
        if (warning != null) {
            this.phpUnitOptionsPanel.setWarning(warning);
            return true;
        }
        this.phpUnitOptionsPanel.setError(" ");
        return true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public JComponent getComponent(Lookup masterLookup) {
        if (this.phpUnitOptionsPanel == null) {
            this.phpUnitOptionsPanel = new PhpUnitOptionsPanel();
            this.phpUnitOptionsPanel.addChangeListener(this);
        }
        return this.phpUnitOptionsPanel;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(PhpUnit.class);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.changed) {
            this.changed = true;
            this.propertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.propertyChangeSupport.firePropertyChange("valid", null, null);
    }

    private PhpOptions getPhpOptions() {
        return PhpOptions.getInstance();
    }
}

