/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ejb;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.dd.spi.MetadataUnit;
import org.netbeans.modules.j2ee.dd.spi.ejb.EjbJarMetadataModelFactory;
import org.netbeans.modules.j2ee.dd.spi.webservices.WebservicesMetadataModelFactory;
import org.netbeans.modules.j2ee.deployment.common.api.EjbChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleImplementation2;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarImplementation2;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.classpath.ProjectSourcesClassPathProvider;
import org.netbeans.modules.maven.j2ee.ejb.EjbModuleProviderImpl;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class EjbJarImpl
implements EjbJarImplementation2,
J2eeModuleImplementation2,
ModuleChangeReporter {
    private Project project;
    private List versionListeners;
    private EjbModuleProviderImpl provider;
    private MetadataModel<EjbJarMetadata> ejbJarMetadataModel;
    private MetadataModel<WebservicesMetadata> webservicesMetadataModel;
    private NbMavenProject mavenproject;

    EjbJarImpl(Project proj, EjbModuleProviderImpl prov) {
        this.project = proj;
        this.versionListeners = new ArrayList();
        this.provider = prov;
        this.mavenproject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
    }

    boolean isValid() {
        return true;
    }

    public Profile getJ2eeProfile() {
        String version = ((AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class)).get("netbeans.hint.j2eeVersion", true);
        if (version != null) {
            return Profile.fromPropertiesString((String)version);
        }
        String ver = this.getModuleVersion();
        if ("2.1".equals(ver)) {
            return Profile.J2EE_14;
        }
        if ("3.0".equals(ver)) {
            return Profile.JAVA_EE_5;
        }
        if ("3.1".equals(ver)) {
            return Profile.JAVA_EE_6_FULL;
        }
        return Profile.J2EE_14;
    }

    public FileObject getMetaInf() {
        Sources srcs = ProjectUtils.getSources((Project)this.project);
        if (srcs != null) {
            SourceGroup[] grp = srcs.getSourceGroups("resources");
            for (int i = 0; i < grp.length; ++i) {
                FileObject fo;
                if (grp[i] == null || grp[i].getRootFolder() == null || (fo = grp[i].getRootFolder().getFileObject("META-INF")) == null) continue;
                return fo;
            }
        }
        return null;
    }

    File getDDFile(String path) {
        URI[] dir = this.mavenproject.getResources(false);
        File fil = new File(new File(dir[0]), path);
        fil = FileUtil.normalizeFile((File)fil);
        return fil;
    }

    public FileObject getDeploymentDescriptor() {
        FileObject metaInf = this.getMetaInf();
        if (metaInf != null) {
            return metaInf.getFileObject("ejb-jar.xml");
        }
        return null;
    }

    public FileObject[] getJavaSources() {
        Sources srcs = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] gr = srcs.getSourceGroups("java");
        ArrayList<FileObject> toRet = new ArrayList<FileObject>();
        if (gr != null) {
            for (int i = 0; i < gr.length; ++i) {
                toRet.add(gr[i].getRootFolder());
            }
        }
        return toRet.toArray(new FileObject[toRet.size()]);
    }

    public String getModuleVersion() {
        String version;
        DDProvider prov = DDProvider.getDefault();
        FileObject dd = this.getDeploymentDescriptor();
        if (dd != null) {
            try {
                EjbJar ejb = prov.getDDRoot(dd);
                String ejbVersion = ejb.getVersion().toString();
                return ejbVersion;
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
        }
        if ((version = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)"org.apache.maven.plugins", (String)"maven-ejb-plugin", (String)"ejbVersion", (String)"ejb")) != null) {
            return version.trim();
        }
        return "3.0";
    }

    public J2eeModule.Type getModuleType() {
        return J2eeModule.Type.EJB;
    }

    public String getUrl() {
        return "/" + this.mavenproject.getMavenProject().getBuild().getFinalName();
    }

    public FileObject getArchive() throws IOException {
        String jarfile = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)"org.apache.maven.plugins", (String)"maven-ejb-plugin", (String)"jarName", (String)"ejb");
        MavenProject proj = this.mavenproject.getMavenProject();
        if (jarfile == null) {
            jarfile = proj.getBuild().getFinalName();
        }
        String loc = proj.getBuild().getDirectory();
        File fil = FileUtil.normalizeFile((File)new File(loc, jarfile + ".jar"));
        return FileUtil.toFileObject((File)fil);
    }

    public Iterator getArchiveContents() throws IOException {
        FileObject fo = this.getContentDirectory();
        if (fo != null) {
            return new ContentIterator(fo);
        }
        return null;
    }

    public FileObject getContentDirectory() throws IOException {
        File fil = this.mavenproject.getOutputDirectory(false);
        FileObject fo = FileUtil.toFileObject((File)fil.getParentFile());
        if (fo != null) {
            fo.refresh();
        }
        return FileUtil.toFileObject((File)fil);
    }

    public RootInterface getDeploymentDescriptor(String location) {
        if ("ejb-jar.xml".equals(location)) {
            location = "META-INF/ejb-jar.xml";
        }
        if ("META-INF/ejb-jar.xml".equals(location)) {
            try {
                FileObject deploymentDescriptor;
                URI[] uris;
                FileObject content = this.getContentDirectory();
                if (content == null && (uris = this.mavenproject.getResources(false)).length > 0) {
                    content = URLMapper.findFileObject((URL)uris[0].toURL());
                }
                if (content != null && (deploymentDescriptor = content.getFileObject("META-INF/ejb-jar.xml")) != null) {
                    return DDProvider.getDefault().getDDRoot(deploymentDescriptor);
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().log(e.getLocalizedMessage());
            }
        }
        return null;
    }

    public EjbChangeDescriptor getEjbChanges(long timestamp) {
        return new EjbChange();
    }

    public boolean isManifestChanged(long timestamp) {
        return false;
    }

    public File getResourceDirectory() {
        File toRet = new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), "src" + File.separator + "main" + File.separator + "setup");
        return toRet;
    }

    public File getDeploymentConfigurationFile(String name) {
        if (name == null) {
            return null;
        }
        String path = this.provider.getConfigSupport().getContentRelativePath(name);
        if (path == null) {
            path = name;
        }
        return this.getDDFile(path);
    }

    public void addPropertyChangeListener(PropertyChangeListener arg0) {
    }

    public void removePropertyChangeListener(PropertyChangeListener arg0) {
    }

    public synchronized MetadataModel<EjbJarMetadata> getMetadataModel() {
        if (this.ejbJarMetadataModel == null) {
            FileObject ddFO = this.getDeploymentDescriptor();
            File ddFile = ddFO != null ? FileUtil.toFile((FileObject)ddFO) : null;
            ProjectSourcesClassPathProvider cpProvider = (ProjectSourcesClassPathProvider)this.project.getLookup().lookup(ProjectSourcesClassPathProvider.class);
            MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)cpProvider.getProjectSourcesClassPath("classpath/source"), (File)ddFile);
            this.ejbJarMetadataModel = EjbJarMetadataModelFactory.createMetadataModel((MetadataUnit)metadataUnit);
        }
        return this.ejbJarMetadataModel;
    }

    public <T> MetadataModel<T> getMetadataModel(Class<T> type) {
        if (type == EjbJarMetadata.class) {
            MetadataModel<EjbJarMetadata> model = this.getMetadataModel();
            return model;
        }
        if (type == WebservicesMetadata.class) {
            MetadataModel<WebservicesMetadata> model = this.getWebservicesMetadataModel();
            return model;
        }
        return null;
    }

    private synchronized MetadataModel<WebservicesMetadata> getWebservicesMetadataModel() {
        if (this.webservicesMetadataModel == null) {
            FileObject ddFO = this.getWebServicesDeploymentDescriptor();
            File ddFile = ddFO != null ? FileUtil.toFile((FileObject)ddFO) : null;
            ProjectSourcesClassPathProvider cpProvider = (ProjectSourcesClassPathProvider)this.project.getLookup().lookup(ProjectSourcesClassPathProvider.class);
            MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)cpProvider.getProjectSourcesClassPath("classpath/source"), (File)ddFile);
            this.webservicesMetadataModel = WebservicesMetadataModelFactory.createMetadataModel((MetadataUnit)metadataUnit);
        }
        return this.webservicesMetadataModel;
    }

    private FileObject getWebServicesDeploymentDescriptor() {
        FileObject metaInf = this.getMetaInf();
        if (metaInf != null) {
            return metaInf.getFileObject("webservices.xml");
        }
        return null;
    }

    private static final class FSRootRE
    implements J2eeModule.RootedEntry {
        private FileObject f;
        private FileObject root;

        FSRootRE(FileObject rt, FileObject fo) {
            this.f = fo;
            this.root = rt;
        }

        public FileObject getFileObject() {
            return this.f;
        }

        public String getRelativePath() {
            return FileUtil.getRelativePath((FileObject)this.root, (FileObject)this.f);
        }
    }

    private static final class ContentIterator
    implements Iterator {
        private ArrayList<FileObject> ch = new ArrayList();
        private FileObject root;

        private ContentIterator(FileObject f) {
            this.ch.add(f);
            this.root = f;
        }

        @Override
        public boolean hasNext() {
            return !this.ch.isEmpty();
        }

        public Object next() {
            FileObject f = this.ch.get(0);
            this.ch.remove(0);
            if (f.isFolder()) {
                f.refresh();
                FileObject[] chArr = f.getChildren();
                for (int i = 0; i < chArr.length; ++i) {
                    this.ch.add(chArr[i]);
                }
            }
            return new FSRootRE(this.root, f);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class EjbChange
    implements EjbChangeDescriptor {
        private EjbChange() {
        }

        public boolean ejbsChanged() {
            return false;
        }

        public String[] getChangedEjbs() {
            return new String[0];
        }
    }
}

