/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.general;

import java.awt.Image;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.midp.codegen.InstanceNameResolver;
import org.netbeans.modules.vmd.midp.components.MidpTypes;

public class ClassSupport {
    private static final InfoPresenter.Resolver INFO_RESOLVER = new ClassInfoResolver();

    public static boolean isLazyInitialized(DesignComponent classComponent) {
        return MidpTypes.getBoolean(classComponent.readProperty("lazyInit"));
    }

    public static Presenter createInfoPresenter() {
        return InfoPresenter.create((InfoPresenter.Resolver)INFO_RESOLVER);
    }

    public static String resolveDisplayName(DesignComponent component) {
        PropertyValue value = component.readProperty("instanceName");
        if (value.getKind() == PropertyValue.Kind.VALUE && MidpTypes.TYPEID_JAVA_LANG_STRING.equals((Object)value.getType())) {
            return (String)value.getPrimitiveValue();
        }
        Debug.warning((Object[])new Object[]{"Invalid instance name ", value, "for component", component});
        return null;
    }

    private static class ClassInfoResolver
    implements InfoPresenter.Resolver {
        private ClassInfoResolver() {
        }

        public String getDisplayName(DesignComponent component, InfoPresenter.NameType nameType) {
            switch (nameType) {
                case PRIMARY: {
                    return ClassSupport.resolveDisplayName(component);
                }
                case SECONDARY: {
                    return MidpTypes.getSimpleClassName(component.getType());
                }
                case TERTIARY: {
                    return null;
                }
            }
            throw new IllegalStateException();
        }

        public DesignEventFilter getEventFilter(DesignComponent component) {
            return new DesignEventFilter(new DesignEventFilter[0]).addComponentFilter(component, false);
        }

        public boolean isEditable(DesignComponent component) {
            return true;
        }

        public String getEditableName(DesignComponent component) {
            if (component == null) {
                throw new IllegalArgumentException("Component cannot be null");
            }
            return (String)component.readProperty("instanceName").getPrimitiveValue();
        }

        public void setEditableName(DesignComponent component, String name) {
            if (component == null || name == null) {
                throw new IllegalArgumentException("Component or name cannot be null");
            }
            component.writeProperty("instanceName", InstanceNameResolver.createFromSuggested(component, name));
        }

        public Image getIcon(DesignComponent component, InfoPresenter.IconType iconType) {
            if (InfoPresenter.IconType.COLOR_16x16.equals((Object)iconType)) {
                for (ComponentDescriptor descriptor = component.getComponentDescriptor(); descriptor != null; descriptor = descriptor.getSuperDescriptor()) {
                    Image image = MidpTypes.getRegisteredIcon(descriptor.getTypeDescriptor().getThisType());
                    if (image == null) continue;
                    return image;
                }
            }
            return null;
        }
    }
}

