/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.ref.WeakReference;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.DialogBinding;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.points.CallPointCD;
import org.netbeans.modules.vmd.midp.components.points.IfPointCD;
import org.netbeans.modules.vmd.midp.components.points.MethodPointCD;
import org.netbeans.modules.vmd.midp.components.points.SwitchPointCD;
import org.netbeans.modules.vmd.midp.components.sources.SwitchCaseEventSourceCD;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.CodeUtils;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class PropertyEditorJavaString
extends DesignPropertyEditor {
    private static final String JAVA_CODE = NbBundle.getMessage(PropertyEditorJavaString.class, (String)"LBL_JAVA_CODE_STR");
    private static final String METHOD_NAME = NbBundle.getMessage(PropertyEditorJavaString.class, (String)"LBL_METHOD_NAME_STR");
    private static final String CONDITION_EXPRESSION = NbBundle.getMessage(PropertyEditorJavaString.class, (String)"LBL_CONDITION_EXPRESSION_STR");
    private static final String SWITCH_OPERAND = NbBundle.getMessage(PropertyEditorJavaString.class, (String)"LBL_SWITCH_OPERAND_STR");
    private static final String CASE_OPERAND = NbBundle.getMessage(PropertyEditorJavaString.class, (String)"LBL_CASE_OPERAND_STR");
    private static final String JAVA_EXPRESSION = NbBundle.getMessage(PropertyEditorJavaString.class, (String)"LBL_JAVA_EXPRESSION_STR");
    private static final String AMP = "&";
    private static final String COLON = ":";
    protected WeakReference<DesignComponent> component;
    private TypeID typeID;
    private CustomEditor customEditor;
    private PropertyValue resetToDefaultValue;

    private PropertyEditorJavaString(TypeID typeID) {
        this.typeID = typeID;
    }

    private PropertyEditorJavaString(TypeID typeID, PropertyValue resetToDefaultValue) {
        this(typeID);
        this.resetToDefaultValue = resetToDefaultValue;
    }

    public static final PropertyEditorJavaString createInstance(TypeID typeID) {
        return new PropertyEditorJavaString(typeID);
    }

    public static final PropertyEditorJavaString createInstance(TypeID typeID, PropertyValue resetTodefaultValue) {
        return new PropertyEditorJavaString(typeID, resetTodefaultValue);
    }

    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        this.typeID = null;
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.component = null;
        this.resetToDefaultValue = null;
    }

    public Component getCustomEditor() {
        PropertyValue value;
        if (this.customEditor == null) {
            this.customEditor = new CustomEditor();
        }
        if ((value = (PropertyValue)super.getValue()) != null) {
            this.customEditor.setText(MidpTypes.getJavaCode(value));
        }
        this.customEditor.init();
        return this.customEditor;
    }

    public String getAsText() {
        PropertyValue value = (PropertyValue)super.getValue();
        if (value == null) {
            return PropertyEditorUserCode.NULL_TEXT;
        }
        return MidpTypes.getJavaCode(value);
    }

    public void setAsText(String text) {
        PropertyValue value = (PropertyValue)super.getValue();
        if (value == null) {
            return;
        }
        Object pv = value.getPrimitiveValue();
        if (pv != null && pv.equals(text)) {
            return;
        }
        this.saveValue(text);
    }

    public Object getDefaultValue() {
        return this.resetToDefaultValue;
    }

    private void saveValue(String text) {
        if (text != null) {
            super.setValue((Object)MidpTypes.createJavaCodeValue(text));
        }
    }

    public void customEditorOKButtonPressed() {
        String text = this.customEditor.getText();
        this.saveValue(text);
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public String getCustomEditorTitle() {
        String title = this.getLabelName();
        title = title.replace(AMP, "");
        title = title.replace(COLON, "");
        return title;
    }

    public void init(DesignComponent component) {
        if (component != null) {
            this.component = new WeakReference<DesignComponent>(component);
        }
    }

    private String getLabelName() {
        if (this.typeID.equals((Object)CallPointCD.TYPEID)) {
            return JAVA_CODE;
        }
        if (this.typeID.equals((Object)MethodPointCD.TYPEID)) {
            return METHOD_NAME;
        }
        if (this.typeID.equals((Object)IfPointCD.TYPEID)) {
            return CONDITION_EXPRESSION;
        }
        if (this.typeID.equals((Object)SwitchPointCD.TYPEID)) {
            return SWITCH_OPERAND;
        }
        if (this.typeID.equals((Object)SwitchCaseEventSourceCD.TYPEID)) {
            return CASE_OPERAND;
        }
        return JAVA_EXPRESSION;
    }

    private final class CustomEditor
    extends JPanel {
        private JEditorPane textPane;

        public CustomEditor() {
            this.initComponents();
        }

        void cleanUp() {
            this.textPane = null;
            this.removeAll();
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            JLabel label = new JLabel();
            Mnemonics.setLocalizedText((JLabel)label, (String)PropertyEditorJavaString.this.getLabelName());
            constraints.insets = new Insets(12, 12, 3, 12);
            constraints.anchor = 18;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 1;
            this.add((Component)label, constraints);
            this.textPane = new JEditorPane();
            label.setLabelFor(this.textPane);
            this.textPane.getAccessibleContext().setAccessibleName(label.getText());
            this.textPane.getAccessibleContext().setAccessibleDescription(label.getText());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CustomEditor.this.textPane.setContentType("text/x-java");
                }
            });
            this.textPane.setPreferredSize(new Dimension(400, 100));
            JScrollPane jsp = new JScrollPane();
            jsp.setViewportView(this.textPane);
            constraints.insets = new Insets(0, 12, 12, 12);
            constraints.anchor = 18;
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            this.add((Component)jsp, constraints);
        }

        public void setText(String text) {
            this.textPane.setText(text);
        }

        public String getText() {
            return this.textPane.getText();
        }

        public void init() {
            if (PropertyEditorJavaString.this.component == null || PropertyEditorJavaString.this.component.get() == null) {
                return;
            }
            DesignComponent _component = (DesignComponent)PropertyEditorJavaString.this.component.get();
            Document swingDoc = this.textPane.getDocument();
            if (swingDoc.getProperty(JavaSource.class) == null) {
                DataObjectContext context = ProjectUtils.getDataObjectContextForDocument((DesignDocument)_component.getDocument());
                swingDoc.putProperty("stream", context.getDataObject());
                int offset = CodeUtils.getMethodOffset(context);
                String text = this.textPane.getText();
                DialogBinding.bindComponentToFile((FileObject)context.getDataObject().getPrimaryFile(), (int)offset, (int)0, (JTextComponent)this.textPane);
                this.textPane.setText(text);
            }
        }
    }
}

