/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JField;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.converters.BaseClassInterfaceConverter;
import com.sun.javacard.converter.converters.ClinitConverter;
import com.sun.javacard.converter.converters.PackageConverter;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfMethod;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcException;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcImplementedInterfaceInfo;
import com.sun.javacard.jcfile.JcLocalVariable;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcMethodTable;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class InterfaceConverter
extends BaseClassInterfaceConverter {
    public InterfaceConverter(JClassFile jClassFile, PackageConverter packageConverter) {
        super(jClassFile, packageConverter);
    }

    public JcClass convert() throws Exception {
        int n;
        this.intTypeCheck();
        this.jc_class.setInterfaceType(true);
        this.jc_class.setAccessFlags(this.jc_class.getAccessFlags() | 0x400);
        this.jc_class.setAccessFlags(this.jc_class.getAccessFlags() & 0xFFFFF7FF);
        if (this.jc_class.isAnnotation()) {
            this.jc_class.setAccessFlags(8704);
            this.jc_class.setSuperInterfaces(new String[0]);
            this.jc_class.setPublicSuperInterfaces(new String[0]);
            this.jc_class.setPublicSuperClasses(new String[0]);
            this.jc_class.setFields(new JcField[0]);
            this.jc_class.setMethods(new JcMethod[0]);
            this.jc_class.setPublicMethodTable(new JcMethodTable(new MethodDefinition[0], 0));
            this.jc_class.setPackageMethodTable(new JcMethodTable(new MethodDefinition[0], 0));
            return this.jc_class;
        }
        String[] stringArray = this.determineAllSuperInterfaces();
        this.jc_class.setSuperInterfaces(stringArray);
        String[] stringArray2 = this.determinePublicSuperInterfaces();
        this.jc_class.setPublicSuperInterfaces(stringArray2);
        this.detectRemovedPublicSuperinterfaces();
        if (!this.getPackageConverter().getConversionProfile().packageUpgrade) {
            this.detectAddedPublicSuperinterfaces();
        }
        boolean bl = this.determineShareableType();
        this.jc_class.setShareableType(bl);
        String[] stringArray3 = new String[]{this.java_class.getSuperClassName()};
        this.jc_class.setPublicSuperClasses(stringArray3);
        JField[] jFieldArray = this.java_class.getFields();
        JcField[] jcFieldArray = new JcField[jFieldArray.length];
        for (int i = 0; i < jFieldArray.length; ++i) {
            jcFieldArray[i] = new JcField(jFieldArray[i]);
            if (this.getJcClass().getEfClass() == null) continue;
            jcFieldArray[i].setEfField(this.getJcClass().getEfClass().getField(jFieldArray[i].getFieldName(), jFieldArray[i].getFieldDescriptor()));
        }
        this.jc_class.setFields(jcFieldArray);
        this.detectRemovedAPIFields();
        this.detectAddedAPIFields();
        this.checkFieldFlags();
        this.checkFieldValues();
        this.assignFieldTokens(jcFieldArray);
        JMethod[] jMethodArray = this.java_class.getMethods();
        int n2 = jMethodArray.length;
        for (JMethod jMethod : jMethodArray) {
            if (!jMethod.getMethodName().equals("<clinit>")) continue;
            ClinitConverter clinitConverter = new ClinitConverter(jMethod, this.jc_class);
            clinitConverter.convert();
            n2 = jMethodArray.length - 1;
            break;
        }
        MethodDefinition[] methodDefinitionArray = new JcMethod[n2];
        this.jc_class.setMethods((JcMethod[])methodDefinitionArray);
        int n3 = 0;
        int n4 = 1;
        for (n = 0; n < jMethodArray.length; ++n) {
            if (jMethodArray[n].getMethodName().equals("<clinit>")) continue;
            methodDefinitionArray[n3] = new JcMethod(jMethodArray[n]);
            if (!jMethodArray[n].throwsRemoteExceptionOrSuper()) {
                n4 = 0;
            }
            ((JcMethod)methodDefinitionArray[n3]).setLocalVariables(new JcLocalVariable[0]);
            ((JcMethod)methodDefinitionArray[n3]).setExceptions(new JcException[0]);
            ++n3;
        }
        if (this.jc_class.inheritsRemote()) {
            if (n4 != 0) {
                for (n = 0; n < methodDefinitionArray.length; ++n) {
                    methodDefinitionArray[n].setRemote(true);
                }
                this.jc_class.setRemote(true);
            } else {
                Object[] objectArray = new String[]{this.java_class.getClassName().replace('/', '.')};
                Notifier.warning("warning.10", objectArray);
                this.jc_class.setRemote(false);
            }
        }
        JcMethodTable jcMethodTable = this.constructPublicMethodTable();
        this.jc_class.setPublicMethodTable(jcMethodTable);
        this.assignMethodTokens();
        this.jc_class.setPackageMethodTable(new JcMethodTable(new MethodDefinition[0], 0));
        this.jc_class.setImplementedInterfaceInfos(new JcImplementedInterfaceInfo[0]);
        return this.jc_class;
    }

    private String[] determineAllSuperInterfaces() throws Exception {
        Object[] objectArray = this.java_class.getInterfaceNames();
        if (objectArray == null) {
            return new String[0];
        }
        Vector<String> vector = new Vector<String>(15);
        String string = Names.getPackageName(this.java_class.getClassName());
        for (String string2 : objectArray) {
            String[] stringArray;
            Object[] objectArray2;
            Object object;
            if (Names.getPackageName(string2).equals(string)) {
                object = this.p_converter.getJcClass(string2);
                if (object == null) {
                    objectArray2 = new String[]{this.java_class.getClassName().replace('/', '.'), string2.replace('/', '.')};
                    Notifier.error("linking.5", objectArray2);
                    throw new ConversionException();
                }
                stringArray = ((JcClass)object).getSuperInterfaces();
            } else {
                object = this.p_converter.getExportFileManager();
                objectArray2 = ((ExportFileManager)object).getClass(string2);
                if (objectArray2 == null) {
                    Object[] objectArray3 = new String[]{this.java_class.getClassName().replace('/', '.'), string2.replace('/', '.'), Names.getExportFileName(Names.getPackageName(string2))};
                    Notifier.error("linking.4", objectArray3);
                    throw new ConversionException();
                }
                stringArray = objectArray2.getInterfaceNames();
            }
            this.addInterfaces(vector, stringArray);
            this.addInterface(vector, string2);
        }
        Object[] objectArray4 = new String[vector.size()];
        vector.copyInto(objectArray4);
        return objectArray4;
    }

    /*
     * WARNING - void declaration
     */
    private JcMethodTable constructPublicMethodTable() throws Exception {
        Object object;
        String[] stringArray = this.java_class.getInterfaceNames();
        Vector<MethodDefinition> vector = new Vector<MethodDefinition>(20);
        String string = Names.getPackageName(this.java_class.getClassName());
        for (String string2 : stringArray) {
            void object2;
            if (Names.getPackageName(string2).equals(string)) {
                object = this.p_converter.getJcClass(string2);
                if (object == null) {
                    Object[] objectArray = new String[]{this.java_class.getClassName().replace('/', '.'), string2.replace('/', '.')};
                    Notifier.error("linking.5", objectArray);
                    throw new ConversionException();
                }
                MethodDefinition[] methodDefinitionArray = ((JcClass)object).getPublicMethodTable().getMethods();
            } else {
                object = this.getExportClass(string2);
                if (object == null) {
                    Object[] objectArray = new String[]{this.java_class.getClassName().replace('/', '.'), string2.replace('/', '.'), Names.getExportFileName(Names.getPackageName(string2))};
                    Notifier.error("linking.4", objectArray);
                    throw new ConversionException();
                }
                EfMethod[] efMethodArray = ((EfClass)object).getMethods();
            }
            for (Object object3 : object2) {
                MethodDefinition methodDefinition = new MethodDefinition((MethodDefinition)object3);
                this.addMethod(vector, methodDefinition);
            }
        }
        Object[] objectArray = this.jc_class.getMethods();
        for (Object object4 : objectArray) {
            object = new MethodDefinition((MethodDefinition)object4);
            this.addMethod(vector, (MethodDefinition)object4);
        }
        Object[] objectArray2 = new MethodDefinition[vector.size()];
        vector.copyInto(objectArray2);
        return new JcMethodTable((MethodDefinition[])objectArray2, 0);
    }

    private void addMethod(Vector<MethodDefinition> vector, MethodDefinition methodDefinition) {
        for (int i = 0; i < vector.size(); ++i) {
            MethodDefinition methodDefinition2 = vector.elementAt(i);
            if (!methodDefinition2.getMethodName().equals(methodDefinition.getMethodName()) || !methodDefinition2.getMethodDescriptor().equals(methodDefinition.getMethodDescriptor())) continue;
            return;
        }
        vector.addElement(methodDefinition);
    }

    private void assignMethodTokens() throws Exception {
        JcMethod[] jcMethodArray;
        MethodDefinition[] methodDefinitionArray = this.jc_class.getPublicMethodTable().getMethods();
        this.detectRemovedAPIMethods(methodDefinitionArray);
        this.detectAddedAPIMethods(methodDefinitionArray);
        this.assignKnownMethodTokens(methodDefinitionArray);
        InterfaceConverter.sortMethodsByTokens(methodDefinitionArray);
        InterfaceConverter.assignNewMethodTokens(methodDefinitionArray);
        for (JcMethod jcMethod : jcMethodArray = this.jc_class.getMethods()) {
            int n;
            for (n = 0; n < methodDefinitionArray.length; ++n) {
                MethodDefinition methodDefinition = methodDefinitionArray[n];
                if (!jcMethod.getMethodName().equals(methodDefinition.getMethodName()) || !jcMethod.getMethodDescriptor().equals(methodDefinition.getMethodDescriptor())) continue;
                jcMethod.setMethodToken(n);
                break;
            }
            if (n != methodDefinitionArray.length) continue;
            throw new ConversionException();
        }
    }

    private MethodDefinition[] getMethodsFromExportFile() throws Exception {
        String string = this.java_class.getClassName();
        EfClass efClass = this.getExportClass(string);
        if (efClass == null) {
            Object[] objectArray = new String[]{string.replace('/', '.'), string.replace('/', '.'), Names.getExportFileName(Names.getPackageName(string))};
            Notifier.error("linking.20", objectArray);
            throw new ConversionException();
        }
        MethodDefinition[] methodDefinitionArray = efClass.getMethods();
        for (int i = 0; i < methodDefinitionArray.length; ++i) {
            MethodDefinition methodDefinition = methodDefinitionArray[i];
            int n = methodDefinition.getMethodToken();
            if (i == n) continue;
            MethodDefinition methodDefinition2 = methodDefinitionArray[n];
            methodDefinitionArray[n] = methodDefinition;
            methodDefinitionArray[i] = methodDefinition2;
        }
        return methodDefinitionArray;
    }

    private void assignFieldTokens(JcField[] jcFieldArray) {
        this.assignKnownFieldTokens();
        this.presortFieldsByTokens();
        int n = 0;
        for (JcField jcField : jcFieldArray) {
            String string = jcField.getFieldDescriptor();
            if (DataType.getType(string) != 10) continue;
            jcField.setFieldToken(n++);
        }
    }

    private boolean isThisExpProvided() {
        int n = this.java_class.getAccessFlags();
        if (Modifier.isPublic(n)) {
            return this.p_converter.isThisExpProvided();
        }
        return false;
    }

    protected void detectRemovedAPIMethods(MethodDefinition[] methodDefinitionArray) throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        EfMethod[] efMethodArray = this.getJcClass().getEfClass().getMethods();
        for (int i = 0; i < efMethodArray.length; ++i) {
            EfMethod efMethod = efMethodArray[i];
            if (InterfaceConverter.findMethodInArray(methodDefinitionArray, efMethod.getMethodName(), efMethod.getMethodDescriptor()) != null) continue;
            Object[] objectArray = new Object[]{efMethod.getMethodDescriptor(), efMethod.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
            Notifier.error("binary.22", objectArray);
            throw new ConversionException();
        }
    }

    protected void detectAddedAPIMethods(MethodDefinition[] methodDefinitionArray) throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        for (int i = 0; i < methodDefinitionArray.length; ++i) {
            EfMethod efMethod = this.getJcClass().getEfClass().getMethod(methodDefinitionArray[i].getMethodName(), methodDefinitionArray[i].getMethodDescriptor());
            if (efMethod != null) continue;
            Object[] objectArray = new Object[]{methodDefinitionArray[i].getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
            Notifier.error("binary.39", objectArray);
            throw new ConversionException();
        }
    }

    private static void sortMethodsByTokens(MethodDefinition[] methodDefinitionArray) {
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int i = 0; i < methodDefinitionArray.length - 1; ++i) {
                if (methodDefinitionArray[i].getMethodToken() <= methodDefinitionArray[i + 1].getMethodToken()) continue;
                bl = true;
                MethodDefinition methodDefinition = methodDefinitionArray[i];
                methodDefinitionArray[i] = methodDefinitionArray[i + 1];
                methodDefinitionArray[i + 1] = methodDefinition;
            }
        }
    }

    private static void assignNewMethodTokens(MethodDefinition[] methodDefinitionArray) {
        for (int i = 0; i < methodDefinitionArray.length; ++i) {
            methodDefinitionArray[i].setMethodToken(i);
        }
    }

    private static MethodDefinition findMethodInArray(MethodDefinition[] methodDefinitionArray, String string, String string2) {
        for (int i = 0; i < methodDefinitionArray.length; ++i) {
            if (!methodDefinitionArray[i].getMethodName().equals(string) || !methodDefinitionArray[i].getMethodDescriptor().equals(string2)) continue;
            return methodDefinitionArray[i];
        }
        return null;
    }

    private void assignKnownMethodTokens(MethodDefinition[] methodDefinitionArray) {
        EfClass efClass = this.getJcClass().getEfClass();
        if (efClass == null) {
            for (int i = 0; i < methodDefinitionArray.length; ++i) {
                methodDefinitionArray[i].setMethodToken(255);
            }
            return;
        }
        for (int i = 0; i < methodDefinitionArray.length; ++i) {
            EfMethod efMethod = efClass.getMethod(methodDefinitionArray[i].getMethodName(), methodDefinitionArray[i].getMethodDescriptor());
            if (efMethod != null) {
                methodDefinitionArray[i].setMethodToken(efMethod.getMethodToken());
                continue;
            }
            methodDefinitionArray[i].setMethodToken(255);
        }
    }
}

