/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.ActionsManagerListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAStep;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ExpressionPool;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.JPDAStepImpl;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class RunIntoMethodActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener,
ActionsManagerListener {
    private static final Logger logger = Logger.getLogger(RunIntoMethodActionProvider.class.getName());
    private JPDADebuggerImpl debugger;
    private ActionsManager lastActionsManager;

    public RunIntoMethodActionProvider(ContextProvider lookupProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)lookupProvider.lookupFirst(null, JPDADebugger.class));
        this.debugger.addPropertyChangeListener("state", this);
        EditorContextBridge.getContext().addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void destroy() {
        this.debugger.removePropertyChangeListener("state", this);
        EditorContextBridge.getContext().removePropertyChangeListener((PropertyChangeListener)this);
    }

    static ActionsManager getCurrentActionsManager() {
        return DebuggerManager.getDebuggerManager().getCurrentEngine() == null ? DebuggerManager.getDebuggerManager().getActionsManager() : DebuggerManager.getDebuggerManager().getCurrentEngine().getActionsManager();
    }

    private ActionsManager getActionsManager() {
        ActionsManager current = RunIntoMethodActionProvider.getCurrentActionsManager();
        if (current != this.lastActionsManager) {
            if (this.lastActionsManager != null) {
                this.lastActionsManager.removeActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            }
            current.addActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            this.lastActionsManager = current;
        }
        return current;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setEnabled(ActionsManager.ACTION_RUN_INTO_METHOD, this.getActionsManager().isEnabled(ActionsManager.ACTION_CONTINUE) && this.debugger.getState() == 3 && EditorContextBridge.getContext().getCurrentLineNumber() >= 0 && EditorContextBridge.getContext().getCurrentURL().endsWith(".java"));
        if (this.debugger.getState() == 4) {
            this.destroy();
        }
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_RUN_INTO_METHOD);
    }

    public void doAction(Object action) {
        final String[] methodPtr = new String[1];
        final String[] urlPtr = new String[1];
        final String[] classPtr = new String[1];
        final int[] linePtr = new int[1];
        final int[] offsetPtr = new int[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    EditorContext context = EditorContextBridge.getContext();
                    methodPtr[0] = context.getSelectedMethodName();
                    linePtr[0] = context.getCurrentLineNumber();
                    offsetPtr[0] = EditorContextBridge.getCurrentOffset();
                    urlPtr[0] = context.getCurrentURL();
                    classPtr[0] = context.getCurrentClassName();
                }
            });
        }
        catch (InvocationTargetException ex) {
            ErrorManager.getDefault().notify(ex.getTargetException());
            return;
        }
        catch (InterruptedException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return;
        }
        final String method = methodPtr[0];
        if (method.length() < 1) {
            NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)NbBundle.getMessage(RunIntoMethodActionProvider.class, (String)"MSG_Put_cursor_on_some_method_call"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            return;
        }
        final int methodLine = linePtr[0];
        final int methodOffset = offsetPtr[0];
        final String url = urlPtr[0];
        String className = classPtr[0];
        VirtualMachine vm = this.debugger.getVirtualMachine();
        if (vm == null) {
            return;
        }
        JPDAThreadImpl ct = (JPDAThreadImpl)this.debugger.getCurrentThread();
        ThreadReference threadReference = ct.getThreadReference();
        ReferenceType clazz = null;
        String clazzName = null;
        try {
            if (ThreadReferenceWrapper.frameCount(threadReference) < 1) {
                return;
            }
            clazz = LocationWrapper.declaringType(StackFrameWrapper.location(ThreadReferenceWrapper.frame(threadReference, 0)));
            clazzName = ReferenceTypeWrapper.name(clazz);
        }
        catch (InternalExceptionWrapper ex) {
            return;
        }
        catch (ObjectCollectedExceptionWrapper ex) {
        }
        catch (InvalidStackFrameExceptionWrapper ex) {
        }
        catch (IncompatibleThreadStateException ex) {
        }
        catch (IllegalThreadStateExceptionWrapper ex) {
            return;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return;
        }
        if (clazz != null && (className == null || className.equals(clazzName))) {
            this.doAction(url, clazz, methodLine, methodOffset, method, true);
        } else {
            try {
                List<ReferenceType> classes = VirtualMachineWrapper.classesByName(vm, className);
                if (classes.size() > 0) {
                    this.doAction(url, classes.get(0), methodLine, methodOffset, method, true);
                    return;
                }
            }
            catch (InternalExceptionWrapper ex) {
                return;
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return;
            }
            final ClassLoadUnloadBreakpoint cbrkp = ClassLoadUnloadBreakpoint.create((String)className, (boolean)false, (int)1);
            cbrkp.setHidden(true);
            cbrkp.setSuspend(0);
            cbrkp.addJPDABreakpointListener(new JPDABreakpointListener(){

                public void breakpointReached(JPDABreakpointEvent event) {
                    DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)cbrkp);
                    RunIntoMethodActionProvider.this.doAction(url, event.getReferenceType(), methodLine, methodOffset, method, false);
                }
            });
            try {
                Method setSessionMethod = JPDABreakpoint.class.getDeclaredMethod("setSession", JPDADebugger.class);
                setSessionMethod.setAccessible(true);
                setSessionMethod.invoke((Object)cbrkp, new Object[]{this.debugger});
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)cbrkp);
            RunIntoMethodActionProvider.resume(this.debugger);
        }
    }

    private static void resume(JPDADebugger debugger) {
        if (debugger.getSuspend() == 1) {
            debugger.getCurrentThread().resume();
        } else {
            Session session = ((JPDADebuggerImpl)debugger).getSession();
            session.getEngineForLanguage("Java").getActionsManager().doAction(ActionsManager.ACTION_CONTINUE);
        }
    }

    private void doAction(String url, ReferenceType clazz, int methodLine, int methodOffset, String methodName, boolean doResume) {
        List<Object> locations = Collections.emptyList();
        try {
            while (methodLine > 0 && (locations = ReferenceTypeWrapper.locationsOfLine(clazz, methodLine)).isEmpty()) {
                --methodLine;
            }
        }
        catch (InternalExceptionWrapper aiex) {
            return;
        }
        catch (VMDisconnectedExceptionWrapper aiex) {
            return;
        }
        catch (ObjectCollectedExceptionWrapper aiex) {
            return;
        }
        catch (ClassNotPreparedExceptionWrapper aiex) {
        }
        catch (AbsentInformationException aiex) {
            ErrorManager.getDefault().notify(1, (Throwable)aiex);
        }
        logger.fine("doAction(" + url + ", " + clazz + ", " + methodLine + ", " + methodName + ") locations = " + locations);
        if (locations.isEmpty()) {
            String message = NbBundle.getMessage(RunIntoMethodActionProvider.class, (String)"MSG_RunIntoMeth_absentInfo", (Object)clazz.name());
            NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)message);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            return;
        }
        ExpressionPool.Expression expr = this.debugger.getExpressionPool().getExpressionAt((Location)locations.get(0), url);
        Location bpLocation = null;
        if (expr != null) {
            EditorContext.Operation[] ops = expr.getOperations();
            for (int i = 0; i < ops.length; ++i) {
                EditorContext.Operation op = ops[i];
                if (op.getMethodStartPosition().getOffset() > methodOffset || methodOffset > op.getMethodEndPosition().getOffset()) continue;
                bpLocation = expr.getLocations()[i];
                break;
            }
        }
        if (bpLocation == null) {
            bpLocation = (Location)locations.get(0);
        }
        RunIntoMethodActionProvider.doAction(this.debugger, methodName, bpLocation, false, doResume);
    }

    static boolean doAction(JPDADebuggerImpl debugger, String methodName, Location bpLocation, boolean setBoundaryStep) {
        return RunIntoMethodActionProvider.doAction(debugger, methodName, bpLocation, setBoundaryStep, true);
    }

    private static boolean doAction(final JPDADebuggerImpl debugger, final String methodName, Location bpLocation, boolean setBoundaryStep, boolean doResume) {
        JPDAThreadImpl t;
        boolean areWeOnTheLocation;
        CallStackFrame[] topFramePtr;
        final VirtualMachine vm = debugger.getVirtualMachine();
        if (vm == null) {
            return false;
        }
        final int line = LocationWrapper.lineNumber0(bpLocation, "Java");
        JPDAThreadImpl ct = (JPDAThreadImpl)debugger.getCurrentThread();
        if (ct == null) {
            return false;
        }
        try {
            topFramePtr = ct.getCallStack(0, 1);
        }
        catch (AbsentInformationException ex) {
            return false;
        }
        if (topFramePtr.length < 1) {
            return false;
        }
        CallStackFrameImpl csf = (CallStackFrameImpl)topFramePtr[0];
        try {
            areWeOnTheLocation = LocationWrapper.equals(StackFrameWrapper.location(csf.getStackFrame()), bpLocation);
            t = (JPDAThreadImpl)csf.getThread();
        }
        catch (InvalidStackFrameExceptionWrapper e) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper e) {
            return false;
        }
        catch (InternalExceptionWrapper e) {
            return false;
        }
        final boolean doFinishWhenMethodNotFound = setBoundaryStep;
        if (areWeOnTheLocation) {
            RunIntoMethodActionProvider.traceLineForMethod(debugger, ct.getThreadReference(), methodName, line, doFinishWhenMethodNotFound);
        } else {
            final JPDAStep[] boundaryStepPtr = new JPDAStep[]{null};
            try {
                final BreakpointRequest brReq = EventRequestManagerWrapper.createBreakpointRequest(VirtualMachineWrapper.eventRequestManager(vm), bpLocation);
                final ThreadReference preferredThread = t.getThreadReference();
                Executor tracingExecutor = new Executor(){

                    @Override
                    public boolean exec(Event event) {
                        ThreadReference tr = ((BreakpointEvent)event).thread();
                        try {
                            if (!preferredThread.equals(tr)) {
                                logger.fine("doAction: tracingExecutor.exec(" + event + ") called with non-preferred thread.");
                                for (int i = 20; !ThreadReferenceWrapper.isAtBreakpoint(preferredThread) && i > 0; --i) {
                                    try {
                                        Thread.sleep(50L);
                                        continue;
                                    }
                                    catch (InterruptedException ex) {
                                        break;
                                    }
                                }
                                if (ThreadReferenceWrapper.isAtBreakpoint(preferredThread) && ThreadReferenceWrapper.frameCount(tr) > 0) {
                                    Location prLoc;
                                    Location trLoc = StackFrameWrapper.location(ThreadReferenceWrapper.frame(tr, 0));
                                    if (ThreadReferenceWrapper.frameCount(preferredThread) > 0 && ((Object)trLoc).equals(prLoc = StackFrameWrapper.location(ThreadReferenceWrapper.frame(preferredThread, 0)))) {
                                        logger.fine("doAction: tracingExecutor - preferredThread " + preferredThread + " is at breakpoint, resuming hit thread " + tr);
                                        return true;
                                    }
                                }
                            }
                        }
                        catch (InternalExceptionWrapper iex) {
                        }
                        catch (InternalException iex) {
                        }
                        catch (VMDisconnectedExceptionWrapper vdex) {
                        }
                        catch (VMDisconnectedException vdex) {
                        }
                        catch (ObjectCollectedExceptionWrapper ocex) {
                        }
                        catch (ObjectCollectedException ocex) {
                        }
                        catch (IllegalThreadStateExceptionWrapper itex) {
                        }
                        catch (IllegalThreadStateException itex) {
                        }
                        catch (IncompatibleThreadStateException itex) {
                        }
                        catch (InvalidStackFrameExceptionWrapper isex) {
                            // empty catch block
                        }
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("doAction: tracingExecutor.exec(" + event + ") called with thread " + tr + " which is " + (preferredThread.equals(tr) ? "" : "not ") + "preferred.");
                            logger.fine("Calling location reached, tracing for " + methodName + "()");
                        }
                        if (boundaryStepPtr[0] != null) {
                            ((JPDAStepImpl)boundaryStepPtr[0]).cancel();
                        }
                        try {
                            try {
                                EventRequestManagerWrapper.deleteEventRequest(VirtualMachineWrapper.eventRequestManager(vm), brReq);
                            }
                            catch (InvalidRequestStateExceptionWrapper ex) {
                                // empty catch block
                            }
                            debugger.getOperator().unregister(brReq);
                        }
                        catch (InternalExceptionWrapper e) {
                        }
                        catch (VMDisconnectedExceptionWrapper e) {
                            return false;
                        }
                        RunIntoMethodActionProvider.traceLineForMethod(debugger, tr, methodName, line, doFinishWhenMethodNotFound);
                        return true;
                    }

                    @Override
                    public void removed(EventRequest eventRequest) {
                    }
                };
                debugger.getOperator().register(brReq, tracingExecutor);
                EventRequestWrapper.setSuspendPolicy(brReq, debugger.getSuspend());
                try {
                    EventRequestWrapper.enable(brReq);
                }
                catch (ObjectCollectedExceptionWrapper ocex) {
                    debugger.getOperator().unregister(brReq);
                    return false;
                }
                catch (InvalidRequestStateExceptionWrapper irse) {
                    Exceptions.printStackTrace((Throwable)irse);
                    debugger.getOperator().unregister(brReq);
                    return false;
                }
                if (setBoundaryStep) {
                    boundaryStepPtr[0] = RunIntoMethodActionProvider.setBoundaryStepRequest(debugger, t, brReq);
                }
            }
            catch (VMDisconnectedExceptionWrapper e) {
                return false;
            }
            catch (InternalExceptionWrapper e) {
                return false;
            }
        }
        if (doResume) {
            RunIntoMethodActionProvider.resume(debugger);
        }
        return true;
    }

    private static JPDAStep setBoundaryStepRequest(final JPDADebuggerImpl debugger, JPDAThread tr, final EventRequest request) {
        JPDAStep boundaryStep = debugger.createJPDAStep(-2, 2);
        boundaryStep.addPropertyChangeListener("exec", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                VirtualMachine vm = debugger.getVirtualMachine();
                if (vm != null) {
                    try {
                        debugger.getOperator().unregister(request);
                        EventRequestManagerWrapper.deleteEventRequest(VirtualMachineWrapper.eventRequestManager(vm), request);
                    }
                    catch (InternalExceptionWrapper ex) {
                    }
                    catch (VMDisconnectedExceptionWrapper ex) {
                    }
                    catch (InvalidRequestStateExceptionWrapper invalidRequestStateExceptionWrapper) {
                        // empty catch block
                    }
                }
            }
        });
        boundaryStep.addStep(tr);
        return boundaryStep;
    }

    private static void traceLineForMethod(final JPDADebuggerImpl debugger, ThreadReference tr, final String method, final int methodLine, final boolean finishWhenNotFound) {
        final JPDAThreadImpl jtr = debugger.getThread(tr);
        final int depth = jtr.getStackDepth();
        final JPDAStep step = debugger.createJPDAStep(-2, 1);
        step.setHidden(true);
        step.addPropertyChangeListener("exec", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                block12: {
                    if (Logger.getLogger(RunIntoMethodActionProvider.class.getName()).isLoggable(Level.FINE)) {
                        logger.fine("traceLineForMethod(" + method + ") step is at " + debugger.getCurrentThread().getClassName() + ":" + debugger.getCurrentThread().getMethodName());
                    }
                    int currentDepth = jtr.getStackDepth();
                    logger.fine("  depth = " + currentDepth + ", target = " + depth);
                    if (currentDepth == depth) {
                        try {
                            if (jtr.getCallStack()[0].getLineNumber("Java") != methodLine) {
                                step.setHidden(false);
                                break block12;
                            }
                            logger.fine("  back on the method invoaction line, setting additional step into.");
                            step.setDepth(1);
                            step.addStep(debugger.getCurrentThread());
                        }
                        catch (AbsentInformationException aiex) {
                            ErrorManager.getDefault().notify(1, (Throwable)aiex);
                            step.setHidden(false);
                        }
                    } else if (jtr.getMethodName().equals(method)) {
                        step.setHidden(false);
                    } else if (jtr.getMethodName().equals("<init>") && (jtr.getClassName().endsWith("." + method) || jtr.getClassName().equals(method))) {
                        step.setHidden(false);
                    } else if (finishWhenNotFound) {
                        step.setHidden(false);
                    } else {
                        step.setDepth(3);
                        step.addStep(debugger.getCurrentThread());
                    }
                }
            }
        });
        step.addStep((JPDAThread)jtr);
    }

    public void actionPerformed(Object action) {
    }

    public void actionStateChanged(Object action, boolean enabled) {
        if (ActionsManager.ACTION_CONTINUE == action) {
            this.setEnabled(ActionsManager.ACTION_RUN_INTO_METHOD, enabled && this.debugger.getState() == 3 && EditorContextBridge.getContext().getCurrentLineNumber() >= 0 && EditorContextBridge.getContext().getCurrentURL().endsWith(".java"));
        }
    }
}

