/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.modules.maven.api.CommonArtifactActions;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.embedder.exec.ProgressTransferListener;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryUtil;
import org.netbeans.modules.maven.indexer.api.ui.ArtifactViewer;
import org.netbeans.modules.maven.repository.Bundle;
import org.netbeans.modules.maven.repository.dependency.AddAsDependencyAction;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.openide.actions.CopyAction;
import org.openide.actions.OpenAction;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.ExTransferable;

public class VersionNode
extends AbstractNode {
    private static final String JAVADOC_BADGE_ICON = "org/netbeans/modules/maven/repository/DependencyJavadocIncluded.png";
    private static final String SOURCE_BADGE_ICON = "org/netbeans/modules/maven/repository/DependencySrcIncluded.png";
    private static final RequestProcessor RP = new RequestProcessor(VersionNode.class);
    private NBVersionInfo record;
    private boolean hasJavadoc;
    private boolean hasSources;
    private RepositoryInfo info;
    private FileObject localArtifact;
    private static String toolTipJavadoc = "<img src=\"" + VersionNode.class.getClassLoader().getResource("org/netbeans/modules/maven/repository/DependencyJavadocIncluded.png") + "\">&nbsp;" + NbBundle.getMessage(VersionNode.class, (String)"ICON_JavadocBadge");
    private static String toolTipSource = "<img src=\"" + VersionNode.class.getClassLoader().getResource("org/netbeans/modules/maven/repository/DependencySrcIncluded.png") + "\">&nbsp;" + NbBundle.getMessage(VersionNode.class, (String)"ICON_SourceBadge");

    private static FileObject findLocalArtifact(RepositoryInfo info, NBVersionInfo record) {
        return FileUtil.toFileObject((File)FileUtilities.convertArtifactToLocalRepositoryFile((Artifact)RepositoryUtil.createArtifact((NBVersionInfo)record)));
    }

    private static Children createChildren(FileObject fo) {
        if (fo != null) {
            try {
                Node n = DataObject.find((FileObject)fo).getNodeDelegate();
                if (!n.isLeaf()) {
                    return new FilterNode.Children(n);
                }
            }
            catch (DataObjectNotFoundException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
        return Children.LEAF;
    }

    public VersionNode(RepositoryInfo info, NBVersionInfo versionInfo, boolean javadoc, boolean source, boolean dispNameShort) {
        this(info, versionInfo, VersionNode.findLocalArtifact(info, versionInfo), javadoc, source, dispNameShort);
    }

    private VersionNode(RepositoryInfo info, NBVersionInfo versionInfo, FileObject localArtifact, boolean javadoc, boolean source, boolean dispNameShort) {
        super(VersionNode.createChildren(localArtifact));
        this.info = info;
        this.hasJavadoc = javadoc;
        this.hasSources = source;
        this.record = versionInfo;
        if (dispNameShort) {
            this.setName(versionInfo.getVersion());
            this.setDisplayName(versionInfo.getVersion() + " [ " + (versionInfo.getType() != null ? versionInfo.getType() : "jar") + (versionInfo.getClassifier() != null ? "," + versionInfo.getClassifier() : "") + " ]");
        } else {
            this.setName(versionInfo.getGroupId() + ":" + versionInfo.getArtifactId() + ":" + versionInfo.getVersion());
        }
        this.setIconBaseWithExtension("org/netbeans/modules/maven/repository/DependencyJar.gif");
        this.setLocalArtifact(localArtifact);
    }

    private void setLocalArtifact(FileObject localArtifact) {
        if (localArtifact != null && localArtifact.isData()) {
            try {
                OpenCookie oc = (OpenCookie)DataObject.find((FileObject)NodeUtils.readOnlyLocalRepositoryFile((FileObject)localArtifact)).getLookup().lookup(OpenCookie.class);
                if (oc != null) {
                    this.getCookieSet().add((Node.Cookie)oc);
                }
            }
            catch (DataObjectNotFoundException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
        this.localArtifact = localArtifact;
    }

    public boolean canCopy() {
        return true;
    }

    public Transferable clipboardCopy() throws IOException {
        Transferable deflt = super.clipboardCopy();
        ExTransferable enriched = ExTransferable.create((Transferable)deflt);
        ExTransferable.Single ex = new ExTransferable.Single(DataFlavor.stringFlavor){

            protected Object getData() {
                return "<dependency>\n  <groupId>" + VersionNode.this.record.getGroupId() + "</groupId>\n" + "  <artifactId>" + VersionNode.this.record.getArtifactId() + "</artifactId>\n" + "  <version>" + VersionNode.this.record.getVersion() + "</version>\n" + "</dependency>";
            }
        };
        enriched.put(ex);
        return enriched;
    }

    public Action[] getActions(boolean context) {
        Artifact artifact = RepositoryUtil.createArtifact((NBVersionInfo)this.record);
        ArrayList<Action> actions = new ArrayList<Action>(5);
        actions.add(new ShowArtifactAction(this.record));
        actions.add(new AddAsDependencyAction(artifact));
        actions.add(CommonArtifactActions.createFindUsages((Artifact)artifact));
        if (this.info.isLocal()) {
            actions.add(CommonArtifactActions.createViewJavadocAction((Artifact)artifact));
        }
        if (this.getLookup().lookup(OpenCookie.class) != null) {
            actions.add((Action)OpenAction.get(OpenAction.class));
        }
        if (this.localArtifact == null && this.info.isRemoteDownloadable()) {
            actions.add(new DownloadAction(artifact));
        }
        actions.add((Action)CopyAction.get(CopyAction.class));
        return actions.toArray(new Action[actions.size()]);
    }

    public Action getPreferredAction() {
        return new ShowArtifactAction(this.record);
    }

    public Image getIcon(int param) {
        Image ann;
        Image retValue = super.getIcon(param);
        if (this.hasJavadoc) {
            ann = ImageUtilities.loadImage((String)JAVADOC_BADGE_ICON);
            ann = ImageUtilities.addToolTipToImage((Image)ann, (String)toolTipJavadoc);
            retValue = ImageUtilities.mergeImages((Image)retValue, (Image)ann, (int)12, (int)0);
        }
        if (this.hasSources) {
            ann = ImageUtilities.loadImage((String)SOURCE_BADGE_ICON);
            ann = ImageUtilities.addToolTipToImage((Image)ann, (String)toolTipSource);
            retValue = ImageUtilities.mergeImages((Image)retValue, (Image)ann, (int)12, (int)8);
        }
        return retValue;
    }

    public Image getOpenedIcon(int param) {
        return this.getIcon(param);
    }

    public String getShortDescription() {
        StringBuffer buffer = new StringBuffer();
        if (this.record != null) {
            buffer.append("<html>").append(NbBundle.getMessage(VersionNode.class, (String)"TXT_GroupId")).append("<b>").append(this.record.getGroupId()).append("</b><p>");
            buffer.append(NbBundle.getMessage(VersionNode.class, (String)"TXT_ArtifactId")).append("<b>").append(this.record.getArtifactId()).append("</b><p>");
            buffer.append(NbBundle.getMessage(VersionNode.class, (String)"TXT_Version")).append("<b>").append(this.record.getVersion().toString()).append("</b><p>");
            buffer.append(NbBundle.getMessage(VersionNode.class, (String)"TXT_Packaging")).append("<b>").append(this.record.getPackaging()).append("</b><p>");
            buffer.append(NbBundle.getMessage(VersionNode.class, (String)"TXT_Name")).append(this.record.getProjectName()).append("<p>");
        }
        return buffer.toString();
    }

    private class DownloadAction
    extends AbstractAction {
        private final Artifact art;

        public DownloadAction(Artifact art) {
            super(Bundle.DownloadAction_label());
            this.art = art;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
                    AggregateProgressHandle hndl = AggregateProgressFactory.createHandle((String)Bundle.DownloadAction_downloading(DownloadAction.this.art.getId()), (ProgressContributor[])new ProgressContributor[]{AggregateProgressFactory.createProgressContributor((String)"")}, (Cancellable)ProgressTransferListener.cancellable(), null);
                    ProgressTransferListener.setAggregateHandle((AggregateProgressHandle)hndl);
                    try {
                        hndl.start();
                        online.resolve(DownloadAction.this.art, Collections.singletonList(EmbedderFactory.createRemoteRepository((MavenEmbedder)online, (String)VersionNode.this.info.getRepositoryUrl(), (String)VersionNode.this.info.getId())), online.getLocalRepository());
                    }
                    catch (ThreadDeath d) {
                        return;
                    }
                    catch (AbstractArtifactResolutionException x) {
                        return;
                    }
                    finally {
                        hndl.finish();
                        ProgressTransferListener.clearAggregateHandle();
                    }
                    RepositoryInfo local = RepositoryPreferences.getInstance().getRepositoryInfoById("local");
                    if (local != null) {
                        RepositoryIndexer.updateIndexWithArtifacts((RepositoryInfo)local, Collections.singletonList(DownloadAction.this.art));
                    }
                    VersionNode.this.setLocalArtifact(VersionNode.findLocalArtifact(VersionNode.this.info, VersionNode.this.record));
                    VersionNode.this.setChildren(VersionNode.createChildren(VersionNode.this.localArtifact));
                }
            });
        }
    }

    private static class ShowArtifactAction
    extends AbstractAction {
        private NBVersionInfo info;

        ShowArtifactAction(NBVersionInfo info) {
            this.info = info;
            this.putValue("Name", NbBundle.getMessage(VersionNode.class, (String)"ACT_View_Details"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArtifactViewer.showArtifactViewer((NBVersionInfo)this.info);
        }
    }
}

