/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.ActionMouseCursor;
import org.netbeans.modules.mobility.svgcore.composer.ComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.ComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SVGObjectOutline;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;

public class ScaleActionFactory
extends AbstractComposerActionFactory {
    private static final ActionMouseCursor SCALE_NW_MOUSE_CURSOR = new ActionMouseCursor(6, 3);
    private static final ActionMouseCursor SCALE_SE_MOUSE_CURSOR = new ActionMouseCursor(5, 3);

    public ScaleActionFactory(SceneManager sceneMgr) {
        super(sceneMgr);
    }

    @Override
    public synchronized ComposerAction startAction(AWTEvent e, boolean isOutsideEvent) {
        MouseEvent me;
        SVGObject selObj;
        if (!isOutsideEvent && !this.m_sceneMgr.isReadOnly() && e.getID() == 501 && (selObj = this.getObjectToScaleAt(me = (MouseEvent)e)) != null) {
            return new ScaleAction(this, selObj, me);
        }
        return null;
    }

    @Override
    public ActionMouseCursor getMouseCursor(MouseEvent evt, boolean isOutsideEvent) {
        SVGObject selObj = this.getSelectedObject();
        if (!isOutsideEvent && selObj != null) {
            if (this.isNWScalePoint(selObj, evt)) {
                return SCALE_NW_MOUSE_CURSOR;
            }
            if (this.isSEScalePoint(selObj, evt)) {
                return SCALE_SE_MOUSE_CURSOR;
            }
        }
        return null;
    }

    private SVGObject getObjectToScaleAt(MouseEvent me) {
        SVGObject selObj = this.getSelectedObject();
        if (selObj != null && (this.isNWScalePoint(selObj, me) || this.isSEScalePoint(selObj, me))) {
            return selObj;
        }
        return null;
    }

    protected SVGObject getSelectedObject() {
        SVGObject[] selectedObjects = this.m_sceneMgr.getSelected();
        if (selectedObjects != null && selectedObjects.length > 0) {
            return selectedObjects[0];
        }
        return null;
    }

    private boolean isNWScalePoint(SVGObject selObj, MouseEvent me) {
        return selObj.getOutline().isAtScaleNWHandlePoint(me.getX(), me.getY());
    }

    private boolean isSEScalePoint(SVGObject selObj, MouseEvent me) {
        return selObj.getOutline().isAtScaleSEHandlePoint(me.getX(), me.getY());
    }

    protected static class ScaleAction
    extends AbstractComposerAction {
        protected final SVGObject m_scaled;
        protected final SVGObject.ScalePivotPoint m_scalePtIdx;
        private final int m_x;
        private final int m_y;
        private final float[] pt;

        public ScaleAction(ComposerActionFactory factory, SVGObject selected, MouseEvent me) {
            super(factory);
            this.m_scaled = selected;
            this.m_x = me.getX();
            this.m_y = me.getY();
            this.pt = this.m_scaled.getOutline().getScalePivotPoint(this.m_x, this.m_y);
            this.m_scalePtIdx = this.getScalePivotPoint(this.m_scaled, this.m_x, this.m_y);
        }

        @Override
        public boolean consumeEvent(AWTEvent evt, boolean isOutsideEvent) {
            if (!isOutsideEvent && evt.getID() == 506) {
                MouseEvent me = (MouseEvent)evt;
                Rectangle bBox = this.m_scaled.getScreenBBox();
                this.m_scaled.scale(this.calculateScaleX(me.getX()), this.calculateScaleY(me.getY()), this.m_scalePtIdx);
                bBox.add(this.m_scaled.getScreenBBox());
                this.m_factory.getSceneManager().getScreenManager().repaint(bBox, 5);
            } else if (evt.getID() == 502) {
                this.actionCompleted();
                this.m_scaled.commitChanges();
            }
            return false;
        }

        @Override
        public ActionMouseCursor getMouseCursor(boolean isOutsideEvent) {
            return isOutsideEvent ? null : SCALE_SE_MOUSE_CURSOR;
        }

        @Override
        public synchronized void actionCompleted() {
            this.m_scaled.repaint(5);
            this.m_scaled.applyTextChanges();
            this.m_scaled.commitChanges();
            if (this.getScreenManager().getShowAllArea()) {
                this.getScreenManager().refresh();
            }
            super.actionCompleted();
        }

        protected float calculateScaleX(int x) {
            return this.calculateScale(this.pt[0], this.m_x, x);
        }

        protected float calculateScaleY(int y) {
            return this.calculateScale(this.pt[1], this.m_y, y);
        }

        private float calculateScale(float pivot, float from, float to) {
            float d1 = pivot - from;
            float d2 = pivot - to;
            return d2 / d1;
        }

        private SVGObject.ScalePivotPoint getScalePivotPoint(SVGObject selObj, float x, float y) {
            SVGObjectOutline outline = selObj.getOutline();
            if (outline.isAtScaleSEHandlePoint(x, y) || outline.isAtScaleEHandlePoint(x, y) || outline.isAtScaleSHandlePoint(x, y)) {
                return SVGObject.ScalePivotPoint.NW_CORNER;
            }
            return SVGObject.ScalePivotPoint.SE_CORNER;
        }
    }
}

