/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.navigator;

import java.awt.Component;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.mobility.svgcore.model.SVGFileModel;
import org.netbeans.modules.mobility.svgcore.navigator.SVGNavigatorNode;
import org.netbeans.modules.mobility.svgcore.navigator.SVGNavigatorTree;
import org.openide.awt.HtmlRenderer;
import org.openide.util.ImageUtilities;

class SVGNavigatorTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final String TAG_16 = "org/netbeans/modules/xml/text/navigator/resources/tag.png";
    private static final String ERROR_16 = "org/netbeans/modules/xml/text/navigator/resources/badge_error.png";
    private static final String ANIMATE_16 = "org/netbeans/modules/mobility/svgcore/resources/badge_animate.png";
    private static final String TAG_GRAY_16 = "org/netbeans/modules/mobility/svgcore/resources/tag_gray.png";
    private final Image ERROR_IMAGE = ImageUtilities.loadImage((String)"org/netbeans/modules/xml/text/navigator/resources/badge_error.png", (boolean)true);
    private final Image ANIMATE_IMAGE = ImageUtilities.loadImage((String)"org/netbeans/modules/mobility/svgcore/resources/badge_animate.png", (boolean)true);
    private final Icon[] TAG_GRAY_ICON = new Icon[]{this.getImageIcon("org/netbeans/modules/mobility/svgcore/resources/tag_gray.png", false), this.getImageIcon("org/netbeans/modules/mobility/svgcore/resources/tag_gray.png", true)};
    private final Icon[] TAG_ICON = new Icon[]{this.getImageIcon("org/netbeans/modules/xml/text/navigator/resources/tag.png", false), this.getImageIcon("org/netbeans/modules/xml/text/navigator/resources/tag.png", true)};
    private final Icon[] ANIMATE_TAG_ICON = new Icon[]{new ImageIcon(ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/xml/text/navigator/resources/tag.png"), (Image)this.ANIMATE_IMAGE, (int)5, (int)3)), this.TAG_ICON[1]};
    private final HtmlRenderer.Renderer renderer = HtmlRenderer.createRenderer();

    public SVGNavigatorTreeCellRenderer() {
        this.renderer.setHtml(true);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        boolean containsError;
        SVGNavigatorNode tna = (SVGNavigatorNode)value;
        DocumentElement de = tna.getDocumentElement();
        String htmlText = tna.getText(true);
        Component comp = this.renderer.getTreeCellRendererComponent(tree, (Object)htmlText, sel, expanded, leaf, row, hasFocus);
        comp.setEnabled(tree.isEnabled());
        ((JLabel)comp).setToolTipText(tna.getToolTipText().trim().length() > 0 ? tna.getToolTipText() : null);
        boolean bl = containsError = tna.getChildrenErrorCount() > 0;
        if (tna.getNodeVisibility() == SVGNavigatorTree.VISIBILITY_UNDIRECT) {
            this.setIcon(this.TAG_GRAY_ICON, containsError);
        } else if (SVGNavigatorTree.isTreeElement(de)) {
            if (SVGFileModel.isAnimation(de)) {
                this.setIcon(this.ANIMATE_TAG_ICON, containsError);
            } else {
                this.setIcon(this.TAG_ICON, containsError);
            }
        }
        return comp;
    }

    private void setIcon(Icon[] icons, boolean containsError) {
        this.renderer.setIcon(icons[containsError ? 1 : 0]);
    }

    private ImageIcon getImageIcon(String name, boolean error) {
        ImageIcon icon = ImageUtilities.loadImageIcon((String)name, (boolean)false);
        if (error) {
            return new ImageIcon(ImageUtilities.mergeImages((Image)icon.getImage(), (Image)this.ERROR_IMAGE, (int)15, (int)7));
        }
        return icon;
    }
}

