/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets.mojarra;

import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.facelets.util.ReflectionUtil;
import com.sun.faces.util.FacesLogger;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.servlet.ServletContext;
import org.netbeans.modules.web.jsf.editor.facelets.AbstractFaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.CompositeComponentLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrarySupport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FaceletsTaglibConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String LIBRARY_CLASS = "library-class";
    private static final String TAGLIB_NAMESPACE = "namespace";
    private static final String TAG = "tag";
    private static final String FUNCTION = "function";
    private static final String TAG_NAME = "tag-name";
    private static final String COMPONENT = "component";
    private static final String VALIDATOR = "validator";
    private static final String CONVERTER = "converter";
    private static final String BEHAVIOR = "behavior";
    private static final String SOURCE = "source";
    private static final String HANDLER_CLASS = "handler-class";
    private static final String VALIDATOR_ID = "validator-id";
    private static final String CONVERTER_ID = "converter-id";
    private static final String BEHAVIOR_ID = "behavior-id";
    private static final String COMPONENT_TYPE = "component-type";
    private static final String RENDERER_TYPE = "renderer-type";
    private static final String FUNCTION_NAME = "function-name";
    private static final String FUNCTION_CLASS = "function-class";
    private static final String FUNCTION_SIGNATURE = "function-signature";
    private static final String COMPOSITE_LIBRARY_NAME = "composite-library-name";
    private static final String ATTRIBUTE_NAME = "attribute";
    public FaceletsLibrarySupport.Compiler compiler = new FaceletsLibrarySupport.Compiler();
    private FaceletsLibrarySupport support;

    public FaceletsTaglibConfigProcessor(FaceletsLibrarySupport faceletsLibrarySupport) {
        this.support = faceletsLibrarySupport;
    }

    protected Class<?> loadClass(String string, Object object, Class<?> clazz) {
        try {
            return super.loadClass(string, object, clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return null;
    }

    public void process(ServletContext servletContext, DocumentInfo[] documentInfoArray) {
        int n = documentInfoArray.length;
        for (int i = 0; i < n; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing facelet-taglibrary document: ''{0}''", documentInfoArray[i].getDocument().getDocumentURI()));
            }
            String string = documentInfoArray[i].getDocument().getDocumentElement().getNamespaceURI();
            Element element = documentInfoArray[i].getDocument().getDocumentElement();
            NodeList nodeList = element.getElementsByTagNameNS(string, LIBRARY_CLASS);
            if (nodeList != null && nodeList.getLength() > 0) {
                this.processTaglibraryClass(nodeList, this.compiler);
                continue;
            }
            this.processTagLibrary(documentInfoArray[i], element, string, this.compiler);
        }
    }

    private void processTaglibraryClass(NodeList nodeList, FaceletsLibrarySupport.Compiler compiler) {
    }

    private void processTagLibrary(DocumentInfo documentInfo, Element element, String string, FaceletsLibrarySupport.Compiler compiler) {
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null && nodeList.getLength() > 0) {
            URL uRL;
            Object object;
            String string2 = null;
            String string3 = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                object = nodeList.item(i);
                if (TAGLIB_NAMESPACE.equals(object.getLocalName())) {
                    string2 = this.getNodeText((Node)object);
                    continue;
                }
                if (!COMPOSITE_LIBRARY_NAME.equals(object.getLocalName())) continue;
                string3 = this.getNodeText((Node)object);
            }
            try {
                uRL = documentInfo.getSourceURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                LOGGER.log(Level.INFO, null, malformedURLException);
                return;
            }
            NodeList nodeList2 = element.getElementsByTagNameNS(string, TAG);
            object = string3 != null ? new CompositeComponentLibrary(this.support, string3, string2, uRL) : new FaceletsLibrary(this.support, string2, uRL);
            this.processTags(element, nodeList2, (FaceletsLibrary)object);
            compiler.addTagLibrary((AbstractFaceletsLibrary)object);
        }
    }

    private void processTags(Element element, NodeList nodeList, FaceletsLibrary faceletsLibrary) {
        if (nodeList != null && nodeList.getLength() > 0) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                NodeList nodeList2 = node.getChildNodes();
                String string = null;
                NodeList nodeList3 = null;
                NodeList nodeList4 = null;
                NodeList nodeList5 = null;
                NodeList nodeList6 = null;
                Node node2 = null;
                Node node3 = null;
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Node node4 = nodeList2.item(j);
                    if (TAG_NAME.equals(node4.getLocalName())) {
                        string = this.getNodeText(node4);
                        continue;
                    }
                    if (COMPONENT.equals(node4.getLocalName())) {
                        nodeList3 = node4.getChildNodes();
                        continue;
                    }
                    if (CONVERTER.equals(node4.getLocalName())) {
                        nodeList4 = node4.getChildNodes();
                        continue;
                    }
                    if (VALIDATOR.equals(node4.getLocalName())) {
                        nodeList5 = node4.getChildNodes();
                        continue;
                    }
                    if (BEHAVIOR.equals(node4.getLocalName())) {
                        nodeList6 = node4.getChildNodes();
                        continue;
                    }
                    if (SOURCE.equals(node4.getLocalName())) {
                        node2 = node4;
                        continue;
                    }
                    if (!HANDLER_CLASS.equals(node4.getLocalName())) continue;
                    node3 = node4;
                }
                if (nodeList3 != null) {
                    this.processComponent(nodeList3, faceletsLibrary, string);
                    continue;
                }
                if (nodeList4 != null) {
                    this.processConverter(nodeList4, faceletsLibrary, string);
                    continue;
                }
                if (nodeList5 != null) {
                    this.processValidator(nodeList5, faceletsLibrary, string);
                    continue;
                }
                if (nodeList6 != null) {
                    this.processBehavior(nodeList6, faceletsLibrary, string);
                    continue;
                }
                if (node2 != null) {
                    this.processSource(element, node2, faceletsLibrary, string);
                    continue;
                }
                if (node3 == null) continue;
                this.processHandlerClass(node3, faceletsLibrary, string);
            }
        }
    }

    private void processBehavior(NodeList nodeList, FaceletsLibrary faceletsLibrary, String string) {
        if (nodeList != null && nodeList.getLength() > 0) {
            String string2 = null;
            String string3 = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (BEHAVIOR_ID.equals(node.getLocalName())) {
                    string2 = this.getNodeText(node);
                    continue;
                }
                if (!HANDLER_CLASS.equals(node.getLocalName())) continue;
                string3 = this.getNodeText(node);
            }
            if (string3 != null) {
                Class<?> clazz = this.loadClass(string3, (Object)this, null);
                faceletsLibrary.putBehavior(string, string2, clazz);
            } else {
                faceletsLibrary.putBehavior(string, string2);
            }
        }
    }

    private void processHandlerClass(Node node, FaceletsLibrary faceletsLibrary, String string) {
        String string2 = this.getNodeText(node);
        if (string2 == null) {
            return;
        }
        Class<?> clazz = this.loadClass(string2, (Object)this, null);
        faceletsLibrary.putTagHandler(string, clazz);
    }

    private void processSource(Element element, Node node, FaceletsLibrary faceletsLibrary, String string) {
        String string2 = element.getOwnerDocument().getDocumentURI();
        String string3 = this.getNodeText(node);
        if (string3 == null) {
            return;
        }
        try {
            URL uRL = new URL(new URL(string2), string3);
            faceletsLibrary.putUserTag(string, uRL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new FacesException((Throwable)malformedURLException);
        }
    }

    private void processValidator(NodeList nodeList, FaceletsLibrary faceletsLibrary, String string) {
        if (nodeList != null && nodeList.getLength() > 0) {
            String string2 = null;
            String string3 = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (VALIDATOR_ID.equals(node.getLocalName())) {
                    string2 = this.getNodeText(node);
                    continue;
                }
                if (!HANDLER_CLASS.equals(node.getLocalName())) continue;
                string3 = this.getNodeText(node);
            }
            if (string3 != null) {
                Class<?> clazz = this.loadClass(string3, (Object)this, null);
                faceletsLibrary.putValidator(string, string2, clazz);
            } else {
                faceletsLibrary.putValidator(string, string2);
            }
        }
    }

    private void processConverter(NodeList nodeList, FaceletsLibrary faceletsLibrary, String string) {
        if (nodeList != null && nodeList.getLength() > 0) {
            String string2 = null;
            String string3 = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (CONVERTER_ID.equals(node.getLocalName())) {
                    string2 = this.getNodeText(node);
                    continue;
                }
                if (!HANDLER_CLASS.equals(node.getLocalName())) continue;
                string3 = this.getNodeText(node);
            }
            if (string3 != null) {
                Class<?> clazz = this.loadClass(string3, (Object)this, null);
                faceletsLibrary.putConverter(string, string2, clazz);
            } else {
                faceletsLibrary.putConverter(string, string2);
            }
        }
    }

    private void processComponent(NodeList nodeList, FaceletsLibrary faceletsLibrary, String string) {
        if (nodeList != null && nodeList.getLength() > 0) {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (COMPONENT_TYPE.equals(node.getLocalName())) {
                    string2 = this.getNodeText(node);
                    continue;
                }
                if (RENDERER_TYPE.equals(node.getLocalName())) {
                    string3 = this.getNodeText(node);
                    continue;
                }
                if (!HANDLER_CLASS.equals(node.getLocalName())) continue;
                string4 = this.getNodeText(node);
            }
            if (string4 != null) {
                Class<?> clazz = this.loadClass(string4, (Object)this, null);
                faceletsLibrary.putComponent(string, string2, string3, clazz);
            } else {
                faceletsLibrary.putComponent(string, string2, string3);
            }
        }
    }

    private void processFunctions(NodeList nodeList, FaceletsLibrary faceletsLibrary) {
        if (nodeList != null && nodeList.getLength() > 0) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                NodeList nodeList2 = nodeList.item(i).getChildNodes();
                String string = null;
                String string2 = null;
                String string3 = null;
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Node node = nodeList2.item(j);
                    if (FUNCTION_NAME.equals(node.getLocalName())) {
                        string = this.getNodeText(node);
                        continue;
                    }
                    if (FUNCTION_CLASS.equals(node.getLocalName())) {
                        string2 = this.getNodeText(node);
                        continue;
                    }
                    if (!FUNCTION_SIGNATURE.equals(node.getLocalName())) continue;
                    string3 = this.getNodeText(node);
                }
                Method method = null;
                try {
                    Class<?> clazz = this.loadClass(string2, (Object)this, null);
                    method = FaceletsTaglibConfigProcessor.createMethod(clazz, string3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                faceletsLibrary.putFunction(string, method);
            }
        }
    }

    private static Method createMethod(Class clazz, String string) throws Exception {
        Class[] classArray;
        int n = string.indexOf(32);
        if (n == -1) {
            throw new Exception("Must Provide Return Type: " + string);
        }
        int n2 = string.indexOf(40, n + 1);
        if (n2 == -1) {
            throw new Exception("Must provide a method name, followed by '(': " + string);
        }
        String string2 = string.substring(n + 1, n2).trim();
        n = string.indexOf(41, n2 + 1);
        if (n == -1) {
            throw new Exception("Must close parentheses, ')' missing: " + string);
        }
        String[] stringArray = string.substring(n2 + 1, n).trim().split(",");
        if (stringArray.length == 1 && "".equals(stringArray[0])) {
            classArray = new Class[]{};
        } else {
            classArray = new Class[stringArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                classArray[i] = ReflectionUtil.forName((String)stringArray[i].trim());
            }
        }
        try {
            return clazz.getMethod(string2, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new Exception("No Function Found on type: " + clazz.getName() + " with signature: " + string);
        }
    }
}

